/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.listener;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.mcloud.admin.action.xt.api.XTClient;
import com.kingdee.mcloud.admin.action.xt.base.XTMessage;
import com.kingdee.mcloud.admin.action.xt.base.secruity.KeyCache;
import com.kingdee.mcloud.admin.action.xt.base.secruity.RSAUtils;
import com.kingdee.mcloud.admin.action.xt.message.BusinessMsgRequest;
import com.kingdee.mcloud.admin.action.xt.message.BussinessMsgResponse;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.util.ConfigurationItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class XTMessageListener
implements MessageListener {
    private static Logger logger = Logger.getLogger(XTMessageListener.class);
    private static String endPoint = "http://mcloud.kingdee.com:6899/xtapi/open.action";
    private static String appID = "XTAPP100";
    private static String mid = "10189";
    private static String isSend = "false";
    private static String keyPath = "";
    private static XTClient client = null;
    private static final String SEPATATOR = ";";
    private static String[] blackWord = new String[]{"\u8e22\u51fa"};

    private static void initXTClient() {
        XTMessageListener.initConfig();
        String priKeyName = appID + ".pri.key";
        String pubKeyName = appID + ".pub.key";
        File prikeyFile = new File(keyPath + priKeyName);
        File pubkeyFile = new File(keyPath + pubKeyName);
        try {
            KeyCache.add(priKeyName, RSAUtils.restorePrivateKey(FileUtils.readFileToByteArray((File)prikeyFile)));
            KeyCache.add(pubKeyName, RSAUtils.restorePublicKey(FileUtils.readFileToByteArray((File)pubkeyFile)));
        }
        catch (Exception e) {
            logger.error((Object)"KeyCache add error", (Throwable)e);
        }
        client = new XTClient();
        client.setAlg(1);
        client.setEndPoint(endPoint);
        client.setAppID(appID);
    }

    private static void initConfig() {
        ConfigurationItem xtItem = PortalConfig.getConfiguration().getConfigItem("XT");
        endPoint = xtItem.getProperty("endPoint");
        appID = xtItem.getProperty("appID");
        mid = xtItem.getProperty("mid");
        isSend = xtItem.getProperty("isSend");
        String portalConfig = System.getProperty("portal.config");
        File portalConfigFile = new File(portalConfig);
        keyPath = portalConfigFile.getParentFile().getAbsolutePath() + Constant.SYSTEM_PATH_SEPARATOR;
        logger.error((Object)("XTMessageListener initConfig,endPoint=" + endPoint + ",appID=" + appID + ",mid=" + mid + ",keyPath=" + keyPath + ",isSend=" + isSend));
    }

    private static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    public int onMessage(Message message) {
        try {
            if ("false".equals(isSend)) {
                return 1;
            }
            boolean isSendCommon = message.getBooleanheader("isSendCommon");
            if (!isSendCommon && (message.getBooleanheader("isSendEmail") || message.getBooleanheader("isSendMobile"))) {
                return 1;
            }
            ArrayList messages = this.parseMessage(message);
            logger.error((Object)("messages size:" + messages.size()));
            if (messages != null && messages.size() > 0) {
                for (int i = 0; i < messages.size(); ++i) {
                    this.sendXTMessage((Message)messages.get(i));
                }
            }
            logger.info((Object)"msg process success!");
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)"msg process failed!", (Throwable)e);
            return 0;
        }
    }

    private void sendXTMessage(Message message) {
        BusinessMsgRequest req = new BusinessMsgRequest();
        req.setPublicId(appID);
        req.setMid(mid);
        req.setBusinessId(appID + message.getIntHeader("type"));
        req.setBusinessName("\u5de5\u4f5c\u6d41\u901a\u77e5");
        req.setFromPersonId(appID);
        Context ctx = XTMessageListener.getContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        try {
            IUser user = UserFactory.getLocalInstance((Context)ctx);
            String msgReceiver = message.getStringHeader("receiver");
            UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(msgReceiver));
            if (userInfo != null && userInfo.getPerson() != null) {
                req.setToPersonId(userInfo.getPerson().getId().toString());
                logger.error((Object)("personID:" + userInfo.getPerson().getId().toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"get personID error!", (Throwable)e);
        }
        req.setMsgType(2);
        logger.error((Object)("body=" + message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + message.getLocaleStringHeader("title", new Locale("L2"))));
        String msgContent = message.getLocaleStringHeader("body", new Locale("L2"));
        if ((msgContent == null || msgContent.equals("")) && ((msgContent = message.getLocaleStringHeader("title", new Locale("L2"))) == null || msgContent.equals(""))) {
            return;
        }
        if (!this.check2Send(msgContent)) {
            return;
        }
        req.setContent(msgContent);
        req.setMsgLen(msgContent.length());
        BussinessMsgResponse resp = new BussinessMsgResponse();
        try {
            client.doHttpRemoter(req, resp);
        }
        catch (Exception e) {
            logger.error((Object)"client doHttpRemoter error:", (Throwable)e);
        }
        XTMessage.Header header = resp.getHeader();
        if (!header.isOk()) {
            logger.error((Object)("\u6d88\u606f\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + header.getError()));
            return;
        }
        if (!resp.isOk()) {
            logger.error((Object)("\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + resp.getError()));
            return;
        }
    }

    private ArrayList parseMessage(Message message) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String receivers = message.getStringHeader("receiver");
        MsgType type = MsgType.getEnum((int)message.getIntHeader("type"));
        ArrayList receiverIDs = this.parseReceivers(receivers);
        int receiverSize = receiverIDs.size();
        if (receiverSize == 0) {
            return null;
        }
        if (receiverSize == 1) {
            if (type.equals((Object)MsgType.NOTICE)) {
                message.setStringHeader("receiver", String.valueOf(receiverIDs.get(0)));
                messages.add(message);
                return messages;
            }
        } else if (type.equals((Object)MsgType.NOTICE)) {
            for (int i = 0; i < receiverSize; ++i) {
                Message newMessage = this.copyMessage(message);
                newMessage.setStringHeader("receiver", receiverIDs.get(i).toString());
                messages.add(newMessage);
            }
        }
        return messages;
    }

    private ArrayList parseReceivers(String str) {
        ArrayList<String> receiverIDs = new ArrayList<String>();
        if (str != null && !str.trim().equalsIgnoreCase("")) {
            if (str.indexOf(SEPATATOR) != -1) {
                StringTokenizer stReveivers = null;
                stReveivers = new StringTokenizer(str, SEPATATOR);
                while (stReveivers.hasMoreTokens()) {
                    receiverIDs.add(stReveivers.nextToken());
                }
            } else {
                receiverIDs.add(str);
            }
        }
        return receiverIDs;
    }

    private boolean check2Send(String content) {
        boolean send = true;
        for (int i = 0; i < blackWord.length; ++i) {
            if (content.indexOf(blackWord[i]) <= -1) continue;
            send = false;
            break;
        }
        return send;
    }

    private Message copyMessage(Message message) {
        Message newMessage = MessageFactory.newMessage();
        newMessage.setStringHeader("databaseCenter", message.getStringHeader("databaseCenter"));
        newMessage.setStringHeader("solution", message.getStringHeader("solution"));
        newMessage.setStringHeader("sourceID", message.getStringHeader("sourceID"));
        newMessage.setStringHeader("sourceIDs", message.getStringHeader("sourceIDs"));
        newMessage.setStringHeader("receiver", message.getStringHeader("receiver"));
        newMessage.setIntHeader("type", message.getIntHeader("type"));
        newMessage.setIntHeader("bizType", message.getIntHeader("bizType"));
        newMessage.setIntHeader("sourceStatus", message.getIntHeader("sourceStatus"));
        newMessage.setIntHeader("priority", message.getIntHeader("priority"));
        newMessage.setStringHeader("bizObjectId", message.getStringHeader("bizObjectId"));
        newMessage.setStringHeader("realBizPackage", message.getStringHeader("realBizPackage"));
        newMessage.setStringHeader("sender", message.getStringHeader("sender"));
        Locale locale = new Locale("L2");
        newMessage.setLocaleStringHeader("title", message.getLocaleStringHeader("title", locale), locale);
        newMessage.setLocaleStringHeader("body", message.getLocaleStringHeader("body", locale), locale);
        newMessage.setLocaleStringHeader("sender", message.getLocaleStringHeader("sender", locale), locale);
        newMessage.setLocaleStringHeader("initiatorName", message.getLocaleStringHeader("initiatorName", locale), locale);
        return newMessage;
    }

    static {
        XTMessageListener.initXTClient();
    }
}

