/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil;
import com.kingdee.eas.base.weibo.IWeiboBizFacade;
import com.kingdee.eas.base.weibo.IWeiboFacade;
import com.kingdee.eas.base.weibo.WeiboBizFacadeFactory;
import com.kingdee.eas.base.weibo.WeiboFacadeFactory;
import com.kingdee.eas.base.weibo.util.WeiboUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import weibo4j.Activity;
import weibo4j.Comment;
import weibo4j.Feed;
import weibo4j.Status;
import weibo4j.User;
import weibo4j.http.ImageItem;

public class WeiboBizUtil {
    public static boolean isWeiboEnable() throws BOSException, EASBizException {
        return WeiboBizUtil.isWeiboEnable(null);
    }

    public static boolean isWeiboEnable(Context ctx) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.isWeiboEnable();
    }

    public static boolean isShowBillWeibo(String billId) throws BOSException {
        if (StringUtils.isEmpty((String)billId)) {
            return false;
        }
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.isShowBillWeibo(billId);
    }

    public static boolean isBosTypeConfiged(String bosType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bosType)) {
            return false;
        }
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.isBosTypeConfiged(bosType);
    }

    public static Map getBillUnread(String billIds, String type, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.getFeedUnread(billIds, type);
    }

    public static boolean createBillFeed(String billId, String billCreatorName, String billNumber, String state, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.createFeed(billId, billCreatorName, billNumber, state);
    }

    public static boolean updateBillDigest(String billId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.updateFeedDigest(billId);
    }

    public static boolean billFeedExist(String billId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.feedExist(billId);
    }

    public static boolean subscribeBillFeed(String billId, String userIds, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.subscribeBillFeed(null, billId, userIds, appSrc);
    }

    public static boolean subscribeBillFeed(Context ctx, String billId, String userIds, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.subscribeFeed(billId, userIds);
    }

    public static boolean isBillSubscribed(String billId, String userId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.checkSubscribeFeed(billId, userId);
    }

    public static boolean unSubscribeBillFeed(String billId, String userIds, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = WeiboBizFacadeFactory.getRemoteInstance();
        return weiboFacade.unSubscribeFeed(billId, userIds);
    }

    public static boolean postBillFeedMsg(String billId, String userId, String verb, String content, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.postBillFeedMsg((Context)null, billId, userId, verb, content);
    }

    public static boolean postBillFeedMsg(Context ctx, String billId, String userId, String verb, String content) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.postMessage(billId, userId, verb, content);
    }

    public static boolean updateBillFeedState(String billId, String state, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.updateBillFeedState((Context)null, billId, state);
    }

    public static boolean updateBillFeedState(Context ctx, String billId, String state) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.updateFeedState(billId, state);
    }

    public static String getWeiboUserId(String personId) {
        String weiboId = null;
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            weiboId = weiboFacade.getWeiboIdbyPersonId(personId);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return weiboId;
    }

    public static String getWeiboUserIdByUserId(String userId) {
        String weiboId = null;
        try {
            IWeiboFacade weiboFacade = WeiboFacadeFactory.getRemoteInstance();
            weiboId = weiboFacade.getWeiboIdbyUserId(userId);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return weiboId;
    }

    public static String getGUIBillListWeiboUrl(String height, String locale, String database, String appSrc) throws BOSException {
        return WeiboBizUtil.getGUIBillListWeiboUrl(height, null, locale, database, appSrc);
    }

    public static String getGUIBillListWeiboUrl(String height, String width, String locale, String database, String appSrc) throws BOSException {
        String widgetUrl = null;
        try {
            widgetUrl = WeiboBizUtil.getBillListWidgetUrl(height, width);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return WeiboBizUtil.buildFullUrl(widgetUrl, locale, database);
    }

    private static String getBillListWidgetUrl(String height, String width) throws UnsupportedEncodingException {
        StringBuffer widgetUrl = new StringBuffer();
        widgetUrl.append("/portal/pages/weibo/weiboBillRedirect.jsp?t=all&height=").append(height);
        if (!StringUtils.isEmpty((String)width)) {
            widgetUrl.append("&width=").append(width);
        }
        return URLEncoder.encode(widgetUrl.toString(), "utf-8");
    }

    private static String buildFullUrl(String widgetUrl, String locale, String database) throws BOSException {
        if (StringUtils.isEmpty((String)widgetUrl)) {
            return null;
        }
        String ssoUrl = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(widgetUrl, true, locale, database);
        return WeiboBizUtil.getServerUrl() + "/easportal/" + ssoUrl;
    }

    public static String getGUIWeiboRegisterUrl(String locale, String database, String appSrc) throws BOSException {
        String widgetUrl = null;
        try {
            widgetUrl = WeiboBizUtil.getRegisterWidgetUrl();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return WeiboBizUtil.buildFullUrl(widgetUrl, locale, database);
    }

    private static String getRegisterWidgetUrl() throws UnsupportedEncodingException {
        StringBuffer widgetUrl = new StringBuffer();
        widgetUrl.append("/portal/pages/weibo/weiboRegisterRedirect.jsp");
        return URLEncoder.encode(widgetUrl.toString(), "utf-8");
    }

    private static String getServerUrl() {
        String serverURL = System.getProperty("UPDATE_SERVER_ADDR");
        System.out.println("serverURL: " + serverURL);
        if (StringUtils.isEmpty((String)serverURL)) {
            return "http://localhost:6888";
        }
        return "http://" + serverURL;
    }

    public static String getGUIBillWeiboUrl(String billId, String height, String locale, String database, String appSrc) throws BOSException {
        return WeiboBizUtil.getGUIBillWeiboUrl(billId, height, null, locale, database, appSrc);
    }

    public static String getGUIBillWeiboUrl(String billId, String height, String width, String locale, String database, String appSrc) throws BOSException {
        billId = WeiboUtil.encodeBillId(billId);
        String widgetUrl = null;
        try {
            widgetUrl = WeiboBizUtil.getBillWidgetUrl(billId, height, width);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("encode err billId: " + billId);
            e.printStackTrace();
        }
        return WeiboBizUtil.buildFullUrl(widgetUrl, locale, database);
    }

    private static String getBillWidgetUrl(String billId, String height, String width) throws UnsupportedEncodingException {
        StringBuffer widgetUrl = new StringBuffer();
        widgetUrl.append("/portal/pages/weibo/weiboBillRedirect.jsp?billId=").append(URLEncoder.encode(billId, "utf-8"));
        widgetUrl.append("&height=").append(height);
        if (!StringUtils.isEmpty((String)width)) {
            widgetUrl.append("&width=").append(width);
        }
        return URLEncoder.encode(widgetUrl.toString(), "utf-8");
    }

    public static String getBindEmailByPersonId(String personId) throws EASBizException, BOSException {
        return WeiboBizUtil.getBindEmailByPersonId(null, personId);
    }

    public static String getBindEmailByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getBindEmailByPersonId(personId);
    }

    public static boolean sendDirectMessage(String personId, String content, String appSrc) throws EASBizException, BOSException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "4");
        }
        return WeiboBizUtil.sendDirectMessage(null, personId, content);
    }

    public static boolean sendDirectMessage(Context ctx, String personId, String content, String appSrc) throws EASBizException, BOSException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.sendDirectMessage(personId, content);
    }

    public static boolean uploadDirectMessage(String personIds, String content, byte[] fileBytes, String fileName, String appSrc) throws EASBizException, BOSException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "4");
        }
        return WeiboBizUtil.uploadDirectMessage(null, personIds, content, fileBytes, fileName, appSrc);
    }

    public static boolean uploadDirectMessage(Context ctx, String personIds, String content, byte[] fileBytes, String fileName, String appSrc) throws EASBizException, BOSException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.uploadDirectMessage(personIds, content, fileBytes, fileName);
    }

    public static boolean updateStatus4Community(String content, String appSrc) throws EASBizException, BOSException {
        return WeiboBizUtil.updateStatus4Community(null, content);
    }

    public static boolean updateStatus4Community(Context ctx, String content, String appSrc) throws EASBizException, BOSException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.updateStatus4Community(content);
    }

    public static boolean updateStatus(String content, String appSrc) throws EASBizException, BOSException {
        return WeiboBizUtil.updateStatus(null, content);
    }

    public static boolean updateStatus(Context ctx, String content, String appSrc) throws EASBizException, BOSException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.updateStatus(content);
    }

    public static List getStreamFeeds(String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamFeeds(null, userId, page, count, appSrc);
    }

    public static List getStreamFeeds(Context ctx, String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamFeeds(userId, page, count);
    }

    public static Feed getStreamFeedDetail(String billId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamFeedDetail(null, billId, appSrc);
    }

    public static Feed getStreamFeedDetail(Context ctx, String billId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamFeedDetail(billId);
    }

    public static List getStreamTargetTimeline(String billId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamTargetTimeline(null, billId, page, count, appSrc);
    }

    public static List getStreamTargetTimeline(Context ctx, String billId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamTargetTimeline(billId, page, count);
    }

    public static List getStreamUserTimeline(String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamUserTimeline(null, userId, page, count, appSrc);
    }

    public static List getStreamUserTimeline(Context ctx, String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamUserTimeline(page, count, userId);
    }

    public static List getStreamMentionsTimeline(String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamMentionsTimeline(null, userId, page, count, appSrc);
    }

    public static List getStreamMentionsTimeline(Context ctx, String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamMentionsTimeline(page, count, userId);
    }

    public static Activity getStreamActivityDetail(String activityId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamActivityDetail(null, activityId, appSrc);
    }

    public static Activity getStreamActivityDetail(Context ctx, String activityId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamActivityDetail(activityId);
    }

    public static List getStreamCommentsTimeline(String activityId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamCommentsTimeline(null, activityId, page, count, appSrc);
    }

    public static List getStreamCommentsTimeline(Context ctx, String activityId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamCommentsTimeline(page, count, activityId);
    }

    public static boolean postTextStreamMessage(String billId, String content, String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics(BOSUuid.read((String)billId).getType().toString(), appSrc, "5");
        }
        return WeiboBizUtil.postTextStreamMessage(null, billId, content, appSrc);
    }

    public static boolean postTextStreamMessage(Context ctx, String billId, String content, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.postTextStreamMessage(billId, content);
    }

    public static boolean uploadTextStreamMessage(String billId, String content, byte[] fileBytes, String fileName, String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics(BOSUuid.read((String)billId).getType().toString(), appSrc, "5");
        }
        return WeiboBizUtil.uploadTextStreamMessage(null, billId, content, fileBytes, fileName, appSrc);
    }

    public static boolean uploadTextStreamMessage(Context ctx, String billId, String content, byte[] fileBytes, String fileName, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.uploadTextStreamMessage(billId, content, fileBytes, fileName);
    }

    public static boolean postCommentToActivity(String activityId, String replyCommentId, String content, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.postCommentToActivity(null, activityId, replyCommentId, content, appSrc);
    }

    public static boolean postCommentToActivity(Context ctx, String activityId, String replyCommentId, String content, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.postCommentToActivity(activityId, replyCommentId, content);
    }

    public static boolean deleteActivity(String activityId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.deleteActivity(null, activityId, appSrc);
    }

    public static boolean deleteActivity(Context ctx, String activityId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.deleteActivity(activityId);
    }

    public static List searchUsers(String q, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.searchUsers(null, q, appSrc);
    }

    public static List searchUsers(Context ctx, String q, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.searchUsers(q);
    }

    public static boolean createUnverifiedWeiboUser(String email, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.createUnverifiedWeiboUser(null, email, appSrc);
    }

    public static boolean createUnverifiedWeiboUser(Context ctx, String email, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.register(email, false);
    }

    public static List getStreamReplyToMeTimeline(String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamReplyToMeTimeline(null, userId, page, count, appSrc);
    }

    public static List getStreamReplyToMeTimeline(Context ctx, String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamReplyToMeTimeline(userId, page, count);
    }

    public static List getStreamMySendTimeline(String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamMySendTimeline(null, userId, page, count, appSrc);
    }

    public static List getStreamMySendTimeline(Context ctx, String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamMySendTimeline(userId, page, count);
    }

    public static List batchCreateWeiboUserAndToken() throws BOSException, EASBizException {
        WeiboBizUtil.sendGuiStatistics("", "4", "3");
        return WeiboBizUtil.batchCreateWeiboUserAndToken(null);
    }

    public static List batchCreateWeiboUserAndToken(Context ctx) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.batchCreateWeiboUserAndToken();
    }

    public static boolean adminCreateUnverifiedWeiboUser(String email, String personId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.adminCreateUnverifiedWeiboUser(null, email, personId, appSrc);
    }

    public static boolean adminCreateUnverifiedWeiboUser(Context ctx, String email, String personId, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.adminCreateUnverifiedWeiboUser(email, personId);
    }

    public static long getStreamCommentUnread(String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamCommentUnread(null, appSrc);
    }

    public static long getStreamCommentUnread(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamCommentUnread();
    }

    public static long getStreamMentionUnread(String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getStreamMentionUnread(null, appSrc);
    }

    public static long getStreamMentionUnread(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.streamMentionUnread();
    }

    public static String getWeiboCommentUrl(String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getWeiboCommentUrl(null, appSrc);
    }

    public static String getWeiboCommentUrl(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboCommentUrl();
    }

    public static String getWeiboMentionUrl(String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getWeiboMentionUrl(null, appSrc);
    }

    public static String getWeiboMentionUrl(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboMentionUrl();
    }

    public static String getWeiboMySendUrl(String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "7");
        }
        return WeiboBizUtil.getWeiboMySendUrl(null, appSrc);
    }

    public static String getWeiboMySendUrl(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboMySendUrl();
    }

    public static String getWeiboFocusUrl(String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "8");
        }
        return WeiboBizUtil.getWeiboFocusUrl(null, appSrc);
    }

    public static String getWeiboFocusUrl(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboFocusUrl();
    }

    public static String getPortalBillUrl() throws BOSException, EASBizException {
        return "/plt_widget/weibo/bill.action";
    }

    public static boolean bindWeiboUserNoPerson(String email, String psw, String userId) throws BOSException, EASBizException {
        return WeiboBizUtil.bindWeiboUserNoPerson(null, email, psw, userId);
    }

    public static boolean bindWeiboUserNoPerson(Context ctx, String email, String psw, String userId) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.bindNoPerson(email, psw, userId);
    }

    public static boolean sendDirectMessageNoPerson(String userId, String personId, String content) throws BOSException, EASBizException {
        return WeiboBizUtil.sendDirectMessageNoPerson(null, userId, personId, content);
    }

    public static boolean sendDirectMessageNoPerson(Context ctx, String userId, String personId, String content) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.sendDirectMessageNoPerson(userId, personId, content);
    }

    public static boolean addFeedParticipant(String userId, String billId, String participantIds, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.addFeedParticipant(null, userId, billId, participantIds, appSrc);
    }

    public static boolean addFeedParticipant(Context ctx, String userId, String billId, String participantIds, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.addFeedParticipant(userId, billId, participantIds);
    }

    public static List getFeedDynamicTimeline(String categoryName, int activityCount, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getFeedDynamicTimeline(null, categoryName, activityCount, page, count, appSrc);
    }

    public static List getFeedDynamicTimeline(Context ctx, String categoryName, int activityCount, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.feedDynamicTimeline(categoryName, activityCount, page, count);
    }

    public static List getFeedRelatedDoc(String userId, String targetId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getFeedRelatedDoc(null, userId, targetId, page, count, appSrc);
    }

    public static List getFeedRelatedDoc(Context ctx, String userId, String targetId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.feedRelatedDoc(userId, targetId, page, count);
    }

    public static List getFeedSubscribeTimeline(String categoryName, int activityCount, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getFeedSubscribeTimeline(null, categoryName, activityCount, page, count, appSrc);
    }

    public static List getFeedSubscribeTimeline(Context ctx, String categoryName, int activityCount, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.feedSubscribeTimeline(categoryName, activityCount, page, count);
    }

    public static List getFeedParticipants(String userId, String billId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getFeedParticipants(null, userId, billId, appSrc);
    }

    public static List getFeedParticipants(Context ctx, String userId, String billId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getFeedParticipants(userId, billId);
    }

    public static List getHotStreamFeedsRecently(int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getHotStreamFeedsRecently(null, count, appSrc);
    }

    public static List getHotStreamFeedsRecently(Context ctx, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.hotStreamFeedsRecently(count);
    }

    public static String getLocalWeiboIdByPersonId(String personId) throws BOSException, EASBizException {
        return WeiboBizUtil.getLocalWeiboIdByPersonId(null, personId);
    }

    public static String getLocalWeiboIdByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getLocalWeiboIdByPersonId(personId);
    }

    public static boolean adminSendDirectMessage(String personId, String content, String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "4");
        }
        return WeiboBizUtil.adminSendDirectMessage(null, personId, content, appSrc);
    }

    public static boolean adminSendDirectMessage(Context ctx, String personId, String content, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.adminSendDirectMessage(personId, content);
    }

    public static List getFeedCompletedTimeline(String categoryName, int activityCount, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getFeedCompletedTimeline(null, categoryName, activityCount, page, count, appSrc);
    }

    public static List getFeedCompletedTimeline(Context ctx, String categoryName, int activityCount, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.feedCompletedTimeline(categoryName, activityCount, page, count);
    }

    public static boolean modifyFeedTitle(String billId, String title, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.modifyFeedTitle(null, billId, title, appSrc);
    }

    public static boolean modifyFeedTitle(Context ctx, String billId, String title, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.modifyFeedTitle(billId, title);
    }

    public static User getWeiboUser(String userId) throws BOSException, EASBizException {
        return WeiboBizUtil.getWeiboUser(null, userId);
    }

    public static User getWeiboUser(Context ctx, String userId) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboUser(userId);
    }

    public static Map getUserAllUnread(String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getUserAllUnread(null, appSrc);
    }

    public static Map getUserAllUnread(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.userAllUnread();
    }

    public static List getJoinedGroups(String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getJoinedGroups(null, userId, page, count, appSrc);
    }

    public static List getJoinedGroups(Context ctx, String userId, int page, int count, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getJoinedGroups(userId, page, count);
    }

    public static Status updateGroupStatus(String groupId, String status, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.updateGroupStatus(null, groupId, status, appSrc);
    }

    public static Status updateGroupStatus(Context ctx, String groupId, String status, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.updateGroupStatus(groupId, status);
    }

    public static Status uploadGroupStatus(String groupId, String status, ImageItem item, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.uploadGroupStatus(null, groupId, status, item, appSrc);
    }

    public static Status uploadGroupStatus(Context ctx, String groupId, String status, ImageItem item, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.uploadGroupStatus(groupId, status, item);
    }

    public static Comment commentGroup(String groupId, String sid, String cid, String comment, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.commentGroup(null, groupId, sid, cid, comment, appSrc);
    }

    public static Comment commentGroup(Context ctx, String groupId, String sid, String cid, String comment, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.commentGroup(groupId, sid, cid, comment);
    }

    public static Boolean sendDirectMessageByWeiboId(String weiboIds, String content, String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "4");
        }
        return WeiboBizUtil.sendDirectMessageByWeiboId(null, weiboIds, content, appSrc);
    }

    public static Boolean sendDirectMessageByWeiboId(Context ctx, String weiboIds, String content, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.sendDirectMessageByWeiboId(weiboIds, content);
    }

    public static Boolean sendDirectMessageByWeiboId2(String weiboIds, String content, boolean sendMail) throws BOSException, EASBizException {
        return WeiboBizUtil.sendDirectMessageByWeiboId2(null, weiboIds, content, sendMail);
    }

    public static Boolean sendDirectMessageByWeiboId2(Context ctx, String weiboIds, String content, boolean sendMail) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.sendDirectMessageByWeiboId2(weiboIds, content, sendMail);
    }

    public static Boolean uploadDirectMessageByWeiboId(String weiboIds, String content, byte[] file, String fileName, String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "4");
        }
        return WeiboBizUtil.uploadDirectMessageByWeiboId(null, weiboIds, content, file, fileName, appSrc);
    }

    public static Boolean uploadDirectMessageByWeiboId(Context ctx, String weiboIds, String content, byte[] file, String fileName, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.uploadDirectMessageByWeiboId(weiboIds, content, file, fileName);
    }

    public static List feedDynamicTimelineOnlyUnread(String categoryName, int activityCount, int page, int count, boolean onlyUnread, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.feedDynamicTimelineOnlyUnread(null, categoryName, activityCount, page, count, onlyUnread, appSrc);
    }

    public static List feedDynamicTimelineOnlyUnread(Context ctx, String categoryName, int activityCount, int page, int count, boolean onlyUnread, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.feedDynamicTimelineOnlyUnread(categoryName, activityCount, page, count, onlyUnread);
    }

    public static List feedSubscribeTimelineOnlyUnread(String categoryName, int activityCount, int page, int count, boolean onlyUnread, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.feedSubscribeTimelineOnlyUnread(null, categoryName, activityCount, page, count, onlyUnread, appSrc);
    }

    public static List feedSubscribeTimelineOnlyUnread(Context ctx, String categoryName, int activityCount, int page, int count, boolean onlyUnread, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.feedSubscribeTimelineOnlyUnread(categoryName, activityCount, page, count, onlyUnread);
    }

    public static String getLocalWeiboIdByUserId(String userId) throws BOSException, EASBizException {
        return WeiboBizUtil.getLocalWeiboIdByUserId(null, userId);
    }

    public static String getLocalWeiboIdByUserId(Context ctx, String userId) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getLocalWeiboIdByUserId(userId);
    }

    public static Status uploadGroupStatus4GUI(String groupId, String status, byte[] file, String fileName, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.uploadGroupStatus4GUI(null, groupId, status, file, fileName, appSrc);
    }

    public static Status uploadGroupStatus4GUI(Context ctx, String groupId, String status, byte[] file, String fileName, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.uploadGroupStatus4GUI(groupId, status, file, fileName);
    }

    public static User getWeiboUserByWeiboId(String weiboUserId) throws BOSException, EASBizException {
        return WeiboBizUtil.getWeiboUserByWeiboId(null, weiboUserId);
    }

    public static User getWeiboUserByWeiboId(Context ctx, String weiboUserId) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboUserByWeiboId(weiboUserId);
    }

    public static String getWeiboAllGroupUrl(String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getWeiboAllGroupUrl(null, appSrc);
    }

    public static String getWeiboAllGroupUrl(Context ctx, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboAllGroupUrl();
    }

    public static String getWeiboGroupUrl(String groupId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.getWeiboGroupUrl(null, groupId, appSrc);
    }

    public static String getWeiboGroupUrl(Context ctx, String groupId, String appSrc) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboGroupUrl(groupId);
    }

    public static Boolean doCooperate(String billId, String title, String userId, String weiboUsers, String content, byte[] fileContent, String fileName, String appSrc) throws BOSException, EASBizException {
        if (WeiboBizUtil.isGuiCaller(appSrc)) {
            WeiboBizUtil.sendGuiStatistics("", appSrc, "6");
        }
        return WeiboBizUtil.doCooperate(null, billId, title, userId, weiboUsers, content, fileContent, fileName, appSrc);
    }

    public static Boolean doCooperate(Context ctx, String billId, String title, String userId, String weiboUsers, String content, byte[] fileContent, String fileName, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.doCooperate(billId, title, userId, weiboUsers, content, fileContent, fileName);
    }

    public static String getEasLoginName(String weiboId) throws BOSException, EASBizException {
        return WeiboBizUtil.getEasLoginName(null, weiboId);
    }

    public static String getEasLoginName(Context ctx, String weiboId) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getEasLoginName(weiboId);
    }

    public static boolean addGroupMember(String groupId, String userId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.addGroupMember(null, groupId, userId, appSrc);
    }

    public static boolean addGroupMember(Context ctx, String groupId, String userId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.addGroupMember(groupId, userId);
    }

    public static Boolean addGroupMember2(String communityId, String groupId, String userId, String token, String tokenSecret, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.addGroupMember2(null, communityId, groupId, userId, token, tokenSecret, appSrc);
    }

    public static Boolean addGroupMember2(Context ctx, String communityId, String groupId, String userId, String token, String tokenSecret, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.addGroupMember2(communityId, groupId, userId, token, tokenSecret);
    }

    public static boolean addUserToCommunity2(String communityId, String email, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.addUserToCommunity2(null, communityId, email, appSrc);
    }

    public static boolean addUserToCommunity2(Context ctx, String communityId, String email, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.addUserToCommunity2(communityId, email);
    }

    public static Boolean addUserToCommunity3(String communityId, String userId, String appSrc) throws BOSException, EASBizException {
        return WeiboBizUtil.addUserToCommunity3(null, communityId, userId, appSrc);
    }

    public static Boolean addUserToCommunity3(Context ctx, String communityId, String userId, String appSrc) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.addUserToCommunity3(communityId, userId);
    }

    public static List getJoinedGroups2(String userId, int page, int count, String appSrc, String communityId) throws BOSException, EASBizException {
        return WeiboBizUtil.getJoinedGroups2(null, userId, page, count, appSrc, communityId);
    }

    public static List getJoinedGroups2(Context ctx, String userId, int page, int count, String appSrc, String communityId) throws BOSException, EASBizException {
        IWeiboBizFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboBizFacadeFactory.getRemoteInstance() : WeiboBizFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getJoinedGroups2(userId, page, count, communityId);
    }

    public static String getWeiboGroupUrl2(String groupId, String domain) throws BOSException, EASBizException {
        return WeiboBizUtil.getWeiboGroupUrl2(null, groupId, domain);
    }

    public static String getWeiboGroupUrl2(Context ctx, String groupId, String domain) throws BOSException, EASBizException {
        IWeiboFacade weiboFacade = null;
        weiboFacade = ctx == null ? WeiboFacadeFactory.getRemoteInstance() : WeiboFacadeFactory.getLocalInstance(ctx);
        return weiboFacade.getWeiboGroupUrl2(groupId, domain);
    }

    private static void sendGuiStatistics(String bosType, String appSrc, String type) {
        StringBuffer message = new StringBuffer();
        message.append(bosType);
        message.append("888");
        message.append(appSrc);
        message.append("888");
        message.append(type);
        message.append("888");
        message.append(new Date().getTime());
        System.out.println("sendGuiStatistics:" + message.toString());
        StatisticsUtil.send((int)2, (String)message.toString());
    }

    private static boolean isGuiCaller(String appSrc) {
        return "4".equals(appSrc);
    }
}

