/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.util;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.weibo.EcaFacadeFactory;
import com.kingdee.eas.base.weibo.IEcaFacade;
import com.kingdee.eas.base.weibo.util.HttpClientTool;
import com.kingdee.eas.base.weibo.util.MapTool;
import com.kingdee.eas.base.weibo.util.User;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;

public class XTAppService {
    private static XTAppService instance = null;
    private static String cust3gNo = "";
    private static String baseUrl = "";
    private static String token;

    public static synchronized XTAppService getInstance() {
        if (instance == null) {
            instance = new XTAppService();
            XTAppService.initXTConfig();
        }
        return instance;
    }

    private static void initXTConfig() {
        try {
            IEcaFacade ecaFacade = null;
            ecaFacade = EcaFacadeFactory.getRemoteInstance();
            HashMap hm = ecaFacade.getInitConfig();
            cust3gNo = (String)hm.get("cust3gNo");
            baseUrl = (String)hm.get("xtUrl");
            token = (String)hm.get("token");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map login(String userId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("cust3gNo", cust3gNo);
        param.put("token", token);
        String url = baseUrl + "loginForEas.action";
        return HttpClientTool.httpPost(url, param);
    }

    public String createGroup(HttpClient client, Map params) {
        String urlSuffix = "ecLite/convers/createGroup.action";
        String[] userIds = MapTool.getStrings(params, "userIds");
        int len = userIds.length;
        StringBuffer pStr = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i == 0) {
                pStr.append("userIds=" + userIds[i]);
                continue;
            }
            pStr.append("&userIds=" + userIds[i]);
        }
        String url = baseUrl + urlSuffix;
        return HttpClientTool.httpPost(client, url, pStr.toString(), null, null);
    }

    public String send(HttpClient client, Map params) {
        String urlSuffix = "ecLite/convers/send.action";
        String url = baseUrl + urlSuffix;
        return HttpClientTool.httpPost(client, url, params);
    }

    public String sendFile(HttpClient client, Map params, File file) {
        String urlSuffix = "ecLite/convers/sendFile.action";
        String url = baseUrl + urlSuffix;
        return HttpClientTool.httpPostFile(client, url, params, null, null, file);
    }

    public List<User> searchUser(HttpClient client, Map params) throws Exception {
        ArrayList<User> list = new ArrayList<User>();
        String urlSuffix = "ecLite/search.action";
        String url = baseUrl + urlSuffix;
        String result = HttpClientTool.httpPost(client, url, params);
        JSONObject jo = new JSONObject(result);
        System.out.println("json search result:" + result);
        if (jo.getBoolean("success")) {
            JSONArray array = jo.getJSONObject("data").getJSONArray("list");
            for (int i = 0; i < array.length(); ++i) {
                User user = new User();
                JSONObject obj = array.getJSONObject(i);
                user.setId(obj.getString("id"));
                user.setName(obj.getString("name"));
                user.setDefaultPhone(obj.getString("defaultPhone"));
                user.setDepartment(obj.getString("department"));
                user.setJobTitle(obj.getString("jobTitle"));
                user.setPhotoUrl(obj.getString("photoUrl"));
                user.setPhotoId(obj.getString("photoId"));
                user.setHasOpened(obj.getBoolean("hasOpened"));
                list.add(user);
            }
            return list;
        }
        throw new Exception(jo.getString("error"));
    }

    public static void main(String[] args) {
    }
}

