/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mcloud.admin.action.xt.base;

import com.kingdee.mcloud.admin.action.xt.base.secruity.SecurityEngine;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class XTMessage {
    public static final int MSG_TYPE_SYSTEM = 0;
    public static final int MSG_TYPE_CALL = 1;
    public static final int MSG_TYPE_TEXT = 2;
    public static final int MSG_TYPE_VOICE = 3;
    public static final int MSG_TYPE_PIC = 4;
    public static final int MSG_TYPE_TEXT_LINK = 5;
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_ERROR = 1;
    public static final int CODE_UNKNOWN_SERVICEID = 2;
    public static final int CODE_UNKNOWN_ALG = 3;
    public static final int CODE_ERROR_MSG_FORMAT = 4;
    public static final int CODE_ERROR_PARAM = 5;
    protected Header header;
    protected SecurityEngine securityEngine;

    public abstract void decodeBody(JSONObject var1);

    public abstract JSONObject encodeBody();

    public abstract String getServiceId();

    public static Header parseHeader(String msgContent) throws Exception {
        Header header = new Header();
        JSONObject msgJSON = JSONObject.fromObject((Object)msgContent);
        if (msgJSON.has("appID")) {
            header.appID = msgJSON.getString("appID");
        }
        if (msgJSON.has("serviceID")) {
            header.serviceID = msgJSON.getString("serviceID");
        }
        if (msgJSON.has("alg")) {
            header.alg = msgJSON.getInt("alg");
        }
        if (msgJSON.has("time")) {
            header.time = msgJSON.getLong("time");
        }
        if (msgJSON.has("data")) {
            String data = msgJSON.getString("data");
            header.setOriginalBodyData(data);
        }
        if (msgJSON.has("error")) {
            header.error = msgJSON.getString("error");
        }
        if (msgJSON.has("errorCode")) {
            header.errorCode = msgJSON.getInt("errorCode");
        }
        return header;
    }

    public String encode() throws Exception {
        JSONObject msg = new JSONObject();
        msg.put((Object)"appID", (Object)this.header.appID);
        msg.put((Object)"serviceID", (Object)this.header.serviceID);
        msg.put((Object)"alg", (Object)this.header.alg);
        msg.put((Object)"time", (Object)System.currentTimeMillis());
        msg.put((Object)"error", (Object)this.header.error);
        msg.put((Object)"errorCode", (Object)this.header.errorCode);
        JSONObject data = this.encodeBody();
        if (data != null) {
            String encrypted = this.securityEngine.encrypt(data.toString());
            msg.put((Object)"data", (Object)encrypted);
        }
        return msg.toString();
    }

    public NameValuePair[] encode1() throws Exception {
        JSONObject data = this.encodeBody();
        String encrypted = "";
        if (data != null) {
            encrypted = this.securityEngine.encrypt(data.toString());
        }
        NameValuePair[] pairs = new NameValuePair[]{new NameValuePair("appID", this.header.appID), new NameValuePair("serviceID", this.header.serviceID), new NameValuePair("alg", "" + this.header.alg), new NameValuePair("time", "" + System.currentTimeMillis()), new NameValuePair("error", this.header.error), new NameValuePair("errorCode", "" + this.header.errorCode), new NameValuePair("data", encrypted)};
        return pairs;
    }

    public void decode() throws Exception {
        if (StringUtils.isBlank((String)this.header.originalBodyData)) {
            return;
        }
        String decrypted = this.securityEngine.decrypt(this.header.originalBodyData);
        JSONObject bodyJSON = JSONObject.fromObject((Object)decrypted);
        this.decodeBody(bodyJSON);
    }

    public boolean validate() {
        return true;
    }

    public SecurityEngine getSecurityEngine() {
        return this.securityEngine;
    }

    public void setSecurityEngine(SecurityEngine securityEngine) {
        this.securityEngine = securityEngine;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public static class Header {
        protected String appID;
        protected String serviceID;
        protected int alg;
        protected long time;
        protected String error;
        protected int errorCode;
        protected String originalBodyData;

        public String getAppID() {
            return this.appID;
        }

        public void setAppID(String appID) {
            this.appID = appID;
        }

        public String getServiceID() {
            return this.serviceID;
        }

        public void setServiceID(String serviceID) {
            this.serviceID = serviceID;
        }

        public int getAlg() {
            return this.alg;
        }

        public void setAlg(int alg) {
            this.alg = alg;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        protected String getOriginalBodyData() {
            return this.originalBodyData;
        }

        protected void setOriginalBodyData(String originalBodyData) {
            this.originalBodyData = originalBodyData;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public boolean isOk() {
            return this.errorCode == 0;
        }
    }
}

