/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class ImageItem {
    private byte[] content;
    private String name;
    private String contentType;

    public ImageItem(String name, byte[] content) throws Exception {
        String imgtype = ImageItem.getContentType(content);
        if (imgtype == null || !imgtype.equalsIgnoreCase("image/gif") && !imgtype.equalsIgnoreCase("image/png") && !imgtype.equalsIgnoreCase("image/jpeg")) {
            throw new IllegalStateException("Unsupported image type, Only Suport JPG ,GIF,PNG!");
        }
        this.content = content;
        this.name = name;
        this.contentType = imgtype;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentType(byte[] mapObj) throws IOException {
        String type = "";
        ByteArrayInputStream bais = null;
        MemoryCacheImageInputStream mcis = null;
        try {
            bais = new ByteArrayInputStream(mapObj);
            mcis = new MemoryCacheImageInputStream(bais);
            Iterator<ImageReader> itr = ImageIO.getImageReaders(mcis);
            while (itr.hasNext()) {
                ImageReader reader = itr.next();
                if (reader instanceof GIFImageReader) {
                    type = "image/gif";
                    continue;
                }
                if (reader instanceof JPEGImageReader) {
                    type = "image/jpeg";
                    continue;
                }
                if (reader instanceof PNGImageReader) {
                    type = "image/png";
                    continue;
                }
                if (!(reader instanceof BMPImageReader)) continue;
                type = "application/x-bmp";
            }
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            if (mcis != null) {
                try {
                    mcis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return type;
    }
}

