/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.basesync;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.IBaseSync;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.BaseSyncHelperImpFactory;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AbstractBaseSyncService
implements IBaseSync {
    protected static Logger logger = Logger.getLogger(AbstractBaseSyncService.class);
    protected Context ctx = null;
    protected SyncContext syncCtx = null;

    public AbstractBaseSyncService(SyncContext syncCtx) {
        this.ctx = syncCtx.getCtx();
        this.syncCtx = syncCtx;
    }

    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        return null;
    }

    @Override
    public void dataBind() throws BOSException, EASBizException {
    }

    protected void getAllOrg() throws BOSException {
        JSONArray array = new JSONArray();
        try {
            String url = this.getSyncURL(SyncItemType.GetAllOrg.getName());
            JSONObject response = SyncCommunitcateUtil.getSyncResponse(url);
            if (!"0".equals(response.getString("errcode"))) {
                throw new BOSException(response.getString("errmsg"));
            }
            array = response.getJSONArray("department");
            if (array != null) {
                logger.info((Object)("*******\u83b7\u53d6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a " + array.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        this.clearXtOrgDatas();
        if (array != null && array.size() > 0) {
            this.insertIntoSyncOrgTable(array);
        }
    }

    protected void updateOrgLongName() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("updateOrgLongName");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
    }

    protected void updateOrgName() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("updateOrgName");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
    }

    protected void updateOrgStatus() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("updateOrgStatus");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
        String dbType = (String)this.ctx.get((Object)"dbType");
        String valueKey = "";
        if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
            valueKey = "updateOrgWeights_Oracle";
        } else if ("MS SQL Server".equals(dbType)) {
            valueKey = "updateOrgWeights_sqlServer";
        } else if ("DB2 UDB".equals(dbType)) {
            valueKey = "updateOrgWeights_DB2";
        } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
            valueKey = "updateOrgWeights_PG";
        }
        if (!StringUtils.isEmpty((String)valueKey)) {
            sql = SyncConfigUtil.getInstance().getValue(valueKey);
            sql = "/*dialect*/" + sql;
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
        }
    }

    protected void updateOrgParentId() throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = SyncConfigUtil.getInstance().getValue("updateOrgEasParentId");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
        long t2 = System.currentTimeMillis();
        sql = SyncConfigUtil.getInstance().getValue("updateOrgXtParentId");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
    }

    protected String getSyncURL(String syncType) throws BOSException {
        return null;
    }

    protected String getSyncURL(String syncType, String type, String secretName) throws BOSException {
        return null;
    }

    protected void insertNewPersonToMap() throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = SyncConfigUtil.getInstance().getValue("insertNewPersonToMap");
        sql = this.fillTemplateSql(sql, 1);
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    protected void bindPersonByCellAndName() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("bindPersonByCellAndName");
        sql = this.fillTemplateSql(sql, 1);
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    protected void bindPersonByEmailAndName() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("bindPersonByEmailAndName");
        sql = this.fillTemplateSql(sql, 1);
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    protected void bindPersonAfterSyncPerson(JSONObject requestData, JSONObject responseData) throws BOSException {
    }

    protected void getAllPerson() throws BOSException {
        JSONArray array = new JSONArray();
        try {
            String url = this.getSyncURL(SyncItemType.GetAllPerson.getName());
            JSONObject response = SyncCommunitcateUtil.getSyncResponse(url);
            if (!"0".equals(response.getString("errcode"))) {
                throw new BOSException(response.getString("errmsg"));
            }
            array = response.getJSONArray("userlist");
            if (array != null) {
                logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a " + array.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        this.clearXtPersonDatas();
        if (array != null && array.size() > 0) {
            this.insertIntoSyncPersonTable(array);
        }
    }

    protected void insertNewOrgToMap() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("insertNewOrgToMap");
        sql = this.fillTemplateSql(sql, 0);
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    protected void bindOrgByOrgLongName() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("bindOrgByOrgLongName");
        if ("Kingbase".equals((String)this.ctx.get((Object)"dbType"))) {
            sql = "/*dialect*/" + sql;
        }
        sql = this.fillTemplateSql(sql, 0);
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    protected void updatePersonStatus() throws BOSException {
        String sql = null;
        SyncConfigUtil instance = SyncConfigUtil.getInstance();
        sql = instance.getValue("updateUserStatus");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateUserStatus2");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateReNomalUserMap");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateDeletedUserMap");
        if (!StringUtils.isEmpty((String)sql)) {
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        }
        if (!StringUtils.isEmpty((String)(sql = instance.getValue("updateDeletedPUMap")))) {
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        }
        if (!StringUtils.isEmpty((String)(sql = instance.getValue("updateDeletedPerson")))) {
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        }
    }

    protected void updateSyncPersonInfo() throws BOSException {
        SyncConfigUtil instance = SyncConfigUtil.getInstance();
        String sql = instance.getValue("insertWhenNewUser");
        sql = instance.getValue("updateWhenNewUser");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateUserCell");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateNoUserCell");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateUserEmail");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateNoUserEmail");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updatePersonPosition");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updatePersonOrg");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateNoUserName");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateUserName");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updatePCellWhenUCellNull");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updatePersonNumber");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        this.updateMapPersonWeights(this.ctx);
        sql = instance.getValue("updatePersonTelephone");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updatePersonAddress");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updatePEmailWhenUEmailNull");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("updateUserNumber");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
    }

    protected void updateMapPersonWeights(Context ctx) throws BOSException {
        String dbType = (String)ctx.get((Object)"dbType");
        String valueKey = "";
        if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
            valueKey = "updatePersonWeights_Oracle";
        } else if ("MS SQL Server".equals(dbType)) {
            valueKey = "updatePersonWeights_sqlServer";
        } else if ("DB2 UDB".equals(dbType)) {
            valueKey = "updatePersonWeights_DB2";
        } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
            valueKey = "updatePersonWeights_PG";
        }
        if (!StringUtils.isEmpty((String)valueKey)) {
            SyncConfigUtil instance = SyncConfigUtil.getInstance();
            String sql = instance.getValue(valueKey);
            sql = "/*dialect*/" + sql;
            this.updatePersonWeights(ctx, this.fillTemplateSql(sql, 1));
        }
    }

    protected void setDefaultNull() {
        SyncConfigUtil instance = SyncConfigUtil.getInstance();
        String sql = null;
        try {
            sql = instance.getValue("setXtIdNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setCellNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setEmailNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setPositionNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setOrgLongNameNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setDescriptionNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setUserNameNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setUserNumberNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setPersonNameNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
            sql = instance.getValue("setUserIdNULL");
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        }
        catch (BOSException e) {
            logger.error((Object)"\u8bbe\u7f6e''\u4e3anull\u51fa\u9519");
            e.printStackTrace();
        }
    }

    protected void updateSynchStatus() throws BOSException {
        SyncConfigUtil instance = SyncConfigUtil.getInstance();
        String sql = instance.getValue("canSyncWithCellNotNull");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("canSyncWithCellNotRepeat");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncWithCellNull");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncWithCellRepeat");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncWithNoInservice");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncWithCellRepeat4User");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncWithEmailRepeat");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncWithEmailRepeat4User");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncWithCellError");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
        sql = instance.getValue("cantSyncSameCellButDiffName");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
    }

    protected void insertNoSyncPerson() throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = this.getSqlByName("insertNoSyncPerson");
        logger.info((Object)("*****insertNoSyncPerson******" + sql));
        EasXtSyncUtil.execute(this.ctx, sql);
        logger.info((Object)("*****insertNoSyncPerson cost ******" + (System.currentTimeMillis() - t1)));
    }

    protected void insertNoSyncPersonByPosition() throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = this.getSqlByName("insertNoSyncPersonByPosition");
        logger.info((Object)("*****insertNoSyncPerson******" + sql));
        EasXtSyncUtil.execute(this.ctx, sql);
        logger.info((Object)("*****insertNoSyncPerson cost ******" + (System.currentTimeMillis() - t1)));
    }

    protected void syncIsExistsUser() throws BOSException {
        Map xtConfig = BaseSyncHelperImpFactory.getInstance(this.ctx, this.syncCtx.getType()).getConfig();
        if ("1".equals(xtConfig.get("ExistsUser"))) {
            String sql = this.getSqlByName("insertNoUserPerson");
            EasXtSyncUtil.execute(this.ctx, sql);
            String sql2 = this.getSqlByName("deleteExistsUserPerson");
            EasXtSyncUtil.execute(this.ctx, sql2);
        } else {
            String sql = this.getSqlByName("deleteAllExistsUserPerson");
            EasXtSyncUtil.execute(this.ctx, sql);
        }
    }

    protected void fillUserId() throws BOSException {
        String sql = SyncConfigUtil.getInstance().getValue("fillUserId");
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 1));
    }

    private void updatePersonWeights(Context ctx, String sql) throws BOSException {
        IRowSet rs = EasXtSyncUtil.executeQuery(ctx, sql);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = new ArrayList<String>();
        String updateSql = "update " + this.syncCtx.getMappingTableName() + " set fweight = ? where fpersonid = ?";
        try {
            while (rs.next()) {
                param = new ArrayList();
                param.add(rs.getString("sortCode"));
                param.add(rs.getString("pid"));
                params.add(param.toArray());
            }
            if (params.size() == 1000) {
                EasXtSyncUtil.executeBatch(ctx, updateSql, params);
                params = new ArrayList();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (params.size() > 0) {
            EasXtSyncUtil.executeBatch(ctx, updateSql, params);
            params = null;
        }
    }

    protected void clearXtOrgDatas() throws BOSException {
        String sql = "truncate table " + this.syncCtx.getSyncTableName();
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    protected void insertIntoSyncOrgTable(JSONArray totalArray) throws BOSException {
        int i;
        String sql = SyncConfigUtil.getInstance().getValue("insertIntoSyncOrgTable");
        sql = SyncBaseUtil.fillTemplateSql(sql, 1, this.syncCtx.getSyncTableName());
        sql = SyncBaseUtil.fillTemplateSql(sql, 2, this.syncCtx.getMappingOrgIdColnum());
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        HashMap<String, String> orgLongNameMap = new HashMap<String, String>();
        JSONArray orderOrgArray = new JSONArray();
        ArrayList<Integer> parentIds = new ArrayList<Integer>();
        if (this.syncCtx.getType() == 1 || this.syncCtx.getType() == 0) {
            for (i = 0; i < totalArray.size(); ++i) {
                JSONObject o = totalArray.getJSONObject(i);
                int id = o.getInteger("id");
                if (id != 1) continue;
                parentIds.add(id);
                orderOrgArray.add((Object)o);
                totalArray.remove(i);
                break;
            }
        } else {
            parentIds.add(((JSONObject)totalArray.get(0)).getInteger("id"));
            orderOrgArray.add(totalArray.get(0));
            totalArray.remove(0);
        }
        this.orderOrg(parentIds, orderOrgArray, totalArray, 0);
        for (i = 0; i < orderOrgArray.size(); ++i) {
            JSONObject json = orderOrgArray.getJSONObject(i);
            String id = json.getString("id");
            if (ids.contains(id)) continue;
            ids.add(id);
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(id);
            String orgName = json.getString("name");
            String parentId = json.getString("parentid");
            if ("1".equals(parentId)) {
                param.add(orgName);
                orgLongNameMap.put(id, orgName);
            } else if ("0".equals(parentId) || StringUtils.isEmpty((String)parentId)) {
                param.add("\\");
                orgLongNameMap.put(id, orgName);
            } else {
                String parentLongName;
                String string = parentLongName = orgLongNameMap.get(parentId) == null ? null : ((String)orgLongNameMap.get(parentId)).toString();
                if (StringUtils.isEmpty(parentLongName)) {
                    throw new BOSException(json.getString("name") + "\u7684\u4e0a\u7ea7\u4e3a\u7a7a");
                }
                String longName = parentLongName + "\\" + orgName;
                param.add(longName);
                orgLongNameMap.put(id, longName);
            }
            param.add(orgName);
            param.add(parentId);
            String weights = json.getString("order");
            if (weights == null || "".equals(weights.trim()) || "null".equalsIgnoreCase(weights)) {
                param.add("0");
            } else {
                param.add(weights);
            }
            params.add(param.toArray());
        }
        logger.info((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u7ec4\u7ec7\u8868----------");
        EasXtSyncUtil.executeBatch(this.ctx, sql, params);
        logger.error((Object)"-------logger.info\u529f----------");
    }

    protected void clearXtPersonDatas() throws BOSException {
        String sql = "truncate table " + this.syncCtx.getSyncTableName();
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    protected void insertIntoSyncPersonTable(JSONArray totalArray) throws BOSException {
    }

    protected String getInsertPersonSql() throws BOSException {
        return SyncConfigUtil.getInstance().getValue("insertIntoSyncPersonTable");
    }

    protected String getOrgLongNameById(String mainDept) throws BOSException {
        return null;
    }

    private void orderOrg(List<Integer> parentIds, JSONArray orderOrgArray, JSONArray totalArray, int count) throws BOSException {
        if (totalArray.size() == 0) {
            return;
        }
        if (count > 10) {
            logger.error((Object)("\u5269\u4f59\u7ec4\u7ec7\u6570\u636e\u4e3a:" + totalArray.toJSONString()));
            return;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject o = totalArray.getJSONObject(i);
            int parentId = o.getIntValue("parentid");
            if (!parentIds.contains(parentId)) continue;
            list.add(o.getInteger("id"));
            orderOrgArray.add((Object)o);
            totalArray.remove(i);
            --i;
        }
        this.orderOrg(list, orderOrgArray, totalArray, ++count);
    }

    protected JSONObject getSyncResultCount(SyncContext syncCtx, String itemType) throws NumberFormatException, BOSException {
        String lastSyncTime = SyncLogUtils.getLastSyncTime(syncCtx);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("succCount", (Object)SyncLogUtils.getSyncLogCount(syncCtx, itemType, lastSyncTime, null, true));
        jsonObject.put("failCount", (Object)SyncLogUtils.getSyncLogCount(syncCtx, itemType, lastSyncTime, null, false));
        jsonObject.put("syncTimeId", (Object)lastSyncTime);
        jsonObject.put("highItemType", (Object)syncCtx.getHighItemType().getValue());
        jsonObject.put("syncType", (Object)itemType);
        return jsonObject;
    }

    public String fillTemplateSql(String sql, int i) {
        if (i == 0) {
            sql = SyncBaseUtil.fillTemplateSql(sql, 0, this.syncCtx.getMappingTableName());
            sql = SyncBaseUtil.fillTemplateSql(sql, 1, this.syncCtx.getSyncTableName());
            sql = SyncBaseUtil.fillTemplateSql(sql, 2, this.syncCtx.getMappingOrgIdColnum());
            sql = SyncBaseUtil.fillTemplateSql(sql, 3, this.syncCtx.getMappingOrgParentIdColnum());
            sql = SyncBaseUtil.fillTemplateSql(sql, 4, this.syncCtx.getNoSyncTableName());
        } else {
            sql = SyncBaseUtil.fillTemplateSql(sql, 0, this.syncCtx.getMappingTableName());
            sql = SyncBaseUtil.fillTemplateSql(sql, 1, this.syncCtx.getSyncTableName());
            sql = SyncBaseUtil.fillTemplateSql(sql, 2, this.syncCtx.getMappingUserIdColnum());
            sql = SyncBaseUtil.fillTemplateSql(sql, 4, this.syncCtx.getNoSyncTableName());
        }
        return sql;
    }

    protected String getSqlByName(String sqlKey) throws BOSException {
        return null;
    }
}

