/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.ddsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncDeptLeaderBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncURLUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DDSyncDeptLeaderService
extends SyncDeptLeaderBaseService {
    private static Logger logger = Logger.getLogger(DDSyncDeptLeaderService.class);

    public DDSyncDeptLeaderService(SyncContext syncCtx) {
        super(syncCtx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        this.getAllLeader();
        this.updateDeprLeaderJobInfo();
        return "true";
    }

    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        if (type == null) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)type) + "11");
        }
        if (SyncItemType.DeptLeaderSyncBefore.equals((Object)type)) {
            return this.beforeSync();
        }
        if (SyncItemType.DeptLeaderSyncAfter.equals((Object)type)) {
            return this.afterSync();
        }
        if (SyncItemType.BatchSetOrgLeader.equals((Object)type)) {
            return this.batchUpdateLeader(itemType);
        }
        if (SyncItemType.BatchDeleteOrgLeader.equals((Object)type)) {
            return this.batchUpdateLeader(itemType);
        }
        return null;
    }

    @Override
    public String afterSync() throws BOSException, EASBizException {
        this.getAllLeader();
        return this.insertDeptLeaderInfo();
    }

    private void updateDeprLeaderJobInfo() throws BOSException {
        HashMap<String, Object> partMap = new HashMap<String, Object>();
        String sql = DDSyncConfigUtil.getInstance().getValue("selectOrgLeader");
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        try {
            while (rs.next()) {
                String personId = rs.getString("FPersonId");
                String ddId = rs.getString("FDDId");
                Object info = (OrgLeaderInfo)partMap.get(personId);
                if (info == null) {
                    info = new OrgLeaderInfo(personId, ddId);
                    partMap.put(personId, info);
                }
                ((OrgLeaderInfo)info).addEasOrgId(rs.getString("FEasOrgId"));
                ((OrgLeaderInfo)info).addWXOrgId(rs.getString("FDDOrgId"));
                String orgLongName = "\\".equals(rs.getString("FOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(this.ctx) : rs.getString("FOrgLongName");
                ((OrgLeaderInfo)info).addOrgLongName(orgLongName);
            }
            Set personIdSet = partMap.keySet();
            if (personIdSet.size() < 1) {
                return;
            }
            StringBuilder sb = new StringBuilder("select FPersonId FROM T_PM_EASDDORGLEADERMAP WHERE FPersonId in (");
            for (String pId : personIdSet) {
                sb.append("'" + pId + "',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") ");
            IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            String updateSql = "UPDATE T_PM_EASDDORGLEADERMAP SET FEASORGIDS = ?,FDDORGIDS = ?,FORGLONGNAMES = ? WHERE FPERSONID = ?";
            while (rs1.next()) {
                ArrayList<String> updateParam = new ArrayList<String>();
                String personId = rs1.getString("FPersonId");
                OrgLeaderInfo pi = (OrgLeaderInfo)partMap.get(personId);
                updateParam.add(pi.easOrgIds.toString());
                updateParam.add(pi.ddOrgIds.toString().replace(" ", ""));
                updateParam.add(pi.orgLongName.toString());
                updateParam.add(pi.personId);
                updateParams.add(updateParam.toArray());
                partMap.remove(personId);
            }
            EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
            String insertSql = "INSERT INTO T_PM_EASDDORGLEADERMAP (FID,FPERSONID,FEASORGIDS,FDDORGIDS,FDDID,FORGLONGNAMES ) VALUES (?,?,?,?,?,?)";
            Set personIdSet1 = partMap.keySet();
            ArrayList<Object[]> updateParams1 = new ArrayList<Object[]>();
            for (String pid : personIdSet1) {
                ArrayList<String> updateParam = new ArrayList<String>();
                OrgLeaderInfo pi = (OrgLeaderInfo)partMap.get(pid);
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.add(pi.personId);
                updateParam.add(pi.easOrgIds.toString());
                updateParam.add(pi.ddOrgIds.toString().replace(" ", ""));
                updateParam.add(pi.ddId);
                updateParam.add(pi.orgLongName.toString());
                updateParams1.add(updateParam.toArray());
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String insertDeptLeaderInfo() {
        return "true";
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        return new String[]{"roleIds", "userIds"};
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        return new String[]{"fddorgids", "fddid"};
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        return new String[]{"FDDId", "FOrgLongNames", "FOldDDOrgIds", "FDDOrgIds"};
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        return new String[]{"FDDId", "FOrgLongNames", "FOldDDOrgIds", "FDDOrgIds"};
    }

    @Override
    protected String syncPart(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        try {
            String url = null;
            String comUrl = null;
            if (SyncItemType.BatchSetOrgLeader.equals((Object)type)) {
                url = DDSyncURLUtil.getSyncUrl(this.ctx, "/topapi/role/addrolesforemps");
            }
            if (SyncItemType.BatchDeleteOrgLeader.equals((Object)type)) {
                url = DDSyncURLUtil.getSyncUrl(this.ctx, "/topapi/role/removerolesforemps");
            }
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject dataJSON = dataArray.getJSONObject(i);
                comUrl = url;
                for (int j = 0; j < syncJsonKey.length; ++j) {
                    comUrl = comUrl + "&" + syncJsonKey[j] + "=" + dataJSON.get((Object)syncJsonKey[j]);
                }
                result = SyncCommunitcateUtil.getSyncResponse(comUrl);
                logArray.add((Object)result);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String batchUpdateLeader(String itemType) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        String sql = null;
        if (SyncItemType.BatchSetOrgLeader.equals((Object)type)) {
            sql = DDSyncConfigUtil.getInstance().getValue("selectOrgLeaderAdd");
        }
        if (SyncItemType.BatchDeleteOrgLeader.equals((Object)type)) {
            sql = DDSyncConfigUtil.getInstance().getValue("selectOrgLeaderDel");
        }
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                for (i = 0; i < syncJsonKey.length; ++i) {
                    if ("roleIds".equals(syncJsonKey[i])) {
                        dataJSON.put(syncJsonKey[i], (Object)"1538662010");
                        continue;
                    }
                    Object value = rowSet.getObject(syncJsonValue[i]);
                    dataJSON.put(syncJsonKey[i], (Object)(value == null ? "" : value.toString()));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    Object value2 = rowSet.getObject(syncLogColValue[i]);
                    logValue.add(value2 == null ? "" : value2.toString());
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            String string = this.syncPart(this.syncCtx, dataArray, itemType, logMap);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private void getAllLeader() throws BOSException {
        String comUrl = null;
        JSONObject responseLeaders = null;
        JSONArray array = new JSONArray();
        JSONArray leaderArray = new JSONArray();
        try {
            String url = DDSyncURLUtil.getSyncUrl(this.ctx, "/topapi/role/simplelist") + "&role_id=" + "1538662010";
            int i = 0;
            while (true) {
                if (!"ok".equalsIgnoreCase((responseLeaders = SyncCommunitcateUtil.getSyncResponse(comUrl = url + "&offset=" + 200 * i + "&size=200")).getString("errmsg"))) {
                    throw new BOSException(responseLeaders.getString("errmsg"));
                }
                leaderArray = responseLeaders.getJSONObject("result").getJSONArray("list");
                array.addAll((Collection)leaderArray);
                if ("false".equalsIgnoreCase(responseLeaders.getJSONObject("result").getString("hasMore"))) break;
                ++i;
            }
            if (array != null) {
                logger.error((Object)("*******\u83b7\u53d6\u9489\u9489\u8d1f\u8d23\u4eba\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a " + array.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        String sql = "truncate table " + this.syncCtx.getSyncTableName();
        EasXtSyncUtil.execute(this.ctx, sql);
        this.insertIntoSyncLTable(array);
    }

    private void insertIntoSyncLTable(JSONArray array) throws BOSException {
        String sql = this.getInsertLeaderSql();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = array.getJSONObject(i);
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(null);
            String userid = json.getString("userid");
            param.add(userid);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u9489\u9489\u8d1f\u8d23\u4eba\u8868----------");
        EasXtSyncUtil.executeBatch(this.ctx, sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u9489\u9489\u8d1f\u8d23\u4eba\u8868\u6210\u529f----------");
    }

    private String getInsertLeaderSql() throws BOSException {
        return DDSyncConfigUtil.getInstance().getValue("insertIntoSyncLeaderTable");
    }

    class OrgLeaderInfo {
        String personId;
        String ddId;
        List<String> easOrgIds;
        List<String> ddOrgIds;
        List<String> orgLongName;

        OrgLeaderInfo(String personId, String ddId) {
            this.personId = personId;
            this.ddId = ddId;
            this.easOrgIds = new ArrayList<String>();
            this.ddOrgIds = new ArrayList<String>();
            this.orgLongName = new ArrayList<String>();
        }

        public void addEasOrgId(String easOrgId) {
            if (!this.easOrgIds.contains(easOrgId)) {
                this.easOrgIds.add(easOrgId);
            }
        }

        public void addWXOrgId(String wxOrgId) {
            if (!this.ddOrgIds.contains(wxOrgId)) {
                this.ddOrgIds.add(wxOrgId);
            }
        }

        public void addOrgLongName(String orgLongName) {
            this.orgLongName.add(orgLongName);
        }
    }
}

