/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wlsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncDeptLeaderBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.WLSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLHttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WLSyncDeptLeaderService
extends SyncDeptLeaderBaseService {
    public WLSyncDeptLeaderService(SyncContext syncCtx) {
        super(syncCtx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        this.deleteNotExistsOrg();
        this.updateDeptLeaderJobInfo();
        return "true";
    }

    private void deleteNotExistsOrg() throws BOSException {
        String sql = WLSyncConfigUtil.getInstance().getValue("deleteNotExistOrg");
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            return super.sync(itemType);
        }
        WLSyncItemType WLType = WLSyncUtil.getWLSyncEnum(itemType);
        if (WLSyncItemType.BatchUpdateDeptLeader.equals((Object)WLType)) {
            String sql = WLSyncConfigUtil.getInstance().getValue("selectOrgLeaderChanged");
            IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
            String[] syncJsonKey = this.getSyncJsonKey(itemType);
            String[] syncJsonValue = this.getSyncJsonValue(itemType);
            String[] syncLogColName = this.getSyncLogColName(itemType);
            String[] syncLogColValue = this.getSyncLogColValue(itemType);
            JSONArray dataArray = new JSONArray();
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logColName", syncLogColName);
            ArrayList logArrays = new ArrayList();
            try {
                ArrayList<String> logValue = null;
                while (rowSet.next()) {
                    int i;
                    JSONObject dataJSON = new JSONObject();
                    for (i = 0; syncJsonKey != null && i < syncJsonKey.length; ++i) {
                        Object value;
                        if ("managerId".equals(syncJsonKey[i]) || "corpManagerId".equals(syncJsonKey[i])) {
                            value = rowSet.getObject(syncJsonValue[i]);
                            dataJSON.put(syncJsonKey[i], (Object)(value == null ? new JSONArray() : JSONArray.parseArray((String)value.toString())));
                            continue;
                        }
                        value = rowSet.getObject(syncJsonValue[i]);
                        dataJSON.put(syncJsonKey[i], (Object)(value == null ? "" : value.toString()));
                    }
                    logValue = new ArrayList<String>();
                    for (i = 0; i < syncLogColName.length; ++i) {
                        Object value2 = rowSet.getObject(syncLogColValue[i]);
                        logValue.add(value2 == null ? "" : value2.toString());
                    }
                    logArrays.add(logValue);
                    dataArray.add((Object)dataJSON);
                }
                logMap.put("logColValue", logArrays);
                String string = this.syncDeptLeader(this.syncCtx, dataArray, itemType, logMap);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
            }
            finally {
                if (rowSet != null) {
                    try {
                        rowSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    protected String syncDeptLeader(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException {
        WLSyncItemType type = WLSyncUtil.getWLSyncEnum(itemType);
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            String syncUrl = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/department/update");
            JSONObject url0 = JSONObject.parseObject((String)syncUrl);
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject dataJSON = dataArray.getJSONObject(i);
                result = WLHttpSendUtil.startPost(url0.getString("url"), dataJSON, url0.getString("token"), null, url0.getJSONObject("hwConfig"));
                result.put("errcode", result.get((Object)"code"));
                result.put("errmsg", result.get((Object)"message"));
                logArray.add((Object)result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }

    @Override
    public String afterSync() throws BOSException, EASBizException {
        return this.insertDeptLeaderInfo();
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        return new String[]{"deptCode", "managerId", "corpManagerId"};
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        return new String[]{"FWLOrgId", "FUserIds", "FEasPersonNumbers"};
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        return new String[]{"FEasOrgId", "FWLOrgId", "FUserIds", "FOldUserIds", "FPersonNames"};
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        return new String[]{"FEasOrgId", "FWLOrgId", "FUserIds", "FOldUserIds", "FPersonNames"};
    }

    private String insertDeptLeaderInfo() throws BOSException {
        String syncTimeId = SyncLogUtils.getLastSyncTime(this.syncCtx);
        String sql = "SELECT FWLORGID FROM T_WL_SYNCORGLEADERLOG WHERE FSyncTimeID = '" + syncTimeId + "' and FSUCCESS = 0";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        ArrayList<String> deptCodes = new ArrayList<String>();
        try {
            while (rs.next()) {
                String deptCode = rs.getString("FWLORGID");
                if (StringUtils.isEmpty((String)deptCode)) continue;
                deptCodes.add(deptCode);
            }
            HashMap paramMap = new HashMap();
            String syncUrl = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/department/detail");
            JSONObject url0 = JSONObject.parseObject((String)syncUrl);
            for (int i = 0; i < deptCodes.size(); ++i) {
                String deptCode = (String)deptCodes.get(i);
                try {
                    ArrayList<String> param = new ArrayList<String>();
                    JSONObject result = WLHttpSendUtil.startGet(url0.getString("url") + "?deptCode=" + deptCode, null, url0.getString("token"), url0.getJSONObject("hwConfig"));
                    JSONArray userIds = result.getJSONArray("managerId");
                    Collections.sort((List)userIds);
                    param.add(userIds.toString());
                    JSONArray easPersonNumbers = result.getJSONArray("corpManagerId");
                    param.add(easPersonNumbers.toString());
                    param.add(deptCode);
                    paramMap.put(deptCode, param);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Set allOrgId = paramMap.keySet();
            if (allOrgId.size() < 1) {
                return null;
            }
            StringBuilder sb = new StringBuilder("select FWLORGID FROM T_WL_ORGLEADER WHERE FWLORGID in (");
            for (String orgId : allOrgId) {
                sb.append("'" + orgId + "',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            String updateSql = "UPDATE T_WL_ORGLEADER SET FUSERIDS = ?,FEASPERSONNUMBERS = ? WHERE FWLORGID = ?";
            while (rs1.next()) {
                String FWLOrgId = rs1.getString("FWLORGID");
                updateParams.add(((List)paramMap.get(FWLOrgId)).toArray());
                paramMap.remove(FWLOrgId);
            }
            EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
            String insertSql = "INSERT INTO T_WL_ORGLEADER (FID,FUSERIDS,FEASPERSONNUMBERS,FWLORGID) VALUES (?,?,?,?)";
            Set insertOrgIdSet = paramMap.keySet();
            ArrayList<Object[]> updateParams1 = new ArrayList<Object[]>();
            for (String orgId : insertOrgIdSet) {
                ArrayList<String> updateParam = new ArrayList<String>();
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.addAll((Collection)paramMap.get(orgId));
                updateParams1.add(updateParam.toArray());
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "true";
    }

    private void updateDeptLeaderJobInfo() throws BOSException {
        String initSql = "UPDATE T_PM_EASWLORGLEADERMAP SET FUSERIDS = '[]',FPERSONNAMES = '[]'";
        EasXtSyncUtil.execute(this.ctx, initSql);
        HashMap<String, Object> partMap = new HashMap<String, Object>();
        String sql = WLSyncConfigUtil.getInstance().getValue("selectOrgLeader");
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        try {
            while (rs.next()) {
                String easOrgId = rs.getString("FEasOrgId");
                String orgName = rs.getString("FOrgName");
                Object info = (OrgLeaderInfo)partMap.get(easOrgId);
                if (info == null) {
                    info = new OrgLeaderInfo(easOrgId, orgName);
                    partMap.put(easOrgId, info);
                }
                ((OrgLeaderInfo)info).addEasPersonId(rs.getString("FPersonId"));
                ((OrgLeaderInfo)info).addXTId(rs.getString("FXTId"));
                ((OrgLeaderInfo)info).addPersonName(rs.getString("FPersonName"));
                ((OrgLeaderInfo)info).addEasPersonNumbers(rs.getString("FEasPersonNumber"));
            }
            Set orgIdSet = partMap.keySet();
            if (orgIdSet.size() < 1) {
                return;
            }
            StringBuilder sb = new StringBuilder("select FEASORGID FROM T_PM_EASWLORGLEADERMAP WHERE FEASORGID in (");
            for (String orgId : orgIdSet) {
                sb.append("'" + orgId + "',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") ");
            IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
            ArrayList<String[]> updateParams = new ArrayList<String[]>();
            String updateSql = "UPDATE T_PM_EASWLORGLEADERMAP SET FEASORGNAME = ?,FEASPERSONIDS = ?,FPERSONNAMES = ?,FUSERIDS = ?,FEASPERSONNUMBERS = ? WHERE FEASORGID = ?";
            while (rs1.next()) {
                ArrayList<String> updateParam = new ArrayList<String>();
                String orgId = rs1.getString("FEASORGID");
                OrgLeaderInfo pi = (OrgLeaderInfo)partMap.get(orgId);
                updateParam.add(pi.orgName);
                updateParam.add(pi.easPersonIds.toString());
                updateParam.add(pi.personNames.toString());
                Collections.sort((List)pi.xtIds);
                updateParam.add(pi.xtIds.toString());
                updateParam.add(pi.easPersonNumbers.toString());
                updateParam.add(pi.easOrgId);
                updateParams.add(updateParam.toArray(new String[updateParam.size()]));
                partMap.remove(orgId);
            }
            EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
            String insertSql = "INSERT INTO T_PM_EASWLORGLEADERMAP (FID,FEASORGID,FEASORGNAME,FEASPERSONIDS,FPERSONNAMES,FUSERIDS,FEASPERSONNUMBERS ) VALUES (?,?,?,?,?,?,?)";
            Set personIdSet1 = partMap.keySet();
            ArrayList<String[]> updateParams1 = new ArrayList<String[]>();
            for (String pid : personIdSet1) {
                ArrayList<String> updateParam = new ArrayList<String>();
                OrgLeaderInfo pi = (OrgLeaderInfo)partMap.get(pid);
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.add(pi.easOrgId);
                updateParam.add(pi.orgName);
                updateParam.add(pi.easPersonIds.toString());
                updateParam.add(pi.personNames.toString());
                Collections.sort((List)pi.xtIds);
                updateParam.add(pi.xtIds.toString());
                updateParam.add(pi.easPersonNumbers.toString());
                updateParams1.add(updateParam.toArray(new String[updateParam.size()]));
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    class OrgLeaderInfo {
        private String easOrgId;
        private String orgName;
        private JSONArray easPersonIds;
        private JSONArray xtIds;
        private JSONArray easPersonNumbers;
        private JSONArray personNames;

        OrgLeaderInfo(String easOrgId, String orgName) {
            this.easOrgId = easOrgId;
            this.orgName = orgName;
            this.easPersonIds = new JSONArray();
            this.xtIds = new JSONArray();
            this.personNames = new JSONArray();
            this.easPersonNumbers = new JSONArray();
        }

        public void addEasPersonId(String easPersonId) {
            if (!this.easPersonIds.contains((Object)easPersonId)) {
                this.easPersonIds.add((Object)easPersonId);
            }
        }

        public void addXTId(String xtId) {
            if (!this.xtIds.contains((Object)xtId)) {
                this.xtIds.add((Object)xtId);
            }
        }

        public void addPersonName(String personName) {
            this.personNames.add((Object)personName);
        }

        public void addEasPersonNumbers(String personNumber) {
            this.easPersonNumbers.add((Object)personNumber);
        }
    }
}

