/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wlsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.BaseSyncFacadeFactory;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncPersonBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLHttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WLSyncPersonService
extends SyncPersonBaseService {
    private static Logger logger = Logger.getLogger(WLSyncPersonService.class);

    public WLSyncPersonService(SyncContext ctx) {
        super(ctx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        super.beforeSync();
        String sqlByName = this.getSqlByName("updatePersonEn");
        EasXtSyncUtil.execute(this.ctx, sqlByName);
        sqlByName = this.getSqlByName("updatePersonEnIsNull");
        EasXtSyncUtil.execute(this.ctx, sqlByName);
        sqlByName = this.getSqlByName("updatePersonOrg");
        EasXtSyncUtil.execute(this.ctx, sqlByName);
        return "true";
    }

    @Override
    protected void insertNewPersonToMap() throws BOSException {
        String sql = this.getSqlByName("insertNewPersonToMap");
        Map<String, String> orgInfo = WLSyncUtil.getRootOrgInfo(this.ctx);
        if (orgInfo != null) {
            String orgLongNumber = orgInfo.get("orgLongNumber");
            sql = sql + " AND org.FLONGNUMBER LIKE '" + orgLongNumber + "%'";
        }
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncUpdatePersonOrg(String itemType) throws BOSException {
        String sql = this.getUpdatePersonOrg(itemType);
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                for (i = 0; i < syncJsonKey.length; ++i) {
                    String keyData = syncJsonKey[i];
                    if ("deptCodes".equalsIgnoreCase(keyData)) {
                        String mainDepart = rowSet.getString(syncJsonValue[i]);
                        ArrayList<String> orgids = new ArrayList<String>();
                        orgids.add(mainDepart);
                        String ssql = "SELECT top 1 fwlorgids,feasorgnumbers FROM T_PM_EASWLPARTMAP where fwlid = '" + rowSet.getString("fxtid") + "'";
                        IRowSet rowSet1 = EasXtSyncUtil.executeQuery(this.ctx, ssql);
                        while (rowSet1.next()) {
                            orgids.addAll(JSONArray.parseArray((String)rowSet1.getString("fwlorgids"), String.class));
                            ArrayList<String> codeDeparts = new ArrayList<String>();
                            String mainCodeDepart = rowSet.getString("forgnumber");
                            codeDeparts.add(mainCodeDepart);
                            codeDeparts.addAll(JSONArray.parseArray((String)rowSet1.getString("feasorgnumbers"), String.class));
                            dataJSON.put("corpDeptCodes", (Object)codeDeparts.toArray());
                        }
                        dataJSON.put(keyData, (Object)orgids.toArray());
                        continue;
                    }
                    Object value = rowSet.getObject(syncJsonValue[i]);
                    dataJSON.put(keyData, (Object)(value == null ? "" : value.toString()));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    Object value2 = rowSet.getObject(syncLogColValue[i]);
                    logValue.add(value2 == null ? "" : value2.toString());
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            result = this.syncPerson(this.syncCtx, dataArray, itemType, logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncAddNewPerson(String itemType) throws BOSException {
        String sql = this.getAddNewPersonSql();
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                for (i = 0; i < syncJsonKey.length; ++i) {
                    if ("deptCodes".equalsIgnoreCase(syncJsonKey[i])) {
                        dataJSON.put(syncJsonKey[i], (Object)new String[]{rowSet.getString(syncJsonValue[i])});
                        continue;
                    }
                    if ("sex".equalsIgnoreCase(syncJsonKey[i])) {
                        dataJSON.put(syncJsonKey[i], (Object)(rowSet.getInt(syncJsonValue[i]) == 0 ? "" : (rowSet.getInt(syncJsonValue[i]) == 2 ? "F" : "M")));
                        continue;
                    }
                    Object value = rowSet.getObject(syncJsonValue[i]);
                    dataJSON.put(syncJsonKey[i], (Object)(value == null ? null : value.toString()));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    Object value2 = rowSet.getObject(syncLogColValue[i]);
                    logValue.add(value2 == null ? null : value2.toString());
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            result = this.syncPerson(this.syncCtx, dataArray, itemType, logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncPerson(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException, IOException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            JSONObject url0 = JSONObject.parseObject((String)this.getSyncURL(itemType));
            if (baseType != null) {
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject dataJSON = dataArray.getJSONObject(i);
                    if (SyncItemType.UpdatePersonGender.equals((Object)baseType)) {
                        String sex = dataJSON.getString("sex");
                        if (sex == null || "".equals(sex)) {
                            dataJSON.put("sex", (Object)"");
                        } else {
                            dataJSON.put("sex", (Object)("1".equals(dataJSON.getString("sex")) ? "M" : "F"));
                        }
                    }
                    if (SyncItemType.DeletePerson.equals((Object)baseType)) {
                        dataJSON.put("isDeleteUser", (Object)"1");
                    }
                    result = WLHttpSendUtil.startPost(url0.getString("url"), dataJSON, url0.getString("token"), null, url0.getJSONObject("hwConfig"));
                    result.put("errcode", result.get((Object)"code"));
                    result.put("errmsg", result.get((Object)"message"));
                    logArray.add((Object)result);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, syncType);
        }
        if (SyncItemType.UpdatePersonOrg.equals((Object)baseType) && dataArray.size() > 0) {
            try {
                String e = BaseSyncFacadeFactory.getLocalInstance(this.ctx).sync(2, "DeleteOrg");
            }
            catch (EASBizException e) {
                logger.error((Object)("\u5220\u9664\u7ec4\u7ec7\u5931\u8d25\u6570\u636e\u4e3a:" + dataArray.toJSONString()));
                e.printStackTrace();
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, syncType));
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (baseEnum != null) {
            return super.getSyncLogColName(itemType);
        }
        return head;
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (baseEnum != null) {
            return super.getSyncLogColValue(itemType);
        }
        return head;
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewPerson.equals((Object)baseEnum)) {
            head = new String[]{"corpUserId", "userNameCn", "mobileNumber", "deptCodes", "order", "position", "sex", "userEmail", "landlineNumber", "businessAddress", "mainCorpDeptCode", "mainDeptCode", "employeeId"};
            return head;
        }
        if (SyncItemType.DeletePerson.equals((Object)baseEnum)) {
            return new String[]{"userId"};
        }
        if (SyncItemType.UpdatePersonCell.equals((Object)baseEnum)) {
            return new String[]{"userId", "mobileNumber"};
        }
        if (SyncItemType.UpdatePersonEmail.equals((Object)baseEnum)) {
            return new String[]{"userId", "userEmail"};
        }
        if (SyncItemType.UpdatePersonName.equals((Object)baseEnum)) {
            return new String[]{"userId", "userNameCn"};
        }
        if (SyncItemType.UpdatePersonGender.equals((Object)baseEnum)) {
            return new String[]{"userId", "sex"};
        }
        if (SyncItemType.UpdatePersonPosition.equals((Object)baseEnum)) {
            return new String[]{"userId", "position"};
        }
        if (SyncItemType.UpdatePersonTelephone.equals((Object)baseEnum)) {
            return new String[]{"userId", "landlineNumber"};
        }
        if (SyncItemType.UpdatePersonWeights.equals((Object)baseEnum)) {
            return new String[]{"userId", "order"};
        }
        if (SyncItemType.UpdatePersonAddress.equals((Object)baseEnum)) {
            return new String[]{"userId", "businessAddress"};
        }
        if (SyncItemType.UpdatePersonNumber.equals((Object)baseEnum)) {
            return new String[]{"userId", "employeeId"};
        }
        if (SyncItemType.UpdatePersonOrg.equals((Object)baseEnum)) {
            return new String[]{"userId", "deptCodes", "mainCorpDeptCode", "mainDeptCode"};
        }
        return head;
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewPerson.equals((Object)baseType)) {
            head = new String[]{"FPersonNumber", "FPersonName", "FCell", "FDepartment", "FWeight", "FPosition", "FGender", "FEmail", "FTelephone", "FAddress", "FOrgNumber", "FDepartment", "FPersonNumber"};
            return head;
        }
        if (SyncItemType.UpdatePersonOrg.equals((Object)baseType)) {
            return new String[]{this.syncCtx.getMappingUserIdColnum(), "FDepartment", "FOrgNumber", "FDepartment"};
        }
        if (SyncItemType.UpdatePersonName.equals((Object)baseType)) {
            return new String[]{this.syncCtx.getMappingUserIdColnum(), "FPersonName"};
        }
        return super.getSyncJsonValue(itemType);
    }

    @Override
    protected String getSyncURL(String itemType) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        if (type != null) {
            if (SyncItemType.AddNewPerson.equals((Object)type)) {
                return WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/user/create");
            }
            if (SyncItemType.GetAllPerson.equals((Object)type)) {
                return WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/user/list");
            }
            if (SyncItemType.DeletePerson.equals((Object)type)) {
                return WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/user/delete");
            }
            if (SyncItemType.UpdatePersonCell.equals((Object)type)) {
                return WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/user/mobilenumber");
            }
            if (SyncItemType.UpdatePersonEmail.equals((Object)type) || SyncItemType.UpdatePersonOrg.equals((Object)type) || SyncItemType.UpdatePersonName.equals((Object)type) || SyncItemType.UpdatePersonGender.equals((Object)type) || SyncItemType.UpdatePersonPosition.equals((Object)type) || SyncItemType.UpdatePersonTelephone.equals((Object)type) || SyncItemType.UpdatePersonAddress.equals((Object)type) || SyncItemType.UpdatePersonWeights.equals((Object)type) || SyncItemType.UpdatePersonNumber.equals((Object)type)) {
                return WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/user/update");
            }
        }
        return null;
    }

    @Override
    protected String getOrgLongNameById(String mainDept) throws BOSException {
        String longName = null;
        String sql = "SELECT FORGLONGNAME FROM T_WL_ORG WHERE FWLORGID = ?";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql, new String[]{mainDept});
        try {
            while (rs.next()) {
                longName = rs.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return longName;
    }

    @Override
    protected void getAllPerson() throws BOSException {
        ArrayList<String> wlOrgIds = new ArrayList<String>();
        JSONArray allUserArray = new JSONArray();
        try {
            String selectWLOrg = this.getSqlByName("getAllOrg");
            IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, selectWLOrg);
            while (rs.next()) {
                wlOrgIds.add(rs.getString("FWLORGID"));
            }
            if (wlOrgIds.size() < 1) {
                return;
            }
            for (String wlOrgId : wlOrgIds) {
                JSONObject response;
                int pageNo = 1;
                do {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("deptCode", wlOrgId);
                    paramMap.put("pageNo", pageNo++ + "");
                    paramMap.put("pageSize", "50");
                    String url = this.getSyncURL(SyncItemType.GetAllPerson.getName());
                    JSONObject url0 = JSONObject.parseObject((String)url);
                    response = WLHttpSendUtil.startGet(url0.getString("url"), paramMap, url0.getString("token"), url0.getJSONObject("hwConfig"));
                    if (!"0".equals(response.getString("code"))) {
                        logger.error((Object)response.toString());
                        throw new BOSException(response.getString("message"));
                    }
                    JSONArray userArray = response.getJSONArray("data");
                    if (userArray.size() <= 0) continue;
                    allUserArray.addAll((Collection)userArray);
                } while (!"1".equals(response.getString("hasMore")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        String sql = "truncate table T_WL_USER";
        EasXtSyncUtil.execute(this.ctx, sql);
        this.insertIntoSyncPersonTable(allUserArray);
    }

    @Override
    protected void insertIntoSyncPersonTable(JSONArray totalArray) throws BOSException {
        String sql = this.getInsertPersonSql();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        ArrayList<String> userIdList = new ArrayList<String>();
        for (int i = 0; i < totalArray.size(); ++i) {
            String weights;
            String nationCell;
            JSONObject json = totalArray.getJSONObject(i);
            logger.info((Object)("WeLink\u4eba\u5458\u4fe1\u606f\u4e3a:" + json.toJSONString()));
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            String userid = json.getString("userId");
            if (userIdList.contains(userid)) continue;
            userIdList.add(userid);
            param.add(userid);
            String name = json.getString("userNameCn");
            param.add(name);
            String nameEn = json.getString("userNameEn");
            param.add(nameEn);
            String string = nationCell = StringUtils.isEmpty((String)json.getString("mobileNumber")) ? "" : json.getString("mobileNumber");
            if (nationCell.startsWith("+86-")) {
                nationCell = nationCell.substring(4, nationCell.length());
            }
            param.add(nationCell);
            String email = json.getString("userEmail");
            param.add(email);
            String mainDept = json.getString("mainDeptCode");
            String orgLongName = "\\";
            if (!"1".equals(mainDept)) {
                orgLongName = this.getOrgLongNameById(mainDept);
            }
            param.add(orgLongName);
            String position = json.getString("position");
            param.add(position);
            String telephone = json.getString("landlineNumber");
            param.add(telephone);
            String sex = json.getString("sex");
            if (sex == null || "".equals(sex)) {
                param.add(null);
            } else {
                param.add("F".equals(json.getString("sex")) ? "2" : "1");
            }
            String address = json.getString("businessAddress");
            param.add(address);
            String jobNo = json.getString("employeeId");
            param.add(jobNo);
            String string2 = weights = json.getJSONObject("orderInDepts") == null ? "0" : json.getJSONObject("orderInDepts").getString(mainDept);
            if (weights == null || "".equals(weights.trim()) || "null".equalsIgnoreCase(weights)) {
                param.add("0");
            } else {
                param.add(weights);
            }
            String status = json.getString("userStatus");
            param.add(status);
            String corpUserId = json.getString("corpUserId");
            param.add(corpUserId);
            param.add(mainDept);
            String mainCorpDeptCode = json.getString("mainCorpDeptCode");
            param.add(mainCorpDeptCode);
            params.add(param.toArray());
        }
        EasXtSyncUtil.executeBatch(this.ctx, sql, params);
    }

    @Override
    protected String getUpdatePersonOrg(String itemType) throws BOSException {
        return this.getSqlByName("selectOrgChanged");
    }

    @Override
    protected String getInsertPersonSql() throws BOSException {
        return this.getSqlByName("insertIntoSyncPersonTable");
    }

    @Override
    protected String getSqlByName(String sqlKey) throws BOSException {
        return WLSyncConfigUtil.getInstance().getValue(sqlKey);
    }

    @Override
    protected String getAddNewPersonSql() throws BOSException {
        return WLSyncConfigUtil.getInstance().getValue("selectAddNewPersonInfo");
    }

    @Override
    protected String getUpdatePersonSql(String itemType) throws BOSException {
        StringBuilder sql = new StringBuilder(WLSyncConfigUtil.getInstance().getValue("selectPersonChangeInfo"));
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        if (type != null) {
            if (SyncItemType.UpdatePersonGender.equals((Object)type)) {
                sql.append(" and (p.FGender != xt.FGender or (p.FGender is not null and xt.FGender is null))");
            } else if (SyncItemType.UpdatePersonName.equals((Object)type)) {
                sql.append(" and (umap.FPersonName != xt.FPersonName)");
            } else if (SyncItemType.UpdatePersonCell.equals((Object)type)) {
                sql.append(" and (umap.FCell != xt.FCell or (umap.FCell is not null and xt.FCell is null))");
            } else if (SyncItemType.UpdatePersonEmail.equals((Object)type)) {
                sql.append(" and (UPPER(umap.FEmail) != UPPER(xt.FEmail) or (umap.FEmail is not null and xt.FEmail is null))");
            } else if (SyncItemType.UpdatePersonPosition.equals((Object)type)) {
                sql.append(" and (umap.FPosition != xt.FPosition or (umap.FPosition is not null and xt.FPosition is null))");
            } else if (SyncItemType.UpdatePersonWeights.equals((Object)type)) {
                sql.append(" and (umap.fweight != xt.fweight)");
            } else if (SyncItemType.UpdatePersonAddress.equals((Object)type)) {
                sql.append(" and (p.FAddress_l2 != xt.FAddress or (p.FAddress_l2 is not null and xt.FAddress is null))");
            } else if (SyncItemType.UpdatePersonTelephone.equals((Object)type)) {
                sql.append(" and (p.FOFFICEPHONE != xt.FTelephone or (p.FOFFICEPHONE is not null and xt.FTelephone is null))");
            } else if (SyncItemType.UpdatePersonNumber.equals((Object)type)) {
                sql.append(" and (umap.FPersonNumber != xt.FJobNo or (umap.FPersonNumber is not null and xt.FJobNo is null))");
            }
            String noSyncSql = " and not exists(select nsp.fpersonid from T_WL_NoSyncPerson nsp where nsp.fpersonid = umap.fpersonid)";
            sql.append(noSyncSql);
        }
        return sql.toString();
    }
}

