/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wxsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncDeptLeaderBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.WXSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncHelper;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WXSyncDeptLeaderService
extends SyncDeptLeaderBaseService {
    public WXSyncDeptLeaderService(SyncContext syncCtx) {
        super(syncCtx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        this.updateDeprLeaderJobInfo();
        this.deleteMapDeptLeader();
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            return super.sync(itemType);
        }
        WXSyncItemType wxType = WXSyncUtil.getWXSyncEnum(itemType);
        if (WXSyncItemType.BatchUpdateDeptLeader.equals((Object)wxType)) {
            String sql = WXSyncConfigUtil.getInstance().getValue("selectOrgLeaderChanged");
            IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
            String[] syncJsonKey = this.getSyncJsonKey(itemType);
            String[] syncJsonValue = this.getSyncJsonValue(itemType);
            String[] syncLogColName = this.getSyncLogColName(itemType);
            String[] syncLogColValue = this.getSyncLogColValue(itemType);
            JSONArray dataArray = new JSONArray();
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logColName", syncLogColName);
            ArrayList logArrays = new ArrayList();
            Object result = null;
            try {
                ArrayList<String> logValue = null;
                while (rowSet.next()) {
                    int i;
                    JSONObject dataJSON = new JSONObject();
                    for (i = 0; i < syncJsonKey.length; ++i) {
                        if ("is_leader_in_dept".equals(syncJsonKey[i])) {
                            ArrayList orgLeaderids = new ArrayList();
                            ArrayList<Integer> userOrgids = new ArrayList<Integer>();
                            String fwxorgids = rowSet.getString("FWXORGIDS");
                            String fpartorgids = rowSet.getString("FPARTORGIDS");
                            if (!StringUtils.isEmpty((String)fwxorgids)) {
                                orgLeaderids.addAll(JSONArray.parseArray((String)rowSet.getString("FWXORGIDS"), Integer.class));
                            }
                            if (!StringUtils.isEmpty((String)fpartorgids)) {
                                userOrgids.addAll(JSONArray.parseArray((String)rowSet.getString("FPARTORGIDS"), Integer.class));
                            }
                            if (userOrgids.size() != 0) {
                                userOrgids.add(0, Integer.parseInt(rowSet.getString("fmaindepartment")));
                            } else if (orgLeaderids.size() == 0) {
                                userOrgids.add(0, Integer.parseInt(rowSet.getString("fmaindepartment")));
                            } else {
                                userOrgids = orgLeaderids;
                            }
                            ArrayList<Integer> userLeadList = new ArrayList<Integer>();
                            for (int j = 0; j < userOrgids.size(); ++j) {
                                if (orgLeaderids.contains(userOrgids.get(j))) {
                                    userLeadList.add(1);
                                    continue;
                                }
                                userLeadList.add(0);
                            }
                            dataJSON.put("department", (Object)userOrgids.toArray());
                            dataJSON.put(syncJsonKey[i], (Object)userLeadList.toArray());
                            continue;
                        }
                        Object value = rowSet.getObject(syncJsonValue[i]);
                        dataJSON.put(syncJsonKey[i], (Object)(value == null ? "" : value.toString()));
                    }
                    logValue = new ArrayList<String>();
                    for (i = 0; i < syncLogColName.length; ++i) {
                        Object value2 = rowSet.getObject(syncLogColValue[i]);
                        logValue.add(value2 == null ? "" : value2.toString());
                    }
                    logArrays.add(logValue);
                    dataArray.add((Object)dataJSON);
                }
                logMap.put("logColValue", logArrays);
                String string = this.syncPart(this.syncCtx, dataArray, itemType, logMap);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
            }
            finally {
                if (rowSet != null) {
                    try {
                        rowSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected String syncPart(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException {
        WXSyncItemType type = WXSyncUtil.getWXSyncEnum(itemType);
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            String url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/update");
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject dataJSON = dataArray.getJSONObject(i);
                result = SyncCommunitcateUtil.getSyncResponse(dataJSON, url);
                logArray.add((Object)result);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }

    @Override
    public String afterSync() throws BOSException, EASBizException {
        return "true";
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        return new String[]{"userid", "is_leader_in_dept"};
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        return new String[]{"fwxid", "fwxorgids"};
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        return new String[]{"FWXId", "FOrgLongNames", "FOldWXOrgIds", "FWXOrgIds"};
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        return new String[]{"FWXId", "FOrgLongNames", "FOldWXOrgIds", "FWXOrgIds"};
    }

    private String insertDeptLeaderInfo() throws BOSException {
        String syncTimeId = SyncLogUtils.getLastSyncTime(this.syncCtx);
        String sql = "SELECT FWXID FROM T_WX_SYNCORGLEADERLOG WHERE FSyncTimeID = '" + syncTimeId + "' and FSUCCESS = 0";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        ArrayList<String> userIds = new ArrayList<String>();
        try {
            while (rs.next()) {
                String userid = rs.getString("FWXID");
                if (StringUtils.isEmpty((String)userid)) continue;
                userIds.add(userid);
            }
            if (userIds.size() <= 1000) {
                HashMap paramMap = new HashMap();
                Map config = new WXSyncHelper(this.ctx).getConfig(this.ctx);
                String secretName = (String)config.get("selfBuildSecret");
                if (StringUtils.isEmpty((String)secretName)) {
                    secretName = (String)config.get("secret");
                }
                String syncUrl = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/get", "selfBuildtoken", secretName);
                for (int i = 0; i < userIds.size(); ++i) {
                    String userID = (String)userIds.get(i);
                    String syncReqUrl = syncUrl + "&userid=" + userID;
                    try {
                        JSONObject result = SyncCommunitcateUtil.getSyncResponse(syncUrl);
                        JSONArray departs = result.getJSONArray("department");
                        JSONArray isLeadOrgs = result.getJSONArray("is_leader_in_dept");
                        for (int j = 0; j < departs.size(); ++j) {
                            if (!"0".equals(isLeadOrgs.get(j).toString())) continue;
                            departs.remove(j);
                            isLeadOrgs.remove(j);
                            --j;
                        }
                        if (departs.size() <= 0) continue;
                        ArrayList<String> param = new ArrayList<String>();
                        Collections.sort((List)departs);
                        param.add(departs.toString());
                        param.add(userID);
                        paramMap.put(userID, param);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Set allUserId = paramMap.keySet();
                if (allUserId.size() < 1) {
                    return null;
                }
                StringBuilder sb = new StringBuilder("select FUserId FROM T_WX_ORGLEADER WHERE FUserId in (");
                for (String uId : allUserId) {
                    sb.append("'" + uId + "',");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(")");
                IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
                String updateSql = "UPDATE T_WX_ORGLEADER SET FOrgIds = ? WHERE FUserId = ?";
                while (rs1.next()) {
                    String FUserId = rs1.getString("FUserId");
                    updateParams.add(((List)paramMap.get(FUserId)).toArray());
                    paramMap.remove(FUserId);
                }
                EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
                String insertSql = "INSERT INTO T_WX_ORGLEADER (FID,FOrgIds,FUserId) VALUES (?,?,?)";
                Set insertUserIdSet = paramMap.keySet();
                ArrayList<Object[]> updateParams1 = new ArrayList<Object[]>();
                for (String uId : insertUserIdSet) {
                    ArrayList<String> updateParam = new ArrayList<String>();
                    updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                    updateParam.addAll((Collection)paramMap.get(uId));
                    updateParams1.add(updateParam.toArray());
                }
                EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "true";
    }

    private void updateDeprLeaderJobInfo() throws BOSException {
        HashMap<String, Object> partMap = new HashMap<String, Object>();
        String sql = WXSyncConfigUtil.getInstance().getValue("selectOrgLeader");
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        try {
            while (rs.next()) {
                String personId = rs.getString("FPersonId");
                String wxId = rs.getString("FXTId");
                Object info = (OrgLeaderInfo)partMap.get(personId);
                if (info == null) {
                    info = new OrgLeaderInfo(personId, wxId);
                    partMap.put(personId, info);
                }
                ((OrgLeaderInfo)info).addEasOrgId(rs.getString("FEasOrgId"));
                ((OrgLeaderInfo)info).addWXOrgId(rs.getString("FWXOrgId"));
                String orgLongName = "\\".equals(rs.getString("FOrgLongName")) ? EasXtCommonUtils.getEasTopUnitName(this.ctx) : rs.getString("FOrgLongName");
                ((OrgLeaderInfo)info).addOrgLongName(orgLongName);
            }
            Set personIdSet = partMap.keySet();
            if (personIdSet.size() < 1) {
                return;
            }
            StringBuilder sb = new StringBuilder("select FPersonId FROM T_PM_EASWXORGLEADERMAP WHERE FPersonId in (");
            for (String pId : personIdSet) {
                sb.append("'" + pId + "',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") ");
            IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            String updateSql = "UPDATE T_PM_EASWXORGLEADERMAP SET FEASORGIDS = ?,FWXORGIDS = ?,FORGLONGNAMES = ? WHERE FPERSONID = ?";
            while (rs1.next()) {
                ArrayList<String> updateParam = new ArrayList<String>();
                String personId = rs1.getString("FPersonId");
                OrgLeaderInfo pi = (OrgLeaderInfo)partMap.get(personId);
                updateParam.add(pi.easOrgIds.toString());
                updateParam.add(pi.wxOrgIds.toString().replace(" ", ""));
                updateParam.add(pi.orgLongName.toString());
                updateParam.add(pi.personId);
                updateParams.add(updateParam.toArray());
                partMap.remove(personId);
            }
            EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
            String insertSql = "INSERT INTO T_PM_EASWXORGLEADERMAP (FID,FPERSONID,FEASORGIDS,FWXORGIDS,FWXID,FORGLONGNAMES ) VALUES (?,?,?,?,?,?)";
            Set personIdSet1 = partMap.keySet();
            ArrayList<Object[]> updateParams1 = new ArrayList<Object[]>();
            for (String pid : personIdSet1) {
                ArrayList<String> updateParam = new ArrayList<String>();
                OrgLeaderInfo pi = (OrgLeaderInfo)partMap.get(pid);
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.add(pi.personId);
                updateParam.add(pi.easOrgIds.toString());
                updateParam.add(pi.wxOrgIds.toString().replace(" ", ""));
                updateParam.add(pi.wXId);
                updateParam.add(pi.orgLongName.toString());
                updateParams1.add(updateParam.toArray());
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void deleteMapDeptLeader() throws BOSException {
        String sql = WXSyncConfigUtil.getInstance().getValue("deleteNotExistOrgLeader");
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    class OrgLeaderInfo {
        String personId;
        String wXId;
        List<String> easOrgIds;
        List<String> wxOrgIds;
        List<String> orgLongName;

        OrgLeaderInfo(String personId, String wxId) {
            this.personId = personId;
            this.wXId = wxId;
            this.easOrgIds = new ArrayList<String>();
            this.wxOrgIds = new ArrayList<String>();
            this.orgLongName = new ArrayList<String>();
        }

        public void addEasOrgId(String easOrgId) {
            if (!this.easOrgIds.contains(easOrgId)) {
                this.easOrgIds.add(easOrgId);
            }
        }

        public void addWXOrgId(String wxOrgId) {
            if (!this.wxOrgIds.contains(wxOrgId)) {
                this.wxOrgIds.add(wxOrgId);
            }
        }

        public void addOrgLongName(String orgLongName) {
            this.orgLongName.add(orgLongName);
        }
    }
}

