/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wxsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncPersonBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.EasWXSyncFacadeFactory;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.IEasWXSyncFacade;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncHelper;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncURLUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WXSyncPersonService
extends SyncPersonBaseService {
    private static Logger logger = Logger.getLogger(WXSyncPersonService.class);

    public WXSyncPersonService(SyncContext ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataBind() throws BOSException, EASBizException {
        String sql = WXSyncConfigUtil.getInstance().getValue("selectNeedBindPersonByName");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        try {
            while (rowSet.next()) {
                JSONObject syncResponse;
                JSONObject dataJSON;
                String syncURL;
                String userid = "";
                String useridLocal = rowSet.getString("fUserid");
                String name = rowSet.getString("fPersonName");
                String mobile = rowSet.getString("fCell");
                String email = rowSet.getString("fEmail");
                if (!StringUtils.isEmpty((String)mobile)) {
                    syncURL = this.getSyncURL("getIDByMobile");
                    dataJSON = new JSONObject();
                    dataJSON.put("mobile", (Object)mobile);
                    syncResponse = SyncCommunitcateUtil.getSyncResponse(dataJSON, syncURL);
                    logger.error((Object)("WX_DUPLICATE_CELL:" + syncResponse.toString()));
                    if (!"0".equals(syncResponse.getString("errcode")) || !(userid = syncResponse.getString("userid")).equals(useridLocal)) continue;
                    String sqlByCell = this.getSqlByName("bindPersonAfterFailByCell");
                    logger.error((Object)("sqlByCell 60104:" + sqlByCell + ";" + userid + "," + name + "," + mobile));
                    EasXtSyncUtil.execute(this.ctx, sqlByCell, new String[]{userid, mobile});
                    continue;
                }
                if (StringUtils.isEmpty((String)email)) continue;
                syncURL = this.getSyncURL("getIDByEmail");
                dataJSON = new JSONObject();
                dataJSON.put("email", (Object)email);
                dataJSON.put("email_type", (Object)"2");
                syncResponse = SyncCommunitcateUtil.getSyncResponse(dataJSON, syncURL);
                logger.error((Object)("WX_DUPLICATE_EMAIL:" + syncResponse.toString()));
                if (!"0".equals(syncResponse.getString("errcode")) || !(userid = syncResponse.getString("userid")).equals(useridLocal)) continue;
                String sqlByEmail = this.getSqlByName("bindPersonAfterFailByEmail");
                logger.error((Object)("sqlByEmail 60106:" + sqlByEmail + ";" + userid + "," + name + "," + email));
                EasXtSyncUtil.execute(this.ctx, sqlByEmail, new String[]{userid, email});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            try {
                rowSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncUpdatePersonOrg(String itemType) throws BOSException {
        String sql = this.getUpdatePersonOrg(itemType);
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                for (i = 0; i < syncJsonKey.length; ++i) {
                    String keyData = syncJsonKey[i];
                    if ("department".equalsIgnoreCase(keyData)) {
                        String mainDepart = rowSet.getString(syncJsonValue[i]);
                        ArrayList<String> orgids = new ArrayList<String>();
                        orgids.add(mainDepart);
                        String ssql = "SELECT top 1 forgids FROM t_wx_part where fuserid = '" + rowSet.getString("fxtid") + "'";
                        IRowSet rowSet1 = EasXtSyncUtil.executeQuery(this.ctx, ssql);
                        while (rowSet1.next()) {
                            orgids.addAll(JSONArray.parseArray((String)rowSet1.getString("forgids"), String.class));
                        }
                        dataJSON.put(keyData, (Object)orgids.toArray());
                        continue;
                    }
                    if ("main_department".equalsIgnoreCase(keyData)) {
                        dataJSON.put(keyData, (Object)new int[]{rowSet.getInt(syncJsonValue[i])});
                        continue;
                    }
                    Object value = rowSet.getObject(syncJsonValue[i]);
                    dataJSON.put(keyData, (Object)(value == null ? "" : value.toString()));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    Object value2 = rowSet.getObject(syncLogColValue[i]);
                    logValue.add(value2 == null ? "" : value2.toString());
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            result = this.syncPerson(this.syncCtx, dataArray, itemType, logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    protected void getAllPerson() throws BOSException {
        JSONArray array = new JSONArray();
        try {
            String url = this.getSyncURL(SyncItemType.GetAllPerson.getName());
            JSONObject response = SyncCommunitcateUtil.getSyncResponse(url);
            if (!"0".equals(response.getString("errcode"))) {
                if (this.syncCtx.getType() == 0 && "48009".equals(response.getString("errcode"))) {
                    url = this.getSyncURL(SyncItemType.GetAllPerson.getName(), "selfBuildtoken", "selfBuildSecret");
                    response = SyncCommunitcateUtil.getSyncResponse(url);
                    if (!"0".equals(response.getString("errcode"))) {
                        throw new BOSException(response.getString("errmsg"));
                    }
                } else {
                    throw new BOSException(response.getString("errmsg"));
                }
            }
            if ((array = response.getJSONArray("userlist")) != null) {
                logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a " + array.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        this.clearXtPersonDatas();
        if (array != null && array.size() > 0) {
            this.insertIntoSyncPersonTable(array);
            this.insertIntoSyncDeptLeaderTable(array);
        }
    }

    private void insertIntoSyncDeptLeaderTable(JSONArray totalArray) throws BOSException {
        Map wxSyncConfig = new WXSyncHelper(this.ctx).getConfig(this.ctx);
        if ("1".equals(wxSyncConfig.get("UpdateDepartmentPerson").toString())) {
            String clearSql = "truncate table T_WX_ORGLEADER";
            EasXtSyncUtil.execute(this.ctx, clearSql);
            String insertSql = "INSERT INTO T_WX_ORGLEADER (FID,FUserId,FOrgIds) VALUES (?,?,?)";
            logger.error((Object)insertSql);
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            ArrayList<String> param = null;
            for (int i = 0; i < totalArray.size(); ++i) {
                JSONObject json = totalArray.getJSONObject(i);
                String userid = json.getString("userid");
                JSONArray departs = json.getJSONArray("department");
                JSONArray isLeaderInDepts = json.getJSONArray("is_leader_in_dept");
                for (int j = 0; j < departs.size(); ++j) {
                    if (!"1".equals(isLeaderInDepts.get(j).toString())) continue;
                    String depart = departs.get(j).toString();
                    param = new ArrayList<String>();
                    param.add(BOSUuid.create((String)"F4AF4F04").toString());
                    param.add(userid);
                    param.add(depart);
                    params.add(param.toArray());
                    if (params.size() % 1000 != 0) continue;
                    EasXtSyncUtil.executeBatch(this.ctx, insertSql, params);
                    params.clear();
                }
            }
            logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u5fae\u4fe1\u90e8\u95e8\u8d1f\u8d23\u4eba\u8868----------");
            if (params.size() != 0) {
                EasXtSyncUtil.executeBatch(this.ctx, insertSql, params);
            }
            logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u5fae\u4fe1\u90e8\u95e8\u8d1f\u8d23\u4eba\u8868\u6210\u529f----------");
        }
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (baseEnum != null) {
            return super.getSyncLogColName(itemType);
        }
        return head;
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (baseEnum != null) {
            return super.getSyncLogColValue(itemType);
        }
        return head;
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            if (SyncItemType.AddNewPerson.equals((Object)baseType)) {
                head = new String[]{"userid", "name", "mobile", "department", "order", "position", "gender", "email", "telephone", "address", "main_department"};
                return head;
            }
            if (SyncItemType.UpdatePersonWeights.equals((Object)baseType)) {
                head = new String[]{"userid", "department", "order"};
                return head;
            }
            return super.getSyncJsonKey(itemType);
        }
        return null;
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewPerson.equals((Object)baseType)) {
            head = new String[]{"FPersonNumber", "FPersonName", "FCell", "FDepartment", "FWeight", "FPosition", "FGender", "FEmail", "FTelephone", "FAddress", "FDepartment"};
            return head;
        }
        if (SyncItemType.UpdatePersonWeights.equals((Object)baseType)) {
            head = new String[]{"fxtid", "FDepartment", "FWeight"};
            return head;
        }
        return super.getSyncJsonValue(itemType);
    }

    @Override
    protected String getSyncURL(String itemType) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        String url = null;
        if (type != null) {
            if (SyncItemType.AddNewPerson.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/create");
                return url;
            }
            if (SyncItemType.GetAllPerson.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/list");
                url = url + "&department_id=1&fetch_child=1";
                return url;
            }
            if (SyncItemType.DeletePerson.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/delete");
            }
            if (SyncItemType.UpdatePersonCell.equals((Object)type) || SyncItemType.UpdatePersonEmail.equals((Object)type) || SyncItemType.UpdatePersonOrg.equals((Object)type) || SyncItemType.UpdatePersonName.equals((Object)type) || SyncItemType.UpdatePersonGender.equals((Object)type) || SyncItemType.UpdatePersonPosition.equals((Object)type) || SyncItemType.UpdatePersonTelephone.equals((Object)type) || SyncItemType.UpdatePersonAddress.equals((Object)type) || SyncItemType.UpdatePersonWeights.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/update");
                return url;
            }
        }
        if ("getIDByMobile".equals(itemType)) {
            url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/getuserid");
        }
        if ("getIDByEmail".equals(itemType)) {
            url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/get_userid_by_email");
        }
        return url;
    }

    @Override
    protected String getSyncURL(String itemType, String tokenType, String secretName) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        String url = null;
        if (type != null) {
            if (SyncItemType.AddNewPerson.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/create");
                return url;
            }
            if (SyncItemType.GetAllPerson.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/list", tokenType, secretName);
                url = url + "&department_id=1&fetch_child=1";
                return url;
            }
            if (SyncItemType.DeletePerson.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/delete");
            }
            if (SyncItemType.UpdatePersonCell.equals((Object)type) || SyncItemType.UpdatePersonEmail.equals((Object)type) || SyncItemType.UpdatePersonOrg.equals((Object)type) || SyncItemType.UpdatePersonName.equals((Object)type) || SyncItemType.UpdatePersonGender.equals((Object)type) || SyncItemType.UpdatePersonPosition.equals((Object)type) || SyncItemType.UpdatePersonTelephone.equals((Object)type) || SyncItemType.UpdatePersonAddress.equals((Object)type) || SyncItemType.UpdatePersonWeights.equals((Object)type)) {
                url = WXSyncURLUtil.getSyncUrl(this.ctx, "/cgi-bin/user/update");
                return url;
            }
        }
        return url;
    }

    @Override
    protected String getOrgLongNameById(String mainDept) throws BOSException {
        String longName = null;
        String sql = "SELECT FORGLONGNAME FROM T_WX_ORG WHERE FWXORGID = ?";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql, new String[]{mainDept});
        try {
            while (rs.next()) {
                longName = rs.getString(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return longName;
    }

    @Override
    protected String getAddNewPersonSql() throws BOSException {
        String syncAccording = "0";
        try {
            IEasWXSyncFacade easWXSync = EasWXSyncFacadeFactory.getLocalInstance(this.ctx);
            syncAccording = easWXSync.getConfig().get("sycnAccording").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("1".equals(syncAccording)) {
            return WXSyncConfigUtil.getInstance().getValue("selectAddNewPersonInfoByPersonName");
        }
        return WXSyncConfigUtil.getInstance().getValue("selectAddNewPersonInfo");
    }

    @Override
    protected String getUpdatePersonSql(String itemType) throws BOSException {
        StringBuilder sql = new StringBuilder(WXSyncConfigUtil.getInstance().getValue("selectPersonChangeInfo"));
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        if (type != null) {
            if (SyncItemType.UpdatePersonGender.equals((Object)type)) {
                sql.append(" and (p.FGender != xt.FGender or xt.FGender is null or xt.FGender = '')");
            } else if (SyncItemType.UpdatePersonName.equals((Object)type)) {
                sql.append(" and (ltrim(rtrim(case when(umap.FUserId is null) then umap.FPersonName else umap.FUserName end)) != ltrim(rtrim(xt.FPersonName)) or xt.FPersonName is null or xt.FPersonName = '')");
            } else if (SyncItemType.UpdatePersonCell.equals((Object)type)) {
                sql.append(" and (ltrim(rtrim(umap.FCell)) != ltrim(rtrim(xt.FCell)) or (umap.fcell is not null and (xt.FCell is null or xt.FCell = '')))");
            } else if (SyncItemType.UpdatePersonEmail.equals((Object)type)) {
                sql.append(" and (ltrim(rtrim(umap.FEmail)) != ltrim(rtrim(xt.FEmail)) or (umap.femail is not null and (xt.FEmail is null or xt.FEmail = '')))");
            } else if (SyncItemType.UpdatePersonPosition.equals((Object)type)) {
                sql.append(" and (ltrim(rtrim(umap.FPosition)) != ltrim(rtrim(xt.FPosition)) or xt.FPosition is null or xt.FPosition = '')");
            } else if (SyncItemType.UpdatePersonWeights.equals((Object)type)) {
                sql.append(" and (umap.fweight != xt.fweight or xt.fweight is null or xt.fweight = '')");
            } else if (SyncItemType.UpdatePersonAddress.equals((Object)type)) {
                sql.append(" and (ltrim(rtrim(p.FAddress_l2)) != ltrim(rtrim(xt.FAddress))  or (p.FADDRESS_L2 is not null and (xt.faddress is null or xt.faddress = '')))");
            } else if (SyncItemType.UpdatePersonTelephone.equals((Object)type)) {
                sql.append(" and (ltrim(rtrim(p.FOFFICEPHONE)) != ltrim(rtrim(xt.FTelephone)) or (p.FOFFICEPHONE is not null and (xt.FTelephone is null or xt.FTelephone = '')))");
            }
            String noSyncSql = " and not exists(select nsp.fpersonid from T_WX_NoSyncPerson nsp where nsp.fpersonid = umap.fpersonid)";
            sql.append(noSyncSql);
        }
        return sql.toString();
    }

    @Override
    protected void insertIntoSyncPersonTable(JSONArray totalArray) throws BOSException {
        String sql = this.getInsertPersonSql();
        sql = SyncBaseUtil.fillTemplateSql(sql, 1, this.syncCtx.getSyncTableName());
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            String userid = json.getString("userid");
            param.add(userid);
            String name = json.getString("name");
            param.add(name);
            String cell = json.getString("mobile");
            String email = json.getString("email");
            String gender = json.getString("gender");
            String address = json.getString("address");
            if (cell == null && email == null && gender == null && address == null) {
                cell = "20220620";
                email = "20220620";
                gender = "8";
                address = "20220620";
            }
            param.add(cell);
            param.add(email);
            String mainDept = json.getString("main_department");
            String orgLongName = "\\";
            if (!"1".equals(mainDept)) {
                orgLongName = this.getOrgLongNameById(mainDept);
            }
            param.add(orgLongName);
            String position = json.getString("position");
            param.add(position);
            String telephone = json.getString("telephone");
            param.add(telephone);
            param.add(gender);
            param.add(address);
            String weights = ((String[])json.getObject("order", String[].class))[0];
            if (weights == null || "".equals(weights.trim()) || "null".equalsIgnoreCase(weights)) {
                param.add("0");
            } else {
                param.add(weights);
            }
            String status = json.getString("status");
            param.add(status);
            String openId = json.getString("open_userid");
            param.add(openId);
            param.add(mainDept);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u7ec4\u7ec7\u8868----------");
        EasXtSyncUtil.executeBatch(this.ctx, sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u7ec4\u7ec7\u8868\u6210\u529f----------");
    }

    @Override
    protected String getUpdatePersonOrg(String itemType) throws BOSException {
        return this.getSqlByName("selectOrgChanged");
    }

    @Override
    protected String getInsertPersonSql() throws BOSException {
        return this.getSqlByName("insertIntoSyncPersonTable");
    }

    @Override
    protected String getSqlByName(String sqlKey) throws BOSException {
        return WXSyncConfigUtil.getInstance().getValue(sqlKey);
    }

    @Override
    protected void updateMapPersonWeights(Context ctx) throws BOSException {
        String dbType = (String)ctx.get((Object)"dbType");
        String valueKey = "";
        if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
            valueKey = "updatePersonWeights_Oracle";
        } else if ("MS SQL Server".equals(dbType)) {
            valueKey = "updatePersonWeights_sqlServer";
        } else if ("DB2 UDB".equals(dbType)) {
            valueKey = "updatePersonWeights_DB2";
        } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
            valueKey = "updatePersonWeights_PG";
        }
        if (!StringUtils.isEmpty((String)valueKey)) {
            String sql = this.getSqlByName(valueKey);
            sql = "/*dialect*/" + sql;
            EasXtSyncUtil.execute(ctx, sql);
        }
    }

    @Override
    protected String syncUpdatePerson(String itemType) throws BOSException {
        String result;
        block10: {
            SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
            if (!SyncItemType.UpdatePersonWeights.equals((Object)type)) {
                return super.syncUpdatePerson(itemType);
            }
            String sql = this.getUpdatePersonSql(itemType);
            String[] syncJsonKey = this.getSyncJsonKey(itemType);
            String[] syncJsonValue = this.getSyncJsonValue(itemType);
            String[] syncLogColName = this.getSyncLogColName(itemType);
            String[] syncLogColValue = this.getSyncLogColValue(itemType);
            JSONArray dataArray = new JSONArray();
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logColName", syncLogColName);
            ArrayList logArrays = new ArrayList();
            JSONObject dataJSON = null;
            ArrayList<String> logValue = null;
            ArrayList<String> orgids = null;
            ArrayList<String> orders = null;
            String partSql = null;
            result = null;
            try {
                IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
                IRowSet partRowSet = null;
                while (rowSet.next()) {
                    int i;
                    dataJSON = new JSONObject();
                    orgids = new ArrayList<String>();
                    orders = new ArrayList<String>();
                    for (i = 0; i < syncJsonKey.length; ++i) {
                        if ("department".equalsIgnoreCase(syncJsonKey[i])) {
                            orgids.add(rowSet.getString(syncJsonValue[i]));
                            partSql = "SELECT top 1 forgids FROM t_wx_part where fuserid = '" + rowSet.getString("fxtid") + "'";
                            partRowSet = EasXtSyncUtil.executeQuery(this.ctx, partSql);
                            while (partRowSet.next()) {
                                orgids.addAll(JSONArray.parseArray((String)partRowSet.getString("forgids"), String.class));
                            }
                            dataJSON.put(syncJsonKey[i], (Object)orgids.toArray());
                            continue;
                        }
                        if ("order".equalsIgnoreCase(syncJsonKey[i])) {
                            orders.add(rowSet.getString(syncJsonValue[i]));
                            for (int j = 1; j < orgids.size(); ++j) {
                                orders.add("0");
                            }
                            dataJSON.put(syncJsonKey[i], (Object)orders.toArray());
                            continue;
                        }
                        dataJSON.put(syncJsonKey[i], (Object)(rowSet.getString(syncJsonValue[i]) == null ? "" : rowSet.getString(syncJsonValue[i])));
                    }
                    logValue = new ArrayList<String>();
                    for (i = 0; i < syncLogColName.length; ++i) {
                        logValue.add(rowSet.getString(syncLogColValue[i]) == null ? "" : rowSet.getString(syncLogColValue[i]));
                    }
                    logArrays.add(logValue);
                    dataArray.add((Object)dataJSON);
                }
                logMap.put("logColValue", logArrays);
                result = this.syncPerson(this.syncCtx, dataArray, itemType, logMap);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!(e instanceof BOSException)) break block10;
                throw (BOSException)((Object)e);
            }
        }
        return result;
    }

    @Override
    protected void bindPersonAfterSyncPerson(JSONObject requestDate, JSONObject responseData) throws BOSException {
        String errorCode = responseData.getString("errcode");
        String mobile = requestDate.getString("mobile");
        String email = requestDate.getString("email");
        String name = requestDate.getString("name");
        String userid = "";
        try {
            if ("0".equals(errorCode)) {
                userid = requestDate.getString("userid");
                if (!StringUtils.isEmpty((String)userid) && !StringUtils.isEmpty((String)name)) {
                    if (!StringUtils.isEmpty((String)mobile)) {
                        String sqlByCell = this.getSqlByName("bindPersonAfterSuccessByCell");
                        logger.error((Object)("sqlByCell:" + sqlByCell + ";" + userid + "," + mobile + "," + name));
                        EasXtSyncUtil.execute(this.ctx, sqlByCell, new String[]{userid, mobile, name});
                    } else if (!StringUtils.isEmpty((String)email)) {
                        String sqlByEmail = this.getSqlByName("bindPersonAfterSuccessByEmail");
                        logger.error((Object)("sqlByEmail:" + sqlByEmail + ";" + userid + "," + email + "," + name));
                        EasXtSyncUtil.execute(this.ctx, sqlByEmail, new String[]{userid, email, name});
                    }
                }
            } else if ("60104".equals(errorCode)) {
                if (!StringUtils.isEmpty((String)mobile)) {
                    String syncURL = this.getSyncURL("getIDByMobile");
                    JSONObject dataJSON = new JSONObject();
                    dataJSON.put("mobile", (Object)mobile);
                    JSONObject syncResponse = SyncCommunitcateUtil.getSyncResponse(dataJSON, syncURL);
                    logger.error((Object)("WX_DUPLICATE_CELL:" + syncResponse.toString()));
                    if ("0".equals(syncResponse.getString("errcode"))) {
                        userid = syncResponse.getString("userid");
                        String sqlByCell = this.getSqlByName("bindPersonAfterFailByCell");
                        logger.error((Object)("sqlByCell 60104:" + sqlByCell + ";" + userid + "," + mobile));
                        EasXtSyncUtil.execute(this.ctx, sqlByCell, new String[]{userid, mobile});
                    }
                }
            } else if ("60106".equals(errorCode) && !StringUtils.isEmpty((String)email)) {
                String syncURL = this.getSyncURL("getIDByEmail");
                JSONObject dataJSON = new JSONObject();
                dataJSON.put("email", (Object)email);
                dataJSON.put("email_type", (Object)"2");
                JSONObject syncResponse = SyncCommunitcateUtil.getSyncResponse(dataJSON, syncURL);
                logger.error((Object)("WX_DUPLICATE_EMAIL:" + syncResponse.toString()));
                if ("0".equals(syncResponse.getString("errcode"))) {
                    userid = syncResponse.getString("userid");
                    String sqlByEmail = this.getSqlByName("bindPersonAfterFailByEmail");
                    logger.error((Object)("sqlByEmail 60106:" + sqlByEmail + ";" + userid + "," + email));
                    EasXtSyncUtil.execute(this.ctx, sqlByEmail, new String[]{userid, email});
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncPerson(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException, IOException {
        if (!SyncItemType.AddNewPerson.equals(itemType)) {
            return super.syncPerson(syncCtx, dataArray, itemType, logList);
        }
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        if (type == null) {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)type));
        }
        if (dataArray.size() < 1) {
            return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
        }
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        Boolean isAutoInvite = Boolean.TRUE;
        try {
            IEasWXSyncFacade easWXSync = EasWXSyncFacadeFactory.getLocalInstance(this.ctx);
            Map wxSyncConfig = easWXSync.getConfig();
            if (null != wxSyncConfig.get("isAutoInvite")) {
                isAutoInvite = "1".equals(wxSyncConfig.get("isAutoInvite").toString());
            }
            String url = this.getSyncURL(itemType);
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject dataJSON = dataArray.getJSONObject(i);
                dataJSON.put("to_invite", (Object)isAutoInvite);
                logger.info((Object)("syncPerson  url:" + url));
                logger.info((Object)("syncPerson  dataJSON:" + dataJSON.toJSONString()));
                result = SyncCommunitcateUtil.getSyncResponse(dataJSON, url);
                logger.info((Object)("syncPerson  result:" + result.toJSONString()));
                logArray.add((Object)result);
                this.bindPersonAfterSyncPerson(dataJSON, result);
            }
        }
        catch (Exception e) {
            logger.error((Object)"syncAddNewPerson failed");
            e.printStackTrace();
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }
}

