/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.web.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncType;
import com.kingdee.eas.base.xtsync.web.AbstractEasXtSyncService;
import com.kingdee.eas.base.xtsync.web.ExceptionLogInfo;
import com.kingdee.eas.base.xtsync.web.ExceptionLogService;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;

public class SyncDeptLeaderService
extends AbstractEasXtSyncService {
    private Context ctx;

    public SyncDeptLeaderService(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public String beforeSync(EasXtSyncType syncType) throws BOSException, EASBizException {
        if (this.isItemUpdate(this.ctx, "isUpdateDepartmentPerson")) {
            this.updateXtOrgLeader(this.ctx);
            this.updateOrgLeaderToMap(this.ctx);
        }
        return "true";
    }

    @Override
    public String sync(EasXtSyncItemType itemType) throws BOSException, EASBizException, EASBizException {
        if (EasXtSyncItemType.BatchSetOrgLeader.equals((Object)itemType)) {
            return this.syncBatchSetOrgLeader(this.ctx, itemType);
        }
        if (EasXtSyncItemType.BatchDeleteOrgLeader.equals((Object)itemType)) {
            return this.syncBatchDeleteOrgLeader(this.ctx, itemType);
        }
        throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
    }

    @Override
    public String afterSync(EasXtSyncType syncType) throws BOSException, EASBizException {
        if (this.isItemUpdate(this.ctx, "isUpdateDepartmentPerson")) {
            this.updateXtOrgLeader(this.ctx);
            this.updateOrgLeaderToMap(this.ctx);
        }
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncBatchSetOrgLeader(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        Map xtConfig = easXtSyncUtil.getXtConfig(ctx);
        String sql = null;
        sql = "1".equals(xtConfig.get("isUpdatePluralityMsg")) ? EasXtSyncUtil.getInstance(ctx).getValue("selectAddMiddleOrgLeader") : EasXtSyncUtil.getInstance(ctx).getValue("selectAddMiddleOrgLeaderNoPart");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                JSONObject logO = new JSONObject();
                String department = rowSet.getString("orgLongName");
                o.put("openId", (Object)rowSet.getString("xtId"));
                o.put("orgId", (Object)rowSet.getString("orgId"));
                o.put("weights", (Object)rowSet.getString("weights"));
                o.put("commitId", (Object)department);
                dataArray.add((Object)o);
                logO.put("openId", (Object)rowSet.getString("xtId"));
                logO.put("department", (Object)department);
                logO.put("orgId", (Object)rowSet.getString("orgId"));
                logO.put("weights", (Object)rowSet.getString("weights"));
                logO.put("commitId", (Object)department);
                logO.put("personName", (Object)rowSet.getString("personName"));
                logO.put("cell", (Object)rowSet.getString("cell"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncOrgLeader(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******syncBatchDeleteOrgLeader one more again********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncOrgLeader(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******syncBatchDeleteOrgLeader over********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("syncBatchSetOrgLeader", e, null, itemType.getAlias());
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncBatchDeleteOrgLeader(Context ctx, EasXtSyncItemType itemType) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectDeleteMiddleOrgLeader");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                JSONObject logO = new JSONObject();
                String department = rowSet.getString("orgLongName");
                o.put("openId", (Object)rowSet.getString("xtId"));
                o.put("orgId", (Object)rowSet.getString("orgId"));
                o.put("commitId", (Object)department);
                dataArray.add((Object)o);
                logO.put("openId", (Object)rowSet.getString("xtId"));
                logO.put("department", (Object)department);
                logO.put("orgId", (Object)rowSet.getString("orgId"));
                logO.put("commitId", (Object)department);
                logO.put("personName", (Object)rowSet.getString("personName"));
                logO.put("cell", (Object)rowSet.getString("cell"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncOrgLeader(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******syncBatchDeleteOrgLeader one more again********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncOrgLeader(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******syncBatchDeleteOrgLeader over********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("syncBatchDeleteOrgLeader", e, null, itemType.getAlias());
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        sql = EasXtSyncUtil.getInstance(ctx).getValue("deleteDeletedMiddleOrgLeader");
        EasXtSyncUtil.execute(ctx, sql);
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    private void syncOrgLeader(Context ctx, JSONArray dataArray, JSONArray logArray, EasXtSyncItemType itemType) throws EasXtException, BOSException {
        logger.error((Object)("*****" + itemType.getName() + "********"));
        boolean isAll = true;
        String description = "\u4e91\u4e4b\u5bb6\u63a5\u53e3\u8bbf\u95ee\u5f02\u5e38";
        JSONObject result = null;
        try {
            JSONObject response = null;
            if (EasXtSyncItemType.BatchSetOrgLeader.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchSetOrgLeader(dataArray);
            } else if (EasXtSyncItemType.BatchDeleteOrgLeader.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncBatchDeleteOrgLeader(dataArray);
            } else {
                return;
            }
            if (response.getBooleanValue("success")) {
                logger.error((Object)("***" + itemType.getName() + "  success*********"));
                isAll = false;
                result = response;
            } else {
                logger.error((Object)("***" + itemType.getName() + "  fail*********" + response.toString()));
                description = response.getString("error");
                result = response;
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
        catch (EasXtException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
            throw e;
        }
        finally {
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
    }
}

