/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.xtutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.xtsync.xtutil.WordsUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EasXtCommonUtils {
    public static final String[] ITEMS = new String[]{"DeleteOrg", "AddNewOrg", "UpdateOrgName", "DeletePerson", "AddNewPerson", "UpdatePersonStatus", "UpdatePersonOrg", "UpdatePersonOther", "BatchSetOrgLeader", "BatchDeleteOrgLeader", "BatchSetPartJob", "BatchDeletePartJob"};

    public static String formLongTimeString(Date time) {
        if (null == time) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(time);
    }

    public static Date formLongTimeString(String time) {
        if (null == time) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return formatter.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formDateString(Date time) {
        if (null == time) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(time);
    }

    public static Date formDateString(String time) {
        if (null == time) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formShortTimeString(Date time) {
        if (null == time) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        return formatter.format(time);
    }

    public static String formShortTimeString(Date time, String formaText) throws Exception {
        if (StringUtils.isEmpty((String)formaText)) {
            throw new Exception("\u683c\u5f0f\u5316\u53c2\u6570\u9519\u8bef formText: " + formaText);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(formaText);
        return formatter.format(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEasTopUnitName(Context ctx) {
        String sql = "select FName_L2 from t_org_admin where FParentID is null or FParentID = ''";
        IRowSet rs = null;
        String topUnitName = "";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                topUnitName = rs.getString(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return topUnitName;
    }

    public static void listMapSortByPinYin(List resultList, boolean isAsc, String sortKey) throws Exception {
        Collections.sort(resultList, new SortCompare(isAsc, sortKey));
    }

    public static String getIncludeStr(String[] inArr) {
        String inStr = "";
        int j = inArr.length;
        for (int i = 0; i < j; ++i) {
            inStr = inStr + "'" + inArr[i] + "',";
        }
        inStr = inStr.length() > 0 ? inStr.substring(0, inStr.length() - 1) : "''";
        return inStr;
    }

    public static boolean isMobile(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static String toPreSta(List params) {
        if (params.size() == 0) {
            return "('')";
        }
        StringBuffer paramStr = new StringBuffer("(");
        for (int i = 0; i < params.size(); ++i) {
            if (i == params.size() - 1) {
                paramStr.append("?)");
                continue;
            }
            paramStr.append("?,");
        }
        return paramStr.toString();
    }

    public static boolean isPhone(String str) {
        Pattern p = null;
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        Matcher m1 = null;
        Matcher m2 = null;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        p1 = Pattern.compile("^[0][1-9]{2,3}-[0-9]{5,10}$");
        p2 = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
        m = p.matcher(str);
        m1 = p1.matcher(str);
        m2 = p2.matcher(str);
        return m.matches() || m1.matches() || m2.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXtCellById(Context ctx, String xtid) {
        String sql = "select fcell from t_pm_easxtusermap where fxtid = '" + xtid + "'";
        String cell = "";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                cell = rs.getString("fcell");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastCheckTime(Context ctx) throws BOSException {
        String sql = "select max(fchecktime) from t_xt_checktime";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                Timestamp checktime = rs.getTimestamp(1);
                if (checktime == null) {
                    String string = "1900-01-01 01:01:01";
                    return string;
                }
                String string = EasXtCommonUtils.formLongTimeString(checktime);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return "1900-01-01 01:01:01";
    }

    public static void insertsynchTime(Context ctx) throws BOSException {
        String sql = "insert into t_xt_synchtime (fid,fsynchtime) select newbosid('F4AF4F04'),now()";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static boolean checkSpecialParam(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() > 0 && (str.indexOf(".") > -1 || str.indexOf("%2f") > -1 || str.indexOf("%2F") > -1 || str.indexOf("/") > -1)) {
            return true;
        }
        return str.indexOf("'") > -1 || str.indexOf("%27") > -1 || str.indexOf("(") > -1 || str.indexOf("%28") > -1;
    }

    public static void sendMessage(Context ctx, String[] ids, String messageStr, String senderStr, String bodyStr) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = EasXtCommonUtils.getContextLocales(ctx);
        Locale locale2 = null;
        if (ids == null || ids.length == 0) {
            return;
        }
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", messageStr, locale2);
            message.setLocaleStringHeader("sender", senderStr, locale2);
            if (bodyStr == null) {
                message.setLocaleStringHeader("body", messageStr, locale2);
                continue;
            }
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 40);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (ids[i] == null) continue;
            message.setStringHeader("receiver", ids[i]);
            senderAgent.sendMessage(message);
        }
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    static class SortCompare
    implements Comparator {
        private boolean isAsc = true;
        private String sortKey = "";
        private WordsUtil wordsUtil = new WordsUtil();

        public SortCompare(boolean isAsc, String sortKey) {
            this.isAsc = isAsc;
            this.sortKey = sortKey;
        }

        public int compare(Object o1, Object o2) {
            String str0 = "";
            String str1 = "";
            if (null != o1) {
                str0 = (String)((Map)o1).get(this.sortKey);
            }
            if (null != o2) {
                str0 = (String)((Map)o1).get(this.sortKey);
            }
            int leng = str0.length() > str1.length() ? str1.length() : str0.length();
            for (int i = 0; i < leng; ++i) {
                int result = this.compareChar(str0.charAt(i), str1.charAt(i));
                if (result == 0) continue;
                return this.isAsc ? result : result * -1;
            }
            return this.isAsc ? str0.length() - str1.length() : str1.length() - str0.length();
        }

        private int compareChar(char c0, char c1) {
            int result = 0;
            boolean ifC0IsChinese = this.wordsUtil.isChinese(c0);
            boolean ifC1IsChinese = this.wordsUtil.isChinese(c1);
            if (!ifC0IsChinese && !ifC1IsChinese) {
                if (Character.isLetter(c0) && Character.isLetter(c1)) {
                    if (Math.abs(c0 - c1) == 32) {
                        return c1 - c0;
                    }
                    c0 = Character.toUpperCase(c0);
                    c1 = Character.toUpperCase(c1);
                }
                result = c0 - c1;
            } else {
                result = ifC0IsChinese && ifC1IsChinese ? this.wordsUtil.getQuanPin(String.valueOf(c0)).compareTo(this.wordsUtil.getQuanPin(String.valueOf(c1))) : (ifC0IsChinese ? 1 : -1);
            }
            return result;
        }
    }
}

