/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.xtutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class EasXtSyncUtilExt {
    private Logger logger = Logger.getLogger(EasXtSyncUtilExt.class);
    private Document doc = null;
    private static Map config = null;
    private static EasXtSyncUtilExt instance = null;
    private long xmlFileTime = 0L;
    private static String FILE_SQL = System.getProperty("eas.properties.dir") + File.separator + "easXtSyncExt.xml";

    private EasXtSyncUtilExt() {
        this.loadXml();
    }

    public static EasXtSyncUtilExt getInstance() {
        if (instance == null) {
            instance = new EasXtSyncUtilExt();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReloadXml() {
        File file = new File(FILE_SQL);
        if (!file.exists()) {
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            XMLWriter writer = null;
            try {
                file.createNewFile();
                this.doc = DocumentHelper.createDocument();
                Element root = this.doc.addElement("nodes");
                Element e = root.addElement("node");
                e.addAttribute("ID", "Example");
                e.addAttribute("desc", "SQL \u811a\u672c\u6837\u4f8b");
                e.setText("select u.fid from t_pm_user u");
                fos = new FileOutputStream(file);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                OutputFormat of = new OutputFormat();
                of.setEncoding("UTF-8");
                of.setIndent(true);
                of.setIndent("    ");
                of.setNewlines(true);
                writer = new XMLWriter((Writer)osw, of);
                writer.write(this.doc);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        long lastModefiedTime = file.lastModified();
        if (this.xmlFileTime == 0L || this.xmlFileTime < lastModefiedTime) {
            this.xmlFileTime = lastModefiedTime;
            return true;
        }
        return false;
    }

    private void loadXml() {
        if (!this.isReloadXml()) {
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(FILE_SQL);
            SAXReader reader = new SAXReader();
            this.doc = reader.read((InputStream)is);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getValue(String key) {
        this.loadXml();
        if (this.doc == null) {
            return null;
        }
        Element element = this.doc.elementByID(key);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }
}

