/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.Reference;
import com.tool.classfile.sc;

public class Const
extends Reference {
    public final Object value;
    public final String type;

    public Const(boolean b) {
        super(3);
        this.value = new Boolean(b);
        this.type = "Z";
    }

    public Const(byte b) {
        super(3);
        this.value = new Byte(b);
        this.type = "B";
    }

    public Const(char c) {
        super(3);
        this.value = new Character(c);
        this.type = "C";
    }

    public Const(int _value) {
        super(3);
        this.value = new Integer(_value);
        this.type = "I";
    }

    public Const(long _value) {
        super(5);
        this.value = new Long(_value);
        this.type = "J";
    }

    public Const(float _value) {
        super(5);
        this.value = new Float(_value);
        this.type = "F";
    }

    public Const(double _value) {
        super(6);
        this.value = new Double(_value);
        this.type = "D";
    }

    public Const(String _value) {
        super(8);
        this.value = _value;
        this.type = "Ljava/lang/String;";
    }

    public boolean boolValue() {
        return this.intValue() != 0;
    }

    public byte byteValue() {
        return ((Number)this.value).byteValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    public short shortValue() {
        return ((Number)this.value).shortValue();
    }

    public int intValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1 : 0;
        }
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue();
        }
        return ((Number)this.value).intValue();
    }

    public long longValue() {
        return ((Number)this.value).longValue();
    }

    public float floatValue() {
        return ((Number)this.value).floatValue();
    }

    public double doubleValue() {
        return ((Number)this.value).doubleValue();
    }

    public String stringValue() {
        return (String)this.value;
    }

    public String toString() {
        if (this.type.equals("C")) {
            return "'" + sc.sourceString(this.value.toString()) + "'";
        }
        if (this.type.equals("Ljava/lang/String;")) {
            return "\"" + sc.sourceString(this.value.toString()) + "\"";
        }
        if (this.type.equals("F")) {
            return this.value.toString() + "F";
        }
        if (this.type.equals("J")) {
            return this.value.toString() + "L";
        }
        return this.value.toString();
    }

    protected int refHashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    protected boolean refEquals(Reference ref) {
        return this.value.equals(((Const)ref).value);
    }

    public Const convert(String toType) {
        try {
            if (toType.equals("N")) {
                if (sc.isNumber(this.type)) {
                    return this;
                }
                return null;
            }
            if (toType.equals("VALUE")) {
                return this;
            }
            if (toType.equals("V")) {
                return null;
            }
            if (sc.isBoolean(toType)) {
                return new Const(this.boolValue());
            }
            if (sc.isByte(toType)) {
                return new Const(this.byteValue());
            }
            if (sc.isChar(toType)) {
                return new Const(this.charValue());
            }
            if (sc.isShort(toType)) {
                return new Const(this.shortValue());
            }
            if (sc.isInteger(toType)) {
                return new Const(this.intValue());
            }
            if (sc.isLong(toType)) {
                return new Const(this.longValue());
            }
            if (sc.isFloat(toType)) {
                return new Const(this.floatValue());
            }
            if (sc.isDouble(toType)) {
                return new Const(this.doubleValue());
            }
            if (sc.isString(toType) || toType.equals("Ljava/lang/Object;")) {
                return new Const(this.stringValue());
            }
            return null;
        }
        catch (Exception _) {
            return null;
        }
    }
}

