/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.mainmenu;

import com.kingdee.eas.cp.common.mainmenu.DbConnector;
import com.kingdee.eas.cp.common.mainmenu.EasMenuItemXmlElement;
import com.kingdee.eas.cp.common.mainmenu.EasMenuTreeXml;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class EasMenu {
    private Logger logger = Logger.getLogger((String)EasMenu.class.getName());
    private Connection con = null;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private String sqlStr = null;
    private String selectStr = " select FName_L2, FUiClassName, FUiClassParam, FUiOprt, FOpenMethod,FID, FParent,FIsLeaf  ";
    private String fromStr = "";
    private String ordStr = "";
    private String filterStr = "";
    private EasMenuTreeXml easMenuTreeXml = null;

    public EasMenu(String jndiName) {
        this.createConnection(jndiName);
    }

    public ResultSet fetchEasMenu() {
        this.queryEasMenu();
        return this.rs;
    }

    public void genEasMenu(String xmlFile) {
        this.queryEasMenu();
        this.createXmlDoc(xmlFile);
    }

    private void createConnection(String jndiName) {
        this.con = DbConnector.getConnection(jndiName);
    }

    public void close() {
        this.rs = null;
        this.ps = null;
        DbConnector.close();
        this.con = null;
    }

    private void createXmlDoc(String xmlFile) {
        this.easMenuTreeXml = new EasMenuTreeXml(xmlFile);
        this.easMenuTreeXml.createRootElement();
        this.addAllChild();
        if (xmlFile == null) {
            this.easMenuTreeXml.save();
        } else {
            this.easMenuTreeXml.saveXmlDoc();
        }
    }

    private void addAllChild() {
        if (this.rs == null) {
            return;
        }
        try {
            String uiOpenMethod = null;
            String idStr = null;
            String pos = "10";
            String fid = null;
            String pid = null;
            int isLeaf = 1;
            int count = 0;
            String idPrevStr = null;
            while (this.rs.next()) {
                ++count;
                String uiName = this.rs.getString(1);
                String uiClassName = this.rs.getString(2);
                String uiClassParam = this.rs.getString(3);
                String uiOprt = this.rs.getString(4);
                uiOpenMethod = this.rs.getString(5);
                fid = this.rs.getString(6);
                pid = this.rs.getString(7);
                isLeaf = this.rs.getInt(8);
                idPrevStr = isLeaf == 0 ? "Prod" + count : "ProdF" + count;
                idStr = idPrevStr + " ___" + uiClassName + "___" + uiClassParam + "___" + uiOprt + "___" + uiOpenMethod;
                this.easMenuTreeXml.peekCurrentParent(pid);
                Element el = this.easMenuTreeXml.createElement(uiName, idStr, pos);
                this.easMenuTreeXml.createChild(el);
                if (isLeaf != 0) continue;
                EasMenuItemXmlElement item = new EasMenuItemXmlElement(el, fid);
                this.easMenuTreeXml.push(item);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
        }
    }

    private void queryEasMenu() {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.selectStr);
        strBuff.append(this.fromStr);
        strBuff.append(this.filterStr);
        strBuff.append(this.ordStr);
        this.sqlStr = strBuff.toString();
        this.logger.debug((Object)this.sqlStr);
        try {
            this.ps = this.con.prepareStatement(this.sqlStr);
            this.rs = this.ps.executeQuery();
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
        }
    }

    public String getFilterStr() {
        return this.filterStr;
    }

    public String getFromStr() {
        return this.fromStr;
    }

    public String getOrdStr() {
        return this.ordStr;
    }

    public void setFilterStr(String string) {
        this.filterStr = string;
    }

    public void setFromStr(String string) {
        this.fromStr = string;
    }

    public void setOrdStr(String string) {
        this.ordStr = string;
    }

    public String getSelectStr() {
        return this.selectStr;
    }

    public void setSelectStr(String string) {
        this.selectStr = string;
    }

    public EasMenuTreeXml getEasMenuTreeXml() {
        return this.easMenuTreeXml;
    }
}

