/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.mainmenu;

import com.kingdee.eas.cp.common.mainmenu.EasMenuItemXmlElement;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class EasMenuTreeXml {
    private Document doc = null;
    private Element rootElement = null;
    private String strXMLPath = null;
    private Stack easMenuItemStack = null;

    public EasMenuTreeXml(String xmlfile) {
        this.strXMLPath = xmlfile;
        this.easMenuItemStack = new Stack();
    }

    public void saveXmlDoc() {
        this.save();
        try {
            Format format = Format.getCompactFormat();
            format.setIndent("");
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            format.setEncoding("GBK");
            XMLOutputter out = new XMLOutputter(format);
            FileOutputStream fileOut = new FileOutputStream(this.strXMLPath);
            out.output(this.doc, (OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.doc = new Document(this.rootElement);
    }

    public void createRootElement() {
        Namespace ns = Namespace.getNamespace((String)"wsc", (String)"htc/TreeView.htc");
        Element el = new Element("treeview", ns);
        el.setAttribute("id", "treeview1");
        el.setAttribute("style", "width:100%");
        el.setAttribute("checkedNodeRule", "1");
        this.rootElement = el;
    }

    public Element createElement(String childText, String childId, String childPos) {
        Namespace ns = Namespace.getNamespace((String)"wsc", (String)"htc/TreeView.htc");
        Element el = new Element("node", ns);
        el.setAttribute("text", childText);
        el.setAttribute("id", childId);
        el.setAttribute("textleftpos", childPos);
        return el;
    }

    public void peekCurrentParent(String pid) {
        EasMenuItemXmlElement item;
        while (!this.easMenuItemStack.empty() && !this.isChild((item = (EasMenuItemXmlElement)this.easMenuItemStack.peek()).getFid(), pid)) {
            this.pop();
        }
    }

    private boolean isChild(String fidInStack, String pid) {
        boolean isChildNode = false;
        if (fidInStack != null && fidInStack.equalsIgnoreCase(pid) || fidInStack == null && pid == null) {
            isChildNode = true;
        }
        return isChildNode;
    }

    public void createChild(Element el) {
        this.getCurrentParent().getElement().addContent((Content)el);
    }

    public EasMenuItemXmlElement getCurrentParent() {
        EasMenuItemXmlElement parentElement = null;
        if (this.easMenuItemStack.empty()) {
            parentElement = new EasMenuItemXmlElement(this.rootElement, null);
            this.push(parentElement);
        } else {
            parentElement = (EasMenuItemXmlElement)this.easMenuItemStack.peek();
        }
        return parentElement;
    }

    public void push(EasMenuItemXmlElement item) {
        this.easMenuItemStack.push(item);
    }

    public void pop() {
        if (!this.easMenuItemStack.empty()) {
            this.easMenuItemStack.pop();
        }
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document document) {
        this.doc = document;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(Element element) {
        this.rootElement = element;
    }
}

