/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.converters;

import net.buffalo.protocal.converters.Converter;
import net.buffalo.protocal.io.MarshallingContext;
import net.buffalo.protocal.io.StreamReader;
import net.buffalo.protocal.io.StreamWriter;
import net.buffalo.protocal.io.UnmarshallingContext;

public class ExceptionConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        return Throwable.class.isAssignableFrom(type);
    }

    @Override
    public void marshal(Object source, MarshallingContext marshallingContext, StreamWriter streamWriter) {
        Throwable ex = (Throwable)source;
        String detail = "";
        if (ex.getCause() != null) {
            detail = "caused by: " + ex.getCause().getMessage();
        }
        streamWriter.startNode("fault");
        this.node(streamWriter, "string", "code");
        this.node(streamWriter, "string", ex.getClass().getName());
        this.node(streamWriter, "string", "message");
        this.node(streamWriter, "string", ex.getMessage());
        this.node(streamWriter, "string", "detail");
        this.node(streamWriter, "string", detail);
        streamWriter.endNode();
    }

    private void node(StreamWriter streamWriter, String tagName, String value) {
        streamWriter.startNode(tagName);
        streamWriter.setValue(value);
        streamWriter.endNode();
    }

    @Override
    public Object unmarshal(StreamReader reader, UnmarshallingContext unmarshallingContext) {
        throw new UnsupportedOperationException();
    }
}

