/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.io;

import java.io.IOException;
import java.io.Writer;
import net.buffalo.protocal.io.StreamWriter;
import net.buffalo.protocal.util.FastStack;
import net.buffalo.protocal.util.QuickWriter;

public class FastStreamWriter
implements StreamWriter {
    private static final char[] NULL = "&#x0;".toCharArray();
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] SLASH_R = "&#x0D;".toCharArray();
    private static final char[] QUOT = "&quot;".toCharArray();
    private static final char[] APOS = "&apos;".toCharArray();
    private QuickWriter writer;
    private FastStack stack;
    private int depth = 0;

    public FastStreamWriter(Writer out) {
        this.writer = new QuickWriter(out);
        this.stack = new FastStack(5);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public void endNode() {
        --this.depth;
        this.write("</");
        this.write((String)this.stack.pop());
        this.write(">");
        if (this.depth == 0) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void setValue(String text) {
        if (text == null) {
            this.write("");
            return;
        }
        try {
            this.writeText(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeText(String text) throws IOException {
        int length = text.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\u0000': {
                    this.writer.write(NULL);
                    continue block9;
                }
                case '&': {
                    this.writer.write(AMP);
                    continue block9;
                }
                case '<': {
                    this.writer.write(LT);
                    continue block9;
                }
                case '>': {
                    this.writer.write(GT);
                    continue block9;
                }
                case '\"': {
                    this.writer.write(QUOT);
                    continue block9;
                }
                case '\'': {
                    this.writer.write(APOS);
                    continue block9;
                }
                case '\r': {
                    this.writer.write(SLASH_R);
                    continue block9;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }

    private void write(String text) {
        this.writer.write(text);
    }

    @Override
    public void startNode(String name) {
        this.writer.write("<");
        this.writer.write(name);
        this.writer.write(">");
        this.stack.push(name);
        ++this.depth;
    }
}

