/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.request;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RequestContext {
    public static final String SESSION = "net.buffalo.request.RequestContext.session";
    public static final String APPLICATION = "net.buffalo.request.RequestContext.application";
    public static final String COOKIE = "net.buffalo.request.RequestContext.cookie";
    public static final String PARAMETER = "net.buffalo.request.RequestContext.parameter";
    public static final String HTTP_REQUEST = "net.buffalo.request.RequestContext.http_request";
    public static final String HTTP_RESPONSE = "net.buffalo.request.RequestContext.http_response";
    public static final String HTTP_SESSION = "net.buffalo.request.RequestContext.http_session";
    public static final String SERVLET_CONTEXT = "net.buffalo.request.RequestContext.servlet_context";
    private static ThreadLocal requestContext = new RequestContextThreadLocal();
    private Map context;

    public RequestContext(Map context) {
        this.context = context;
    }

    public void setSession(Map sessionMap) {
        this.put(SESSION, sessionMap);
    }

    public Map getSession() {
        return (Map)this.context.get(SESSION);
    }

    public void setCookie(Map cookieMap) {
        this.put(COOKIE, cookieMap);
    }

    public Map getCookie() {
        return (Map)this.context.get(COOKIE);
    }

    public void setParameter(Map parameterMap) {
        this.put(PARAMETER, parameterMap);
    }

    public Map getParameter() {
        return (Map)this.context.get(PARAMETER);
    }

    public void setHttpRequest(HttpServletRequest request) {
        this.put(HTTP_REQUEST, request);
    }

    public HttpServletRequest getHttpRequest() {
        return (HttpServletRequest)this.context.get(HTTP_REQUEST);
    }

    public void setServletContext(ServletContext servletContext) {
        this.put(SERVLET_CONTEXT, servletContext);
    }

    public ServletContext getServletContext() {
        return (ServletContext)this.context.get(SERVLET_CONTEXT);
    }

    public void setHttpResponse(HttpServletResponse response) {
        this.put(HTTP_RESPONSE, response);
    }

    public HttpServletResponse getHttpResponse() {
        return (HttpServletResponse)this.context.get(HTTP_RESPONSE);
    }

    public HttpSession getHttpSession() {
        HttpSession session = this.getHttpRequest().getSession();
        if (session == null) {
            session = this.getHttpRequest().getSession(true);
        }
        return session;
    }

    public void setApplication(Map applicationMap) {
        this.put(APPLICATION, applicationMap);
    }

    public Map getApplication() {
        return (Map)this.context.get(APPLICATION);
    }

    private void put(String key, Object value) {
        this.context.put(key, value);
    }

    public static RequestContext getContext() {
        RequestContext context = (RequestContext)requestContext.get();
        if (context == null) {
            context = new RequestContext(new HashMap());
            RequestContext.setContext(context);
        }
        return context;
    }

    public static void setContext(RequestContext context) {
        requestContext.set(context);
    }

    private static class RequestContextThreadLocal
    extends ThreadLocal {
        private RequestContextThreadLocal() {
        }

        protected Object initialValue() {
            return new RequestContext(new HashMap());
        }
    }
}

