/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.app;

import com.kingdee.eas.cp.eip.sso.app.LdapItem;
import com.kingdee.eas.cp.eip.sso.app.LdapMapEASItem;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigElementInfo;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.user.XmlUtils;
import com.kingdee.eas.cp.eip.sso.xml.INode;
import com.kingdee.eas.cp.eip.sso.xml.NodeFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LdapConfigManager {
    protected Logger logger = Logger.getLogger(LdapConfigManager.class);
    private String filename = "ldapConfig.xml";
    private FileOutputStream fileos = null;
    private File fw = null;
    private BufferedInputStream bis = null;
    private static LdapConfigManager ldapConfigManager = null;

    private LdapConfigManager() {
    }

    public static LdapConfigManager initLdapConfigManager() {
        if (ldapConfigManager == null) {
            ldapConfigManager = new LdapConfigManager();
        }
        return ldapConfigManager;
    }

    public String getPath() {
        try {
            System.getProperty("portal.config");
        }
        catch (Exception e) {
            this.logger.info((Object)("LdapDNConfigManager System getProperty error " + e));
        }
        if (System.getProperty("portal.config") == null) {
            this.logger.info((Object)"LdapDNConfigManager System getProperty is null ");
        }
        if (System.getProperty("portal.config").length() == 0) {
            this.logger.info((Object)"LdapDNConfigManager System getProperty is null ");
        }
        String portalStr = System.getProperty("portal.config");
        String str1 = "portalConfig.xml";
        String interStr = portalStr.substring(0, portalStr.length() - str1.length());
        this.logger.info((Object)("LdapDNConfigManager path:" + interStr));
        String path = interStr + this.filename;
        this.logger.info((Object)("LdapDNConfigManager path:" + path));
        return path;
    }

    private File getFile() throws IOException {
        this.fw = new File("W:" + File.separator + "eas" + File.separator + "Server" + File.separator + "server" + File.separator + "deploy" + File.separator + "portalConfig" + File.separator + this.filename);
        if (this.fw.exists() && this.fw.length() == 0L) {
            IOException x = new IOException("LdapDNConfig file is null");
            throw x;
        }
        return this.fw;
    }

    private FileOutputStream getPrintWriter() throws IOException {
        this.fileos = new FileOutputStream(this.getFile());
        return this.fileos;
    }

    private void close() throws IOException {
        if (this.fileos != null) {
            this.fileos.flush();
            this.fileos.close();
        }
        if (this.bis != null) {
            this.bis.close();
        }
    }

    public void write(HashMap map) throws IOException {
        StringBuffer sb = new StringBuffer();
        LdapItem item = null;
        List list = null;
        Map.Entry entry2 = null;
        Iterator tempit = null;
        for (Map.Entry entry2 : map.entrySet()) {
            item = (LdapItem)entry2.getValue();
            sb.append("        <ldapDNnode name=\"" + entry2.getKey().toString() + "\" value=\"" + item.getDn() + "\">\r\n");
            sb.append("            <relativelyName>" + item.getRelativelyName() + "</relativelyName>\r\n");
            sb.append("            <easRelativelyName>" + XmlUtils.encodedXmlData(item.getEasRelativelyName()) + "</easRelativelyName>\r\n");
            sb.append("            <adduction>" + XmlUtils.encodedXmlData(item.getAdduction()) + "</adduction>\r\n");
            sb.append("            <importSwitch>" + XmlUtils.encodedXmlData(item.getImportSwitch()) + "</importSwitch>\r\n");
            sb.append("            <parent>" + XmlUtils.encodedXmlData(item.getParent()) + "</parent>\r\n");
            sb.append("            <easEntryID>" + XmlUtils.encodedXmlData(item.getEasEntryID()) + "</easEntryID>\r\n");
            sb.append("            <easEntryPwd>" + XmlUtils.encodedXmlData(item.getEasEntryPwd()) + "</easEntryPwd>\r\n");
            list = item.getObjectClass();
            if (list.size() != 0) {
                tempit = list.iterator();
                while (tempit.hasNext()) {
                    sb.append("            <objectClass>" + XmlUtils.encodedXmlData(tempit.next().toString()) + "</objectClass>\r\n");
                }
                list = item.getMustValue();
                if (list.size() != 0) {
                    tempit = list.iterator();
                    while (tempit.hasNext()) {
                        sb.append("            <mustvalue>" + XmlUtils.encodedXmlData(tempit.next().toString()) + "</mustvalue>\r\n");
                    }
                }
                if ((list = item.getMapValue()).size() != 0) {
                    for (LdapMapEASItem ldapMapEASItem : list) {
                        sb.append("            <mapping name=\"" + ldapMapEASItem.getLdapProName() + "\" value=\"" + ldapMapEASItem.getEASProName() + "\"/>\r\n");
                    }
                }
            }
            sb.append("        </ldapDNnode>\r\n");
        }
        String charset = "UTF-8";
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n";
        this.fileos = this.getPrintWriter();
        this.fileos.write(xmlHeader.getBytes(charset));
        this.fileos.write("<config>\r\n".getBytes(charset));
        byte[] outBytes = sb.toString().getBytes(charset);
        int bufSize = 4096;
        int start = 0;
        int len = bufSize;
        int i = 1;
        while (start < outBytes.length) {
            if (start + len > outBytes.length) {
                len = outBytes.length - start;
            }
            this.fileos.write(outBytes, start, len);
            start = bufSize * (++i - 1);
        }
        this.fileos.write("</config>".getBytes(charset));
        this.close();
    }

    public void getAdduction(String nodeName) {
    }

    public static void main(String[] args) {
        LdapConfigManager ldap = new LdapConfigManager();
        try {
            ldap.getReadXML();
        }
        catch (UserSyncConfigParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private INode[] getChildNodes(INode node, String name) {
        ArrayList<INode> result = new ArrayList<INode>();
        for (INode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new INode[result.size()]);
    }

    public HashMap getReadXML() throws UserSyncConfigParseException, IOException {
        String ldapResxNodeName = "ldapDNnode";
        String ldapResxAttrName = "name";
        try {
            this.bis = new BufferedInputStream(new FileInputStream(this.getFile()));
        }
        catch (IOException e) {
            this.logger.info((Object)("LdapMapEASConfig file is wrong!" + e));
            throw e;
        }
        HashMap<String, LdapItem> ldapResourcesMap = new HashMap<String, LdapItem>();
        INode root = null;
        try {
            root = NodeFactory.build(this.bis);
        }
        catch (IOException e) {
            throw new UserSyncConfigParseException("Invalidate LdapDN config file.expected:<" + UserSyncConfigElementInfo.getRootNodeName() + ">", e);
        }
        if (root == null) {
            throw new UserSyncConfigParseException("Invalidate LdapDN config file.expected:<" + UserSyncConfigElementInfo.getRootNodeName() + ">");
        }
        INode[] ldapResxNodes = this.getChildNodes(root, ldapResxNodeName);
        LdapItem ldapResx = null;
        String ldapResxKey = "";
        for (int i = 0; i < ldapResxNodes.length; ++i) {
            ldapResxKey = ldapResxNodes[i].getAttribute(ldapResxAttrName);
            ldapResx = this.buildUserResource(ldapResxNodes[i]);
            ldapResourcesMap.put(ldapResxKey, ldapResx);
        }
        return ldapResourcesMap;
    }

    private LdapItem buildUserResource(INode resourceNode) throws UserSyncConfigParseException {
        ArrayList<String> objectAy = new ArrayList<String>();
        ArrayList<String> mustAy = new ArrayList<String>();
        ArrayList<LdapMapEASItem> mapAy = new ArrayList<LdapMapEASItem>();
        String ldapResxAttrValue = "value";
        String objectClassName = "objectClass";
        String mustValueName = "mustvalue";
        String mapValueName = "mapping";
        String relativelyValueName = "relativelyName";
        String easRelativelyValueName = "easRelativelyName";
        String adductionValueName = "adduction";
        String importSwitchValueName = "importSwitch";
        String parentValueName = "parent";
        String easEntryIDValueName = "easEntryID";
        String easEntryPwdValueName = "easEntryPwd";
        String ldapResxAttrName = "name";
        LdapItem result = new LdapItem();
        LdapMapEASItem ldapMapEASItem = null;
        result.setDn(resourceNode.getAttribute(ldapResxAttrValue));
        String nodeValue = "";
        for (INode childNode = resourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (objectClassName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                objectAy.add(nodeValue);
                continue;
            }
            if (mustValueName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                mustAy.add(nodeValue);
                continue;
            }
            if (mapValueName.equalsIgnoreCase(childNode.getNodeName())) {
                ldapMapEASItem = new LdapMapEASItem();
                ldapMapEASItem.setLdapProName(childNode.getAttribute(ldapResxAttrName));
                ldapMapEASItem.setEASProName(childNode.getAttribute(ldapResxAttrValue));
                mapAy.add(ldapMapEASItem);
                continue;
            }
            if (relativelyValueName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setRelativelyName(nodeValue);
                continue;
            }
            if (easRelativelyValueName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setEasRelativelyName(nodeValue);
                continue;
            }
            if (adductionValueName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setAdduction(nodeValue);
                continue;
            }
            if (importSwitchValueName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setImportSwitch(nodeValue);
                continue;
            }
            if (parentValueName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setParent(nodeValue);
                continue;
            }
            if (easEntryIDValueName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setEasEntryID(nodeValue);
                continue;
            }
            if (!easEntryPwdValueName.equalsIgnoreCase(childNode.getNodeName())) continue;
            nodeValue = childNode.getNodeValue();
            result.setEasEntryPwd(nodeValue);
        }
        result.setMapValue(mapAy);
        result.setObjectClass(objectAy);
        result.setMustValue(mustAy);
        Iterator it = result.getObjectClass().iterator();
        while (it.hasNext()) {
            this.logger.info((Object)("objectclass:::" + it.next().toString()));
        }
        it = result.getMustValue().iterator();
        while (it.hasNext()) {
            this.logger.info((Object)("mustvalue:::" + it.next().toString()));
        }
        for (LdapMapEASItem aa : result.getMapValue()) {
            this.logger.info((Object)("easpro:::" + aa.getEASProName()));
            this.logger.info((Object)("ldappro:::" + aa.getLdapProName()));
        }
        this.logger.info((Object)("getDn:::" + result.getDn()));
        this.logger.info((Object)("getRelativelyName:::" + result.getRelativelyName()));
        this.logger.info((Object)("getEasRelativelyName:::" + result.getEasRelativelyName()));
        this.logger.info((Object)("getAdduction:::" + result.getAdduction()));
        this.logger.info((Object)("getImportSwitch:::" + result.getImportSwitch()));
        this.logger.info((Object)("getParent:::" + result.getParent()));
        this.logger.info((Object)("getEasEntryID:::" + result.getEasEntryID()));
        this.logger.info((Object)("getEasEntryPwd:::" + result.getEasEntryPwd()));
        this.logger.info((Object)"--------------------------------------------------------");
        return result;
    }
}

