/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ldapAdapter;

import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LdapExtendUtil {
    public static final String DNSTR = "distinguishedName";
    public static final String[] DN_ATTR = new String[]{"distinguishedName"};
    public static final String[] DEFAULT_ATTR = new String[0];
    public static final String DEFAULT_FILTER = "(objectclass=*)";
    public static final String USERSYNCRESOURCE = "com.kingdee.eas.cp.eip.sso.UserSyncResource";
    public static final String STRSUCCESS = "success";
    public static final String STRLOST = "lost";
    private static LdapExtendUtil ldapExtendServerUtil = null;

    private LdapExtendUtil() {
    }

    public static LdapExtendUtil init() {
        if (ldapExtendServerUtil == null) {
            ldapExtendServerUtil = new LdapExtendUtil();
        }
        return ldapExtendServerUtil;
    }

    public HashMap setHashMap(HashMap map, String strtime) throws Exception {
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            this.setHashMap(map, entry.getKey().toString(), strtime);
        }
        return map;
    }

    public HashMap setHashMap(HashMap map, String id, String strtime) throws Exception {
        if (null != map && map.containsKey(id)) {
            UserResource userResource = (UserResource)map.get(id);
            HashMap userSyncConfigMap = userResource.getUserSyncConfigItemMap();
            Iterator ite = userSyncConfigMap.entrySet().iterator();
            Map.Entry entry = null;
            String strkey = null;
            UserSyncConfigItem userSyncConfigItem = null;
            while (ite.hasNext()) {
                entry = ite.next();
                userSyncConfigItem = (UserSyncConfigItem)entry.getValue();
                strkey = (String)entry.getKey();
                userSyncConfigMap.put(strkey, userSyncConfigItem);
            }
            userResource.setLastTime(strtime);
            map.put(id, userResource);
            return map;
        }
        return null;
    }

    public String fileName(String name) {
        char c = '_';
        name = name.replace('/', c);
        name = name.replace('\\', c);
        name = name.replace('.', c);
        name = name.replace(',', c);
        name = name.replace(';', c);
        name = name.replace(':', c);
        name = name.replace('~', c);
        return name;
    }

    public String updateDN(String dn) {
        if ((dn = dn.trim()).indexOf("distinguishedName:") != -1) {
            return dn.substring("distinguishedName: ".length(), dn.length());
        }
        return dn;
    }

    public Object[] getFilterParams(UserSyncConfigItem configItem) {
        String lastSyncUbound;
        String lastSync = configItem.getLastSync();
        if (lastSync == null || "".equals(lastSync)) {
            lastSync = "19900101010101.0Z";
        }
        if ((lastSyncUbound = configItem.getLastSyncUbound()) == null || "".equals(lastSyncUbound)) {
            Calendar cal = Calendar.getInstance();
            Date currentDate = cal.getTime();
            lastSyncUbound = this.getLastSync(currentDate);
        }
        Object[] filterParam = new Object[]{lastSync, lastSyncUbound};
        return filterParam;
    }

    private String getLastSync(Date currentDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String result = format.format(currentDate);
        result = result + "000101.0Z";
        return result;
    }

    public String[] string2Atts(String temp) {
        String[] attrNames = new String[]{};
        attrNames = temp.indexOf(44) > -1 ? temp.split(",") : new String[]{new String(temp)};
        return attrNames;
    }
}

