/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.user;

import com.kingdee.eas.cp.eip.sso.user.IDatasourceUtil;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigManager;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DbUtil
implements IDatasourceUtil {
    protected DataSource ds;
    protected Connection conn;
    protected JdbcRowSet rowSet;
    private static Logger logger = Logger.getLogger((String)DbUtil.class.getName());

    @Override
    public Object lookup(String userSyncResxName) throws NamingException {
        UserResource userSyncResx = UserSyncConfigManager.get(userSyncResxName);
        String jndiName = userSyncResx.getJndiName();
        InitialContext ctx = new InitialContext();
        this.ds = (DataSource)ctx.lookup(jndiName);
        return this.ds;
    }

    @Override
    public Object getConnection() {
        try {
            this.conn = this.ds.getConnection();
        }
        catch (SQLException e) {
            logger.info((Object)e);
        }
        return this.conn;
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                logger.info((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeQuery(Object object) {
        UserSyncConfigItem configItem = (UserSyncConfigItem)object;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String baseDN = configItem.getBaseDN();
        String returnAttrs = configItem.getReturningAttributes();
        if (returnAttrs == null || "".equals(returnAttrs)) {
            returnAttrs = configItem.getMapToEasUserName() + "," + configItem.getMapToEasUserNumber();
        }
        String filterExp = configItem.getFilter();
        String sql = "select " + returnAttrs + " from " + baseDN;
        if (filterExp != null && !"".equals(filterExp)) {
            sql = sql + " where " + filterExp;
        }
        logger.info((Object)("dbutil sqlstring:" + sql));
        Object[] params = this.getFilterParams(configItem);
        this.rowSet = null;
        try {
            ps = this.conn.prepareStatement(sql);
            if (sql.indexOf("?") > -1) {
                for (int i = 0; i < params.length; ++i) {
                    logger.info((Object)("dbutil sql params:" + params[i] + " " + (i + 1)));
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            this.rowSet = new JdbcRowSet();
            this.rowSet.populate(rs);
        }
        catch (SQLException exc) {
            try {
                System.err.println("Sql execute exception : " + sql + "\n" + exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)this.conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)this.conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)this.conn);
        return this.rowSet;
    }

    @Override
    public boolean next() {
        boolean result = false;
        if (this.rowSet == null) {
            result = false;
        } else {
            try {
                result = this.rowSet.next();
            }
            catch (SQLException e) {
                logger.info((Object)e);
            }
        }
        logger.info((Object)("dbutil next():" + result));
        return result;
    }

    @Override
    public String getUserProperty(String propName) {
        String result = null;
        try {
            result = this.rowSet.getString(propName);
        }
        catch (SQLException e) {
            logger.info((Object)e);
        }
        logger.info((Object)("dbutil Property():" + result));
        return result;
    }

    @Override
    public void connect(String dataresxName) throws NamingException {
        this.lookup(dataresxName);
        this.getConnection();
    }

    @Override
    public Object[] getFilterParams(UserSyncConfigItem configItem) {
        String lastSyncUbound;
        String lastSync = configItem.getLastSync();
        if (lastSync == null || "".equals(lastSync)) {
            lastSync = "1990-01-01 00:00:00";
        }
        if ((lastSyncUbound = configItem.getLastSyncUbound()) == null || "".equals(lastSyncUbound)) {
            Calendar cal = Calendar.getInstance();
            Date currentDate = cal.getTime();
            lastSyncUbound = this.getLastSync(currentDate);
        }
        Object[] filterParam = new Object[]{lastSync, lastSyncUbound};
        return filterParam;
    }

    @Override
    public String getLastSync(Date currentDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String result = format.format(currentDate);
        return result;
    }
}

