/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.user;

import com.kingdee.eas.cp.eip.sso.user.IConfigValidator;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigElementInfo;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.user.ValidatorManager;
import com.kingdee.eas.cp.eip.sso.xml.INode;
import com.kingdee.eas.cp.eip.sso.xml.NodeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class UserSyncConfigParser {
    private IConfigValidator configVal = null;

    public HashMap parser(InputStream bis) throws UserSyncConfigParseException {
        String rootNodeName = UserSyncConfigElementInfo.getRootNodeName();
        HashMap ldapResourcesMap = new HashMap();
        INode root = null;
        try {
            root = NodeFactory.build(bis);
        }
        catch (IOException e) {
            throw new UserSyncConfigParseException("Invalidate user sync config file.expected:<" + UserSyncConfigElementInfo.getRootNodeName() + ">", e);
        }
        if (root == null) {
            throw new UserSyncConfigParseException("Invalidate user sync config file.expected:<" + UserSyncConfigElementInfo.getRootNodeName() + ">");
        }
        this.buildUserResources(root, ldapResourcesMap);
        return ldapResourcesMap;
    }

    private void buildUserResources(INode root, HashMap ldapResourcesMap) throws UserSyncConfigParseException {
        String ldapResxNodeName = UserSyncConfigElementInfo.getResourceNodeName();
        String ldapResxAttrName = UserSyncConfigElementInfo.getResourceNodeAttrName();
        INode[] ldapResxNodes = this.getChildNodes(root, ldapResxNodeName);
        UserResource ldapResx = null;
        String ldapResxKey = "";
        for (int i = 0; i < ldapResxNodes.length; ++i) {
            ldapResxKey = ldapResxNodes[i].getAttribute(ldapResxAttrName);
            ldapResx = this.buildUserResource(ldapResxNodes[i]);
            ldapResourcesMap.put(ldapResxKey, ldapResx);
        }
    }

    private INode[] getChildNodes(INode node, String name) {
        ArrayList<INode> result = new ArrayList<INode>();
        for (INode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new INode[result.size()]);
    }

    private UserResource buildUserResource(INode resourceNode) throws UserSyncConfigParseException {
        INode childNode;
        UserResource result = new UserResource();
        String[] resxChildNodeName = UserSyncConfigElementInfo.getResourceChildNodeNames();
        String contextFactoryNodeName = resxChildNodeName[0];
        String providerURLNodeName = resxChildNodeName[1];
        String authenticationNodeName = resxChildNodeName[2];
        String principalNodeName = resxChildNodeName[3];
        String credentialsNodeName = resxChildNodeName[4];
        String jndiNameNodeName = resxChildNodeName[5];
        String lastTime = resxChildNodeName[6];
        String resourceList = resxChildNodeName[7];
        String userID = resxChildNodeName[8];
        String syncClass = resxChildNodeName[9];
        String conDN = resxChildNodeName[10];
        String syncImport = resxChildNodeName[11];
        result.setResourceType(resourceNode.getAttribute(UserSyncConfigElementInfo.getResourceNodeAttrresourceType()));
        String userSyncConfigItemNodeName = UserSyncConfigElementInfo.getUserSyncNodeName();
        String userSyncNodeAttrName = UserSyncConfigElementInfo.getUserSyncNodeAttrName();
        String nodeValue = "";
        UserSyncConfigItem userSyncConfigItem = null;
        for (childNode = resourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (contextFactoryNodeName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setContextFactory(nodeValue);
                continue;
            }
            if (providerURLNodeName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setProviderURL(nodeValue);
                continue;
            }
            if (authenticationNodeName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setAuthentication(nodeValue);
                continue;
            }
            if (principalNodeName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setPrincipal(nodeValue);
                continue;
            }
            if (credentialsNodeName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setCredentials(nodeValue);
                continue;
            }
            if (jndiNameNodeName.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setJndiName(nodeValue);
                continue;
            }
            if (lastTime.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setLastTime(nodeValue);
                continue;
            }
            if (resourceList.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setResourceList(nodeValue);
                continue;
            }
            if (userID.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setUserID(nodeValue);
                continue;
            }
            if (syncClass.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setSyncClass(nodeValue);
                continue;
            }
            if (conDN.equalsIgnoreCase(childNode.getNodeName())) {
                nodeValue = childNode.getNodeValue();
                result.setConDN(nodeValue);
                continue;
            }
            if (!syncImport.equalsIgnoreCase(childNode.getNodeName())) continue;
            nodeValue = childNode.getNodeValue();
            result.setSyncImport(nodeValue);
        }
        if (result.getResourceType() == null || !ValidatorManager.validateResourceType(result.getResourceType())) {
            throw new UserSyncConfigParseException("[Eas multi auth] User sync config init fails. resourceType=" + result.getResourceType());
        }
        this.configVal = ValidatorManager.getValidator(result.getResourceType());
        if (!this.configVal.validateUserSyncResource(result)) {
            throw new UserSyncConfigParseException("[Eas multi auth] User sync config init fails. ldapResource=" + result.toString());
        }
        INode[] userSyncConfigItems = this.getChildNodes(resourceNode, userSyncConfigItemNodeName);
        for (int i = 0; i < userSyncConfigItems.length; ++i) {
            childNode = userSyncConfigItems[i];
            String userSyncItemKey = childNode.getAttribute(userSyncNodeAttrName);
            userSyncConfigItem = this.buildUserSyncConfigItem(childNode);
            result.put(userSyncItemKey, userSyncConfigItem);
            if (this.configVal == null || this.configVal.validateUserSyncConfigItem(userSyncConfigItem)) continue;
            throw new UserSyncConfigParseException("[Eas multi auth]user sync config file is invalid, userSyncConfigItem is invalid. userSyncConfigItem = " + result.toString());
        }
        return result;
    }

    private UserSyncConfigItem buildUserSyncConfigItem(INode userSyncNode) throws UserSyncConfigParseException {
        UserSyncConfigItem result = new UserSyncConfigItem();
        String[] userSyncNodeNames = UserSyncConfigElementInfo.getUserSyncChildNodeNames();
        String executorNodeName = userSyncNodeNames[0];
        String defaultPwd = userSyncNodeNames[1];
        String usernameSuffix = userSyncNodeNames[2];
        String baseDN = userSyncNodeNames[3];
        String filterNodeName = userSyncNodeNames[4];
        String searchScope = userSyncNodeNames[5];
        String lastSyncNodeName = userSyncNodeNames[6];
        String returningAttributesNodeName = userSyncNodeNames[7];
        String mapToEasUserNumber = userSyncNodeNames[8];
        String mapToEasUserName = userSyncNodeNames[9];
        String lastSyncUboundNodeName = userSyncNodeNames[10];
        String usernumber = userSyncNodeNames[11];
        String language = userSyncNodeNames[12];
        String nodeValue = "";
        String nodeName = "";
        for (INode childNode = userSyncNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            nodeValue = childNode.getNodeValue();
            nodeName = childNode.getNodeName().toLowerCase();
            if (executorNodeName.equalsIgnoreCase(nodeName)) {
                result.setExecutor(nodeValue);
                continue;
            }
            if (defaultPwd.equalsIgnoreCase(nodeName)) {
                result.setDefaultPwd(nodeValue);
                continue;
            }
            if (usernameSuffix.equalsIgnoreCase(nodeName)) {
                result.setUsernameSuffix(nodeValue);
                continue;
            }
            if (baseDN.equalsIgnoreCase(nodeName)) {
                result.setBaseDN(nodeValue);
                continue;
            }
            if (filterNodeName.equalsIgnoreCase(nodeName)) {
                result.setFilter(nodeValue);
                continue;
            }
            if (searchScope.equalsIgnoreCase(nodeName)) {
                int tmp = 2;
                try {
                    tmp = Integer.parseInt(nodeValue);
                    if (tmp < 0 || tmp > 2) {
                        tmp = 2;
                    }
                }
                catch (NumberFormatException e) {
                    tmp = 2;
                }
                result.setSearchScope(tmp);
                continue;
            }
            if (returningAttributesNodeName.equalsIgnoreCase(nodeName)) {
                result.setReturningAttributes(nodeValue);
                continue;
            }
            if (lastSyncNodeName.equalsIgnoreCase(nodeName)) {
                result.setLastSync(nodeValue);
                continue;
            }
            if (lastSyncUboundNodeName.equalsIgnoreCase(nodeName)) {
                result.setLastSyncUbound(nodeValue);
                continue;
            }
            if (mapToEasUserNumber.equalsIgnoreCase(nodeName)) {
                result.setMapToEasUserNumber(nodeValue);
                continue;
            }
            if (mapToEasUserName.equalsIgnoreCase(nodeName)) {
                result.setMapToEasUserName(nodeValue);
                continue;
            }
            if (usernumber.equalsIgnoreCase(nodeName)) {
                result.setUsernumber(nodeValue);
                continue;
            }
            if (!language.equalsIgnoreCase(nodeName)) continue;
            result.setLanguage(nodeValue);
        }
        return result;
    }
}

