/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.cp.eip.sso.util.TransferUtil;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudManagerService {
    private static final Logger logger = LoggerFactory.getLogger(CloudManagerService.class);

    public static String getActiveUrl(Context ctx, String vcode) {
        String activeUrl = EasCloud.CLOUD_URL + "clouderp/account/vcode/verifying";
        try {
            long t1 = System.currentTimeMillis();
            Map<String, String> paramMap = CloudParamUtil.getCloudParams(ctx);
            String uid = paramMap.get("uid");
            String prodInstId = paramMap.get("prod_inst_code");
            String phone = paramMap.get("wholePhone");
            String email = "";
            if (phone != null && phone.indexOf("@") > -1) {
                email = phone;
                phone = "";
            }
            String s = EasCloud.CLIENT_ID + EasCloud.CLIENT_SECRET + uid + prodInstId + phone + email + vcode + t1;
            String signiture = TransferUtil.sha1(s);
            activeUrl = activeUrl + "?client_id=" + EasCloud.CLIENT_ID + "&uid=" + URLEncoder.encode(uid, "utf-8") + "&prod_inst_code=" + URLEncoder.encode(prodInstId, "utf-8") + "&vcode=" + vcode + "&timestamp=" + t1 + "&phone=" + phone + "&email=" + email + "&signiture=" + signiture;
        }
        catch (Exception e) {
            logger.error("getActiveUrl error == ", (Throwable)e);
        }
        return activeUrl;
    }

    public static JSONObject getActiveUrlAndActive(Context ctx, String vcode) throws Exception {
        try {
            Map<String, String> paramMap = CloudParamUtil.getCloudParams(ctx);
            String uid = paramMap.get("uid");
            String prodInstId = paramMap.get("prod_inst_code");
            String phone = paramMap.get("wholePhone");
            String email = "";
            if (phone != null && phone.indexOf("@") > -1) {
                email = phone;
                phone = "";
            }
            JSONObject verifyCode = EasCloud.verifyCode((String)uid, (String)prodInstId, (String)phone, (String)email, (String)vcode);
            return verifyCode;
        }
        catch (Exception e) {
            logger.error("getActiveUrl error == ", (Throwable)e);
            throw e;
        }
    }

    public static String getOffineQrcodeUrl(Context context, String userNumber) throws Exception {
        String url = EasCloud.CLOUD_URL + "clouderp/account/qrcode/offline";
        ICloudRegistSrv crs = CloudRegistSrvAgentFactory.getLocalInstance((Context)context);
        String vcode = crs.getErpUserActiveCode(userNumber);
        String prod_inst_code = LicenseSrvAgentFactory.getLocalInstance((Context)context).getLicenseBaseInfo().getProductInstanceID();
        String wholePhone = crs.getCloudRegistUserInfo(userNumber).getPhone();
        Date date = new Date();
        String time = String.valueOf(date.getTime() / 1000L);
        String signiture = TransferUtil.sha1(EasCloud.CLIENT_ID + EasCloud.CLIENT_SECRET + prod_inst_code + wholePhone + vcode + time);
        StringBuilder sb = new StringBuilder();
        sb.append(url).append("?").append("client_id=").append(EasCloud.CLIENT_ID).append("&prod_inst_code=").append(prod_inst_code).append("&vcode=").append(vcode).append("&phone=").append(wholePhone).append("&timestamp=").append(time).append("&signiture=").append(signiture);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMessage(String surl) throws Exception {
        String response = null;
        HttpClient http = new HttpClient();
        GetMethod get = null;
        try {
            get = new GetMethod(surl);
            http.setConnectionTimeout(5000);
            http.executeMethod((HttpMethod)get);
            response = new String(get.getResponseBodyAsString().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            logger.error("error message", e);
            response = "send exception:" + e.getMessage();
        }
        finally {
            get.releaseConnection();
        }
        return response;
    }
}

