/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.auth;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.sso.web.auth.EASCallbackHandler;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;

public class EASWebLicenceHelper {
    public static final String LICENSE_USER = "licesnseId";
    public static final String PORTAL_PKG = "com.kingdee.eas.portal.web.action.PortalAction";
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.";

    public static int checkWebLoginLicence(HttpServletRequest request, EASCallbackHandler easchb, String pkg) throws LicenseException, LoginException {
        Context ctx = easchb.getUserContext();
        LicenseUserInfo licenseUserInfo = EASWebLicenceHelper.createLicenseUserInfo(request, ctx);
        int result = LicenseSrvFactory.getInstance().requestLicense(licenseUserInfo, pkg);
        if (result == 1) {
            request.getSession().setAttribute(LICENSE_USER, (Object)licenseUserInfo);
            return 1;
        }
        Locale local = null;
        if (ctx != null) {
            local = ctx.getLocale();
        }
        if (result == 4) {
            throw new LoginException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid", (Locale)local) + EASWebLicenceHelper.constructLicenseMessage(pkg, local));
        }
        if (result == 2) {
            throw new LoginException(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS", (Locale)local) + EASWebLicenceHelper.constructLicenseMessage(pkg, local));
        }
        return result;
    }

    private static String constructLicenseMessage(String packageName, Locale local) throws LicenseException {
        if (packageName == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append(ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ModuleName", (Locale)local));
        String moduleName = "portal";
        buffer.append(moduleName);
        return buffer.toString();
    }

    public static void releaseLicense(Context ctx, String pkg) throws LicenseException {
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userinfo.getId() != null) {
            LicenseSrvFactory.getInstance().releaseLicenseByUserIDAndModuleName(userinfo.getId().toString(), pkg);
        }
    }

    public static void releaseLicense(String sessionId, String pkg) throws LicenseException {
        LicenseSrvFactory.getInstance().releaseLicense(sessionId, pkg);
    }

    public static LicenseUserInfo createLicenseUserInfo(HttpServletRequest request, Context ctx) {
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        LicenseUserInfo user = null;
        try {
            String clientIP = request.getRemoteAddr();
            Date loginTime = new Date(System.currentTimeMillis());
            user = new LicenseUserInfo();
            if (ctx != null) {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (userInfo != null && userInfo.getId() != null) {
                    user.setUserID(userInfo.getId().toString());
                }
                if (userinfo.getId() != null) {
                    user.setUserID(userinfo.getId().toString());
                }
                user.setUserName(ctx.getUserName());
                user.setSessionID(ctx.getContextID());
                if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                    user.setUserCompany(ContextUtil.getCurrentCtrlUnit((Context)ctx).getName());
                }
                user.setUserLoginAis(ctx.getAIS());
            }
            user.setUserIP(clientIP);
            user.setUserLoginTime(loginTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            user = null;
        }
        return user;
    }
}

