/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AjaxException;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.Ajax;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.QrCodeTokenHelper;
import com.kingdee.eas.cp.eip.sso.util.AutoLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DDLoginToEASController
extends AbstractController {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.sso.web.controller.DDLoginToEASController");
    private static volatile String token = "";
    private final String errorUrl = "/eassso/ssoThird/error.jsp";
    public static final int ERROR_CODE_SECURITY = 0;
    public static final int ERROR_CODE_NONUSER = 1;
    public static final int ERROR_CODE_FALSE = 2;
    public static final int ERROR_CODE_NEEDSYNC = 3;
    public static final int ERROR_CODE_OTHER = 4;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String method = request.getParameter("method");
        String code = request.getParameter("info");
        if (!"authUser".equalsIgnoreCase(method) || !CloudParamUtil.checkXss(code)) {
            logger.error((Object)("ERROR_CODE_SECURITY:method=" + method + ";info=" + code));
            return this.returnAndRedirect(response, "/eassso/ssoThird/error.jsp", 0);
        }
        try {
            if ("authUser".equals(method)) {
                String userName;
                String language;
                String requestUrl = QrCodeTokenHelper.getDDUserURL() + "?access_token=" + DDLoginToEASController.getToken();
                String ret = this.getDDUserInfo(response, code, requestUrl);
                if (StringUtils.isEmpty((String)ret)) {
                    logger.error((Object)("ERROR_TYPE_NONUSER:requestUrl=" + requestUrl));
                    return this.returnAndRedirect(response, "/eassso/ssoThird/error.jsp", 1);
                }
                JSONObject result = (JSONObject)JSON.parse((String)ret);
                if (result.getInteger("errcode") != 0) {
                    requestUrl = QrCodeTokenHelper.getDDUserURL() + "?access_token=" + DDLoginToEASController.reGetToken();
                    ret = this.getDDUserInfo(response, code, requestUrl);
                    if (StringUtils.isEmpty((String)ret)) {
                        logger.error((Object)("ERROR_TYPE_NONUSER:requestUrl=" + requestUrl));
                        return this.returnAndRedirect(response, "/eassso/ssoThird/error.jsp", 1);
                    }
                    result = (JSONObject)JSON.parse((String)ret);
                    if (result.getInteger("errcode") != 0) {
                        logger.error((Object)("ERROR_TYPE_FALSE:result=" + result.toString()));
                        return this.returnAndRedirect(response, "/eassso/ssoThird/error.jsp", 2);
                    }
                }
                JSONObject data = (JSONObject)result.get((Object)"result");
                String userid = data.get((Object)"userid").toString();
                String dataCenter = request.getParameter("datacenter");
                if (StringUtils.isEmpty((String)dataCenter) || !CloudParamUtil.checkXss(dataCenter)) {
                    dataCenter = AutoLoginConfigPropUtil.getDataCenter();
                }
                if (StringUtils.isEmpty((String)(language = request.getParameter("locale"))) || !CloudParamUtil.checkXss(language)) {
                    language = AutoLoginConfigPropUtil.getLocale();
                }
                if (StringUtils.isEmpty((String)(userName = this.getUserInfoMapByOpenId(this.getContext(dataCenter, language), userid)))) {
                    logger.error((Object)("ERROR_CODE_NEEDSYNC:result=" + result.toString()));
                    return this.returnAndRedirect(response, "/eassso/ssoThird/error.jsp", 3);
                }
                String ltpatoken = LtpaTokenManager.generate(userName, LtpaTokenManager.getDefaultLtpaConfig()).toString();
                StringBuilder redirectUrl = new StringBuilder();
                redirectUrl.append("/portal/index2sso.jsp?isNotCheckRelogin=true&username=").append(URLEncoder.encode(userName, "utf-8")).append("&password=").append(ltpatoken).append("&dataCenter=").append(dataCenter).append("&locale=").append(language).append("&redirectTo=").append(this.buildBusinessUrl(request));
                logger.error((Object)("CloudLoginEASFilter loginEAS redirectUrl===" + redirectUrl.toString()));
                return this.returnAndRedirect(response, redirectUrl.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"dd login to eas error");
            e.printStackTrace();
            return this.returnAndRedirect(response, "/eassso/ssoThird/error.jsp", 4);
        }
        return null;
    }

    private static String getToken() {
        if (StringUtils.isEmpty((String)token)) {
            DDLoginToEASController.sendToken();
        }
        return token;
    }

    private static String reGetToken() {
        token = "";
        DDLoginToEASController.sendToken();
        return token;
    }

    private static void sendToken() {
        String appkey = QrCodeTokenHelper.getDDAppID();
        String appsecret = QrCodeTokenHelper.getDDAppSecret();
        String headUrl = QrCodeTokenHelper.getDDTokenURL();
        StringBuilder url = new StringBuilder();
        url.append(headUrl).append("?appkey=").append(appkey).append("&appsecret=").append(appsecret);
        try {
            HttpGet method = new HttpGet(url.toString());
            String exceuteRequest = Ajax.exceuteRequest((HttpRequestBase)method, "utf-8");
            if (exceuteRequest == null || exceuteRequest.trim().length() <= 0) {
                return;
            }
            JSONObject result = (JSONObject)JSON.parse((String)exceuteRequest);
            if (result.getInteger("errcode") != 0) {
                logger.error((Object)("\u83b7\u53d6token\u5931\u8d25:" + result.getString("errmsg")));
                logger.error((Object)("exceuteRequest:" + exceuteRequest));
            } else {
                token = result.getString("access_token");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8c03\u7528\u83b7\u53d6token\u63a5\u53e3\u5931\u8d25;" + e.getMessage()));
            e.printStackTrace();
        }
    }

    private Context getContext(String dataCenter, String language) {
        Context ctx = CloudParamUtil.getContext(dataCenter, language, null);
        return ctx;
    }

    private ModelAndView returnAndRedirect(HttpServletResponse response, String url) throws IOException {
        response.sendRedirect(url);
        return null;
    }

    private ModelAndView returnAndRedirect(HttpServletResponse response, String url, int errorCode) throws IOException {
        response.sendRedirect(url + "?errorCode=" + errorCode);
        return null;
    }

    private String getDDUserInfo(HttpServletResponse response, String code, String url) throws IOException {
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        JSONObject params = new JSONObject();
        params.put("code", (Object)code);
        StringEntity paramsEntity = new StringEntity(params.toString(), "utf-8");
        post.setEntity((HttpEntity)paramsEntity);
        String ret = null;
        try {
            ret = Ajax.exceuteRequest((HttpRequestBase)post, "utf-8");
        }
        catch (AjaxException e) {
            logger.error((Object)("get openid from yunzhijia error :   " + e));
            e.printStackTrace();
        }
        return ret;
    }

    private String buildBusinessUrl(HttpServletRequest req) {
        String pageUrl = req.getParameter("pageUrl");
        String redirectTo = req.getParameter("redirectTo");
        if (!StringUtils.isEmpty((String)pageUrl)) {
            redirectTo = pageUrl;
        }
        if (StringUtils.isEmpty((String)redirectTo)) {
            redirectTo = "//";
        }
        try {
            redirectTo = !redirectTo.contains("?") ? redirectTo + "?" : redirectTo + "&";
            Map paramMap = req.getParameterMap();
            for (Map.Entry entry : paramMap.entrySet()) {
                Object ov = entry.getValue();
                String[] value = new String[1];
                if (ov instanceof String[]) {
                    value = (String[])ov;
                } else {
                    value[0] = ov.toString();
                }
                if (value[0] == null || "ticket".equals(entry.getKey()) || "redirectTo".equals(entry.getKey()) || "pageUrl".equals(entry.getKey()) || "info".equals(entry.getKey()) || "method".equals(entry.getKey()) || "datacenter".equals(entry.getKey()) || "locale".equals(entry.getKey())) continue;
                redirectTo = redirectTo + (String)entry.getKey() + "=" + value[0] + "&";
            }
            return URLEncoder.encode(redirectTo.substring(0, redirectTo.length() - 1), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "//";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserInfoMapByOpenId(Context ctx, String openId) {
        String sql = "SELECT umap.fusernumber userNumber FROM T_pm_easdtusermap umap where fxtid = ?";
        String userNumber = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{openId});
            if (rs.next()) {
                userNumber = rs.getString("userNumber");
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return userNumber;
    }
}

