/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.web.EASWebLicenceHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;

public class SSOTurnServlet
extends HttpServlet {
    protected Logger logger = Logger.getLogger(SSOTurnServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectTo = System.getProperty("sso.client.redirectTo");
        if (request.getParameter("redirectTo") != null) {
            redirectTo = request.getParameter("redirectTo");
            String useBase64 = request.getParameter("useBase64");
            if ("true".equals(useBase64)) {
                URLCodec urlCodec = new URLCodec();
                try {
                    redirectTo = redirectTo.replace("|", "%");
                    redirectTo = urlCodec.decode(redirectTo);
                }
                catch (DecoderException e) {
                    this.logger.error((Object)"urlCodec to redirectTo error:", (Throwable)e);
                }
                redirectTo = URLDecoder.decode(redirectTo, "UTF-8");
            }
        }
        redirectTo = this.assembleRequestParameter(request, redirectTo);
        Context userCtx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (userCtx == null) {
            redirectTo = "/userCtxErr.jsp";
            this.redirect(request, response, redirectTo);
            return;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)userCtx);
        try {
            WebContextUtil.setUserSkinPath((HttpServletRequest)request, (UserInfo)userInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        redirectTo = this.checkLicense(request, userCtx, redirectTo);
        String isCheckRelogin = request.getParameter("isNotCheckRelogin");
        this.logger.error((Object)("SSOTurnServlet isCheckRelogin ==" + isCheckRelogin));
        if (redirectTo.indexOf("/checkLicence.jsp") < 0 && !"true".equals(isCheckRelogin)) {
            this.logger.error((Object)"SSOTurnServlet checkRelogin 111==");
            redirectTo = this.checkRelogin(request, userCtx, redirectTo);
        }
        this.logger.error((Object)("SSOTurnServlet redirectTo ==" + redirectTo));
        this.redirect(request, response, redirectTo);
    }

    private void redirect(HttpServletRequest request, HttpServletResponse response, String redirectTo) throws IOException {
        response.setContentType("UTF-8");
        if (redirectTo != null && !redirectTo.startsWith(WebContextUtil.getPortalContextPath((HttpServletRequest)request)) && (redirectTo.startsWith("/easweb") || redirectTo.startsWith("/portal"))) {
            response.sendRedirect(redirectTo);
        } else {
            response.sendRedirect(WebContextUtil.getPortalContextPath((HttpServletRequest)request) + redirectTo);
        }
    }

    private String checkRelogin(HttpServletRequest request, Context userCtx, String redirectTo) {
        this.logger.error((Object)"SSOTurnServlet checkRelogin begin==");
        boolean finduser = this.findHaveSamePortalUser(request);
        if (finduser) {
            this.logger.error((Object)"SSOTurnServlet checkRelogin finduser true==");
            boolean allowRelogin = this.checkAllowUserRepeatLogin(request);
            this.logger.error((Object)("SSOTurnServlet checkRelogin allowRelogin==" + allowRelogin));
            if (allowRelogin) {
                this.logger.error((Object)"SSOTurnServlet checkRelogin allowRelogin 111==");
                redirectTo = this.assembleReloginRedirectAddress(request, userCtx, redirectTo);
            } else {
                redirectTo = "/loginError.jsp";
            }
        }
        return redirectTo;
    }

    private String assembleReloginRedirectAddress(HttpServletRequest request, Context userCtx, String redirectTo) {
        this.logger.error((Object)"SSOTurnServlet assembleReloginRedirectAddress 111==");
        StringBuffer redirectToBuf = new StringBuffer(redirectTo);
        boolean isAwoke = this.isAwokeAtUserReLogin(userCtx);
        this.logger.error((Object)("SSOTurnServlet assembleReloginRedirectAddress isAwoke==" + isAwoke));
        try {
            if (isAwoke) {
                this.logger.error((Object)"SSOTurnServlet assembleReloginRedirectAddress isAwoke 111==");
                redirectToBuf = new StringBuffer("/loginAgain.jsp");
                redirectToBuf.append("?username=");
                redirectToBuf.append(URLEncoder.encode(userCtx.getUserName(), "UTF-8"));
                redirectToBuf.append("&dbcenter=");
                redirectToBuf.append(URLEncoder.encode(userCtx.getAIS(), "UTF-8"));
                this.setEasportalRedirectto(request, URLEncoder.encode(redirectTo, "UTF-8"));
            }
        }
        catch (Exception e1) {
            this.logger.error((Object)e1);
        }
        return redirectToBuf.toString();
    }

    private void setEasportalRedirectto(HttpServletRequest request, String tempurl) {
        request.getSession().setAttribute("EASPORTALREDIRECTTO", (Object)tempurl);
    }

    private String checkLicense(HttpServletRequest request, Context userCtx, String redirectTo) {
        try {
            if (request.getParameter("username") != null && request.getParameter("password") != null) {
                EASWebLicenceHelper.checkWebLoginLicence(request, userCtx, "com.kingdee.eas.cp.eip.sso.client.LdapMapListUI");
            }
            EASWebLicenceHelper.checkWebLoginLicence(request, userCtx, "com.kingdee.eas.portal.web.action.PortalAction");
        }
        catch (LicenseException e) {
            redirectTo = this.assembleExceptionRedirectAddress((Exception)((Object)e));
        }
        catch (LoginException e) {
            this.logger.error((Object)("license check failed:" + e.getMessage()));
            redirectTo = this.assembleExceptionRedirectAddress(e);
        }
        return redirectTo;
    }

    private String assembleExceptionRedirectAddress(Exception e) {
        StringBuffer redirectTo = new StringBuffer("/checkLicence.jsp");
        redirectTo.append("?message=");
        try {
            if (e.getCause() == null) {
                redirectTo.append(URLEncoder.encode(e.getMessage(), "UTF-8"));
            } else {
                redirectTo.append(URLEncoder.encode(e.getCause().getMessage(), "UTF-8"));
            }
        }
        catch (Exception e1) {
            this.logger.error((Object)e1);
        }
        return redirectTo.toString();
    }

    private String assembleRequestParameter(HttpServletRequest request, String redirectTo) throws UnsupportedEncodingException {
        boolean isFirst = true;
        if (!StringUtils.isEmpty((String)redirectTo) && redirectTo.indexOf("?") >= 0) {
            isFirst = false;
        }
        String strUrl = "";
        Object ob = null;
        String key = "";
        Enumeration enums = request.getParameterNames();
        while (enums.hasMoreElements()) {
            ob = enums.nextElement();
            if (!(ob instanceof String) || (key = (String)ob).equals("isNotCheckRelogin") || key.equals("EASAUTO") || key.equals("username") || key.equals("locale") || key.equals("dataCenter") || key.equals("password") || key.equals("redirectTo") || key.equals("username") || key.equals("password")) continue;
            strUrl = strUrl + this.diyUrl(key, request, isFirst);
            isFirst = false;
        }
        if (!StringUtils.isEmpty((String)redirectTo) && !StringUtils.isEmpty((String)strUrl)) {
            redirectTo = redirectTo + strUrl;
        }
        return redirectTo;
    }

    private String diyUrl(String key, HttpServletRequest request, boolean isFirst) throws UnsupportedEncodingException {
        String str = "";
        str = isFirst ? "?" : "&";
        this.logger.info((Object)("SSOTurnServlet.diyUrl()--key---value:" + request.getParameter(key)));
        String temp = URLEncoder.encode(request.getParameter(key), "UTF-8");
        this.logger.info((Object)("SSOTurnServlet.diyUrl()--key---value.encoder:" + temp));
        str = str + key + "=" + temp;
        return str;
    }

    private boolean findHaveSamePortalUser(HttpServletRequest request) {
        boolean haveSameUser = false;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            haveSameUser = UserMonitorFactory.getRemoteInstance().isSameNamePortalUserExists(ctx.getAIS(), ctx.getUserName(), request.getSession().getId());
        }
        catch (EASBizException e) {
            this.logger.error((Object)"login check error:", (Throwable)e);
        }
        catch (BOSException e) {
            this.logger.error((Object)"login check error:", (Throwable)e);
        }
        return haveSameUser;
    }

    private boolean checkAllowUserRepeatLogin(HttpServletRequest request) {
        boolean allowRepeatLogin = true;
        try {
            Context userCtx = WebContextUtil.getEasContext((HttpServletRequest)request);
            UserInfo user = UserFactory.getRemoteInstance().getUserInfoByNumber(userCtx.getUserName());
            if (user != null) {
                allowRepeatLogin = NotAllowRepeatLoginUserFactory.getRemoteInstance().isAllowRepeatLogin(user.getId().toString());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"SSOTurnServlet.checkAllowUserRepeatLogin error ");
            this.logger.error((Object)e);
        }
        return allowRepeatLogin;
    }

    private boolean isAwokeAtUserReLogin(Context userCtx) {
        boolean flag = true;
        String paramkey = "isAwokeAtUserReLoginForPortal";
        try {
            String paravalue = ParamManager.getParamValue((Context)userCtx, null, (String)paramkey);
            flag = paravalue != null && "true".equalsIgnoreCase(paravalue);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return flag;
    }
}

