/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.PassiveCallbackHandler;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.cp.common.web.util.ExceptionUtil;
import com.kingdee.eas.cp.eip.sso.web.EASCallbackHandlerForCas3;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.auth.EASAuthHandler;
import com.kingdee.eas.cp.eip.sso.web.server.EASAuthException;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;

public class EASAuthHandlerForCas3
implements AuthenticationHandler {
    private Logger logger = Logger.getLogger((String)EASAuthHandlerForCas3.class.getName());
    private String APPLICATION_NAME = EASAuthHandler.class.getName();
    private Class classToSupport = EASCredentials.class;
    private boolean supportSubClasses = true;

    public boolean authenticate(Credentials credentials) throws AuthenticationException {
        EASCredentials easCredentials = (EASCredentials)credentials;
        String username = easCredentials.getUsername();
        this.logger.debug((Object)(" [EASAuthHandlerForCas3-EAS Portal Auth] The user " + username + " want to login EAS Portal."));
        boolean authResult = true;
        Context ctx = null;
        try {
            EASCallbackHandlerForCas3 easchb = new EASCallbackHandlerForCas3();
            PassiveCallbackHandler chb = easchb.createCallbackHandler(easCredentials);
            ctx = this.loginByJaasModule(easchb, chb);
            String sessionID = ctx.getContextID();
            easCredentials.setEasSessionId(sessionID);
        }
        catch (LoginException e) {
            if (e instanceof BOSLoginException) {
                this.logger.error((Object)(" [EASAuthHandlerForCas3-EAS Portal Auth] Authentication attempt failed. \r\n" + ExceptionUtil.getExcLinkStackTrace((Throwable)((BOSLoginException)e), (String)"\r\n")));
            } else {
                this.logger.error((Object)(" [EASAuthHandlerForCas3-EAS Portal Auth] Authentication attempt failed. \r\n" + ExceptionUtil.getExcLinkStackTrace((Throwable)e, (String)"\r\n")));
            }
            authResult = false;
            Throwable ce = e.getCause();
            if (ce != null) {
                if (ce instanceof UserException) {
                    UserException ue = (UserException)ce;
                    String str = ue.getMessage(new Locale(easCredentials.getLocale()));
                    throw new EASAuthException(str);
                }
                if (ce.getCause() instanceof UserException) {
                    UserException ue = (UserException)ce.getCause();
                    String str = ue.getMessage(new Locale(easCredentials.getLocale()));
                    throw new EASAuthException(str);
                }
                String str = e.getCause().toString();
                throw new EASAuthException(str.substring(str.lastIndexOf("Exception:") + 11, str.length()));
            }
            throw new EASAuthException(e.getMessage());
        }
        return authResult;
    }

    private Context loginByEASModuel(EASCallbackHandlerForCas3 easchb) throws LoginException, BOSException {
        String url = "tcp://localhost:11034";
        ORMRPCServiceLocator.setCurrentServiceURL((String)url);
        BOSObjectFactory.clearSession((String)url);
        ILoginModule loginModule = LoginModuleFactory.getRemoteInstance();
        Context userCtx = loginModule.fullLogin(easchb.getLoginContext());
        return userCtx;
    }

    private Context loginByJaasModule(EASCallbackHandlerForCas3 easchb, PassiveCallbackHandler chb) throws LoginException {
        long authReady = System.currentTimeMillis();
        Context ctx = null;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.logger.debug((Object)("[EASAuthHandlerForCas3-EAS Portal Auth] Be ready to auth spend " + authReady + " ms."));
        try {
            ctx = EASLoginHandler.login(easchb.getLoginContext(), easchb.getUserContext());
        }
        catch (LoginException e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        long authEnd = System.currentTimeMillis() - authReady;
        this.logger.debug((Object)("[EASAuthHandlerForCas3-EAS Portal Auth] Perform auth(from be ready to perform) spend " + authEnd + " ms."));
        this.logger.info((Object)("[EASAuthHandlerForCas3-EAS Portal Auth] User " + easchb.getUserContext().getUserName() + " login,EAS LoginModule spent " + authEnd + " ms! SessionId = " + easchb.getUserContext().getContextID()));
        return ctx;
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && (this.classToSupport.equals(credentials.getClass()) || this.classToSupport.isAssignableFrom(credentials.getClass()) && this.supportSubClasses);
    }

    public Class getClassToSupport() {
        return this.classToSupport;
    }

    public void setClassToSupport(Class classToSupport) {
        this.classToSupport = classToSupport;
    }

    public boolean isSupportSubClasses() {
        return this.supportSubClasses;
    }

    public void setSupportSubClasses(boolean supportSubClasses) {
        this.supportSubClasses = supportSubClasses;
    }
}

