/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.validatecode.ValidateCodeParamUtil;
import com.kingdee.util.Uuid;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.bind.CredentialsBinder;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.RequestContext;

public class EASAuthenticationViaFormAction
extends FormAction
implements InitializingBean {
    private CredentialsBinder credentialsBinder;
    private CentralAuthenticationService centralAuthenticationService;
    private CookieGenerator warnCookieGenerator;
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public final void doBind(RequestContext context, Credentials credentials) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        if (this.credentialsBinder != null && this.credentialsBinder.supports(credentials.getClass())) {
            this.credentialsBinder.bind(request, credentials);
        }
        super.bind(context);
        if (credentials instanceof EASCredentials) {
            String ipAddress;
            EASCredentials easCredentials = (EASCredentials)credentials;
            String randomText4Sign = (String)request.getSession().getAttribute(EASCredentials.RANDOM_NO_4_LOGIN);
            if (randomText4Sign != null) {
                easCredentials.getContext().put(EASCredentials.RANDOM_NO_4_LOGIN, randomText4Sign);
                request.getSession().removeAttribute(EASCredentials.RANDOM_NO_4_LOGIN);
            }
            if ((ipAddress = request.getHeader("nap_proxy_client_ip")) == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("X-Forwarded-For");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getRemoteAddr();
            }
            easCredentials.setClientHostIP(ipAddress);
        }
    }

    public final String submit(RequestContext context, Credentials credentials, MessageContext messageContext) throws Exception {
        HttpServletRequest request;
        block9: {
            String authoritativeLoginTicket = WebUtils.getLoginTicketFromFlowScope((RequestContext)context);
            String providedLoginTicket = WebUtils.getLoginTicketFromRequest((RequestContext)context);
            request = WebUtils.getHttpServletRequest((RequestContext)context);
            String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            if (StringUtils.hasText((String)context.getRequestParameters().get("renew")) && ticketGrantingTicketId != null && service != null) {
                try {
                    String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, (Service)service, credentials);
                    WebUtils.putServiceTicketInRequestScope((RequestContext)context, (String)serviceTicketId);
                    this.putWarnCookieIfRequestParameterPresent(context);
                    return "warn";
                }
                catch (TicketException e) {
                    if (this.isCauseAuthenticationException(e)) {
                        this.populateErrorsInstance(e, messageContext);
                        return this.getAuthenticationExceptionEventId(e);
                    }
                    this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug("Attempted to generate a ServiceTicket using renew=true with different credentials", (Throwable)e);
                }
            }
        }
        try {
            ValidateCodeParamUtil.checkValidateCode(request);
            String tgt = this.centralAuthenticationService.createTicketGrantingTicket(credentials);
            WebUtils.putTicketGrantingTicketInRequestScope((RequestContext)context, (String)tgt);
            this.putWarnCookieIfRequestParameterPresent(context);
            context.getConversationScope().put("secondAuthContext", (Object)credentials);
            context.getConversationScope().put("tgt", (Object)tgt);
            String MD5_KEY = Uuid.create().toString();
            WebUtils.getHttpServletRequest((RequestContext)context).getSession().setAttribute("md5_key", (Object)MD5_KEY);
            return "success";
        }
        catch (TicketException e) {
            Integer count = (Integer)request.getSession().getAttribute("login_failed_count");
            if (count == null) {
                request.getSession().setAttribute("login_failed_count", (Object)1);
            } else {
                request.getSession().setAttribute("login_failed_count", (Object)(count + 1));
            }
            this.populateErrorsInstance(e, messageContext);
            if (this.isCauseAuthenticationException(e)) {
                return this.getAuthenticationExceptionEventId(e);
            }
            return "error";
        }
    }

    private void populateErrorsInstance(TicketException e, MessageContext messageContext) {
        try {
            messageContext.addMessage(new MessageBuilder().error().code(e.getCode()).defaultText(e.getCode()).build());
        }
        catch (Exception fe) {
            this.logger.error(fe.getMessage(), (Throwable)fe);
        }
    }

    private void putWarnCookieIfRequestParameterPresent(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        if (StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get("warn"))) {
            this.warnCookieGenerator.addCookie(response, "true");
        } else {
            this.warnCookieGenerator.removeCookie(response);
        }
    }

    private AuthenticationException getAuthenticationExceptionAsCause(TicketException e) {
        return (AuthenticationException)e.getCause();
    }

    private String getAuthenticationExceptionEventId(TicketException e) {
        AuthenticationException authEx = this.getAuthenticationExceptionAsCause(e);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("An authentication error has occurred. Returning the event id " + authEx.getType());
        }
        return authEx.getType();
    }

    private boolean isCauseAuthenticationException(TicketException e) {
        return e.getCause() != null && AuthenticationException.class.isAssignableFrom(e.getCause().getClass());
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setCredentialsBinder(CredentialsBinder credentialsBinder) {
        this.credentialsBinder = credentialsBinder;
    }

    public final void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }
}

