/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.MachineRegisterCollection;
import com.kingdee.eas.base.permission.MachineRegisterFactory;
import com.kingdee.eas.base.permission.MachineRegisterInfo;
import com.kingdee.eas.base.permission.MachineValidataUserManagerFactory;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.security.machinecode.MachineCodeDBUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MachineCodeAuthenticationCheck
extends AbstractAction {
    private static final String MACHINECODE_AUTH_NEED = "machineCodeAuthenticationRequired";
    private static final String MACHINECODE_AUTH_NOT_NEED = "machineCodeAuthenticationNotRequired";
    private static final String MACHINECODE_APPLICATION_AUTH_NEED = "machinecodeApplicationAuthRequired";

    protected Event doExecute(RequestContext context) throws Exception {
        EASCredentials credentials = (EASCredentials)context.getConversationScope().get("secondAuthContext");
        Context ctx = EASLoginHandler.getContextBySessionID(credentials.getEasSessionId());
        if (!MachineCodeDBUtil.getMachineCodeAuthState((Context)ctx)) {
            return this.result(MACHINECODE_AUTH_NOT_NEED);
        }
        String userNumber = credentials.getUsername();
        String machineCode = "";
        String sql = "SELECT FID FROM T_PM_USER WHERE LOWER(FNUMBER)=? or LOWER(FLoginNumber)=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userNumber.toLowerCase(), userNumber.toLowerCase()});
        String userID = "";
        if (rs != null && rs.next()) {
            userID = rs.getString("FID");
        }
        if (StringUtils.isEmpty((String)userID)) {
            return this.result("error");
        }
        try {
            boolean isWithUser = PermissionCommonUtil.IsMachineRegisterWithUser((Context)ctx);
            MachineRegisterInfo info = null;
            String policy = PermissionCommonUtil.getMachineCodeGeneratorPolicy((Context)ctx);
            if ("3".equals(policy) || "12".equals(policy) || "14".equals(policy) || "15".equals(policy)) {
                return this.result(MACHINECODE_AUTH_NOT_NEED);
            }
            machineCode = "2".equals(policy) ? credentials.getClientHostIP().replace(".", "") : ("4".equals(policy) ? credentials.getMcCodeToken() : ("6".equals(policy) ? credentials.getMcCodeToken() + credentials.getClientHostIP().replace(".", "") : credentials.getMcCodeToken()));
            HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
            if ("error".equals(credentials.getMcCodeToken())) {
                request.setAttribute("mcCodeApp", (Object)"need");
                return this.result(MACHINECODE_APPLICATION_AUTH_NEED);
            }
            try {
                machineCode = CryptoTean.encrypt((String)"", (String)machineCode);
            }
            catch (CryptException e) {
                this.logger.error((Object)"", (Throwable)e);
                machineCode = "Crypt Fail";
            }
            if (isWithUser) {
                String type = ParamManager.getParamValue((Context)ctx, null, (String)"BOSBAS_002");
                if ("0".equalsIgnoreCase(type) && MachineCodeAuthenticationCheck.isInExclude(ctx, userID) || "1".equalsIgnoreCase(type) && !MachineCodeAuthenticationCheck.isInExclude(ctx, userID)) {
                    return this.result(MACHINECODE_AUTH_NOT_NEED);
                }
                info = MachineCodeAuthenticationCheck.getRegisterInfoByMachineCodeOrByUserId(machineCode, userID, ctx, 1);
            } else {
                info = MachineCodeAuthenticationCheck.getRegisterInfoByMachineCodeOrByUserId(machineCode, userID, ctx, 0);
            }
            if (info == null || info.getInValidDate().getTime() < System.currentTimeMillis() || info.getValidDate().getTime() > System.currentTimeMillis()) {
                return this.result(MACHINECODE_AUTH_NEED);
            }
            if (info != null && !info.isIsRegistered()) {
                request.setAttribute("checkError", (Object)"false");
                return this.result(MACHINECODE_AUTH_NEED);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
        }
        return this.result(MACHINECODE_AUTH_NOT_NEED);
    }

    private static MachineRegisterInfo getRegisterInfoByMachineCodeOrByUserId(String machineCode, String UserId, Context ctx, int type) throws BOSException, EASBizException {
        MachineRegisterInfo object = null;
        if (type == 0) {
            object = MachineRegisterFactory.getLocalInstance((Context)ctx).getRegisterInfoByMachineCode(machineCode);
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("machineCode", (Object)machineCode));
            filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)UserId));
            filter.getFilterItems().add(new FilterItemInfo("validDate", (Object)new Date(), CompareType.LESS));
            filter.getFilterItems().add(new FilterItemInfo("inValidDate", (Object)new Date(), CompareType.GREATER));
            evi.setFilter(filter);
            evi.getSelector().add("creator.*");
            evi.getSelector().add("CU.*");
            evi.getSelector().add("*");
            MachineRegisterCollection machineRegisterCollection = MachineRegisterFactory.getLocalInstance((Context)ctx).getMachineRegisterCollection(evi);
            if (machineRegisterCollection.size() > 0) {
                object = (MachineRegisterInfo)machineRegisterCollection.getObject(0);
            }
        }
        return object;
    }

    private static boolean isInExclude(Context ctx, String UserId) throws BOSException, EASBizException {
        return MachineValidataUserManagerFactory.getLocalInstance((Context)ctx).exists("where user.id='" + UserId + "'");
    }
}

