/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomCollection;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomFactory;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomInfo;
import com.kingdee.eas.base.myeas.PrivacyStatementFactory;
import com.kingdee.eas.base.permission.util.cloud.Constants;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.QrCodeTokenHelper;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PrivacyStatementCheck
extends AbstractAction {
    private static final String PRIVACY_STATEMENT_NEED = "privacyStatementNeed";
    private static final String PRIVACY_STATEMENT_NOT_NEED = "privacyStatementNotNeed";

    protected Event doExecute(RequestContext context) throws Exception {
        String userId;
        String sql;
        EASCredentials credentials = (EASCredentials)context.getConversationScope().get("secondAuthContext");
        String userNumber = credentials.getUsername();
        Context ctx = EASLoginHandler.getContextBySessionID(credentials.getEasSessionId());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT FID FROM T_PM_USER WHERE LOWER(FNUMBER)=? or LOWER(FLoginNumber)=?"), (Object[])new Object[]{userNumber.toLowerCase(), userNumber.toLowerCase()});
        if (rs == null || rs.size() == 0) {
            return this.result("error");
        }
        if (rs.next() && ("00000000-0000-0000-0000-00000000000013B7DE7F".equalsIgnoreCase(userId = rs.getString("FID")) || "00000000-0000-0000-0000-00000000000213B7DE7F".equalsIgnoreCase(userId) || "Wp3rRSFxRCaPFjuE2apQjRO33n8=".equalsIgnoreCase(userId) || "00000000-0000-0000-0000-00000000000113B7DE7F".equalsIgnoreCase(userId) || "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equalsIgnoreCase(userId))) {
            return this.result(PRIVACY_STATEMENT_NOT_NEED);
        }
        int privacyStatement = QrCodeTokenHelper.getPrivacyStatement();
        if (privacyStatement == 0) {
            return this.result(PRIVACY_STATEMENT_NOT_NEED);
        }
        int count = 0;
        String htmlContent = "";
        String kdOrPrivcy = "KD";
        if (privacyStatement == 1) {
            String versionTime = Constants.PRIVACY_STATE_VERSION;
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("userid", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("versionTime", (Object)versionTime, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            count = PrivacyStatementFactory.getLocalInstance((Context)ctx).getPrivacyStatementCollection(entityViewInfo).size();
            kdOrPrivcy = "KD";
        } else {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"ENABLE", CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            PrivacyStatementCustomCollection customInfos = PrivacyStatementCustomFactory.getLocalInstance((Context)ctx).getPrivacyStatementCustomCollection(entityViewInfo);
            if (customInfos.size() == 0) {
                return this.result(PRIVACY_STATEMENT_NOT_NEED);
            }
            PrivacyStatementCustomInfo privacyStatementCustomInfo = customInfos.get(0);
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("privacyCusId", (Object)privacyStatementCustomInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("userid", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
            entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            count = PrivacyStatementFactory.getLocalInstance((Context)ctx).getPrivacyStatementCollection(entityViewInfo).size();
            htmlContent = privacyStatementCustomInfo.getHtmlContent();
            kdOrPrivcy = "Privcy";
        }
        if (count == 0) {
            HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
            request.setAttribute("htmlContent", (Object)htmlContent);
            request.setAttribute("kdOrPrivcy", (Object)kdOrPrivcy);
            HttpSession session = request.getSession();
            if (session != null) {
                session.setAttribute(PRIVACY_STATEMENT_NEED, (Object)"true");
            }
            return this.result(PRIVACY_STATEMENT_NEED);
        }
        return this.result(PRIVACY_STATEMENT_NOT_NEED);
    }
}

