/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.DoubleItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.DoubleItemStack;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class MultidimensionalModel {
    private List cellList = new ArrayList();

    public void addCell(Member[] left, Member[] top, double value) {
        this.cellList.add(new Cell(left, top, value));
    }

    public CommonChartData extractGroup(String[] seriesDimName, String[] groupsDimName, boolean reserve) {
        Cell cell;
        ArrayList<String> gList = new ArrayList<String>();
        ArrayList<String> sList = new ArrayList<String>();
        int n = this.cellList.size();
        for (int i = 0; i < n; ++i) {
            cell = (Cell)this.cellList.get(i);
            cell.combineCoordinate(seriesDimName, groupsDimName);
            if (!gList.contains(cell.group)) {
                gList.add(cell.group);
            }
            if (sList.contains(cell.series)) continue;
            sList.add(cell.series);
        }
        double[][] dd = new double[gList.size()][sList.size()];
        int n2 = gList.size();
        for (int i = 0; i < n2; ++i) {
            String group = (String)gList.get(i);
            int m = sList.size();
            for (int j = 0; j < m; ++j) {
                cell = new Cell(group, (String)sList.get(j));
                int index = this.cellList.indexOf(cell);
                if (index == -1) {
                    dd[i][j] = 0.0;
                    continue;
                }
                cell = (Cell)this.cellList.get(index);
                dd[i][j] = cell.value;
            }
        }
        if (reserve) {
            ArrayList<String> buf = gList;
            gList = sList;
            sList = buf;
            if (dd.length > 0) {
                double[][] dd2 = new double[dd.length][dd[0].length];
                int n3 = dd.length;
                for (int i = 0; i < n3; ++i) {
                    int m = dd[0].length;
                    for (int j = 0; j < m; ++j) {
                        dd2[j][i] = dd[i][j];
                    }
                }
                dd = dd2;
            }
        }
        CommonChartData ccd = ChartDataUtil.createCommonChartData((String[])gList.toArray(new String[0]), (String[])sList.toArray(new String[0]), (double[][])dd);
        return ccd;
    }

    public static CommonChartData sortBy(int top, String measureKey, CommonChartData ccd) {
        int colIndex;
        int i;
        Comparable[] g = ccd.getGroupKeys();
        int colCount = g.length;
        if (top >= colCount || top <= 0) {
            return ccd;
        }
        Comparable[] s = ccd.getSeriesKeys();
        int rowIndex = -1;
        List<String> keyList = Arrays.asList(measureKey.split(","));
        int n = s.length;
        for (int i2 = 0; i2 < n; ++i2) {
            String skey = s[i2].toString();
            List<String> mks = Arrays.asList(skey.split(","));
            if (mks.size() != keyList.size() || !mks.containsAll(keyList)) continue;
            rowIndex = i2;
            break;
        }
        if (rowIndex == -1) {
            throw new RuntimeException("Can't match series with \"" + measureKey + "\"!");
        }
        int rowCount = s.length;
        double[][] v = ccd.getValues();
        DoubleItemStack ds = new DoubleItemStack(top);
        for (int i3 = 0; i3 < colCount; ++i3) {
            double value = v[rowIndex][i3];
            ds.add(new DoubleItem(i3, value));
        }
        DoubleItem[] items = ds.getAll();
        String[] g2 = new String[top];
        double[][] v2 = new double[rowCount][top];
        for (i = 0; i < top; ++i) {
            colIndex = items[i].getIndex();
            g2[i] = g[colIndex];
        }
        for (i = 0; i < rowCount; ++i) {
            for (int j = 0; j < top; ++j) {
                colIndex = items[j].getIndex();
                v2[i][j] = v[i][colIndex];
            }
        }
        ccd = new CommonChartData(s, (Comparable[])g2, v2);
        return ccd;
    }

    public static void main(String[] args) {
        String[] s = new String[]{"\u6388\u4fe1\u603b\u989d\u5ea6,\u5883\u5185", "\u6388\u4fe1\u603b\u989d\u5ea6,\u5883\u5916", "\u6388\u4fe1\u603b\u989d\u5ea6,\u5c0f\u8ba1", "\u5df2\u4f7f\u7528\u989d\u5ea6,\u5883\u5185", "\u5df2\u4f7f\u7528\u989d\u5ea6,\u5883\u5916", "\u5df2\u4f7f\u7528\u989d\u5ea6,\u5c0f\u8ba1", "\u5269\u4f59\u989d\u5ea6,\u5883\u5185", "\u5269\u4f59\u989d\u5ea6,\u5883\u5916", "\u5269\u4f59\u989d\u5ea6,\u5c0f\u8ba1"};
        String[] g = new String[]{"\u62db\u5546\u534e\u4fa8\u57ce", "\u62db\u5546\u5c40\u96c6\u56e2\u6709\u9650\u516c\u53f8", "\u62db\u5546\u5c40\u8f6e\u8239\u80a1\u4efd\u6709\u9650\u516c\u53f8", "\u96c6\u56e2\u9999\u6e2f", "\u86c7\u53e3\u5de5\u4e1a\u533a\u672c\u90e8", "\u5357\u6cb9\u96c6\u56e2", "\u63a7\u80a1\u672c\u90e8", "\u62db\u5546\u4f9b\u7535", "\u6df1\u5733\u5730\u4ea7\u672c\u90e8", "\u9999\u6e2f\u745e\u5609", "\u5408\u8ba1"};
        double[][] v = new double[][]{{49021.0, 31.57, 5.4, 0.812, 190100.0678, 0.1, 420000.0, 1010.1, 18.081235, 0.021, 660187.152035}, {36.0, 1.2, 164.0, 0.0, 0.0, 0.0, 83926.5, 812.3, 0.0, 39965.0, 124905.0}, {49057.0, 32.77, 169.4, 0.812, 190100.0678, 0.1, 503926.5, 1822.4, 18.081235, 39965.021, 785092.152035}, {22482.8694, 5.6, 36.773965, 5.86264, 43385.11, 0.095, 53282.616, 12.52215, 1.5786775225, 0.0, 119213.02783252251}, {0.04, 8.4, 1264.0, 0.0, 0.0, 0.0, 614873.5145, 5786.0129, 0.0, 279475.245, 901407.2124}, {22482.9094, 14.0, 1300.773965, 5.86264, 43385.11, 0.095, 668156.1305000001, 5798.5350499999995, 1.5786775225, 279475.245, 1020620.2402325225}, {26538.1306, 31.57, 2.226035, 0.7308, 146714.9578, 0.005, 366717.384, 997.57785, 17.081235, 0.021, 541019.68432}, {35.96, 1.2, 48.0, 0.0, 0.0, 0.0, 55951.0, 812.3, 0.0, 39965.0, 96813.46}, {26574.0906, 32.77, 50.226035, 0.7308, 146714.9578, 0.005, 422668.384, 1809.8778499999999, 17.081235, 39965.021, 637833.1443200001}};
        CommonChartData cd = new CommonChartData((Comparable[])s, (Comparable[])g, (double[][])v);
        cd = MultidimensionalModel.sortBy(5, "\u5883\u5916,\u6388\u4fe1\u603b\u989d\u5ea6", cd);
    }

    class Cell {
        double value;
        List memberList;
        String group;
        String series;

        Cell(Member[] left, Member[] top, double value) {
            this.value = value;
            this.memberList = new ArrayList();
            this.memberList.addAll(Arrays.asList(left));
            this.memberList.addAll(Arrays.asList(top));
        }

        void combineCoordinate(String[] groupsDimName, String[] seriesDimName) {
            this.group = this.buildLabel(groupsDimName);
            this.series = this.buildLabel(seriesDimName);
        }

        private String buildLabel(String[] dims) {
            StringBuilder s = new StringBuilder();
            int n = dims.length;
            for (int i = 0; i < n; ++i) {
                String dim = dims[i].toLowerCase(Locale.ENGLISH);
                int m = this.memberList.size();
                for (int j = 0; j < m; ++j) {
                    Member mm = (Member)this.memberList.get(j);
                    if (!mm.getDimension().getName().toLowerCase(Locale.ENGLISH).equals(dim)) continue;
                    s.append(',').append(mm.getLabel());
                }
            }
            return s.substring(1);
        }

        Cell(String group, String series) {
            this.group = group;
            this.series = series;
        }

        public boolean equals(Object o) {
            Cell c = (Cell)o;
            return this.group.equals(c.group) && this.series.equals(c.series);
        }
    }
}

