/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetExpertBase;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class WorksheetMergeExpert
extends WorksheetExpertBase {
    private ArrayList items = new ArrayList(0);

    public WorksheetMergeExpert(WorksheetComponent wc) {
        super(wc);
    }

    public void clear() {
        this.items.clear();
    }

    public void addItem(String[] memberUniqueNames, int contentIndex) {
        if (contentIndex < 0 || contentIndex > memberUniqueNames.length - 1) {
            throw new ArrayIndexOutOfBoundsException("contentIndex\u8d8a\u754c");
        }
        List list = OlapModelUtil.lookupMembers(this.worksheet.getOlapModel(), memberUniqueNames);
        if (list.size() < memberUniqueNames.length) {
            if (this.getLogger().isDebugEnabled()) {
                StringBuffer sb = new StringBuffer(memberUniqueNames[0]);
                for (int i = 1; i < memberUniqueNames.length; ++i) {
                    sb.append(",").append(memberUniqueNames[i]);
                }
                this.getLogger().debug((Object)("\u975e\u6cd5UniqueNames\uff1a{" + sb + "}"));
            }
            return;
        }
        Item item = new Item(list.toArray(new Member[0]), contentIndex);
        this.items.add(item);
    }

    public void render() {
        Result result;
        if (this.items.size() == 0) {
            return;
        }
        try {
            OlapModel olapModel = this.worksheet.getOlapModel();
            result = olapModel.getResult();
        }
        catch (OlapException e) {
            return;
        }
        if (result == null) {
            return;
        }
        this.additionMerge(result, this.items);
    }

    private void additionMerge(Result result, List items) {
        Axis topAxis = OlapModelUtil.getTopAxis(result);
        Axis leftAxis = OlapModelUtil.getLeftAxis(result);
        if (topAxis == null || leftAxis == null) {
            return;
        }
        ArrayList<Item> itemsOnTop = new ArrayList<Item>();
        ArrayList<Item> itemsOnLeft = new ArrayList<Item>();
        List<Hierarchy> listTopHies = Arrays.asList(topAxis.getHierarchies());
        List<Hierarchy> listLeftHies = Arrays.asList(leftAxis.getHierarchies());
        for (Item item : items) {
            int max;
            int min;
            Member[] ms = item.members;
            ArrayList<Integer> indiceTop = new ArrayList<Integer>();
            ArrayList<Integer> indiceLeft = new ArrayList<Integer>();
            for (int i = 0; i < ms.length; ++i) {
                int index = listTopHies.indexOf(ms[i].getHierarchy());
                if (index >= 0) {
                    indiceTop.add(new Integer(index));
                }
                if ((index = listLeftHies.indexOf(ms[i].getHierarchy())) < 0) continue;
                indiceLeft.add(new Integer(index));
            }
            if (indiceTop.size() == ms.length) {
                Collections.sort(indiceTop);
                min = (Integer)indiceTop.get(0);
                max = (Integer)indiceTop.get(indiceTop.size() - 1);
                if (max - min == indiceTop.size() - 1) {
                    itemsOnTop.add(item);
                }
            }
            if (indiceLeft.size() != ms.length) continue;
            Collections.sort(indiceLeft);
            min = (Integer)indiceLeft.get(0);
            max = (Integer)indiceLeft.get(indiceLeft.size() - 1);
            if (max - min != indiceLeft.size() - 1) continue;
            itemsOnLeft.add(item);
        }
        if (itemsOnTop.size() > 0) {
            this.additionMergeTop(itemsOnTop);
        }
        if (itemsOnLeft.size() > 0) {
            this.additionMergeLeft(itemsOnLeft);
        }
    }

    private void additionMergeLeft(List items) {
        if (this.worksheet.getConfig().showNestMemberForRow) {
            return;
        }
        int rowStart = 0;
        int columnStart = 0;
        Axis topAxis = null;
        try {
            topAxis = OlapModelUtil.getTopAxis(this.worksheet.getOlapModel());
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Axis leftAxis = null;
        try {
            leftAxis = OlapModelUtil.getLeftAxis(this.worksheet.getOlapModel());
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Hierarchy[] hies = topAxis.getHierarchies();
        if (!this.worksheet.getConfig().showColumnHeaderInTableHeader) {
            ++rowStart;
            if (this.worksheet.getConfig().showColumnDimensionHeader) {
                rowStart += hies.length;
            }
        }
        HashMap<Integer, MergeInfo> map = new HashMap<Integer, MergeInfo>();
        List listPoses = leftAxis.getPositions();
        int index = 0;
        for (Position pos : listPoses) {
            MergeInfo mergeInfo = this.matchMergeInfo(pos, items);
            if (mergeInfo != null) {
                map.put(new Integer(index), mergeInfo);
            }
            ++index;
        }
        ArrayList keyIndice = new ArrayList();
        keyIndice.addAll(map.keySet());
        Collections.sort(keyIndice);
        for (Integer I : keyIndice) {
            MergeInfo mergeInfo = (MergeInfo)map.get(I);
            Position pos = (Position)listPoses.get(I);
            int rowIndex = rowStart + I;
            this.doMergeLeft(pos, rowIndex, columnStart, mergeInfo);
        }
    }

    private void additionMergeTop(List items) {
        if (this.worksheet.getConfig().showNestMemberForColumn) {
            return;
        }
        int rowStart = 0;
        int columnStart = 0;
        Axis topAxis = null;
        try {
            topAxis = OlapModelUtil.getTopAxis(this.worksheet.getOlapModel());
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Axis leftAxis = null;
        try {
            leftAxis = OlapModelUtil.getLeftAxis(this.worksheet.getOlapModel());
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Hierarchy[] hies = topAxis.getHierarchies();
        if (this.worksheet.getConfig().showColumnDimensionHeader) {
            rowStart += hies.length;
        }
        columnStart += leftAxis.getHierarchies().length;
        HashMap<Integer, MergeInfo> map = new HashMap<Integer, MergeInfo>();
        List listPoses = topAxis.getPositions();
        int index = 0;
        for (Position pos : listPoses) {
            MergeInfo mergeInfo = this.matchMergeInfo(pos, items);
            if (mergeInfo != null) {
                map.put(new Integer(index), mergeInfo);
            }
            ++index;
        }
        ArrayList keyIndice = new ArrayList();
        keyIndice.addAll(map.keySet());
        Collections.sort(keyIndice);
        for (Integer I : keyIndice) {
            MergeInfo mergeInfo = (MergeInfo)map.get(I);
            Position pos = (Position)listPoses.get(I);
            int columnIndex = columnStart + I;
            this.doMergeTop(pos, rowStart, columnIndex, mergeInfo);
        }
    }

    private void doMergeTop(Position pos, int rowStart, int column, MergeInfo mergeInfo) {
        boolean header = this.worksheet.getConfig().showColumnHeaderInTableHeader;
        ICell cell = this.worksheet.getRow(this.worksheet.getKDTable(), header, rowStart + mergeInfo.index).getCell(column);
        KDTMergeBlock mb = cell.getMergeBlock();
        CellItem cellItem = mb != null ? (CellItem)this.worksheet.getRow(this.worksheet.getKDTable(), header, rowStart + mergeInfo.index).getCell(mb.getLeft()).getValue() : (CellItem)cell.getValue();
        int row = rowStart + mergeInfo.min;
        int height = mergeInfo.max - mergeInfo.min;
        for (int i = 0; i < height; ++i) {
            ICell cell2 = this.worksheet.getRow(this.worksheet.getKDTable(), header, row += i).getCell(column);
            mb = cell2.getMergeBlock();
            CellItem cellItem2 = mb != null ? (CellItem)this.worksheet.getRow(this.worksheet.getKDTable(), header, row).getCell(mb.getLeft()).getValue() : (CellItem)cell2.getValue();
            if (mb != null && mb.getRight() > mb.getLeft()) {
                this.worksheet.split(header, mb.getTop(), mb.getLeft(), mb.getBottom(), mb.getRight());
                if (mb.getLeft() < column) {
                    if (mb.getLeft() < column - 1) {
                        this.worksheet.merge(header, mb.getTop(), mb.getLeft(), mb.getBottom(), column - 1);
                    }
                    this.worksheet.fillCellItem(this.worksheet.getKDTable(), header, mb.getTop(), mb.getLeft(), cellItem2);
                }
                if (mb.getRight() > column) {
                    if (mb.getRight() > column + 1) {
                        this.worksheet.merge(header, mb.getTop(), column + 1, mb.getBottom(), mb.getRight());
                    }
                    this.worksheet.fillCellItem(this.worksheet.getKDTable(), header, mb.getTop(), column + 1, cellItem2);
                }
            }
            this.worksheet.fillCellItem(this.worksheet.getKDTable(), header, row, column, cellItem);
        }
        this.worksheet.merge(header, rowStart + mergeInfo.min, column, rowStart + mergeInfo.max, column);
    }

    private void doMergeLeft(Position pos, int row, int columnStart, MergeInfo mergeInfo) {
        boolean header = false;
        ICell cell = this.worksheet.getRow(this.worksheet.getKDTable(), header, row).getCell(columnStart + mergeInfo.index);
        KDTMergeBlock mb = cell.getMergeBlock();
        CellItem cellItem = mb != null ? (CellItem)this.worksheet.getRow(this.worksheet.getKDTable(), header, mb.getTop()).getCell(columnStart + mergeInfo.index).getValue() : (CellItem)cell.getValue();
        int column = columnStart + mergeInfo.min;
        int height = mergeInfo.max - mergeInfo.min;
        for (int i = 0; i < height; ++i) {
            ICell cell2 = this.worksheet.getRow(this.worksheet.getKDTable(), false, row).getCell(column += i);
            mb = cell2.getMergeBlock();
            CellItem cellItem2 = mb != null ? (CellItem)this.worksheet.getRow(this.worksheet.getKDTable(), header, mb.getTop()).getCell(column).getValue() : (CellItem)cell2.getValue();
            if (mb != null && mb.getBottom() > mb.getTop()) {
                this.worksheet.split(header, mb.getTop(), mb.getLeft(), mb.getBottom(), mb.getRight());
                if (mb.getTop() < row) {
                    if (mb.getTop() < row - 1) {
                        this.worksheet.merge(header, mb.getTop(), mb.getLeft(), row - 1, mb.getRight());
                    }
                    this.worksheet.fillCellItem(this.worksheet.getKDTable(), header, mb.getTop(), mb.getLeft(), cellItem2);
                }
                if (mb.getBottom() > row) {
                    if (mb.getBottom() > row + 1) {
                        this.worksheet.merge(header, row + 1, mb.getLeft(), mb.getBottom(), mb.getRight());
                    }
                    this.worksheet.fillCellItem(this.worksheet.getKDTable(), header, row + 1, mb.getLeft(), cellItem2);
                }
            }
            this.worksheet.fillCellItem(this.worksheet.getKDTable(), header, row, column, cellItem);
        }
        this.worksheet.merge(header, row, columnStart + mergeInfo.min, row, columnStart + mergeInfo.max);
    }

    private MergeInfo matchMergeInfo(Position pos, List items) {
        Member[] ms = pos.getMembers();
        MergeInfo info = null;
        for (Item item : items) {
            List<Member> list = Arrays.asList(ms);
            ArrayList<Integer> indice = new ArrayList<Integer>(item.members.length);
            for (int i = 0; i < item.members.length; ++i) {
                int ind = list.indexOf(item.members[i]);
                if (ind < 0) continue;
                indice.add(new Integer(ind));
            }
            if (indice.size() == 0) continue;
            Collections.sort(indice);
            int min = (Integer)indice.get(0);
            int max = (Integer)indice.get(indice.size() - 1);
            if (indice.size() != item.members.length || max - min != item.members.length - 1) continue;
            int ind = list.indexOf(item.members[item.contentIndex]);
            info = new MergeInfo(min, max, ind);
        }
        return info;
    }

    private class MergeInfo {
        int max;
        int min;
        int index;

        MergeInfo(int min, int max, int index) {
            this.max = max;
            this.min = min;
            this.index = index;
        }
    }

    static class Item {
        Member[] members;
        int contentIndex;

        Item(Member[] members, int contentIndex) {
            this.members = members;
            this.contentIndex = contentIndex;
        }
    }
}

