/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.common.dbcenter.ui;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.EnumObj;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModelUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.ui.AbstractDBCenterDialog;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Vector;

public class DBCenterDialog
extends AbstractDBCenterDialog {
    private static final long serialVersionUID = -2950901629883731023L;
    private DBCenterModel model = null;
    private IChecker checker = null;
    private boolean isEdit = false;

    public DBCenterDialog() {
    }

    public DBCenterDialog(Dialog owner) {
        super(owner);
    }

    public DBCenterDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        super.todoAddControls(parent, thisCell);
        this.loadModel();
    }

    @Override
    protected void todoInit() {
        super.todoInit();
    }

    public void loadModel() {
        if (this.model != null) {
            this.txtDBCenterName.setText(this.model.getDbCenterName());
            this.loadModel_cbx_helper(this.cbxBizType, this.model.getBusiType());
            this.loadModel_cbx_helper(this.cbxDBType, this.model.getDbType());
            this.txtDBUrl.setText(this.model.getUrl());
            this.txtDBPort.setText(this.model.getPort());
            this.loadModel_dbn_helper(this.model.getDbName(), this.model.getDbType());
            this.txtDBUserName.setText(this.model.getUserName());
            this.txtDBPassWord.setText(this.model.getPassWord());
            this.txtMaxIdle.setText(Integer.toString(this.model.getMaxIdle()));
            this.txtMinIdle.setText(Integer.toString(this.model.getMinIdle()));
            this.txtMaxActive.setText(Integer.toString(this.model.getMaxActive()));
            this.txtMaxWait.setText(Long.toString(this.model.getMaxWait()));
            this.loadModel_cbx_helper(this.cbxWhenExhausted, String.valueOf(this.model.getWhenExhausted()));
        } else {
            this.action_ChangeDBType("sqlserver");
            this.txtMaxIdle.setText("8");
            this.txtMinIdle.setText("0");
            this.txtMaxActive.setText("8");
            this.txtMaxWait.setText("-1");
        }
    }

    private void loadModel_cbx_helper(KDComboBox cbx, String select) {
        int n = cbx.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object obj = cbx.getItemAt(i);
            if (!((EnumObj)obj).getNumber().equals(select)) continue;
            cbx.setSelectedItem(obj);
            break;
        }
    }

    private void loadModel_dbn_helper(String dbName, String dbType) {
        if ("sqlserver".equals(dbType)) {
            this.cbxDBName_SqlServer.setSelectedItem((Object)new EnumObj(dbName));
        } else if ("oracle".equals(dbType)) {
            this.txtDBName_Oracle.setText(dbName);
        } else if ("db2".equals(dbType)) {
            this.txtDBName_DB2.setText(dbName);
        }
    }

    public DBCenterModel getModel() {
        if (this.model == null) {
            this.model = new DBCenterModel();
        }
        this.model.setDbCenterName(this.txtDBCenterName.getText().trim());
        this.model.setBusiType(((EnumObj)this.cbxBizType.getSelectedItem()).getNumber());
        this.model.setDbType(((EnumObj)this.cbxDBType.getSelectedItem()).getNumber());
        this.model.setUrl(this.txtDBUrl.getText().trim());
        this.model.setPort(this.txtDBPort.getText().trim());
        this.model.setDbName(this.getModel_dbn_helper(this.model.getDbType()));
        this.model.setUserName(this.txtDBUserName.getText().trim());
        this.model.setPassWord(String.valueOf(this.txtDBPassWord.getPassword()));
        this.model.setMaxIdle(Integer.parseInt(this.txtMaxIdle.getText().trim()));
        this.model.setMinIdle(Integer.parseInt(this.txtMinIdle.getText().trim()));
        this.model.setMaxActive(Integer.parseInt(this.txtMaxActive.getText().trim()));
        this.model.setMaxWait(Integer.parseInt(this.txtMaxWait.getText().trim()));
        this.model.setWhenExhausted(Byte.valueOf(((EnumObj)this.cbxWhenExhausted.getSelectedItem()).getNumber()));
        return this.model;
    }

    private String getModel_dbn_helper(String dbType) {
        if ("sqlserver".equals(dbType)) {
            Object obj = this.cbxDBName_SqlServer.getSelectedItem();
            if (obj instanceof EnumObj) {
                return ((EnumObj)obj).getNumber();
            }
            return (String)obj;
        }
        if ("oracle".equals(dbType)) {
            return this.txtDBName_Oracle.getText().trim();
        }
        if ("db2".equals(dbType)) {
            return this.txtDBName_DB2.getText().trim();
        }
        return null;
    }

    @Override
    protected void action_ChangeDBType(String dbType) {
        if ("sqlserver".equals(dbType)) {
            this.txtDBPort.setText("1433");
            this.txtDBUserName.setText("sa");
            this.action_ChangeDBType_helper(dbType);
        } else if ("oracle".equals(dbType)) {
            this.txtDBPort.setText("1521");
            this.action_ChangeDBType_helper(dbType);
        } else if ("db2".equals(dbType)) {
            this.txtDBPort.setText("50000");
            this.txtDBUserName.setText("db2admin");
            this.action_ChangeDBType_helper(dbType);
        }
        this.panSimp.repaint();
        this.panSimp.revalidate();
    }

    private void action_ChangeDBType_helper(String dbType) {
        if (this.lctnDBName_SqlServer != null) {
            this.panSimp.remove((Component)this.lctnDBName_SqlServer);
        }
        if (this.lctnDBName_Oracle != null) {
            this.panSimp.remove((Component)this.lctnDBName_Oracle);
        }
        if (this.lctnDBName_DB2 != null) {
            this.panSimp.remove((Component)this.lctnDBName_DB2);
        }
        if ("sqlserver".equals(dbType)) {
            this.panSimp.add(this.getLctnDBName(dbType), (Object)TableLayout2.param((int)5, (int)1));
            this.btnGetDBs.setVisible(true);
        } else {
            this.btnGetDBs.setVisible(false);
            this.panSimp.add(this.getLctnDBName(dbType), (Object)TableLayout2.param((int)5, (int)1, (int)5, (int)2));
        }
    }

    @Override
    protected void action_Query() {
        this.cbxDBName_SqlServer.removeAllItems();
        String _url = this.txtDBUrl.getText().trim();
        String _port = this.txtDBPort.getText().trim();
        String _user = this.txtDBUserName.getText().trim();
        String _pswd = String.valueOf(this.txtDBPassWord.getPassword());
        if (this.isVolid("query")) {
            Vector vector = null;
            try {
                vector = DBCenterModelUtil.getDBNames(_url, _port, _user, _pswd);
            }
            catch (DBCenterException e) {
                log.error((Object)e);
            }
            if (vector == null || vector.size() == 0) {
                WindowUtil.msgboxInfo((Object)"\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u6570\u636e\u5e93\uff01", (String)this.getTitle(), (Component)((Object)this));
            }
            this.cbxDBName_SqlServer.addItems(vector);
        }
    }

    protected boolean isVolid(String actionType) {
        if (StringUtil.isEmptyString((String)this.txtDBCenterName.getText().trim())) {
            WindowUtil.msgboxInfo((Object)"\u6570\u636e\u4e2d\u5fc3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (StringUtil.isEmptyString((String)this.txtDBUrl.getText().trim())) {
            WindowUtil.msgboxInfo((Object)"\u6570\u636e\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (StringUtil.isEmptyString((String)this.txtDBPort.getText().trim())) {
            WindowUtil.msgboxInfo((Object)"\u6570\u636e\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (StringUtil.isEmptyString((String)this.txtDBUserName.getText().trim())) {
            WindowUtil.msgboxInfo((Object)"\u6570\u636e\u5e93\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if ("submit".equals(actionType)) {
            if (StringUtil.isEmptyString((String)this.getModel_dbn_helper(((EnumObj)this.cbxDBType.getSelectedItem()).getNumber()))) {
                WindowUtil.msgboxInfo((Object)"\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
            if (!this.isEdit && this.checker != null && this.checker.isDBCenterNameExist(this.txtDBCenterName.getText().trim())) {
                WindowUtil.msgboxInfo((Object)"\u6570\u636e\u5e93\u4e2d\u5fc3\u540d\u79f0\u5df2\u7ecf\u88ab\u4f7f\u7528\uff01", (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
        }
        String isInteger = "^-?[1-9]\\d*$";
        String isSignlessInteger = "^[1-9]\\d*$";
        String isNonnegativeIntegers = "^[1-9]\\d*|0$";
        String isIp = "\\d+\\.\\d+\\.\\d+\\.\\d+";
        if (!this.txtDBUrl.getText().trim().matches(isIp) && !this.txtDBUrl.getText().trim().equals("localhost")) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6570\u636e\u5e93\u5730\u5740\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (!this.txtDBPort.getText().trim().matches(isSignlessInteger)) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7aef\u53e3\u53f7\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (!this.txtMaxIdle.getText().trim().matches(isSignlessInteger)) {
            WindowUtil.msgboxInfo((Object)"\u6700\u5927\u8fde\u63a5\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (!this.txtMinIdle.getText().trim().matches(isNonnegativeIntegers)) {
            WindowUtil.msgboxInfo((Object)"\u6700\u5c0f\u8fde\u63a5\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (!this.txtMaxActive.getText().trim().matches(isSignlessInteger)) {
            WindowUtil.msgboxInfo((Object)"\u6700\u5927\u6d3b\u8dc3\u8fde\u63a5\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u662f\u6b63\u6574\u6570\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (!this.txtMaxWait.getText().trim().matches(isInteger) || Integer.parseInt(this.txtMaxWait.getText().trim()) < -1) {
            WindowUtil.msgboxInfo((Object)"\u6700\u5927\u7b49\u5f85\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u662f\u5927\u4e8e-1\u7684\u6574\u6570(-1\u4ee3\u8868\u65e0\u9650\u5236)\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (StringUtil.isEmptyString((String)String.valueOf(this.txtDBPassWord.getPassword()))) {
            return WindowUtil.msgboxYesNo((Component)((Object)this), (Object)"\u60a8\u586b\u5199\u7684\u6570\u636e\u5e93\u5bc6\u7801\u4e3a\u7a7a\uff0c\u662f\u5426\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)this.getTitle());
        }
        return true;
    }

    public void setEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    public void setModel(DBCenterModel model) {
        this.model = model;
    }

    protected void onCancel() {
        super.onCancel();
    }

    protected void onOk() {
        if (this.isVolid("submit")) {
            this.getModel();
            super.onOk();
        }
    }

    public void setChecker(IChecker checker) {
        this.checker = checker;
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        DBCenterDialog aTest = new DBCenterDialog();
        aTest.showDialog();
    }

    public static interface IChecker {
        public boolean isDBCenterNameExist(String var1);
    }
}

