/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.IStorage;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

class FileStorage
implements IStorage {
    private final Window owner;

    FileStorage(Window owner) {
        this.owner = owner;
    }

    private InputStream getInputStream() {
        File file = WindowUtil.chooseOpenFile((Component)this.owner, null, (String[])new String[]{".kmd\tMD" + CubeModelResource.getString(CubeModelResource.class, (String)"CubeModel") + "(*.kmd)"});
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private OutputStream getOutputStream() {
        File file = WindowUtil.chooseSaveFile((Component)this.owner, null, (String[])new String[]{".kmd\tMD" + CubeModelResource.getString(CubeModelResource.class, (String)"CubeModel") + "(*.kmd)"});
        if (file == null) {
            return null;
        }
        try {
            String fileName = file.getAbsolutePath();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".kmd")) {
                file = new File(fileName + ".kmd");
            }
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CubeModel open() throws AnalysisException {
        InputStream in = this.getInputStream();
        if (in == null) {
            return null;
        }
        return CubeModelUtil.loadSchema(in);
    }

    @Override
    public boolean save(CubeModel cubeModel) throws AnalysisException {
        OutputStream out = this.getOutputStream();
        if (out != null) {
            CubeModelUtil.saveSchema(cubeModel, out, "UTF-8");
            return true;
        }
        return false;
    }
}

