/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui;

import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.WizardContext;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.AbstractWizardStep;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Cube_Finish;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.format.FormatEditDialog;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.format.IFormatDataSource;
import com.kingdee.bos.ctrl.analysis.xmlutil.Names;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class Cube_DefineMeasure
extends AbstractWizardStep {
    Table table;
    private KDList listColumns;
    private KDTable tableMeasures;
    private KDLabelContainer contColumns = new KDLabelContainer();
    private KDLabelContainer contMeasures = new KDLabelContainer();
    private KDWorkButton btnSelect;
    private KDWorkButton btnDelete;
    private KDComboBox cbAgg = new KDComboBox();
    private String[] aggTypes = Names.AggTypes.getTypes();
    private String[] aggTypeLabels = Names.AggTypes.getTypeLabels(Locale.getDefault());
    KDPromptBox pbFormat = new KDPromptBox();
    private ActionListener selectAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cube_DefineMeasure.this.doSelect();
        }
    };
    private ActionListener deleteAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cube_DefineMeasure.this.doDelete();
        }
    };
    HashSet selectedColumn = new HashSet();

    public Cube_DefineMeasure(WizardContext context) {
        super(context);
    }

    public IWizardStep outThisStep(boolean isOppose) {
        if (!isOppose) {
            WizardContext.MeasureInfo measureInfo = this.getMeasureResult();
            if (measureInfo == null) {
                return this;
            }
            this.context.put("MeasureInfo", measureInfo);
            if (this.oldNextStep == null) {
                return new Cube_Finish(this.context);
            }
        }
        return null;
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        if (!isOppose && this.table == null) {
            this.table = (Table)this.context.get("FactTable");
            Column[] columns = this.table.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                this.listColumns.addElement((Object)columns[i]);
            }
            WizardContext.MeasureInfo mi = (WizardContext.MeasureInfo)this.context.get("MeasureInfo");
            if (mi != null) {
                HashMap<String, Column> colMap = new HashMap<String, Column>();
                int n = columns.length;
                for (int i = 0; i < n; ++i) {
                    colMap.put(columns[i].getName(), columns[i]);
                }
                WizardContext.AMeasure[] ams = mi.measures;
                List<String> argTypeList = Arrays.asList(this.aggTypes);
                for (WizardContext.AMeasure am : ams) {
                    Column c = (Column)colMap.get(am.column.getName());
                    this.selectedColumn.add(c);
                    IRow row = this.tableMeasures.addRow();
                    row.setHeight(27);
                    row.getCell(0).setValue((Object)am.name);
                    row.getCell(1).setValue((Object)am.alias);
                    row.getCell(2).setValue((Object)c);
                    row.getCell(3).setValue((Object)this.aggTypeLabels[argTypeList.indexOf(am.agg)]);
                    row.getCell(4).setValue((Object)am.format);
                }
                this.tableMeasures.getEditManager().editCellAt(0, 0);
            }
        }
    }

    public WizardContext.MeasureInfo getMeasureResult() {
        int count = this.tableMeasures.getRowCount();
        if (count == 0) {
            this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"MeasureNotNull"));
            return null;
        }
        WizardContext.AMeasure[] ret = new WizardContext.AMeasure[count];
        for (int i = 0; i < count; ++i) {
            IRow row = this.tableMeasures.getRow(i);
            String name = (String)row.getCell(0).getValue();
            if (name == null || name.trim().length() == 0) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"MeasureNameNotNull"));
                return null;
            }
            String alias = (String)row.getCell(1).getValue();
            if (alias == null || alias.trim().length() == 0) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"MeasureAliasNotNull"));
                return null;
            }
            Column column = (Column)row.getCell(2).getValue();
            String agg = (String)row.getCell(3).getValue();
            String format = (String)row.getCell(4).getValue();
            int index = Arrays.asList(this.aggTypeLabels).indexOf(agg);
            agg = this.aggTypes[index];
            ret[i] = new WizardContext.AMeasure(name, alias, column, agg, format);
        }
        return new WizardContext.MeasureInfo(ret);
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        super.initStep(manager);
        this.contColumns.setBoundLabelText(CubeModelResource.getString(CubeModelResource.class, (String)"AvailableColumn"));
        this.contMeasures.setBoundLabelText(CubeModelResource.getString(CubeModelResource.class, (String)"SelectedMeasure"));
        this.contMeasures.setBoundLabelAlignment(8);
        this.contColumns.setBoundLabelAlignment(8);
        this.btnSelect = new KDWorkButton((Icon)Resource.ICON_MOVE_LEFT);
        this.btnDelete = new KDWorkButton((Icon)Resource.ICON_MOVE_RIGHT);
        this.tableMeasures = new KDTable(5, 1, 0);
        this.listColumns = new KDList();
        this.listColumns.setAutoscrolls(true);
        this.tableMeasures.setAutoscrolls(true);
        JScrollPane sp = new JScrollPane((Component)this.listColumns);
        this.contColumns.setBoundEditor((JComponent)sp);
        this.contMeasures.setBoundEditor((JComponent)this.tableMeasures);
        this.contColumns.setMinimumSize(new Dimension(10, 10));
        this.contMeasures.setMinimumSize(new Dimension(10, 10));
        String desc = CubeModelResource.getString(CubeModelResource.class, (String)"DefineMeasureDesc");
        com.kingdee.bos.ctrl.common.layout.table.Table tl = this.layout(CubeModelResource.getString(CubeModelResource.class, (String)"DefineMeasure"), desc).split(1, 3);
        com.kingdee.bos.ctrl.common.layout.table.Table col1 = tl.cell(1).split(6, 1);
        col1.rowStyle(0).setPriY(1);
        col1.rowStyle(3).lockHeight(20);
        col1.rowStyle(5).setPriY(1);
        tl.colStyle(1).lockWidth(40);
        tl.colStyle(1).setMarginLeft(3);
        tl.colStyle(1).setMarginRight(5);
        tl.colStyle(0).setWidth(-30);
        tl.colStyle(2).setWidth(-70);
        this.add((Component)this.contColumns, tl.cell(0, 0));
        this.add((Component)this.btnSelect, col1.cell(2, 0));
        this.add((Component)this.btnDelete, col1.cell(4, 0));
        this.add((Component)this.contMeasures, tl.cell(0, 2));
        IRow headRow = this.tableMeasures.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"MeasureName"));
        headRow.getCell(1).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"MeasureAlias"));
        headRow.getCell(2).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"ColumnName"));
        headRow.getCell(3).setValue((Object)CubeModelResource.getString(CubeModelResource.class, (String)"AggregateFunction"));
        headRow.getCell(4).setValue((Object)"\u663e\u793a\u683c\u5f0f");
        this.tableMeasures.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbAgg));
        this.tableMeasures.getColumn(2).getStyleAttributes().setLocked(true);
        this.tableMeasures.getColumn(0).setWidth(100);
        this.tableMeasures.getColumn(1).setWidth(100);
        this.tableMeasures.getColumn(2).setWidth(100);
        this.tableMeasures.getColumn(3).setWidth(100);
        this.tableMeasures.getColumn(4).setWidth(200);
        this.tableMeasures.getIndexColumn().getStyleAttributes().setHided(true);
        this.cbAgg.addItems((Object[])this.aggTypeLabels);
        this.btnSelect.addActionListener(this.selectAction);
        this.btnDelete.addActionListener(this.deleteAction);
        this.listColumns.setCellRenderer((ListCellRenderer)new DefaultKingdeeListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component cp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                boolean used = Cube_DefineMeasure.this.selectedColumn.contains(value);
                Color c = null;
                c = isSelected ? (used ? Color.GRAY.brighter() : Color.WHITE) : (used ? Color.RED.darker() : Color.BLACK);
                this.setForeground(c);
                return cp;
            }
        });
        FormatEditDialog dlg = new FormatEditDialog((Dialog)manager.getWizardDialog(), new IFormatDataSource(){

            @Override
            public String getFormatString() {
                int row = Cube_DefineMeasure.this.tableMeasures.getSelectManager().get().getTop();
                return String.valueOf(Cube_DefineMeasure.this.tableMeasures.getCell(row, 4).getValue());
            }
        });
        this.tableMeasures.getColumn(4).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.pbFormat));
        this.pbFormat.setSelector((KDPromptSelector)dlg);
        this.pbFormat.setEditable(true);
    }

    private void doSelect() {
        Object[] columns = this.listColumns.getSelectedValues();
        int[] indices = this.listColumns.getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            Column column = (Column)columns[i];
            if (this.selectedColumn.contains(column)) {
                this.alert(column.getName() + CubeModelResource.getString(CubeModelResource.class, (String)"DuplicateColumnSelection"));
                return;
            }
            DataType dataType = column.getDataType();
            if (dataType != DataType.INTEGER && dataType != DataType.DECIMAL) {
                this.alert(column.getName() + CubeModelResource.getString(CubeModelResource.class, (String)"MeasureMustDigital"));
                return;
            }
            this.selectedColumn.add(column);
            IRow row = this.tableMeasures.addRow();
            row.setHeight(27);
            row.getCell(0).setValue((Object)column.toString());
            row.getCell(1).setValue((Object)column.toString());
            row.getCell(2).setValue((Object)column);
            row.getCell(3).setValue((Object)this.aggTypeLabels[0]);
            row.getCell(4).setValue((Object)"#,##0.000");
            this.tableMeasures.getEditManager().editCellAt(row.getRowIndex(), 0);
        }
        this.listColumns.updateUI();
    }

    private void doDelete() {
        if (this.tableMeasures.getSelectManager().get() != null) {
            int index = this.tableMeasures.getSelectManager().get().getTop();
            IRow row = this.tableMeasures.removeRow(index);
            this.selectedColumn.remove(row.getCell(2).getValue());
            this.listColumns.updateUI();
        }
    }
}

