/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.schema;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelException;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Aggregation;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_ChildKey;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Dimension;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Expression;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Fact;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_FactJoinRef;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Hierarchy;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Join;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Level;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Measure;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_MemberAlias;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_MemberKey;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_MemberName;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_ParentKey;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Property;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Rule;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_TableRef;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_MeasureFormat;
import com.kingdee.bos.ctrl.analysis.xmlutil.Names;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLException;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.mdquery.Aggregator;
import com.kingdee.bos.metadata.mdquery.CubeInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceCollection;
import com.kingdee.bos.metadata.mdquery.DataSourceInfo;
import com.kingdee.bos.metadata.mdquery.DataSourceType;
import com.kingdee.bos.metadata.mdquery.DimensionBaseType;
import com.kingdee.bos.metadata.mdquery.DimensionCollection;
import com.kingdee.bos.metadata.mdquery.DimensionInfo;
import com.kingdee.bos.metadata.mdquery.DimensionUsageCollection;
import com.kingdee.bos.metadata.mdquery.DimensionUsageInfo;
import com.kingdee.bos.metadata.mdquery.HierarchyCollection;
import com.kingdee.bos.metadata.mdquery.HierarchyInfo;
import com.kingdee.bos.metadata.mdquery.LevelBaseType;
import com.kingdee.bos.metadata.mdquery.LevelCollection;
import com.kingdee.bos.metadata.mdquery.LevelInfo;
import com.kingdee.bos.metadata.mdquery.MDQueryInfo;
import com.kingdee.bos.metadata.mdquery.MeasureCollection;
import com.kingdee.bos.metadata.mdquery.MeasureInfo;
import com.kingdee.bos.metadata.mdquery.PropertyCollection;
import com.kingdee.bos.metadata.mdquery.PropertyInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimension;
import com.kingdee.bos.olap.def.CubeDimensionDef;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.util.BOSObjectType;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class CubeModelUtil {
    public static final String SAX_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CubeModel loadSchema(InputStream inStream) throws XMLException {
        CubeModel cubeModel;
        try {
            SAXBuilder builder = new SAXBuilder(SAX_PARSER_NAME, false);
            Document doc = builder.build(inStream);
            cubeModel = CubeModelUtil.loadSchema(doc);
        }
        catch (JDOMException e) {
            try {
                throw new CubeModelException(e);
                catch (IOException e2) {
                    throw new CubeModelException("Can't read cube model", e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inStream});
        return cubeModel;
    }

    public static CubeModel loadSchema(Document doc) throws XMLException {
        Element root = doc.getRootElement();
        if (root.getName() == null || !root.getName().equals("CubeModel")) {
            throw new CubeModelException("Illegal cube model schema,root element must be 'CubeModel'");
        }
        return new CubeModel(root);
    }

    public static void saveSchema(CubeModel model, File file, String encoding) throws XMLException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            CubeModelUtil.saveSchema(model, fos, encoding);
        }
        catch (IOException e) {
            try {
                throw new CubeModelException("Can't write cube model", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
    }

    public static void saveSchema(CubeModel model, OutputStream outStream, String encoding) throws XMLException {
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding(encoding);
        XMLOutputter outter = new XMLOutputter(format);
        try {
            outter.output(model.saveXML(), outStream);
        }
        catch (IOException e) {
            try {
                throw new CubeModelException("Can't write cube model.", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{outStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{outStream});
    }

    public static byte[] saveSchema(CubeModel model, String encoding) throws XMLException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(4096);
        CubeModelUtil.saveSchema(model, outStream, encoding);
        return outStream.toByteArray();
    }

    public static SchemaDef convertSchema(CubeModel cubeModel) throws XMLException {
        try {
            SchemaDef schemaDef = new SchemaDef();
            schemaDef.name = "Kingdee OLAP";
            CubeModel_Cube[] cubes = cubeModel.getCubes();
            if (cubes == null) {
                throw new CubeModelException("Illegal cube model schema,no cube is defined.");
            }
            CubeDef[] cubeDefs = new CubeDef[cubes.length];
            schemaDef.cubes = cubeDefs;
            for (int i = 0; i < cubes.length; ++i) {
                cubeDefs[i] = new CubeDef();
                CubeModelUtil.convertCube(cubes[i], schemaDef, cubeDefs[i], true);
            }
            return schemaDef;
        }
        catch (NullPointerException npe) {
            throw new CubeModelException("Illegal cube model schema,please refer the document,\nstrongly recommend you use the designer to generate the cube mode schema.", npe);
        }
    }

    public static SchemaDef convertCube(CubeModel_Cube cube) throws XMLException {
        return CubeModelUtil.convertCube(cube, true);
    }

    public static SchemaDef convertCube(CubeModel_Cube cube, boolean checkDimAndMeasure) throws XMLException {
        try {
            SchemaDef schemaDef = new SchemaDef();
            schemaDef.name = "Kingdee OLAP";
            CubeDef[] cubeDefs = new CubeDef[1];
            schemaDef.cubes = cubeDefs;
            cubeDefs[0] = new CubeDef();
            CubeModelUtil.convertCube(cube, schemaDef, cubeDefs[0], checkDimAndMeasure);
            return schemaDef;
        }
        catch (NullPointerException npe) {
            throw new CubeModelException("Illegal cube model schema,please refer the document,\nstrongly recommend you use the designer to generate the cube mode schema.", npe);
        }
    }

    public static void convertCube(CubeModel_Cube cube, SchemaDef schemaDef, CubeDef cubeDef, boolean checkDimAndMeasure) throws XMLException {
        int count;
        if (cube.getName() == null) {
            throw new CubeModelException("Illegal cube model schema,cube name must not be empty.");
        }
        cubeDef.name = cube.getName();
        cubeDef.caption = cube.getAlias();
        cubeDef.description = cube.getDesc();
        CubeModel_Table[] tables = cube.getTables();
        if (tables == null) {
            throw new CubeModelException("Illegal cube model schema,cube '" + cube.getName() + "' must define table.");
        }
        CubeModel_Fact fact = cube.getFact();
        if (fact == null) {
            throw new CubeModelException("Illegal cube model schema,cube '" + cube.getName() + "' must define fact.");
        }
        CubeModel_Join[] joins = cube.getJoins();
        CubeModel_Dimension[] dims = cube.getDimensions();
        if (checkDimAndMeasure && dims == null) {
            throw new CubeModelException("Illegal cube model schema,cube '" + cube.getName() + "' must have one dimension at least.");
        }
        ArrayList<ParameterDef> list = new ArrayList<ParameterDef>();
        if (schemaDef.parameters != null) {
            list.addAll(Arrays.asList(schemaDef.parameters));
        }
        int count2 = tables.length;
        for (int i = 0; i < count2; ++i) {
            ParameterDef para = new ParameterDef();
            para.type = "Table";
            para.name = CubeModelUtil.tableName(cube, tables[i].getName());
            list.add(para);
        }
        schemaDef.parameters = new ParameterDef[list.size()];
        list.toArray(schemaDef.parameters);
        cubeDef.table = CubeModelUtil.tableName(cube, fact.getTableRef().getName());
        CubeModel_Measure[] measures = fact.getMeasures();
        if (measures == null) {
            if (checkDimAndMeasure) {
                throw new CubeModelException("Illegal cube model schema,cube '" + cube.getName() + "' fact must have one measure at least.");
            }
        } else {
            MeasureDef[] measureDefs = new MeasureDef[measures.length];
            count = measures.length;
            for (int i = 0; i < count; ++i) {
                measureDefs[i] = new MeasureDef();
                measureDefs[i].aggregator = measures[i].getAgg().getFunction();
                measureDefs[i].name = measures[i].getName();
                measureDefs[i].column = measures[i].getExp().getColumns()[0].getName();
                if (measures[i].getFormat() == null) continue;
                measureDefs[i].formatString = measures[i].getFormat().getFormatString();
            }
            cubeDef.measures = measureDefs;
        }
        if (dims != null) {
            ArrayList<SharedDimensionDef> sharedDims = new ArrayList<SharedDimensionDef>(dims.length);
            cubeDef.dimensions = new CubeDimension[dims.length];
            count = dims.length;
            for (int i = 0; i < count; ++i) {
                HierarchyDef hierarchyDef = new HierarchyDef();
                if (dims[i].getFactJoinRef() == null) {
                    CubeDimensionDef cdd = new CubeDimensionDef();
                    cubeDef.dimensions[i] = cdd;
                    cdd.name = dims[i].getName();
                    cdd.caption = dims[i].getAlias();
                    cdd.type = dims[i].getType().equals("time") ? "Time" : "Standard";
                    cdd.hierarchies = new HierarchyDef[]{hierarchyDef};
                } else {
                    SharedDimensionDef sdd = new SharedDimensionDef();
                    sharedDims.add(sdd);
                    CubeModel_Join join = CubeModelUtil.findJoin(joins, dims[i].getFactJoinRef().getName());
                    sdd.primaryKey = join.getLeftColumn();
                    sdd.table = dims[i].getTableRefs()[0].getName();
                    sdd.type = dims[i].getType().equals("time") ? "Time" : "Standard";
                    sdd.name = dims[i].getName();
                    sdd.caption = dims[i].getAlias();
                    sdd.hierarchies = new HierarchyDef[]{hierarchyDef};
                    DimensionUsageDef dud = new DimensionUsageDef();
                    cubeDef.dimensions[i] = dud;
                    dud.name = dims[i].getName();
                    dud.foreignKey = join.getRightColumn();
                }
                CubeModelUtil.convertHierarchy(hierarchyDef, dims[i], schemaDef, cube);
            }
            schemaDef.dimensions = new SharedDimensionDef[sharedDims.size()];
            sharedDims.toArray(schemaDef.dimensions);
        }
    }

    private static void convertHierarchy(HierarchyDef hierarchyDef, CubeModel_Dimension dimension, SchemaDef schemaDef, CubeModel_Cube cube) throws CubeModelException {
        CubeModel_Hierarchy hierarchy = dimension.getHierarchys()[0];
        hierarchyDef.hasAll = hierarchy.isHasAll();
        hierarchyDef.name = hierarchy.getName();
        hierarchyDef.caption = hierarchy.getAlias();
        hierarchyDef.allMemberName = hierarchy.getAllMemberName();
        hierarchyDef.allMemberCaption = hierarchy.getAllMemberCaption();
        if (dimension.isTime()) {
            String hieType = hierarchy.getType();
            String hieTypeLabel = Names.TimeHierarchyTypes.getTypeLabel(Locale.getDefault(), hieType);
            String timeColumnName = dimension.getTimeColumn().getName();
            String[] types = Names.TimeHierarchyTypes.split(hieType);
            String[] typeLabels = Names.TimeHierarchyTypes.split(hieTypeLabel);
            hierarchyDef.levels = new LevelDef[types.length];
            for (int i = 0; i < types.length; ++i) {
                hierarchyDef.levels[i] = new LevelDef();
                hierarchyDef.levels[i].name = types[i];
                hierarchyDef.levels[i].caption = typeLabels[i];
                hierarchyDef.levels[i].column = timeColumnName;
                hierarchyDef.levels[i].type = Names.TimeHierarchyTypes.getTypeForOlap(types[i]);
                hierarchyDef.levels[i].properties = new PropertyDef[0];
            }
        } else if (dimension.isParentChild()) {
            String memberAlias;
            LevelDef levelDef;
            if (!"null".equals(hierarchy.orderMethod) && !"null".equals(hierarchy.orderBy)) {
                hierarchyDef.orderBy = hierarchy.orderBy;
                hierarchyDef.orderMethod = hierarchy.orderMethod;
            }
            String column = hierarchy.memberKey.getExp().getColumns()[0].getName();
            String parentColumn = hierarchy.parentKey.getExp().getColumns()[0].getName();
            hierarchyDef.levels = new LevelDef[1];
            hierarchyDef.levels[0] = levelDef = new LevelDef();
            levelDef.name = hierarchy.getName();
            if (levelDef.name == null) {
                levelDef.name = dimension.getName();
            }
            levelDef.column = column;
            levelDef.parentColumn = parentColumn;
            if (hierarchy.childKey != null) {
                levelDef.childColumn = hierarchy.childKey.getExp().getColumns()[0].getName();
            } else {
                levelDef.rule = hierarchy.rule.getName();
                ArrayList<ParameterDef> list = new ArrayList<ParameterDef>();
                if (schemaDef.parameters != null) {
                    list.addAll(Arrays.asList(schemaDef.parameters));
                }
                ParameterDef para = new ParameterDef();
                para.type = "ParentMemberRule";
                para.name = levelDef.rule;
                list.add(para);
                schemaDef.parameters = new ParameterDef[list.size()];
                list.toArray(schemaDef.parameters);
            }
            ArrayList<PropertyDef> listProp = new ArrayList<PropertyDef>();
            String memberName = column;
            if (hierarchy.memberName != null) {
                memberName = hierarchy.memberName.getExp().getColumns()[0].getName();
                if (!column.equals(memberName)) {
                    PropertyDef prop = new PropertyDef();
                    prop.name = "name";
                    prop.column = memberName;
                    listProp.add(prop);
                } else {
                    memberName = column;
                }
            }
            if (hierarchy.memberAlias != null && !memberName.equals(memberAlias = hierarchy.memberAlias.getExp().getColumns()[0].getName())) {
                PropertyDef prop = new PropertyDef();
                prop.name = "caption";
                prop.column = memberAlias;
                listProp.add(prop);
            }
            if (hierarchy.getProperties() != null) {
                CubeModel_Property[] cps = hierarchy.getProperties();
                for (int j = 0; j < cps.length; ++j) {
                    CubeModel_Property cp = cps[j];
                    PropertyDef prop = new PropertyDef();
                    prop.name = cp.getName();
                    prop.caption = cp.getCaption();
                    prop.description = cp.getDesc();
                    prop.column = cp.getColumn();
                    listProp.add(prop);
                }
            }
            levelDef.properties = new PropertyDef[listProp.size()];
            listProp.toArray(levelDef.properties);
        } else {
            hierarchyDef.levels = new LevelDef[hierarchy.levels.length];
            int count = hierarchy.levels.length;
            for (int i = 0; i < count; ++i) {
                String memberAlias;
                String column;
                LevelDef levelDef;
                hierarchyDef.levels[i] = levelDef = new LevelDef();
                levelDef.name = hierarchy.levels[i].getName();
                levelDef.caption = hierarchy.levels[i].getAlias();
                if (!"null".equals(hierarchy.levels[i].getOrderMethod()) && !"null".equals(hierarchy.levels[i].getOrderBy())) {
                    levelDef.orderBy = hierarchy.levels[i].getOrderBy();
                    levelDef.orderMethod = hierarchy.levels[i].getOrderMethod();
                }
                levelDef.column = column = hierarchy.levels[i].getMemberKey().getExp().getColumns()[0].getName();
                String memberName = column;
                ArrayList<PropertyDef> listProp = new ArrayList<PropertyDef>();
                if (hierarchy.levels[i].getMemberName() != null) {
                    memberName = hierarchy.levels[i].getMemberName().getExp().getColumns()[0].getName();
                    if (!column.equals(memberName)) {
                        PropertyDef prop = new PropertyDef();
                        prop.name = "name";
                        prop.column = memberName;
                        listProp.add(prop);
                    } else {
                        memberName = column;
                    }
                }
                if (hierarchy.levels[i].getMemberAlias() != null && !memberName.equals(memberAlias = hierarchy.levels[i].getMemberAlias().getExp().getColumns()[0].getName())) {
                    PropertyDef prop = new PropertyDef();
                    prop.name = "caption";
                    prop.column = memberAlias;
                    listProp.add(prop);
                }
                if (hierarchy.levels[i].getProperties() != null) {
                    CubeModel_Property[] cps = hierarchy.levels[i].getProperties();
                    for (int j = 0; j < cps.length; ++j) {
                        CubeModel_Property cp = cps[j];
                        PropertyDef prop = new PropertyDef();
                        prop.name = cp.getName();
                        prop.caption = cp.getCaption();
                        prop.description = cp.getDesc();
                        prop.column = cp.getColumn();
                        listProp.add(prop);
                    }
                }
                levelDef.properties = new PropertyDef[listProp.size()];
                listProp.toArray(levelDef.properties);
            }
        }
    }

    public static String tableName(CubeModel_Cube cube, String tablename) {
        return tablename;
    }

    public static String unparse(String tablename) {
        return tablename;
    }

    private static CubeModel_Join findJoin(CubeModel_Join[] joins, String joinname) {
        int count = joins.length;
        for (int i = 0; i < count; ++i) {
            if (!joins[i].getName().equals(joinname)) continue;
            return joins[i];
        }
        return null;
    }

    public static void convertToMDQuery(CubeModel cubeModel, MDQueryInfo mdquery, String metasPath) throws CubeModelException {
        CubeInfo cubeInfo = mdquery.getCube();
        DimensionCollection dimColl = mdquery.getDimensionCollection();
        dimColl.clear();
        DataSourceCollection dsColl = mdquery.getDataSourceCollection();
        dsColl.clear();
        cubeInfo.getMeasureCollection().clear();
        cubeInfo.getDimensionUsageCollection().clear();
        CubeModel_Cube cube = cubeModel.getCubes()[0];
        CubeModel_Table[] tables = cube.tables;
        HashMap<String, DataSourceInfo> tableMap = new HashMap<String, DataSourceInfo>();
        for (int i = 0; i < tables.length; ++i) {
            DataSourceInfo dsInfo = new DataSourceInfo();
            CubeModelUtil.setDSInfo(mdquery, metasPath, dsInfo, tables[i].getName(), tables[i].getAlias());
            tableMap.put(tables[i].getName(), dsInfo);
            dsColl.add(dsInfo);
        }
        CubeModel_Dimension[] dims = cube.dimensions;
        if (dims == null) {
            throw new CubeModelException(cube.getAlias() + CubeModelResource.getString(CubeModelResource.class, (String)"NoDimension"));
        }
        HashMap<String, DimensionInfo> dimMap = new HashMap<String, DimensionInfo>();
        for (int i = 0; i < dims.length; ++i) {
            DimensionInfo dimInfo = new DimensionInfo();
            CubeModelUtil.setDimInfo(mdquery, dimInfo, cube, dims[i], tableMap);
            dimColl.add(dimInfo);
            dimMap.put(dims[i].getName(), dimInfo);
        }
        CubeModelUtil.setCubeInfo(mdquery, cubeInfo, cube, tableMap, dimMap);
    }

    private static void setCubeInfo(MDQueryInfo mdquery, CubeInfo cubeInfo, CubeModel_Cube cube, HashMap tableMap, HashMap dimMap) throws CubeModelException {
        cubeInfo.setName(cube.getName());
        cubeInfo.setAlias(cube.getAlias());
        CubeModel_Fact fact = cube.getFact();
        String tableName = fact.getTableRef().getName();
        cubeInfo.setDataSource((DataSourceInfo)tableMap.get(tableName));
        DimensionUsageCollection duColl = cubeInfo.getDimensionUsageCollection();
        CubeModel_Dimension[] dims = cube.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            DimensionUsageInfo usageInfo = new DimensionUsageInfo();
            CubeModel_Join join = CubeModelUtil.findJoin(cube.joins, dims[i].getFactJoinRef().getName());
            usageInfo.setForeignKey(join.getRightColumn());
            usageInfo.setDimension((DimensionInfo)dimMap.get(dims[i].getName()));
            duColl.add(usageInfo);
        }
        CubeModel_Measure[] measures = fact.getMeasures();
        MeasureCollection measureColl = cubeInfo.getMeasureCollection();
        int count = measures.length;
        for (int i = 0; i < count; ++i) {
            MeasureInfo measureInfo = new MeasureInfo();
            String function = measures[i].getAgg().getFunction();
            if (function.equals("avg")) {
                measureInfo.setAggregator(Aggregator.AVERAGE);
            } else {
                measureInfo.setAggregator(Aggregator.getEnum((String)function));
            }
            OlapRpt_MeasureFormat format = measures[i].getFormat();
            if (format != null) {
                measureInfo.setFormatString(format.getFormatString());
            }
            measureInfo.setName(measures[i].getName());
            measureInfo.setAlias(measures[i].getAlias());
            measureInfo.setColumn(measures[i].getExp().getColumns()[0].getName());
            measureColl.add(measureInfo);
        }
    }

    private static void setDSInfo(MDQueryInfo mdquery, String metasPath, DataSourceInfo dsInfo, String name, String alias) throws CubeModelException {
        block19: {
            IObjectValue bmdObj;
            FullPath fp;
            block18: {
                DataSourceType dsType;
                String pkg = mdquery.getPackage();
                String dsname = "";
                fp = FullPath.parse((String)name);
                String pk = fp.getDots();
                DataDefType ddType = DataDefType.fromName((String)fp.getCategory());
                if (DataDefType.BOS_QUERY == ddType) {
                    dsType = DataSourceType.JOINQUERY;
                } else if (DataDefType.BOS_ENTITY == ddType) {
                    dsType = DataSourceType.ENTITY;
                } else {
                    throw new CubeModelException(fp.getCategory() + CubeModelResource.getString(CubeModelResource.class, (String)"CantConvert") + "BOS Entity" + CubeModelResource.getString(CubeModelResource.class, (String)"Or") + "BOS Query.");
                }
                int index = pk.lastIndexOf(".");
                String shortName = null;
                if (index < 0) {
                    shortName = pk;
                } else {
                    pkg = pk.substring(0, index);
                    shortName = pk.substring(index + 1);
                }
                dsname = dsType.equals((Object)DataSourceType.JOINQUERY) ? pk + ".query" : pk + ".entity";
                dsInfo.setName(dsname);
                dsInfo.setAlias(alias);
                dsInfo.setBaseType(dsType);
                if (metasPath != null) break block18;
                if (dsType.equals((Object)DataSourceType.ENTITY)) {
                    EntityObjectInfo entityInfo = new EntityObjectInfo();
                    entityInfo.setPackage(pkg);
                    entityInfo.setName(shortName);
                    dsInfo.setEntityObject(entityInfo);
                } else {
                    JoinQueryInfo queryInfo = new JoinQueryInfo();
                    queryInfo.setPackage(pkg);
                    queryInfo.setName(shortName);
                    dsInfo.setJoinQueryObject(queryInfo);
                }
                break block19;
            }
            FileInputStream in = null;
            try {
                String metaPath = metasPath + FullPath.dots2path((String)fp.getDots());
                in = new FileInputStream(metaPath + fp.getCategory().replaceFirst("bos-", "."));
                Context ctx = new Context();
                ctx.put((Object)"current_mode", (Object)"DEBUG");
                ctx.put((Object)"METADATAPATH", (Object)metasPath);
                IBOSObject bmdCtrl = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)MetaDataTypeList.BASEQUERY);
                bmdObj = ((AbstractMetaDataCtrl)bmdCtrl).load((InputStream)in);
                bmdObj.setDefaultLocale(ctx.getLocale());
            }
            catch (Exception ex) {
                try {
                    throw new CubeModelException(ex);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
            if (bmdObj instanceof EntityObjectInfo) {
                dsInfo.setBaseType(DataSourceType.ENTITY);
                dsInfo.setEntityObject((EntityObjectInfo)bmdObj);
            } else if (bmdObj instanceof JoinQueryInfo) {
                dsInfo.setBaseType(DataSourceType.JOINQUERY);
                dsInfo.setJoinQueryObject((JoinQueryInfo)bmdObj);
            } else if (bmdObj instanceof UnionQueryInfo) {
                dsInfo.setBaseType(DataSourceType.UNIONQUERY);
                dsInfo.setUnionQueryObject((UnionQueryInfo)bmdObj);
            } else {
                throw new CubeModelException("Unsupport bos type:" + bmdObj.getClass().getName());
            }
        }
    }

    private static void setDimInfo(MDQueryInfo mdquery, DimensionInfo dimInfo, CubeModel_Cube cube, CubeModel_Dimension dim, HashMap tableMap) throws CubeModelException {
        String type = dim.getType();
        DimensionBaseType dimType = type.equals("time") ? DimensionBaseType.TIME : DimensionBaseType.STANDARD;
        dimInfo.setBaseType(dimType);
        dimInfo.setName(dim.getName());
        dimInfo.setAlias(dim.getAlias());
        String tableName = dim.getTableRefs()[0].getName();
        dimInfo.setDataSourceInfo((DataSourceInfo)tableMap.get(tableName));
        CubeModel_Join join = CubeModelUtil.findJoin(cube.joins, dim.getFactJoinRef().getName());
        dimInfo.setPrimaryKey(join.getLeftColumn());
        HierarchyCollection hieColl = dimInfo.getHierarchyCollection();
        CubeModel_Hierarchy[] hies = dim.getHierarchys();
        for (int i = 0; i < hies.length; ++i) {
            HierarchyInfo hieInfo = new HierarchyInfo();
            CubeModelUtil.setHierarchyInfo(mdquery, hieInfo, dim, hies[i], cube);
            hieColl.add(hieInfo);
        }
    }

    private static void setHierarchyInfo(MDQueryInfo mdquery, HierarchyInfo hieInfo, CubeModel_Dimension dim, CubeModel_Hierarchy hie, CubeModel_Cube cube) throws CubeModelException {
        hieInfo.setName(hie.getName());
        hieInfo.setAlias(hie.getAlias());
        hieInfo.setHasAll(hie.isHasAll());
        String allMember = (hie.getAllMemberName() == null ? "" : hie.getAllMemberName()) + "||" + (hie.getAllMemberCaption() == null ? "" : hie.getAllMemberCaption());
        hieInfo.setAllMemberName(allMember);
        LevelCollection levelColl = hieInfo.getLevelCollection();
        if (dim.isTime()) {
            String hieType = hie.getType();
            String hieTypeLabel = Names.TimeHierarchyTypes.getTypeLabel(Locale.getDefault(), hieType);
            String timeColumnName = dim.getTimeColumn().getName();
            String[] types = Names.TimeHierarchyTypes.split(hieType);
            String[] typeLabels = Names.TimeHierarchyTypes.split(hieTypeLabel);
            for (int i = 0; i < types.length; ++i) {
                LevelInfo levelInfo = new LevelInfo();
                levelInfo.setName(types[i]);
                levelInfo.setAlias(typeLabels[i]);
                levelInfo.setColumn(timeColumnName);
                levelInfo.setBaseType(LevelBaseType.getEnum((String)Names.TimeHierarchyTypes.getTypeForOlap(types[i])));
                levelColl.add(levelInfo);
            }
        } else if (dim.isParentChild()) {
            CubeModel_Property[] cps;
            String column = hie.memberKey.getExp().getColumns()[0].getName();
            String memberName = hie.memberName.getExp().getColumns()[0].getName();
            String memberAlias = hie.memberAlias.getExp().getColumns()[0].getName();
            String parentColumn = hie.parentKey.getExp().getColumns()[0].getName();
            String childColumn = null;
            String rule = null;
            if (hie.childKey != null) {
                childColumn = hie.childKey.getExp().getColumns()[0].getName();
            } else if (hie.rule != null) {
                rule = hie.rule.getName();
            } else {
                throw new RuntimeException("impossible.");
            }
            LevelInfo levelInfo = new LevelInfo();
            levelInfo.setName(hie.getName() == null ? dim.getName() : hie.getName());
            levelInfo.setColumn(column);
            levelInfo.setParentColumn(parentColumn);
            if (hie.getOrderBy() != null && hie.getOrderMethod() != null) {
                levelInfo.setOrderBy(hie.getOrderBy() + "||" + hie.getOrderMethod());
            }
            if (rule != null) {
                levelInfo.setString("rule", rule);
            }
            PropertyCollection propColl = levelInfo.getPropertyCollection();
            PropertyInfo propInfo = new PropertyInfo();
            propInfo.setName("name");
            propInfo.setColumnName(memberName);
            propColl.add(propInfo);
            propInfo = new PropertyInfo();
            propInfo.setName("caption");
            propInfo.setColumnName(memberAlias);
            propColl.add(propInfo);
            if (childColumn != null) {
                propInfo = new PropertyInfo();
                propInfo.setName("childColumn");
                propInfo.setColumnName(childColumn);
                propColl.add(propInfo);
            }
            if ((cps = hie.getProperties()) != null) {
                for (int j = 0; j < cps.length; ++j) {
                    propInfo = new PropertyInfo();
                    propInfo.setName(cps[j].getName());
                    propInfo.setColumnName(cps[j].getColumn());
                    propInfo.setAlias(cps[j].getAlias());
                    propColl.add(propInfo);
                }
            }
            levelColl.add(levelInfo);
        } else {
            int count = hie.levels.length;
            for (int i = 0; i < count; ++i) {
                LevelInfo levelInfo = new LevelInfo();
                levelInfo.setName(hie.levels[i].getName());
                levelInfo.setAlias(hie.levels[i].getAlias());
                levelInfo.setColumn(hie.levels[i].getMemberKey().getExp().getColumns()[0].getName());
                if (hie.levels[i].getOrderBy() != null && hie.levels[i].getOrderMethod() != null) {
                    levelInfo.setOrderBy(hie.levels[i].getOrderBy() + "||" + hie.levels[i].getOrderMethod());
                }
                String memberAlias = hie.levels[i].getMemberAlias().getExp().getColumns()[0].getName();
                String memberName = hie.levels[i].getMemberName().getExp().getColumns()[0].getName();
                PropertyCollection propColl = levelInfo.getPropertyCollection();
                PropertyInfo propInfo = new PropertyInfo();
                propInfo.setName("name");
                propInfo.setColumnName(memberName);
                propColl.add(propInfo);
                propInfo = new PropertyInfo();
                propInfo.setName("caption");
                propInfo.setColumnName(memberAlias);
                propColl.add(propInfo);
                CubeModel_Property[] cps = hie.levels[i].getProperties();
                if (cps != null) {
                    for (int j = 0; j < cps.length; ++j) {
                        propInfo = new PropertyInfo();
                        propInfo.setName(cps[j].getName());
                        propInfo.setColumnName(cps[j].getColumn());
                        propInfo.setAlias(cps[j].getAlias());
                        propColl.add(propInfo);
                    }
                }
                levelColl.add(levelInfo);
            }
        }
    }

    public static CubeModel convertFromMDQuery(MDQueryInfo mdquery) throws CubeModelException {
        CubeModel_Table table;
        DataSourceInfo dsInfo;
        CubeModel cm = new CubeModel();
        CubeInfo cubeInfo = mdquery.getCube();
        DataSourceCollection dsColl = mdquery.getDataSourceCollection();
        CubeModel_Cube cube = new CubeModel_Cube();
        cm.setCubes(new CubeModel_Cube[]{cube});
        cube.setName(cubeInfo.getName());
        cube.setAlias(cubeInfo.getAlias());
        CubeModel_Table[] tables = new CubeModel_Table[dsColl.size()];
        cube.setTables(tables);
        HashMap<DataSourceInfo, CubeModel_Table> ds2table = new HashMap<DataSourceInfo, CubeModel_Table>(tables.length);
        for (int i = 0; i < dsColl.size(); ++i) {
            FullPath fp;
            String pk;
            tables[i] = new CubeModel_Table();
            dsInfo = dsColl.get(i);
            ds2table.put(dsInfo, tables[i]);
            DataSourceType type = dsInfo.getBaseType();
            tables[i].setAlias(dsInfo.getAlias());
            if (type.equals((Object)DataSourceType.ENTITY)) {
                EntityObjectInfo entity = dsInfo.getEntityObject();
                pk = entity.getPackage() + "." + entity.getName();
                fp = new FullPath();
                fp.setDots(pk, DataDefType.BOS_ENTITY.getName());
                tables[i].setName(fp.getText());
                if (dsInfo.getAlias() != null) continue;
                tables[i].setAlias(entity.getName());
                continue;
            }
            Object query = null;
            query = type.equals((Object)DataSourceType.JOINQUERY) ? dsInfo.getJoinQueryObject() : dsInfo.getUnionQueryObject();
            pk = query.getPackage() + "." + query.getName();
            fp = new FullPath();
            fp.setDots(pk, DataDefType.BOS_QUERY.getName());
            tables[i].setName(fp.getText());
            if (dsInfo.getAlias() != null) continue;
            tables[i].setAlias(query.getName());
        }
        CubeModel_Fact fact = new CubeModel_Fact();
        cube.setFact(fact);
        fact.setName(cube.getName());
        dsInfo = cubeInfo.getDataSource();
        CubeModel_Table factTable = table = (CubeModel_Table)ds2table.get(dsInfo);
        CubeModel_TableRef tableRef = new CubeModel_TableRef();
        tableRef.setName(table.getName());
        fact.setTableRef(tableRef);
        MeasureCollection measureColl = cubeInfo.getMeasureCollection();
        CubeModel_Measure[] measures = new CubeModel_Measure[measureColl.size()];
        fact.setMeasures(measures);
        for (int i = 0; i < measures.length; ++i) {
            measures[i] = new CubeModel_Measure();
            MeasureInfo measureInfo = measureColl.get(i);
            measures[i].setName(measureInfo.getName());
            measures[i].setAlias(measureInfo.getAlias());
            CubeModel_Expression exp = new CubeModel_Expression();
            measures[i].setExp(exp);
            CubeModel_Column column = new CubeModel_Column();
            exp.setColumns(new CubeModel_Column[]{column});
            column.setName(measureInfo.getColumn());
            column.setTable(table.getName());
            column.setAlias(table.getAlias() + "." + column.getName());
            CubeModel_Aggregation aggregation = new CubeModel_Aggregation();
            measures[i].setAgg(aggregation);
            Aggregator agg = measureInfo.getAggregator();
            if (agg.equals((Object)Aggregator.AVERAGE)) {
                aggregation.setFunction("avg");
            } else {
                aggregation.setFunction(agg.getName());
            }
            String formatString = measureInfo.getFormatString();
            if (formatString == null) continue;
            OlapRpt_MeasureFormat format = new OlapRpt_MeasureFormat();
            format.setFormatString(formatString);
            measures[i].setFormat(format);
        }
        DimensionUsageCollection duColl = cubeInfo.getDimensionUsageCollection();
        CubeModel_Dimension[] dims = new CubeModel_Dimension[duColl.size()];
        CubeModel_Join[] joins = new CubeModel_Join[duColl.size()];
        cube.setDimensions(dims);
        cube.setJoins(joins);
        for (int i = 0; i < duColl.size(); ++i) {
            DimensionUsageInfo duInfo = duColl.get(i);
            DimensionInfo dimInfo = duInfo.getDimension();
            dims[i] = new CubeModel_Dimension();
            dims[i].setName(dimInfo.getName());
            dims[i].setAlias(dimInfo.getAlias());
            DimensionBaseType type = dimInfo.getBaseType();
            if (DimensionBaseType.TIME.equals((Object)type)) {
                dims[i].setType("time");
            } else {
                dims[i].setType("standard");
            }
            dsInfo = dimInfo.getDataSourceInfo();
            table = (CubeModel_Table)ds2table.get(dsInfo);
            tableRef = new CubeModel_TableRef();
            tableRef.setName(table.getName());
            dims[i].setTableRefs(new CubeModel_TableRef[]{tableRef});
            String forkey = duInfo.getForeignKey();
            String prikey = dimInfo.getPrimaryKey();
            joins[i] = new CubeModel_Join(table, factTable, prikey, forkey);
            CubeModel_FactJoinRef joinRef = new CubeModel_FactJoinRef();
            joinRef.setName(joins[i].getName());
            dims[i].setFactJoinRef(joinRef);
            HierarchyCollection hieColl = dimInfo.getHierarchyCollection();
            CubeModel_Hierarchy[] hies = new CubeModel_Hierarchy[hieColl.size()];
            dims[i].setHierarchys(hies);
            for (int ii = 0; ii < hieColl.size(); ++ii) {
                String[] allMembers;
                HierarchyInfo hieInfo = hieColl.get(ii);
                hies[ii] = new CubeModel_Hierarchy();
                hies[ii].setName(hieInfo.getName());
                hies[ii].setAlias(hieInfo.getAlias());
                hies[ii].setHasAll(hieInfo.getHasAll());
                String am = hieInfo.getAllMemberName();
                if (am != null && am.length() > 0 && (allMembers = am.split("\\|\\|")).length == 2) {
                    hies[ii].setAllMemberName(allMembers[0]);
                    hies[ii].setAllMemberCaption(allMembers[1]);
                }
                LevelCollection levelColl = hieInfo.getLevelCollection();
                LevelInfo levelInfo = levelColl.get(0);
                if (levelColl.size() == 1 && levelInfo.getParentColumn() != null) {
                    dims[i].setType("parent/child");
                    CubeModel_MemberKey memberKey = new CubeModel_MemberKey();
                    CubeModel_Expression exp = new CubeModel_Expression();
                    memberKey.setExp(exp);
                    CubeModel_Column column = new CubeModel_Column();
                    exp.setColumns(new CubeModel_Column[]{column});
                    column.setName(levelInfo.getColumn());
                    column.setTable(table.getName());
                    column.setAlias(table.getAlias() + "." + levelInfo.getColumn());
                    hies[ii].setMemberKey(memberKey);
                    String order = levelInfo.getOrderBy();
                    if (order != null && order.length() > 0) {
                        String[] os = order.split("\\|\\|");
                        hies[ii].setOrderBy(os[0]);
                        hies[ii].setOrderMethod(os[1]);
                    }
                    PropertyCollection propColl = levelInfo.getPropertyCollection();
                    PropertyInfo propName = null;
                    PropertyInfo propAlias = null;
                    PropertyInfo childColumn = null;
                    for (int m = 0; m < propColl.size(); ++m) {
                        PropertyInfo propInfo = propColl.get(m);
                        if (propInfo.getName().equals("name")) {
                            propName = propInfo;
                            continue;
                        }
                        if (propInfo.getName().equals("caption")) {
                            propAlias = propInfo;
                            continue;
                        }
                        if (propInfo.getName().equals("childColumn")) {
                            childColumn = propInfo;
                            continue;
                        }
                        CubeModel_Property cp = new CubeModel_Property();
                        cp.setName(propInfo.getName());
                        cp.setAlias(propInfo.getAlias());
                        cp.setColumn(propInfo.getColumnName());
                        hies[ii].addProperty(cp);
                    }
                    if (childColumn != null) {
                        CubeModel_ChildKey childKey = new CubeModel_ChildKey();
                        exp = new CubeModel_Expression();
                        childKey.setExp(exp);
                        column = new CubeModel_Column();
                        exp.setColumns(new CubeModel_Column[]{column});
                        column.setName(childColumn.getColumnName());
                        column.setTable(table.getName());
                        column.setAlias(table.getAlias() + "." + column.getName());
                        hies[ii].setChildKey(childKey);
                    }
                    if (propName != null) {
                        CubeModel_MemberName memberName = new CubeModel_MemberName();
                        exp = new CubeModel_Expression();
                        memberName.setExp(exp);
                        column = new CubeModel_Column();
                        exp.setColumns(new CubeModel_Column[]{column});
                        column.setName(propName.getColumnName());
                        column.setTable(table.getName());
                        column.setAlias(table.getAlias() + "." + column.getName());
                        hies[ii].setMemberName(memberName);
                    }
                    if (propAlias != null) {
                        CubeModel_MemberAlias memberAlias = new CubeModel_MemberAlias();
                        exp = new CubeModel_Expression();
                        memberAlias.setExp(exp);
                        column = new CubeModel_Column();
                        exp.setColumns(new CubeModel_Column[]{column});
                        column.setName(propAlias.getColumnName());
                        column.setTable(table.getName());
                        column.setAlias(table.getAlias() + "." + column.getName());
                        hies[ii].setMemberAlias(memberAlias);
                    }
                    CubeModel_ParentKey parentKey = new CubeModel_ParentKey();
                    exp = new CubeModel_Expression();
                    parentKey.setExp(exp);
                    column = new CubeModel_Column();
                    exp.setColumns(new CubeModel_Column[]{column});
                    column.setName(levelInfo.getParentColumn());
                    column.setTable(table.getName());
                    column.setAlias(table.getAlias() + "." + column.getName());
                    hies[ii].setParentKey(parentKey);
                    String rule = null;
                    rule = levelInfo.getString("rule");
                    if (rule == null) continue;
                    CubeModel_Rule pmrule = new CubeModel_Rule();
                    pmrule.setName(rule);
                    hies[ii].setRule(pmrule);
                    continue;
                }
                if (DimensionBaseType.TIME.equals((Object)type)) {
                    CubeModel_Column column = new CubeModel_Column();
                    dims[i].setTimeColumn(column);
                    String[] types = new String[levelColl.size()];
                    for (int iii = 0; iii < levelColl.size(); ++iii) {
                        levelInfo = levelColl.get(iii);
                        if (iii == 0) {
                            column.setName(levelInfo.getColumn());
                            column.setTable(table.getName());
                            column.setAlias(table.getAlias() + "." + column.getName());
                        }
                        types[iii] = Names.TimeHierarchyTypes.unparseTypeFromOlap(levelInfo.getBaseType().getName());
                    }
                    hies[ii].setType(Names.TimeHierarchyTypes.unsplit(types));
                    continue;
                }
                CubeModel_Level[] levels = new CubeModel_Level[levelColl.size()];
                for (int iii = 0; iii < levelColl.size(); ++iii) {
                    levelInfo = levelColl.get(iii);
                    levels[iii] = new CubeModel_Level();
                    hies[ii].setLevels(levels);
                    levels[iii].setName(levelInfo.getName());
                    levels[iii].setAlias(levelInfo.getAlias());
                    String order = levelInfo.getOrderBy();
                    if (order != null && order.length() > 0) {
                        String[] os = order.split("\\|\\|");
                        levels[iii].setOrderBy(os[0]);
                        levels[iii].setOrderMethod(os[1]);
                    }
                    CubeModel_MemberKey memberKey = new CubeModel_MemberKey();
                    CubeModel_Expression exp = new CubeModel_Expression();
                    memberKey.setExp(exp);
                    CubeModel_Column column = new CubeModel_Column();
                    exp.setColumns(new CubeModel_Column[]{column});
                    column.setName(levelInfo.getColumn());
                    column.setTable(table.getName());
                    column.setAlias(table.getAlias() + "." + levelInfo.getColumn());
                    PropertyCollection propColl = levelInfo.getPropertyCollection();
                    for (int k = 0; k < propColl.size(); ++k) {
                        PropertyInfo propInfo = propColl.get(k);
                        if (propInfo.getName().equals("name")) {
                            CubeModel_MemberName memberName = new CubeModel_MemberName();
                            exp = new CubeModel_Expression();
                            memberName.setExp(exp);
                            column = new CubeModel_Column();
                            exp.setColumns(new CubeModel_Column[]{column});
                            column.setName(propInfo.getColumnName());
                            column.setTable(table.getName());
                            column.setAlias(table.getAlias() + "." + column.getName());
                            levels[iii].setMemberName(memberName);
                            continue;
                        }
                        if (propInfo.getName().equals("caption")) {
                            CubeModel_MemberAlias memberAlias = new CubeModel_MemberAlias();
                            exp = new CubeModel_Expression();
                            memberAlias.setExp(exp);
                            column = new CubeModel_Column();
                            exp.setColumns(new CubeModel_Column[]{column});
                            column.setName(propInfo.getColumnName());
                            column.setTable(table.getName());
                            column.setAlias(table.getAlias() + "." + column.getName());
                            levels[iii].setMemberAlias(memberAlias);
                            continue;
                        }
                        CubeModel_Property cp = new CubeModel_Property();
                        cp.setName(propInfo.getName());
                        cp.setAlias(propInfo.getAlias());
                        cp.setColumn(propInfo.getColumnName());
                        levels[iii].addProperty(cp);
                    }
                    levels[iii].setMemberKey(memberKey);
                }
            }
        }
        return cm;
    }
}

