/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.mdxw.panelet;

import com.kingdee.bos.ctrl.analysis.mdxw.MdxwContext;
import com.kingdee.bos.ctrl.analysis.mdxw.panelet.MdxItem;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Driver;
import com.kingdee.bos.olap.mem.OLAPDatabase;
import com.kingdee.bos.olap.mem.OLAPEngine;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

final class ProjectModel {
    public static final int SCHEMA_TYPE_DEF = 0;
    public static final int SCHEMA_TYPE_CUBE = 1;
    public static final String SCHEMA_TYPE_DEF_LABEL = "def";
    public static final String SCHEMA_TYPE_CUBE_LABEL = "cube";
    private String projectFile;
    private String name;
    private String comment;
    private String schema_file;
    private String schema_type_label;
    private int schema_type_value;
    private List mdxList;
    private transient OLAPDatabase db;
    private transient Document pmDoc;
    private Connection con = null;

    private ProjectModel() {
    }

    ProjectModel(String projectFile) throws Exception {
        this.projectFile = projectFile;
        this.reloadModel();
    }

    public static ProjectModel createProjectModel(String name, String file) throws Exception {
        Document doc;
        ProjectModel pm = new ProjectModel();
        String f = file.replace('\\', '/');
        int pos1 = f.lastIndexOf(47);
        int pos2 = f.lastIndexOf(46);
        pos1 = pos1 == -1 ? 0 : ++pos1;
        if (pos2 == -1) {
            pos2 = f.length();
            pm.schema_type_value = 1;
            pm.schema_type_label = SCHEMA_TYPE_CUBE_LABEL;
        } else {
            String ext = f.substring(pos2 + 1);
            if (MdxwContext.FILE_EXT_CUBE.equalsIgnoreCase(ext)) {
                pm.schema_type_value = 1;
                pm.schema_type_label = SCHEMA_TYPE_CUBE_LABEL;
            } else {
                pm.schema_type_value = 0;
                pm.schema_type_label = SCHEMA_TYPE_DEF_LABEL;
            }
        }
        pm.projectFile = f.substring(0, pos1) + name + "." + MdxwContext.FILE_EXT_PROJECT;
        if (new File(FilenameUtils.normalize((String)pm.projectFile)).exists()) {
            throw new Exception("\u65b9\u6848" + name + "\u5df2\u5b58\u5728\uff0c\u8bf7\u53e6\u53d6\u65b9\u6848\u540d\u79f0\u3002\r\n" + pm.projectFile);
        }
        pm.name = name;
        pm.mdxList = new ArrayList();
        pm.pmDoc = doc = new Document();
        Element root = new Element("mdxw-project");
        doc.setRootElement(root);
        root.addContent((Content)new Element("name").setText(name));
        root.addContent((Content)new Element("comment"));
        root.addContent((Content)new Element("schema").setAttribute("file", f.substring(pos1)).setAttribute("type", pm.schema_type_label));
        root.addContent((Content)new Element("mdx"));
        pm.save();
        pm.reloadModel();
        return pm;
    }

    public void reloadModel() throws Exception {
        FileInputStream is = new FileInputStream(this.projectFile);
        Document doc = new SAXBuilder().build((InputStream)is);
        is.close();
        Element root = doc.getRootElement();
        this.name = root.getChild("name").getText();
        this.comment = root.getChild("comment").getText();
        Element e = root.getChild("schema");
        this.schema_file = e.getAttributeValue("file");
        if (this.schema_file.indexOf(58) == -1) {
            this.schema_file = new File(FilenameUtils.normalize((String)this.projectFile)).getParentFile().getAbsolutePath() + '\\' + this.schema_file;
        }
        this.schema_type_label = e.getAttributeValue("type");
        if (SCHEMA_TYPE_DEF_LABEL.equals(this.schema_type_label)) {
            this.schema_type_value = 0;
        } else if (SCHEMA_TYPE_CUBE_LABEL.equals(this.schema_type_label)) {
            this.schema_type_value = 1;
        } else {
            throw new RuntimeException("unknow schema type");
        }
        List eList = root.getChild("mdx").getChildren("item");
        this.mdxList = new ArrayList(eList.size());
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            e = (Element)eList.get(i);
            MdxItem item = this.loadMdxItem(e);
            this.mdxList.add(item);
        }
        this.db = null;
        this.pmDoc = doc;
    }

    private MdxItem loadMdxItem(Element e) {
        MdxItem item = new MdxItem();
        item.name = e.getAttributeValue("name");
        item.value = e.getText().trim();
        List children = e.getChildren("item");
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            item.addChild(this.loadMdxItem((Element)children.get(i)));
        }
        return item;
    }

    private boolean useRolap() {
        return true;
    }

    private void buildDatabase() throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.schema_file);
            Document doc = new SAXBuilder().build((InputStream)fis);
            this.db = OLAPEngine.build((Document)doc, new HashMap());
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws Exception {
        if (this.con == null) {
            ObjectInputStream ois;
            FileInputStream fis;
            block6: {
                fis = null;
                ois = null;
                try {
                    fis = new FileInputStream(this.schema_file);
                    if (this.schema_type_value == 0) {
                        if (!this.useRolap()) {
                            Document doc = new SAXBuilder().build((InputStream)fis);
                            this.db = OLAPEngine.build((Document)doc, new HashMap());
                            this.con = Driver.openConnection((OLAPDatabase)this.db);
                        } else {
                            this.con = Driver.openRolapConnection((InputStream)fis, null);
                        }
                        break block6;
                    }
                    ois = new ObjectInputStream(fis);
                    this.db = OLAPDatabase.restore((ObjectInputStream)ois);
                    this.con = Driver.openConnection((OLAPDatabase)this.db);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fis, ois});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis, ois});
        }
        return this.con;
    }

    public void save() throws Exception {
        Element e = this.pmDoc.getRootElement().getChild("mdx");
        List children = e.getChildren();
        children.clear();
        int n = this.mdxList.size();
        for (int i = 0; i < n; ++i) {
            children.add(this.buildElementTree((MdxItem)this.mdxList.get(i)));
        }
        FileOutputStream os = new FileOutputStream(this.projectFile);
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("GBK");
        XMLOutputter xo = new XMLOutputter(format);
        xo.output(this.pmDoc, (OutputStream)os);
        ((OutputStream)os).close();
    }

    private Element buildElementTree(MdxItem item) {
        Element e = new Element("item");
        e.setAttribute("name", item.name);
        if (item.isLeaf()) {
            e.setText(item.value);
        }
        int n = item.getChildCount();
        for (int i = 0; i < n; ++i) {
            e.getChildren().add(this.buildElementTree(item.getChild(i)));
        }
        return e;
    }

    public Cube getCube() throws Exception {
        return this.getConnection().getSchemaReader().getCubes()[0];
    }

    public String toString() {
        return this.name;
    }

    public void storeCube(ObjectOutputStream out) throws Exception {
        if (this.db == null) {
            this.buildDatabase();
        }
        this.db.store(out);
    }

    public String getComment() {
        return this.comment;
    }

    public List getMdxList() {
        return this.mdxList;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public String getSchema_file() {
        return this.schema_file;
    }

    public String getSchema_type_label() {
        return this.schema_type_label;
    }

    public int getSchema_type_value() {
        return this.schema_type_value;
    }
}

