/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.modelcore;

import com.kingdee.bos.ctrl.analysis.modelcore.Extension;
import com.kingdee.bos.ctrl.analysis.modelcore.Model;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ModelSupport
implements Model {
    private Collection listeners = new ArrayList();
    private Map extensionMap = new HashMap();
    private Locale locale;
    private Model decoratedModel = this;
    private boolean enableModelChangedEvent = true;

    public void destroy() {
        this.listeners.clear();
        this.extensionMap.clear();
        this.locale = null;
        this.decoratedModel = null;
    }

    @Override
    public Extension getExtension(String id) {
        return (Extension)this.extensionMap.get(id);
    }

    @Override
    public Map getExtensions() {
        return this.extensionMap;
    }

    @Override
    public void addExtension(Extension extension) {
        this.extensionMap.put(extension.getId(), extension);
        extension.setModel(this);
        this.decoratedModel = extension.decorate(this.decoratedModel);
    }

    @Override
    public Object getBookmarkState(int levelOfDetail) {
        return null;
    }

    @Override
    public void setBookmarkState(Object state) {
    }

    @Override
    public void addModelChangeListener(ModelChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeModelChangeListener(ModelChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void enableModelChangedEvent() {
        this.enableModelChangedEvent = true;
    }

    @Override
    public void disableModelChangedEvent() {
        this.enableModelChangedEvent = false;
    }

    public void fireModelChanged() {
        if (this.enableModelChangedEvent) {
            this.fireModelChanged(new ModelChangeEvent(this));
        }
    }

    @Override
    public void postModelChanged() {
        this.enableModelChangedEvent();
        this.fireModelChanged();
    }

    private void fireModelChanged(ModelChangeEvent e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ModelChangeListener)it.next()).modelChanged(e);
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Model getTopDecorator() {
        return this.decoratedModel;
    }
}

