/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap.querymanage;

import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisUtil;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.TreeNode;
import com.kingdee.bos.olap.mdx.Exp;
import java.util.ArrayList;
import java.util.List;

public class ExpGenerator {
    TreeNode rootNode = null;
    int dimCount;
    Hierarchy[] hiers;
    QueryAxisUtil util;

    public ExpGenerator(QueryAxisUtil util) {
        this.util = util;
    }

    public void init(TreeNode rootNode, Hierarchy[] hiers) {
        this.rootNode = rootNode;
        this.hiers = hiers;
        this.dimCount = hiers.length;
    }

    public Exp genExp() {
        Exp exp = null;
        List nodes = new ArrayList();
        if (this.rootNode != null) {
            nodes = this.rootNode.getChildren();
        }
        ArrayList<Exp> openSet = new ArrayList<Exp>();
        for (TreeNode node : nodes) {
            Exp expForNode = null;
            expForNode = this.genExpForNode(node, this.dimCount);
            if (expForNode == null) {
                expForNode = node.getReference();
            }
            if (expForNode == null) {
                return null;
            }
            boolean closeOpenSet = false;
            if (this.dimCount == 1) {
                if (this.util.isMember(expForNode)) {
                    openSet.add(expForNode);
                    continue;
                }
                closeOpenSet = true;
            } else {
                if (this.util.isFunCallTo(expForNode, "()")) {
                    openSet.add(expForNode);
                    continue;
                }
                closeOpenSet = true;
            }
            if (closeOpenSet && openSet.size() > 0) {
                Exp[] expArray = openSet.toArray(new Exp[0]);
                Exp set = this.util.createFunCall("{}", expArray, 2);
                exp = exp == null ? set : this.util.createFunCall("Union", new Exp[]{exp, set}, 0);
                openSet.clear();
            }
            if (exp == null) {
                exp = expForNode;
                continue;
            }
            exp = this.util.createFunCall("Union", new Exp[]{exp, expForNode}, 0);
        }
        if (openSet.size() > 0) {
            Exp[] expArray = openSet.toArray(new Exp[0]);
            Exp set = this.util.createFunCall("{}", expArray, 2);
            exp = exp == null ? set : this.util.createFunCall("Union", new Exp[]{exp, set}, 0);
            openSet.clear();
        }
        return exp;
    }

    private Exp genExpForNode(TreeNode node, int untilIndex) {
        Exp eNode = node.getReference();
        if (node.getLevel() == untilIndex) {
            return eNode;
        }
        Exp[] tuple = this.genTuple(node);
        if (tuple != null) {
            if (tuple.length == 1) {
                return tuple[0];
            }
            return this.util.createFunCall("()", tuple, 3);
        }
        Exp eSet = !this.util.isMember(eNode) ? eNode : this.util.createFunCall("{}", new Exp[]{eNode}, 2);
        Exp childSet = null;
        List childNodes = node.getChildren();
        for (TreeNode childNode : childNodes) {
            Exp childExp = this.genExpForNode(childNode, untilIndex);
            if (this.util.isMember(childExp) || this.util.isFunCallTo(childExp, "()")) {
                childExp = this.util.createFunCall("{}", new Exp[]{childExp}, 2);
            }
            if (childSet == null) {
                childSet = childExp;
                continue;
            }
            if (this.util.isFunCallTo(childSet, "Union") || this.util.isFunCallTo(childSet, "{}")) {
                ArrayList<Exp> args = new ArrayList<Exp>(3);
                for (int i = 0; i < this.util.funCallArgCount(childSet); ++i) {
                    args.add(this.util.funCallArg(childSet, i));
                }
                args.add(childExp);
                childSet = this.util.createFunCall("{}", args.toArray(new Exp[args.size()]), 2);
                continue;
            }
            childSet = this.util.createFunCall("{}", new Exp[]{childSet, childExp}, 2);
        }
        Exp o = this.util.createFunCall("CrossJoin", new Exp[]{eSet, childSet}, 0);
        return o;
    }

    private Exp[] genTuple(TreeNode node) {
        if (!this.util.isMember(node.getReference())) {
            return null;
        }
        int size = this.dimCount - node.getLevel() + 1;
        if (size == 1) {
            return new Exp[]{node.getReference()};
        }
        List childNodes = node.getChildren();
        if (childNodes.size() != 1) {
            return null;
        }
        Exp[] nextTuple = this.genTuple((TreeNode)childNodes.get(0));
        if (nextTuple == null) {
            return null;
        }
        Exp[] tupleMembers = new Exp[size];
        tupleMembers[0] = node.getReference();
        for (int i = 1; i < tupleMembers.length; ++i) {
            tupleMembers[i] = nextTuple[i - 1];
        }
        return tupleMembers;
    }
}

