/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap.querymanage;

import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.base.SetBase;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.ExpGenerator;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisUtil;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.TreeNode;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.TreeNodeCallback;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.util.IntHolder;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryAxisManager {
    static Logger logger = CommonLogger.getLogger(QueryAxisManager.class);
    protected int dimCount;
    private Hierarchy[] hiers;
    private UnknownFunction[] unknownFunctions;
    protected TreeNode posTreeRoot = null;
    private int ordinal;
    private boolean singleMode = false;
    private boolean hierarchizeNeeded = false;
    private boolean changed = false;
    private Collection changeListeners = new ArrayList();
    private QueryAxisUtil util;
    private Map canExpandMemberMap = new HashMap();
    private Map canExpandPosMap = new HashMap();
    private Map canCollapseMemberMap = new HashMap();
    private Map canCollapsePosMap = new HashMap();
    private Map expandStateCache = new HashMap();
    private boolean useExpandStateCache = false;

    public QueryAxisManager(int ordinal) {
        this.ordinal = ordinal;
        this.singleMode = false;
    }

    public void addChangeListener(QueryAxisChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(QueryAxisChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public boolean isUseExpandStateCache() {
        return this.useExpandStateCache;
    }

    public void setUseExpandStateCache(boolean useExpandStateCache) {
        this.useExpandStateCache = useExpandStateCache;
    }

    public void changed(Object source, boolean changedMemberSet) {
        for (QueryAxisChangeListener listener : this.changeListeners) {
            listener.queryAxisChanged(this, source, changedMemberSet);
        }
        this.changed = true;
        this.canExpandMemberMap.clear();
        this.canExpandPosMap.clear();
        this.canCollapseMemberMap.clear();
        this.canCollapsePosMap.clear();
    }

    public void init(Hierarchy[] hiers, List positions) {
        this.hierarchizeNeeded = false;
        this.singleMode = true;
        this.setHiers(hiers);
        if (positions.size() == 0) {
            Member[][] aPosMem = new Member[0][0];
            this.initPositions(aPosMem);
            return;
        }
        Member[][] aPosMem = new Member[positions.size()][this.dimCount];
        int j = 0;
        for (Position pos : positions) {
            aPosMem[j++] = pos.getMembers();
        }
        this.initPositions(aPosMem);
        this.posTreeRoot.walkTree(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDim = node.getLevel();
                if (iDim == QueryAxisManager.this.dimCount) {
                    return 3;
                }
                if (node.getChildren().size() == 1) {
                    return 0;
                }
                QueryAxisManager.this.singleMode = false;
                return 3;
            }
        });
    }

    private void initPositions(Member[][] aPosMemStart) {
        if (aPosMemStart.length == 0) {
            this.posTreeRoot = null;
            return;
        }
        this.posTreeRoot = new TreeNode(null);
        int iEnd = this.addToPosTree(aPosMemStart, 0, aPosMemStart.length, 0, this.posTreeRoot);
        while (iEnd < aPosMemStart.length) {
            iEnd = this.addToPosTree(aPosMemStart, iEnd, aPosMemStart.length, 0, this.posTreeRoot);
        }
        this.posTreeRoot.walkTree(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDim1 = node.getLevel();
                if (iDim1 == QueryAxisManager.this.dimCount - 1) {
                    if (node.getChildren().size() <= 1) {
                        return 1;
                    }
                    Exp[] memArray = new Exp[node.getChildren().size()];
                    int i = 0;
                    for (TreeNode child : node.getChildren()) {
                        memArray[i++] = child.getReference();
                    }
                    node.getChildren().clear();
                    Exp oFun = QueryAxisManager.this.util.createFunCall("{}", memArray, 2);
                    TreeNode newChild = new TreeNode(oFun);
                    node.addChildNode(newChild);
                    return 1;
                }
                return 0;
            }
        });
        this.unknownFunctions = new UnknownFunction[this.dimCount];
        for (int i = 0; i < this.dimCount; ++i) {
            this.unknownFunctions[i] = null;
        }
    }

    protected int addToPosTree(Member[][] aPosMem, int iStartPos, int iEndPos, int iDim, TreeNode parentNode) {
        int iEndRange;
        Member currentOfDim = aPosMem[iStartPos][iDim];
        Exp o = this.util.objForMember(currentOfDim);
        TreeNode newNode = new TreeNode(o);
        parentNode.addChildNode(newNode);
        for (iEndRange = iStartPos + 1; iEndRange < iEndPos && aPosMem[iEndRange][iDim] == aPosMem[iStartPos][iDim]; ++iEndRange) {
        }
        int nextDim = iDim + 1;
        if (nextDim < this.dimCount) {
            int iEndChild = this.addToPosTree(aPosMem, iStartPos, iEndRange, nextDim, newNode);
            while (iEndChild < iEndRange) {
                iEndChild = this.addToPosTree(aPosMem, iEndChild, iEndRange, nextDim, newNode);
            }
        }
        return iEndRange;
    }

    public int dimIdx(Dimension dim) {
        if (this.hiers == null || this.hiers.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.hiers.length; ++i) {
            if (!this.hiers[i].getDimension().equals(dim)) continue;
            return i;
        }
        return -1;
    }

    private boolean isNullArray(Exp[] as) {
        for (int i = 0; i < as.length; ++i) {
            if (as[i] == null) continue;
            return false;
        }
        return true;
    }

    public void regeneratePosTree(Exp[] sets, Hierarchy[] hiers) {
        if (hiers != null && hiers != this.hiers) {
            this.setHiers(hiers);
            this.unknownFunctions = new UnknownFunction[this.dimCount];
        }
        if (this.unknownFunctions == null) {
            this.unknownFunctions = new UnknownFunction[this.dimCount];
        }
        if (this.isNullArray(sets)) {
            this.posTreeRoot = null;
            return;
        }
        if (this.posTreeRoot == null) {
            this.posTreeRoot = new TreeNode(null);
        } else {
            this.posTreeRoot.getChildren().clear();
        }
        TreeNode current = this.posTreeRoot;
        boolean childrenFound = false;
        for (int i = 0; i < this.dimCount; ++i) {
            TreeNode newNode;
            if (sets[i] instanceof SetBase) {
                SetBase setx = (SetBase)sets[i];
                newNode = new TreeNode(setx.getOExp());
            } else {
                boolean bChildrenFound = this.findChildrenCall(sets[i], 0);
                if (bChildrenFound) {
                    childrenFound = true;
                }
                newNode = new TreeNode(sets[i]);
            }
            current.addChildNode(newNode);
            current = newNode;
            this.unknownFunctions[i] = newNode.getReference() != null && this.util.canHandle(newNode.getReference()) ? null : new UnknownFunction(i, newNode.getReference());
        }
        this.singleMode = true;
        if (!childrenFound) {
            this.hierarchizeNeeded = false;
        }
    }

    private boolean findChildrenCall(Exp oExp, int level) {
        if (!this.util.isFunCall(oExp)) {
            return false;
        }
        if (level > 0 && this.util.isFunCallTo(oExp, "children")) {
            return true;
        }
        int nArgs = this.util.funCallArgCount(oExp);
        for (int i = 0; i < nArgs; ++i) {
            if (!this.findChildrenCall(this.util.funCallArg(oExp, i), level + 1)) continue;
            return true;
        }
        return false;
    }

    public boolean canExpand(Member[] pathMembers) {
        List<Member> li = Arrays.asList(pathMembers);
        if (this.canExpandPosMap.containsKey(li)) {
            Boolean bCanExpand = (Boolean)this.canExpandPosMap.get(li);
            return bCanExpand;
        }
        boolean childFound = this.checkChildPosition(pathMembers);
        Boolean bool = new Boolean(!childFound);
        this.canExpandPosMap.put(li, bool);
        return !childFound;
    }

    public void innerExpand(final Member[] mPath) {
        int i;
        if (this.singleMode) {
            this.resolveUnions();
        }
        List tailNodeList = mPath.length < this.dimCount ? this.collectTailNodes(this.posTreeRoot, mPath) : Collections.EMPTY_LIST;
        final int iDim = mPath.length - 1;
        Exp oMember = this.util.objForMember(mPath[iDim]);
        Exp fChildren = this.util.createFunCall("Children", new Exp[]{oMember}, 1);
        final List[] splitLists = new List[mPath.length];
        for (i = 0; i < splitLists.length; ++i) {
            splitLists[i] = new ArrayList();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    if (QueryAxisManager.this.isMemberInFunCall(oExp, mPath[idi], idi)) {
                        return 0;
                    }
                    return 1;
                }
                int level = node.getLevel();
                TreeNode currentNode = node;
                while (level > 0) {
                    Exp o = currentNode.getReference();
                    if (!QueryAxisManager.this.util.isMember(o) && !splitLists[level - 1].contains(currentNode)) {
                        splitLists[level - 1].add(currentNode);
                    }
                    currentNode = currentNode.getParent();
                    level = currentNode.getLevel();
                }
                return 1;
            }
        });
        for (i = splitLists.length - 1; i >= 0; --i) {
            for (TreeNode n : splitLists[i]) {
                this.splitFunCall2(n, mPath[i], i);
            }
        }
        final TreeNode[] parentChild = new TreeNode[2];
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    return 1;
                }
                if (idi == iDim) {
                    if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                        parentChild[0] = node.getParent();
                        parentChild[1] = node;
                    }
                    return 1;
                }
                logger.error((Object)("unexpected tree node level " + idi + " " + QueryAxisManager.this.util.memberString(mPath)));
                return 3;
            }
        });
        TreeNode newNode = new TreeNode(fChildren);
        parentChild[0].insertChildNodeAfter(newNode, parentChild[1]);
        if (mPath.length < this.dimCount) {
            for (TreeNode tailNode : tailNodeList) {
                newNode.addChildNode(tailNode.deepCopy());
            }
        }
        this.changed(this, false);
    }

    public void expand(Member[] mPath) {
        if (this.useExpandStateCache) {
            this.expandWithCache(mPath);
        } else {
            this.innerExpand(mPath);
        }
    }

    public void expandWithCache(final Member[] mPath) {
        int i;
        List cacheList = (List)this.expandStateCache.get(this.makePathKey(mPath));
        if (cacheList == null) {
            this.innerExpand(mPath);
            return;
        }
        if (this.singleMode) {
            this.resolveUnions();
        }
        final int iDim = mPath.length - 1;
        final List[] splitLists = new List[mPath.length];
        for (i = 0; i < splitLists.length; ++i) {
            splitLists[i] = new ArrayList();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    if (QueryAxisManager.this.isMemberInFunCall(oExp, mPath[idi], idi)) {
                        return 0;
                    }
                    return 1;
                }
                int level = node.getLevel();
                TreeNode currentNode = node;
                while (level > 0) {
                    Exp o = currentNode.getReference();
                    if (!QueryAxisManager.this.util.isMember(o) && !splitLists[level - 1].contains(currentNode)) {
                        splitLists[level - 1].add(currentNode);
                    }
                    currentNode = currentNode.getParent();
                    level = currentNode.getLevel();
                }
                return 1;
            }
        });
        for (i = splitLists.length - 1; i >= 0; --i) {
            for (TreeNode n : splitLists[i]) {
                this.splitFunCall2(n, mPath[i], i);
            }
        }
        final TreeNode[] parentChild = new TreeNode[2];
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    return 1;
                }
                if (idi == iDim) {
                    if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                        parentChild[0] = node.getParent();
                        parentChild[1] = node;
                    }
                    return 1;
                }
                logger.error((Object)("unexpected tree node level " + idi + " " + QueryAxisManager.this.util.memberString(mPath)));
                return 3;
            }
        });
        TreeNode before = parentChild[1];
        for (Object o : cacheList) {
            if (!(o instanceof TreeNode)) continue;
            parentChild[0].insertChildNodeAfter((TreeNode)o, before);
            before = (TreeNode)o;
        }
        this.expandStateCache.remove(this.makePathKey(mPath));
        this.changed(this, false);
    }

    private Object makePathKey(Member[] mPath) {
        return Arrays.asList(mPath);
    }

    public boolean canExpand(Member member) {
        if (this.canExpandMemberMap.containsKey(member)) {
            Boolean bCanExpand = (Boolean)this.canExpandMemberMap.get(member);
            return bCanExpand;
        }
        boolean b = !this.findMemberChild(member);
        Boolean bool = new Boolean(b);
        this.canExpandMemberMap.put(member, bool);
        return b;
    }

    public void expand(final Member member) {
        if (this.singleMode) {
            this.resolveUnions();
        }
        final int iDim = this.dimIdx(this.util.dimForMember(member));
        final ArrayList nodesForMember = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (QueryAxisManager.this.util.isMember(oExp)) {
                    if (QueryAxisManager.this.util.equalMember(oExp, member)) {
                        nodesForMember.add(node);
                    }
                } else if (QueryAxisManager.this.isMemberInFunCall(oExp, member, iDim)) {
                    nodesForMember.add(node);
                }
                return 1;
            }
        });
        Exp oMember = this.util.objForMember(member);
        Exp fChildren = this.util.createFunCall("Children", new Exp[]{oMember}, 1);
        for (TreeNode node : nodesForMember) {
            TreeNode newNode = new TreeNode(fChildren);
            for (TreeNode child : node.getChildren()) {
                newNode.addChildNode(child.deepCopy());
            }
            TreeNode parent = node.getParent();
            parent.insertChildNodeAfter(newNode, node);
        }
        this.hierarchizeNeeded = true;
        this.changed(this, false);
    }

    public boolean canCollapse(Member[] pathMembers) {
        List<Member> li = Arrays.asList(pathMembers);
        if (this.canCollapsePosMap.containsKey(li)) {
            Boolean bCanCollapse = (Boolean)this.canCollapsePosMap.get(li);
            return bCanCollapse;
        }
        boolean childFound = this.checkChildPosition(pathMembers);
        Boolean bool = new Boolean(childFound);
        this.canCollapsePosMap.put(li, bool);
        return childFound;
    }

    public void innerCollapse(final Member[] mPath) {
        int i;
        if (this.singleMode) {
            this.resolveUnions();
        }
        final int iDim = mPath.length - 1;
        final List[] splitLists = new List[mPath.length];
        for (i = 0; i < splitLists.length; ++i) {
            splitLists[i] = new ArrayList();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    if (QueryAxisManager.this.isMemberInFunCall(oExp, mPath[idi], idi)) {
                        return 0;
                    }
                    return 1;
                }
                boolean found = false;
                if (QueryAxisManager.this.util.isMember(oExp)) {
                    if (QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oExp)) {
                        found = true;
                    }
                } else if (QueryAxisManager.this.isChildOfMemberInFunCall(oExp, mPath[iDim], iDim)) {
                    found = true;
                }
                if (found) {
                    int level = node.getLevel();
                    TreeNode currentNode = node;
                    while (level > 0) {
                        Exp o = currentNode.getReference();
                        if (!QueryAxisManager.this.util.isMember(o) && !splitLists[level - 1].contains(currentNode)) {
                            splitLists[level - 1].add(currentNode);
                        }
                        currentNode = currentNode.getParent();
                        level = currentNode.getLevel();
                    }
                }
                return 1;
            }
        });
        for (i = splitLists.length - 1; i >= 0; --i) {
            for (TreeNode n : splitLists[i]) {
                this.splitFunCall2(n, mPath[i], i);
            }
        }
        final ArrayList removeList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    return 1;
                }
                if (idi == iDim) {
                    if (!QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.isFunCallTo(oExp, "Children")) {
                            Exp oMember = QueryAxisManager.this.util.funCallArg(oExp, 0);
                            if (QueryAxisManager.this.util.objForMember(mPath[iDim]).equals(oMember) || QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oMember)) {
                                removeList.add(node);
                            }
                        } else if (QueryAxisManager.this.util.isFunCallTo(oExp, "{}")) {
                            int nArgs = QueryAxisManager.this.util.funCallArgCount(oExp);
                            ArrayList<Exp> removeMembers = new ArrayList<Exp>();
                            for (int i = 0; i < nArgs; ++i) {
                                Exp oSetMember = QueryAxisManager.this.util.funCallArg(oExp, i);
                                if (!QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oSetMember)) continue;
                                removeMembers.add(oSetMember);
                            }
                            int nRemove = removeMembers.size();
                            if (nRemove == nArgs) {
                                removeList.add(node);
                            } else if (nRemove > 0) {
                                Exp[] remaining = new Exp[nArgs - nRemove];
                                int j = 0;
                                for (int i = 0; i < nArgs; ++i) {
                                    Exp oSetMember = QueryAxisManager.this.util.funCallArg(oExp, i);
                                    if (removeMembers.contains(oSetMember)) continue;
                                    remaining[j++] = oSetMember;
                                }
                                if (remaining.length == 1) {
                                    node.setReference(remaining[0]);
                                } else {
                                    Exp newSet = QueryAxisManager.this.util.createFunCall("{}", remaining, 2);
                                    node.setReference(newSet);
                                }
                            }
                        } else if (QueryAxisManager.this.util.isFunCallTo(oExp, "Union")) {
                            Exp oRemain = QueryAxisManager.this.removeDescendantsFromFunCall(oExp, mPath[iDim], iDim);
                            if (oRemain == null) {
                                removeList.add(node);
                            } else {
                                node.setReference(oRemain);
                            }
                        }
                        return 1;
                    }
                    if (QueryAxisManager.this.util.isMember(oExp) && QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oExp)) {
                        removeList.add(node);
                    }
                    return 1;
                }
                logger.error((Object)("unexpected tree node level " + idi + " " + QueryAxisManager.this.util.memberString(mPath)));
                return 3;
            }
        });
        for (TreeNode nodeToRemove : removeList) {
            this.removePathToNode(nodeToRemove);
        }
        this.changed(this, false);
    }

    public void collapse(Member[] mPath) {
        if (this.useExpandStateCache) {
            this.collapseWithCache(mPath);
        } else {
            this.innerCollapse(mPath);
        }
    }

    public void collapseWithCache(final Member[] mPath) {
        int i;
        if (this.singleMode) {
            this.resolveUnions();
        }
        final int iDim = mPath.length - 1;
        final List[] splitLists = new List[mPath.length];
        for (i = 0; i < splitLists.length; ++i) {
            splitLists[i] = new ArrayList();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    if (QueryAxisManager.this.isMemberInFunCall(oExp, mPath[idi], idi)) {
                        return 0;
                    }
                    return 1;
                }
                boolean found = false;
                if (QueryAxisManager.this.util.isMember(oExp)) {
                    if (QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oExp)) {
                        found = true;
                    }
                } else if (QueryAxisManager.this.isChildOfMemberInFunCall(oExp, mPath[iDim], iDim)) {
                    found = true;
                }
                if (found) {
                    int level = node.getLevel();
                    TreeNode currentNode = node;
                    while (level > 0) {
                        Exp o = currentNode.getReference();
                        if (!QueryAxisManager.this.util.isMember(o) && !splitLists[level - 1].contains(currentNode)) {
                            splitLists[level - 1].add(currentNode);
                        }
                        currentNode = currentNode.getParent();
                        level = currentNode.getLevel();
                    }
                }
                return 1;
            }
        });
        for (i = splitLists.length - 1; i >= 0; --i) {
            for (TreeNode n : splitLists[i]) {
                this.splitFunCall2(n, mPath[i], i);
            }
        }
        final ArrayList removeList = new ArrayList();
        final ArrayList cacheList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                Exp oExp = node.getReference();
                int idi = node.getLevel() - 1;
                if (idi < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[idi])) {
                            return 0;
                        }
                        return 1;
                    }
                    return 1;
                }
                if (idi == iDim) {
                    if (!QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.isFunCallTo(oExp, "Children")) {
                            Exp oMember = QueryAxisManager.this.util.funCallArg(oExp, 0);
                            if (QueryAxisManager.this.util.objForMember(mPath[iDim]).equals(oMember) || QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oMember)) {
                                removeList.add(node);
                                cacheList.add(node);
                            }
                        } else if (QueryAxisManager.this.util.isFunCallTo(oExp, "{}")) {
                            int nArgs = QueryAxisManager.this.util.funCallArgCount(oExp);
                            ArrayList<Exp> removeMembers = new ArrayList<Exp>();
                            ArrayList<Exp> cacheMembers = new ArrayList<Exp>();
                            for (int i = 0; i < nArgs; ++i) {
                                Exp oSetMember = QueryAxisManager.this.util.funCallArg(oExp, i);
                                if (!QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oSetMember)) continue;
                                removeMembers.add(oSetMember);
                                cacheMembers.add(oSetMember);
                            }
                            int nRemove = removeMembers.size();
                            if (nRemove == nArgs) {
                                removeList.add(node);
                                cacheList.add(node);
                            } else if (nRemove > 0) {
                                Exp[] remaining = new Exp[nArgs - nRemove];
                                int j = 0;
                                for (int i = 0; i < nArgs; ++i) {
                                    Exp oSetMember = QueryAxisManager.this.util.funCallArg(oExp, i);
                                    if (removeMembers.contains(oSetMember)) continue;
                                    remaining[j++] = oSetMember;
                                }
                                if (remaining.length == 1) {
                                    node.setReference(remaining[0]);
                                } else {
                                    Exp newSet = QueryAxisManager.this.util.createFunCall("{}", remaining, 2);
                                    node.setReference(newSet);
                                }
                                Exp newSet = QueryAxisManager.this.util.createFunCall("{}", cacheMembers.toArray(new Exp[0]), 2);
                                TreeNode newNode = new TreeNode(newSet);
                                cacheList.add(newNode);
                            }
                        } else if (QueryAxisManager.this.util.isFunCallTo(oExp, "Union")) {
                            Exp oRemain = QueryAxisManager.this.removeDescendantsFromFunCall(oExp, mPath[iDim], iDim);
                            if (oRemain == null) {
                                removeList.add(node);
                                cacheList.add(node);
                            } else {
                                node.setReference(oRemain);
                                Exp newSet = QueryAxisManager.this.util.createFunCall("-", new Exp[]{oExp, oRemain}, 0);
                                TreeNode newNode = new TreeNode(newSet);
                                cacheList.add(newNode);
                            }
                        }
                        return 1;
                    }
                    if (QueryAxisManager.this.util.isMember(oExp) && QueryAxisManager.this.util.checkDescendantO(mPath[iDim], oExp)) {
                        removeList.add(node);
                        cacheList.add(node);
                    }
                    return 1;
                }
                logger.error((Object)("unexpected tree node level " + idi + " " + QueryAxisManager.this.util.memberString(mPath)));
                return 3;
            }
        });
        for (TreeNode nodeToRemove : removeList) {
            this.removePathToNode(nodeToRemove);
        }
        if (cacheList.size() > 0) {
            this.expandStateCache.put(this.makePathKey(mPath), cacheList);
        }
        this.changed(this, false);
    }

    public boolean canCollapse(Member member) {
        if (this.canCollapseMemberMap.containsKey(member)) {
            Boolean bCanCollapse = (Boolean)this.canCollapseMemberMap.get(member);
            return bCanCollapse;
        }
        boolean b = this.findMemberChild(member);
        Boolean bool = new Boolean(b);
        this.canCollapseMemberMap.put(member, bool);
        return b;
    }

    public void collapse(final Member member) {
        if (this.singleMode) {
            this.resolveUnions();
        }
        final int iDim = this.dimIdx(this.util.dimForMember(member));
        final ArrayList nodesForMember = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (QueryAxisManager.this.util.isMember(oExp)) {
                    if (QueryAxisManager.this.util.checkDescendantO(member, oExp)) {
                        nodesForMember.add(node);
                    }
                } else if (QueryAxisManager.this.isDescendantOfMemberInFunCall(oExp, member, iDimNode)) {
                    nodesForMember.add(node);
                }
                return 1;
            }
        });
        for (TreeNode node : nodesForMember) {
            Exp oExp = node.getReference();
            if (this.util.isMember(oExp)) {
                this.removePathToNode(node);
                continue;
            }
            Exp oComplement = this.removeDescendantsFromFunCall(oExp, member, iDim);
            if (oComplement == null) {
                this.removePathToNode(node);
                continue;
            }
            node.setReference(oComplement);
        }
        this.changed(this, false);
    }

    public boolean canDrillDown(Level level) {
        return level.getchildLevel() != null;
    }

    public boolean canDrillDown(Member member) {
        return !member.isLeaf();
    }

    public void drillDown(Member member) {
        if (member.isLeaf()) {
            return;
        }
        int iDim = this.dimIdx(this.util.dimForMember(member));
        Exp[] sets = new Exp[this.dimCount];
        Exp oMember = this.util.objForMember(member);
        Exp fChildren = this.util.createFunCall("Children", new Exp[]{oMember}, 1);
        for (int i = 0; i < this.dimCount; ++i) {
            sets[i] = i == iDim ? fChildren : this.genExpForDim(i);
        }
        this.regeneratePosTree(sets, null);
        this.changed(this, false);
    }

    public void drillDown(Level level) {
        if (level.getchildLevel() == null) {
            return;
        }
        level = level.getchildLevel();
        int iDim = this.dimIdx(level.getHierarchy().getDimension());
        Exp[] sets = new Exp[this.dimCount];
        Exp oLevel = this.util.objForLevel(level);
        Exp fChildren = this.util.createFunCall("Members", new Exp[]{oLevel}, 1);
        for (int i = 0; i < this.dimCount; ++i) {
            sets[i] = i == iDim ? fChildren : this.genExpForDim(i);
        }
        this.regeneratePosTree(sets, null);
        this.changed(this, false);
    }

    public boolean canDrillUp(Hierarchy hier) {
        final int iDim = this.dimIdx(hier.getDimension());
        int ret = this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (!QueryAxisManager.this.util.isMember(oExp)) {
                    if (QueryAxisManager.this.isFunCallNotTopLevel(oExp, iDimNode)) {
                        return 3;
                    }
                    return 1;
                }
                if (QueryAxisManager.this.util.levelDepthForMember(oExp) > 0) {
                    return 3;
                }
                return 1;
            }
        });
        return ret == 3;
    }

    public void drillUp(Hierarchy hier) {
        int iDim = this.dimIdx(hier.getDimension());
        Exp[] sets = new Exp[this.dimCount];
        for (int i = 0; i < this.dimCount; ++i) {
            sets[i] = i == iDim ? this.drillupExp(iDim, hier) : this.genExpForDim(i);
        }
        this.regeneratePosTree(sets, null);
        this.changed(this, false);
    }

    public Exp genExp(boolean genHierarchize) {
        return this.genNormalExp(genHierarchize);
    }

    private Exp genNormalExp(boolean genHierarchize) {
        ExpGenerator expGenerator = new ExpGenerator(this.util);
        if (!genHierarchize) {
            expGenerator.init(this.posTreeRoot, this.hiers);
            Exp exp = expGenerator.genExp();
            return exp;
        }
        expGenerator.init(this.posTreeRoot, this.hiers);
        Exp exp = expGenerator.genExp();
        Exp eHier = this.util.createFunCall("Hierarchize", new Exp[]{exp}, 0);
        return eHier;
    }

    private boolean checkChildPosition(final Member[] mPath) {
        int ret = this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDim = mPath.length - 1;
                int iDimNode = node.getLevel() - 1;
                Exp oExp = node.getReference();
                if (iDimNode < iDim) {
                    if (QueryAxisManager.this.util.isMember(oExp)) {
                        if (QueryAxisManager.this.util.equalMember(oExp, mPath[iDimNode])) {
                            return 0;
                        }
                        return 1;
                    }
                    if (QueryAxisManager.this.isMemberInFunCall(oExp, mPath[iDimNode], iDimNode)) {
                        return 0;
                    }
                    return 1;
                }
                if (QueryAxisManager.this.util.isMember(oExp)) {
                    if (QueryAxisManager.this.util.checkParent(mPath[iDimNode], oExp)) {
                        return 3;
                    }
                    return 1;
                }
                if (QueryAxisManager.this.isChildOfMemberInFunCall(oExp, mPath[iDimNode], iDimNode)) {
                    return 3;
                }
                return 1;
            }
        });
        return ret == 3;
    }

    private void resolveUnions() {
        final List[] setLists = new List[this.dimCount];
        for (int i = 0; i < setLists.length; ++i) {
            setLists[i] = new ArrayList();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                Exp oExp = node.getReference();
                if (QueryAxisManager.this.util.isMember(oExp)) {
                    setLists[iDimNode].add(oExp);
                } else {
                    QueryAxisManager.this.funToList(oExp, setLists[iDimNode]);
                }
                return 0;
            }
        });
        this.posTreeRoot = new TreeNode(null);
        this.crossJoinTree(setLists, this.posTreeRoot, 0);
        this.singleMode = false;
    }

    private List collectTailNodes(TreeNode startNode, final Member[] mPath) {
        final ArrayList tailNodes = new ArrayList();
        startNode.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDim = mPath.length - 1;
                int iDimNode = node.getLevel() - 1;
                Exp oExp = node.getReference();
                boolean match = false;
                if (QueryAxisManager.this.util.isMember(oExp)) {
                    if (QueryAxisManager.this.util.equalMember(oExp, mPath[iDimNode])) {
                        match = true;
                    }
                } else if (QueryAxisManager.this.isMemberInFunCall(oExp, mPath[iDimNode], iDimNode)) {
                    match = true;
                }
                if (match) {
                    if (iDimNode == iDim) {
                        tailNodes.addAll(node.getChildren());
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
        });
        return tailNodes;
    }

    private boolean findMemberChild(final Member member) {
        final int iDim = this.dimIdx(this.util.dimForMember(member));
        int ret = this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (QueryAxisManager.this.util.isMember(oExp) ? QueryAxisManager.this.util.checkParent(member, oExp) : QueryAxisManager.this.isChildOfMemberInFunCall(oExp, member, iDimNode)) {
                    return 3;
                }
                return 1;
            }
        });
        return ret == 3;
    }

    private boolean findMemberDecendants(final Member member) {
        final int iDim = this.dimIdx(this.util.dimForMember(member));
        int ret = this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (QueryAxisManager.this.util.isMember(oExp) ? QueryAxisManager.this.util.checkDescendantO(member, oExp) : QueryAxisManager.this.isDescendantOfMemberInFunCall(oExp, member, iDimNode)) {
                    return 3;
                }
                return 1;
            }
        });
        return ret == 3;
    }

    public boolean isExpanded(Member member) {
        return this.findMemberDecendants(member);
    }

    public String toString() {
        final StringBuffer sbPosTree = new StringBuffer();
        if (this.posTreeRoot == null) {
            sbPosTree.append("Root=null");
            return sbPosTree.toString();
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                sbPosTree.append("\n");
                for (int i = 0; i < iDimNode - 1; ++i) {
                    sbPosTree.append("   ");
                }
                if (iDimNode > 0) {
                    sbPosTree.append("+--");
                }
                Exp oExp = node.getReference();
                if (!QueryAxisManager.this.util.isMember(oExp)) {
                    sbPosTree.append(QueryAxisManager.this.util.funString(oExp));
                } else {
                    sbPosTree.append(QueryAxisManager.this.util.getMemberUniqueName(oExp));
                }
                return 0;
            }
        });
        return sbPosTree.toString();
    }

    private void crossJoinTree(List[] setLists, TreeNode currentNode, int iDim) {
        for (Exp oExp : setLists[iDim]) {
            TreeNode newNode = new TreeNode(oExp);
            if (iDim < this.dimCount - 1) {
                this.crossJoinTree(setLists, newNode, iDim + 1);
            }
            currentNode.addChildNode(newNode);
        }
    }

    private void splitFunCall2(TreeNode nFunCall, Member member, int iHier) {
        Exp oExp = nFunCall.getReference();
        if (!this.isMemberInFunCall(oExp, member, nFunCall.getLevel() - 1)) {
            return;
        }
        Exp[] oComplement = this.createComplement2(oExp, member, iHier);
        if (oComplement == null) {
            nFunCall.setReference(this.util.objForMember(member));
            return;
        }
        if (oComplement.length == 1) {
            nFunCall.setReference(oComplement[0]);
            return;
        }
        TreeNode newNodeLeft = null;
        TreeNode newNodeRight = null;
        if (oComplement[0] != null) {
            newNodeLeft = new TreeNode(oComplement[0]);
        }
        if (oComplement[1] != null) {
            newNodeRight = new TreeNode(oComplement[1]);
        }
        TreeNode newNodeMember = new TreeNode(this.util.objForMember(member));
        for (TreeNode nChild : nFunCall.getChildren()) {
            if (newNodeLeft != null) {
                newNodeLeft.addChildNode(nChild.deepCopy());
            }
            newNodeMember.addChildNode(nChild.deepCopy());
            if (newNodeRight == null) continue;
            newNodeRight.addChildNode(nChild.deepCopy());
        }
        TreeNode nInsert = nFunCall.getParent();
        if (newNodeLeft != null) {
            nInsert.insertChildNodeBefore(newNodeLeft, nFunCall);
        }
        nInsert.insertChildNodeBefore(newNodeMember, nFunCall);
        if (newNodeRight != null) {
            nInsert.insertChildNodeBefore(newNodeRight, nFunCall);
        }
        nFunCall.remove();
    }

    private void removePathToNode(TreeNode nodeToRemove) {
        if (nodeToRemove.getParent().getChildren().size() > 1) {
            nodeToRemove.remove();
        } else {
            TreeNode parent = nodeToRemove.getParent();
            while (parent.getParent().getChildren().size() == 1) {
                parent = parent.getParent();
            }
            if (parent.getLevel() > 0) {
                parent.remove();
            }
        }
    }

    public Exp genExpForDim(int iDimension) {
        ArrayList funCallList = new ArrayList();
        ArrayList memberList = new ArrayList();
        this.collectFunCallAndMembers(iDimension, funCallList, memberList);
        this.cleanupMemberList(funCallList, memberList, iDimension);
        if (funCallList.size() == 0) {
            if (memberList.size() == 1) {
                return (Exp)memberList.get(0);
            }
            Exp mSet = null;
            if (memberList.size() > 0) {
                Exp[] aExp = memberList.toArray(new Exp[0]);
                mSet = this.util.createFunCall("{}", aExp, 2);
            }
            return mSet;
        }
        if (memberList.size() == 0) {
            if (funCallList.size() == 1) {
                return (Exp)funCallList.get(0);
            }
            Exp mSet = null;
            if (funCallList.size() > 0) {
                Exp[] aExp = funCallList.toArray(new Exp[0]);
                mSet = this.util.createFunCall("{}", aExp, 2);
            }
            return mSet;
        }
        ArrayList<Object> expList = new ArrayList<Object>();
        ArrayList<String> memberSet = new ArrayList<String>();
        for (Exp exp : memberList) {
            memberSet.add(exp.toString());
            expList.add(exp);
        }
        HashMap<Integer, Exp> map = new HashMap<Integer, Exp>();
        for (Exp exp : funCallList) {
            if (this.util.isFunCallTo(exp, "Children") || this.util.isFunCallTo(exp, "Descendant")) {
                Exp parent = this.util.funCallArg(exp, 0);
                int index = -1;
                index = memberSet.indexOf(parent.toString());
                if (index <= -1) continue;
                map.put(new Integer(index), exp);
                continue;
            }
            expList.add(exp);
        }
        ArrayList<Object> expList2 = null;
        if (map.isEmpty()) {
            expList2 = expList;
        } else {
            expList2 = new ArrayList();
            for (int i = 0; i < memberSet.size(); ++i) {
                expList2.add(expList.get(i));
                Object func = map.get(new Integer(i));
                if (func == null) continue;
                expList2.add(func);
            }
        }
        Exp[] aExp = expList2.toArray(new Exp[0]);
        return this.util.createFunCall("{}", aExp, 2);
    }

    private Exp drillupExp(int iDim, Hierarchy hier) {
        IntHolder maxLevel = new IntHolder(0);
        List drillupList = this.collectDrillup(iDim, maxLevel);
        Exp expForHier = null;
        if (maxLevel.value == 0) {
            expForHier = this.util.topLevelMembers(hier, false);
        } else if (drillupList.size() == 1) {
            expForHier = (Exp)drillupList.get(0);
        } else {
            for (Exp oExp : drillupList) {
                if (expForHier == null) {
                    expForHier = oExp;
                    continue;
                }
                expForHier = this.util.createFunCall("Union", new Exp[]{expForHier, oExp}, 0);
            }
        }
        return expForHier;
    }

    private List collectDrillup(final int iDim, final IntHolder maxLevel) {
        final ArrayList drillupList = new ArrayList();
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                if (!QueryAxisManager.this.util.isMember(oExp)) {
                    QueryAxisManager.this.addFunCallToDrillup(drillupList, oExp, maxLevel);
                } else {
                    Member m = QueryAxisManager.this.util.memberForObj(oExp);
                    QueryAxisManager.this.util.addMemberUncles(drillupList, m, maxLevel);
                }
                return 1;
            }
        });
        return drillupList;
    }

    private void cleanupMemberList(List funCallList, List memberList, int iDim) {
        if (funCallList.size() > 0 && memberList.size() > 0) {
            Iterator itMem = memberList.iterator();
            block0: while (itMem.hasNext()) {
                Exp oMember = (Exp)itMem.next();
                Member m = this.util.memberForObj(oMember);
                for (Exp oFun : funCallList) {
                    if (!this.isMemberInFunCall(oFun, m, iDim)) continue;
                    itMem.remove();
                    continue block0;
                }
            }
        }
    }

    private void collectA(Exp oExp, List funCallList, List memberList) {
        if (this.util.isMember(oExp)) {
            if (!memberList.contains(oExp)) {
                memberList.add(oExp);
            }
        } else if (this.util.isFunCallTo(oExp, "{}") || this.util.isFunCallTo(oExp, "Union")) {
            for (int i = 0; i < this.util.funCallArgCount(oExp); ++i) {
                Exp oExp2 = this.util.funCallArg(oExp, i);
                this.collectA(oExp2, funCallList, memberList);
            }
        } else {
            String str = this.util.funString(oExp).toString();
            if (!funCallList.contains(str)) {
                funCallList.add(oExp);
                funCallList.add(str);
            }
        }
    }

    private void collectFunCallAndMembers(final int iDim, final List funCallList, final List memberList) {
        if (this.posTreeRoot == null) {
            return;
        }
        this.posTreeRoot.walkChildren(new TreeNodeCallback(){

            @Override
            public int handleTreeNode(TreeNode node) {
                int iDimNode = node.getLevel() - 1;
                if (iDimNode < iDim) {
                    return 0;
                }
                Exp oExp = node.getReference();
                QueryAxisManager.this.collectA(oExp, funCallList, memberList);
                return 1;
            }
        });
        Iterator iter = funCallList.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof String)) continue;
            iter.remove();
        }
    }

    private void addFunCallToDrillup(List list, Exp oFun, IntHolder maxLevel) {
        if (this.util.isFunCallTo(oFun, "Union")) {
            for (int i = 0; i < 2; ++i) {
                Exp fExp = this.util.funCallArg(oFun, i);
                this.addFunCallToDrillup(list, fExp, maxLevel);
            }
        } else if (this.util.isFunCallTo(oFun, "{}")) {
            for (int i = 0; i < this.util.funCallArgCount(oFun); ++i) {
                Exp oMember = this.util.funCallArg(oFun, i);
                Member m = this.util.memberForObj(oMember);
                this.util.addMemberUncles(list, m, maxLevel);
            }
        } else if (this.util.isFunCallTo(oFun, "Children")) {
            Exp oMember = this.util.funCallArg(oFun, 0);
            Member m = this.util.memberForObj(oMember);
            this.util.addMemberSiblings(list, m, maxLevel);
        } else if (this.util.isFunCallTo(oFun, "Descendants")) {
            Exp oMember = this.util.funCallArg(oFun, 0);
            Member m = this.util.memberForObj(oMember);
            Exp oLevel = this.util.funCallArg(oFun, 1);
            Level lev = this.util.LevelForObj(oLevel);
            int level = this.util.levelDepthForMember(oMember);
            int levlev = lev.getDepth();
            if (levlev == level + 1) {
                this.util.addMemberSiblings(list, m, maxLevel);
            } else if (levlev == level + 2) {
                this.util.addMemberChildren(list, m, maxLevel);
            } else {
                Level parentLevel = this.util.getParentLevel(lev);
                this.util.addMemberDescendants(list, m, parentLevel, maxLevel);
            }
        } else if (this.util.isFunCallTo(oFun, "Members")) {
            Exp oLevel = this.util.funCallArg(oFun, 0);
            Level lev = this.util.LevelForObj(oLevel);
            int levlev = lev.getDepth();
            if (levlev == 0) {
                return;
            }
            Level parentLevel = this.util.getParentLevel(lev);
            this.util.addLevelMembers(list, parentLevel, maxLevel);
        } else {
            Exp oFun2 = this.util.funCallArg(oFun, 0);
            this.addFunCallToDrillup(list, oFun2, maxLevel);
        }
    }

    private void funToList(Exp oFun, List list) {
        if (this.util.isFunCallTo(oFun, "Union")) {
            Exp oArg0 = this.util.funCallArg(oFun, 0);
            Exp oArg1 = this.util.funCallArg(oFun, 1);
            this.funToList(oArg0, list);
            this.funToList(oArg1, list);
        } else if (this.util.isFunCallTo(oFun, "{}")) {
            for (int i = 0; i < this.util.funCallArgCount(oFun); ++i) {
                Exp oMember = this.util.funCallArg(oFun, i);
                list.add(oMember);
            }
        } else {
            list.add(oFun);
        }
    }

    public void setUtil(QueryAxisUtil util) {
        this.util = util;
    }

    public int getDimCount() {
        return this.dimCount;
    }

    public TreeNode getPosTreeRoot() {
        return this.posTreeRoot;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isHierarchizeNeeded() {
        return this.hierarchizeNeeded;
    }

    public void setHierarchizeNeeded(boolean b) {
        this.hierarchizeNeeded = b;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setHiers(Hierarchy[] hierarchies) {
        this.hiers = hierarchies;
        this.dimCount = hierarchies.length;
    }

    public Hierarchy[] getHierarchies() {
        return this.hiers;
    }

    public UnknownFunction getUnknownFunction(int i) {
        if (this.unknownFunctions == null) {
            return null;
        }
        return this.unknownFunctions[i];
    }

    private boolean isMemberInFunCall(Exp oExp, Member member, int hierIndex) {
        boolean b = false;
        try {
            b = this.util.isMemberInFunCall(oExp, member);
        }
        catch (CannotHandleException e) {
            UnknownFunction unk = this.unknownFunctions[hierIndex];
            if (!unk.getFCall().equals(oExp)) {
                throw new IllegalArgumentException("Unknow FunCall Error");
            }
            b = unk.getMemberList().contains(member);
        }
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFunCallNotTopLevel(Exp oExp, int hierIndex) {
        boolean b = false;
        try {
            return this.util.isFunCallNotTopLevel(oExp);
        }
        catch (CannotHandleException e) {
            Exp m;
            UnknownFunction unk = this.unknownFunctions[hierIndex];
            if (!unk.getFCall().equals(oExp)) {
                throw new IllegalArgumentException("Unknow FunCall Error");
            }
            List mList = unk.getMemberList();
            Iterator iter = mList.iterator();
            do {
                if (!iter.hasNext()) return b;
            } while (this.util.isMemberOnToplevel(m = (Exp)iter.next()));
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isChildOfMemberInFunCall(Exp oExp, Member member, int hierIndex) {
        boolean b = false;
        try {
            return this.util.isChildOfMemberInFunCall(oExp, member);
        }
        catch (CannotHandleException e) {
            Member m;
            UnknownFunction unk = this.unknownFunctions[hierIndex];
            if (!unk.getFCall().equals(oExp)) {
                throw new IllegalArgumentException("Unknow FunCall Error");
            }
            List mList = unk.getMemberList();
            Iterator iter = mList.iterator();
            do {
                if (!iter.hasNext()) return b;
            } while (!this.util.checkParent(member, this.util.objForMember(m = (Member)iter.next())));
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDescendantOfMemberInFunCall(Exp oExp, Member member, int hierIndex) {
        boolean b = false;
        try {
            return this.util.isDescendantOfMemberInFunCall(oExp, member);
        }
        catch (CannotHandleException e) {
            Member m;
            UnknownFunction unk = this.unknownFunctions[hierIndex];
            if (!unk.getFCall().equals(oExp)) {
                throw new IllegalArgumentException("Unknow FunCall Error");
            }
            List mList = unk.getMemberList();
            Iterator iter = mList.iterator();
            do {
                if (!iter.hasNext()) return b;
            } while (!this.util.checkDescendantM(member, m = (Member)iter.next()));
            return true;
        }
    }

    private Exp removeDescendantsFromFunCall(Exp oFun, Member member, int iHier) {
        try {
            return this.removeDescendantsFromFunCall(oFun, member);
        }
        catch (CannotHandleException e) {
            logger.error((Object)("Unkown FunCall " + this.util.funCallName(oFun)));
            UnknownFunction unk = this.unknownFunctions[iHier];
            if (unk == null || !unk.getFCall().equals(oFun)) {
                throw new IllegalArgumentException("Funcall not handled " + this.util.funCallName(oFun));
            }
            List mList = unk.getMemberList();
            ArrayList<Exp> newList = new ArrayList<Exp>();
            for (Member m : mList) {
                if (this.util.checkDescendantM(member, m)) continue;
                newList.add(this.util.objForMember(m));
            }
            return this.util.createFunCall("{}", (Exp[])newList.toArray(), 2);
        }
    }

    private Exp removeDescendantsFromFunCall(Exp oFun, Member member) throws CannotHandleException {
        if (this.util.isFunCallTo(oFun, "Children")) {
            return null;
        }
        if (this.util.isFunCallTo(oFun, "Descendants")) {
            return null;
        }
        if (this.util.isFunCallTo(oFun, "Members")) {
            Level level = member.getLevel();
            Exp[] members = this.util.getLevelMembers(level);
            ArrayList<Exp> remainder = new ArrayList<Exp>();
            for (int i = 0; i < members.length; ++i) {
                if (this.util.checkDescendantO(member, members[i])) continue;
                remainder.add(members[i]);
            }
            return this.util.createMemberSet(remainder);
        }
        if (this.util.isFunCallTo(oFun, "{}")) {
            ArrayList<Exp> remainder = new ArrayList<Exp>();
            for (int i = 0; i < this.util.funCallArgCount(oFun); ++i) {
                Exp om = this.util.funCallArg(oFun, i);
                if (this.util.checkDescendantO(member, om)) continue;
                remainder.add(om);
            }
            return this.util.createMemberSet(remainder);
        }
        if (this.util.isFunCallTo(oFun, "Union")) {
            Exp[] uargs = new Exp[]{this.removeDescendantsFromFunCall(this.util.funCallArg(oFun, 0), member), this.removeDescendantsFromFunCall(this.util.funCallArg(oFun, 0), member)};
            if (uargs[0] == null && uargs[1] == null) {
                return null;
            }
            if (uargs[1] == null) {
                return uargs[0];
            }
            if (uargs[0] == null) {
                return uargs[1];
            }
            if (this.util.isMember(uargs[0])) {
                uargs[0] = this.util.createFunCall("{}", new Exp[]{uargs[0]}, 2);
            }
            if (this.util.isMember(uargs[1])) {
                uargs[1] = this.util.createFunCall("{}", new Exp[]{uargs[1]}, 2);
            }
            if (this.util.isFunCallTo(uargs[0], "{}") && this.util.isFunCallTo(uargs[1], "{}")) {
                return this.unionOfSets(uargs[0], uargs[1]);
            }
            return this.util.createFunCall("Union", uargs, 0);
        }
        throw new CannotHandleException(this.util.funCallName(oFun));
    }

    private Exp[] createComplement2(Exp oFun, Member member, int iHier) {
        try {
            return this.createComplement2(oFun, member);
        }
        catch (CannotHandleException e) {
            logger.error((Object)("Unkown FunCall " + this.util.funCallName(oFun)));
            UnknownFunction unk = this.unknownFunctions[iHier];
            if (unk == null || !unk.getFCall().equals(oFun)) {
                throw new IllegalArgumentException("Funcall not handled " + this.util.funCallName(oFun));
            }
            List mList = unk.getMemberList();
            ArrayList<Exp> newList = new ArrayList<Exp>();
            for (Member m : mList) {
                newList.add(this.util.objForMember(m));
            }
            if (newList.size() == 1) {
                return new Exp[]{(Exp)newList.get(0)};
            }
            Exp o = this.util.createFunCall("{}", newList.toArray(new Exp[0]), 2);
            return this.createComplement2(o, member, iHier);
        }
    }

    private Exp[] createComplement2(Exp oFun, Member member) throws CannotHandleException {
        if (this.util.isFunCallTo(oFun, "Children")) {
            Exp oParent = this.util.funCallArg(oFun, 0);
            Exp oMember = this.util.objForMember(member);
            if (!this.util.checkChild(member, oParent)) {
                return new Exp[]{oFun};
            }
            Exp[] oChildren = this.util.getChildren(oParent);
            if (oChildren.length < 2) {
                return null;
            }
            Exp[] mComplement = new Exp[oChildren.length - 1];
            int index = -1;
            int ii = 0;
            for (int i = 0; i < oChildren.length; ++i) {
                if (!oChildren[i].equals(oMember)) {
                    mComplement[ii++] = oChildren[i];
                    continue;
                }
                index = i;
            }
            if (index == oChildren.length - 1) {
                Exp oComplement = this.util.createFunCall("{}", mComplement, 2);
                return new Exp[]{oComplement, null};
            }
            if (index == 0) {
                Exp oComplement = this.util.createFunCall("{}", mComplement, 2);
                return new Exp[]{null, oComplement};
            }
            Exp[] left = new Exp[index];
            System.arraycopy(mComplement, 0, left, 0, index);
            Exp[] right = new Exp[mComplement.length - index];
            System.arraycopy(mComplement, index, right, 0, mComplement.length - index);
            Exp oLeft = this.util.createFunCall("{}", left, 2);
            Exp oRight = this.util.createFunCall("{}", right, 2);
            return new Exp[]{oLeft, oRight};
        }
        if (this.util.isFunCallTo(oFun, "Members")) {
            Exp oParent = this.util.funCallArg(oFun, 0);
            Exp oMember = this.util.objForMember(member);
            Exp[] oChildren = this.util.getMembers(oParent);
            if (oChildren.length < 2) {
                return null;
            }
            Exp[] mComplement = new Exp[oChildren.length - 1];
            int index = -1;
            int ii = 0;
            for (int i = 0; i < oChildren.length; ++i) {
                if (!oChildren[i].equals(oMember)) {
                    mComplement[ii++] = oChildren[i];
                    continue;
                }
                index = i;
            }
            if (index == oChildren.length - 1) {
                Exp oComplement = this.util.createFunCall("{}", mComplement, 2);
                return new Exp[]{oComplement, null};
            }
            if (index == 0) {
                Exp oComplement = this.util.createFunCall("{}", mComplement, 2);
                return new Exp[]{null, oComplement};
            }
            Exp[] left = new Exp[index];
            System.arraycopy(mComplement, 0, left, 0, index);
            Exp[] right = new Exp[mComplement.length - index];
            System.arraycopy(mComplement, index, right, 0, mComplement.length - index);
            Exp oLeft = this.util.createFunCall("{}", left, 2);
            Exp oRight = this.util.createFunCall("{}", right, 2);
            return new Exp[]{oLeft, oRight};
        }
        if (this.util.isFunCallTo(oFun, "{}")) {
            int nComp = 0;
            int nArg = this.util.funCallArgCount(oFun);
            Exp oMember = this.util.objForMember(member);
            for (int i = 0; i < nArg; ++i) {
                Exp o = this.util.funCallArg(oFun, i);
                if (o.equals(oMember)) continue;
                ++nComp;
            }
            if (nComp == 0) {
                return null;
            }
            if (nComp == nArg) {
                return new Exp[]{oFun};
            }
            Exp[] mComplement = new Exp[nComp];
            int index = -1;
            int ii = 0;
            for (int i = 0; i < nArg; ++i) {
                Exp o = this.util.funCallArg(oFun, i);
                if (!o.equals(oMember)) {
                    mComplement[ii++] = o;
                    continue;
                }
                index = i;
            }
            if (index == nArg - 1) {
                Exp oComplement = this.util.createFunCall("{}", mComplement, 2);
                return new Exp[]{oComplement, null};
            }
            if (index == 0) {
                Exp oComplement = this.util.createFunCall("{}", mComplement, 2);
                return new Exp[]{null, oComplement};
            }
            Exp[] left = new Exp[index];
            System.arraycopy(mComplement, 0, left, 0, index);
            Exp[] right = new Exp[mComplement.length - index];
            System.arraycopy(mComplement, index, right, 0, mComplement.length - index);
            Exp oLeft = this.util.createFunCall("{}", left, 2);
            Exp oRight = this.util.createFunCall("{}", right, 2);
            return new Exp[]{oLeft, oRight};
        }
        if (this.util.isFunCallTo(oFun, "Union")) {
            Exp oRight;
            Exp oLeft;
            Exp[][] complementss = new Exp[2][2];
            for (int i = 0; i < 2; ++i) {
                Exp o = this.util.funCallArg(oFun, i);
                complementss[i] = this.createComplement2(o, member);
            }
            if (complementss[0] == null && complementss[1] == null) {
                return null;
            }
            if (complementss[0] != null && complementss[1] == null) {
                return complementss[0];
            }
            if (complementss[0] == null && complementss[1] != null) {
                return complementss[1];
            }
            if (complementss[0].length == 1 && complementss[1].length == 1) {
                return new Exp[]{oFun};
            }
            Exp[] complements = null;
            int index = -1;
            if (complementss[0].length == 1) {
                complements = new Exp[]{complementss[0][0], complementss[1][0], complementss[1][1]};
                index = 1;
            } else if (complementss[1].length == 1) {
                complements = new Exp[]{complementss[0][0], complementss[0][1], complementss[1][0]};
                index = 0;
            } else {
                complements = new Exp[]{complementss[0][0], complementss[0][1], complementss[1][0], complementss[1][1]};
                index = 0;
            }
            for (int i = 0; i < complements.length; ++i) {
                if (this.util.isFunCall(complements[i])) continue;
                complements[i] = this.createBraceFunCall(complements[i]);
            }
            if (index == 0) {
                oLeft = complements[0];
                Exp[] com2 = new Exp[complements.length - 1];
                System.arraycopy(complements, 1, com2, 0, com2.length);
                oRight = this.unionOfSets(com2);
            } else {
                Exp[] com2 = new Exp[2];
                System.arraycopy(complements, 0, com2, 0, 2);
                oLeft = this.unionOfSets(com2);
                com2 = new Exp[complements.length - 2];
                System.arraycopy(complements, 2, com2, 0, com2.length);
                oRight = this.unionOfSets(com2);
            }
            return new Exp[]{oLeft, oRight};
        }
        throw new CannotHandleException(this.util.funCallName(oFun));
    }

    private Exp unionOfSets(Exp[] complements) {
        int len = complements.length;
        Util.assertPostcondition((len == 2 || len == 3 ? 1 : 0) != 0);
        if (len == 2) {
            if (this.util.isFunCallTo(complements[0], "{}") && this.util.isFunCallTo(complements[1], "{}")) {
                return this.unionOfSets(complements[0], complements[1]);
            }
            return this.util.createFunCall("Union", complements, 0);
        }
        if (this.util.isFunCallTo(complements[0], "{}") && this.util.isFunCallTo(complements[1], "{}")) {
            return this.unionOfSets(this.unionOfSets(complements[0], complements[1]), complements[2]);
        }
        if (this.util.isFunCallTo(complements[1], "{}") && this.util.isFunCallTo(complements[2], "{}")) {
            return this.unionOfSets(complements[0], this.unionOfSets(complements[1], complements[2]));
        }
        return this.unionOfSets(this.unionOfSets(complements[0], complements[1]), complements[2]);
    }

    private Exp createBraceFunCall(Exp o) {
        return this.util.createFunCall("{}", new Exp[]{o}, 2);
    }

    private Exp unionOfSets(Exp set1, Exp set2) {
        int j;
        int n1 = this.util.funCallArgCount(set1);
        int n2 = this.util.funCallArgCount(set2);
        Exp[] newSet = new Exp[n1 + n2];
        int i = 0;
        for (j = 0; j < n1; ++j) {
            newSet[i++] = this.util.funCallArg(set1, j);
        }
        for (j = 0; j < n2; ++j) {
            newSet[i++] = this.util.funCallArg(set2, j);
        }
        return this.util.createFunCall("{}", newSet, 2);
    }

    public QueryAxisUtil getUtil() {
        return this.util;
    }

    public static class CannotHandleException
    extends Exception {
        public CannotHandleException(String arg0) {
            super(arg0);
        }
    }

    public class UnknownFunction {
        private Exp fCall;
        int hierIndex;
        private List memberList = null;

        public UnknownFunction(int hierIndex, Exp fCall) {
            this.hierIndex = hierIndex;
            this.fCall = fCall;
        }

        public Exp getFCall() {
            return this.fCall;
        }

        public List getMemberList() {
            return this.memberList;
        }

        public void setMemberList(List list) {
            this.memberList = list;
        }
    }
}

