/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap.querymanage;

import com.kingdee.bos.ctrl.analysis.modelcore.Extension;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelSupport;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.olap.base.FilterBase;
import com.kingdee.bos.ctrl.analysis.olap.base.SortRankBase;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.mdx.Exp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class QueryManager {
    static Logger logger = CommonLogger.getLogger(QueryManager.class);
    protected ModelSupport model;
    protected QueryAxisManager[] qams;
    protected boolean useQueryAxisManager = false;
    protected boolean axesSwapped = false;
    protected SortRankBase sortRank = null;
    protected FilterBase filter = null;

    protected QueryManager(ModelSupport model) {
        Extension filterExt;
        this.model = model;
        Extension sortExt = model.getExtension("sortRank");
        if (sortExt != null) {
            this.sortRank = (SortRankBase)sortExt;
        }
        if ((filterExt = model.getExtension("filter")) != null) {
            this.filter = (FilterBase)filterExt;
        }
        this.axesSwapped = false;
    }

    public QueryAxisManager[] getQueryAxisManageres() {
        return this.qams;
    }

    public QueryAxisManager findQueryAxisManager(Dimension dim) {
        for (int i = 0; i < this.qams.length; ++i) {
            if (this.qams[i].dimIdx(dim) < 0) continue;
            return this.qams[i];
        }
        return null;
    }

    public void afterExecute(Result result) {
        int i;
        Axis[] axes = result.getOriginAxes();
        for (i = 0; i < axes.length; ++i) {
            Hierarchy[] hiers = axes[i].getHierarchies();
            List positions = axes[i].getPositions();
            if (this.qams[this.iASwap((int)i)].posTreeRoot != null || positions.size() <= 0) continue;
            this.qams[this.iASwap(i)].init(hiers, positions);
        }
        if (this.useQueryAxisManager) {
            for (i = 0; i < this.qams.length; ++i) {
                List positions = axes[this.iASwap(i)].getPositions();
                int nDimension = this.qams[i].getDimCount();
                for (int j = 0; j < nDimension; ++j) {
                    QueryAxisManager.UnknownFunction unkown = this.qams[i].getUnknownFunction(j);
                    if (unkown == null || unkown.getMemberList() != null) continue;
                    List memList = this.memListForHier(j, positions);
                    unkown.setMemberList(memList);
                }
            }
        }
    }

    private List memListForHier(int hierIndex, List positions) {
        ArrayList<Member> memList = new ArrayList<Member>();
        for (Position pos : positions) {
            Member m = pos.getMembers()[hierIndex];
            if (memList.contains(m)) continue;
            memList.add(m);
        }
        return memList;
    }

    protected abstract Exp createMemberSet(List var1);

    public abstract boolean canExpand(Member var1);

    public abstract boolean canExpand(Member[] var1);

    public abstract boolean canCollapse(Member var1);

    public abstract boolean canCollapse(Member[] var1);

    public abstract boolean isExpanded(Member var1);

    public void expand(Member member) {
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        if (!qam.canExpand(member)) {
            logger.fatal((Object)("Expand Member failed for" + member.getUniqueName()));
            return;
        }
        qam.expand(member);
        this.model.fireModelChanged();
    }

    public void expand(Member[] pathMembers) {
        Member member = pathMembers[pathMembers.length - 1];
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        if (!qam.canExpand(pathMembers)) {
            logger.fatal((Object)("Expand failed for" + this.poString(pathMembers, null)));
            return;
        }
        qam.expand(pathMembers);
        this.model.fireModelChanged();
    }

    public void collapse(Member member) {
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        qam.collapse(member);
        this.model.fireModelChanged();
    }

    public void collapse(Member[] pathMembers) {
        Member member = pathMembers[pathMembers.length - 1];
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        QueryAxisManager qam = this.findQueryAxisManager(dim);
        qam.collapse(pathMembers);
        this.model.fireModelChanged();
    }

    public abstract boolean canDrillDown(Member var1);

    public abstract boolean canDrillDown(Level var1);

    public boolean canDrillUp(Hierarchy hier) {
        QueryAxisManager qam = this.findQueryAxisManager(hier.getDimension());
        return qam.canDrillUp(hier);
    }

    public void drillDown(Member member) {
        QueryAxisManager qam = this.findQueryAxisManager(member.getLevel().getHierarchy().getDimension());
        qam.drillDown(member);
        this.model.fireModelChanged();
    }

    public void drillDown(Level level) {
        QueryAxisManager qam = this.findQueryAxisManager(level.getHierarchy().getDimension());
        qam.drillDown(level);
        this.model.fireModelChanged();
    }

    public void drillUp(Hierarchy hier) {
        QueryAxisManager qam = this.findQueryAxisManager(hier.getDimension());
        qam.drillUp(hier);
        this.model.fireModelChanged();
    }

    public boolean isSwapAxes() {
        return this.axesSwapped;
    }

    public int iASwap(int i) {
        if (this.axesSwapped) {
            return (i + 1) % 2;
        }
        return i;
    }

    protected String poString(Member[] posMembers, Member member) {
        StringBuffer sb = new StringBuffer();
        if (posMembers != null) {
            sb.append(" Position=");
            for (int i = 0; i < posMembers.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(posMembers[i].getUniqueName());
            }
        }
        if (member != null) {
            sb.append(" Member=");
            sb.append(member.getUniqueName());
        }
        return sb.toString();
    }

    public void setUseExpandStateCache(boolean b) {
        for (int i = 0; i < this.qams.length; ++i) {
            this.qams[i].setUseExpandStateCache(b);
        }
    }
}

