/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.modelcore.ExtensionSupport;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.elementexp.MemberExpr;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class KDOLAP_ChangeSlicer
extends ExtensionSupport
implements ChangeSlicer {
    static Logger logger = CommonLogger.getLogger(KDOLAP_ChangeSlicer.class);

    public KDOLAP_ChangeSlicer() {
        super.setId("changeSlicer");
    }

    @Override
    public Member[] getSlicer() {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        Result res = null;
        try {
            res = model.getResult();
        }
        catch (OlapException ex) {
            return new Member[0];
        }
        Axis slicer = res.getSlicer();
        List positions = slicer.getPositions();
        ArrayList<Member> members = new ArrayList<Member>();
        for (Position pos : positions) {
            Member[] posMembers = pos.getMembers();
            for (int i = 0; i < posMembers.length; ++i) {
                if (members.contains(posMembers[i])) continue;
                members.add(posMembers[i]);
            }
        }
        return members.toArray(new Member[0]);
    }

    @Override
    public void setSlicer(Member[] members) {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)model.getQueryManager();
        MdxQuery kdQuery = adapter.getKDQuery();
        if (members == null || members.length == 0) {
            kdQuery.setSlicer(null);
        } else {
            ArrayList<Member> mList = new ArrayList<Member>();
            for (int i = 0; i < members.length; ++i) {
                if (members[i] == null) continue;
                mList.add(members[i]);
            }
            Exp[] kdExpr = new Exp[mList.size()];
            for (int i = 0; i < kdExpr.length; ++i) {
                kdExpr[i] = this.createExpressionFor(kdQuery, (KDOLAP_Member)mList.get(i));
            }
            FunCall f = new FunCall("()", kdExpr, Syntax.Parentheses);
            kdQuery.setSlicer((Exp)f);
        }
        model.fireModelChanged();
    }

    protected Exp createExpressionFor(MdxQuery kdQuery, KDOLAP_Member member) {
        return new MemberExpr(member.getKDMember());
    }

    @Override
    public void removeHierarchy(Hierarchy hierarchy) {
        Member[] members = this.getSlicer();
        if (members != null) {
            ArrayList<Member> list = new ArrayList<Member>();
            for (int i = 0; i < members.length; ++i) {
                if (members[i].getHierarchy().equals(hierarchy)) continue;
                list.add(members[i]);
            }
            this.setSlicer(list.toArray(new Member[0]));
        }
    }

    @Override
    public void setMember(Member member) {
        Member[] members = this.getSlicer();
        if (members != null) {
            ArrayList<Member> list = new ArrayList<Member>();
            for (int i = 0; i < members.length; ++i) {
                if (members[i].getHierarchy().equals(member.getHierarchy())) continue;
                list.add(members[i]);
            }
            list.add(member);
            this.setSlicer(list.toArray(new Member[0]));
        }
    }
}

