/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.modelcore.ExtensionSupport;
import com.kingdee.bos.ctrl.analysis.olap.NonEmpty;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.QueryAxis;
import org.apache.log4j.Logger;

public class KDOLAP_NonEmpty
extends ExtensionSupport
implements NonEmpty {
    static Logger logger = CommonLogger.getLogger(KDOLAP_NonEmpty.class);
    private boolean useNonEmpty = true;

    public KDOLAP_NonEmpty() {
        super.setId("nonEmpty");
    }

    @Override
    public boolean isUseNonEmpty() {
        return this.useNonEmpty;
    }

    @Override
    public void setUseNonEmpty(boolean useNonEmpty) {
        this.useNonEmpty = useNonEmpty;
    }

    public boolean isNonEmpty(String axis) {
        KDOLAP_Model m = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)m.getQueryManager();
        if (adapter == null) {
            return false;
        }
        MdxQuery kdQuery = adapter.getKDQuery();
        for (int i = 0; i < kdQuery.getAxes().length; ++i) {
            QueryAxis qAxis = kdQuery.getAxes()[i];
            if (!axis.equalsIgnoreCase(qAxis.getName()) || !qAxis.isNonEmpty()) continue;
            return true;
        }
        return false;
    }

    public void setNonEmpty(String axis, boolean nonEmpty) {
        if (!this.useNonEmpty) {
            return;
        }
        KDOLAP_Model m = (KDOLAP_Model)this.getModel();
        KDOLAP_QueryManager adapter = (KDOLAP_QueryManager)m.getQueryManager();
        if (adapter == null) {
            return;
        }
        MdxQuery kdQuery = adapter.getKDQuery();
        boolean bChange = false;
        for (int i = 0; i < kdQuery.getAxes().length; ++i) {
            QueryAxis qAxis = kdQuery.getAxes()[i];
            if (!axis.equalsIgnoreCase(qAxis.getName()) || qAxis.isNonEmpty() == nonEmpty) continue;
            qAxis.setNonEmpty(nonEmpty);
            bChange = true;
        }
        if (bChange) {
            ((KDOLAP_Model)this.getModel()).fireModelChanged();
        }
    }

    @Override
    public boolean isNonEmptyForColumn() {
        return this.isNonEmpty("columns");
    }

    @Override
    public boolean isNonEmptyForRow() {
        return this.isNonEmpty("rows");
    }

    @Override
    public void setNonEmptyForColumn(boolean nonEmpty) {
        this.setNonEmpty("columns", nonEmpty);
    }

    @Override
    public void setNonEmptyForRow(boolean nonEmpty) {
        this.setNonEmpty("rows", nonEmpty);
    }
}

