/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.olapconnection.ui;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.report.UIContext;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectStringParser;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectionInfoWrapper;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IOlapConnectionStorage;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IURLResolver;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectionException;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectionInfo;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ui.ICubeModelSelectComponent;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ui.OlapConnectionInfoEditUI;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLException;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SchemaParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;

public class OlapConnectionInfoListUI
extends TypicalDialog {
    UIContext uiContext;
    private IURLResolver urlResolver;
    IOlapConnectionStorage storage;
    OlapConnectionInfo[] infoes;
    KDTree tree = new KDTree();
    KDButton btnNew = new KDButton(ReportResource.getString(ReportResource.class, (String)"New"));
    KDButton btnEdit = new KDButton(ReportResource.getString(ReportResource.class, (String)"Edit"));
    KDButton btnDelete = new KDButton(ReportResource.getString(ReportResource.class, (String)"delete"));
    OlapConnectionInfo cnInfo;
    Object dbSchema;
    String cubeName;

    public OlapConnectionInfoListUI(UIContext context) throws OlapConnectionException {
        this.setUIContext(context);
    }

    public OlapConnectionInfoListUI(Dialog owner, UIContext context) throws OlapConnectionException {
        super(owner);
        this.setUIContext(context);
    }

    public OlapConnectionInfoListUI(Frame owner, UIContext context) throws OlapConnectionException {
        super(owner);
        this.setUIContext(context);
    }

    private void setUIContext(UIContext context) throws OlapConnectionException {
        this.uiContext = context;
        if (context == null) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustProvide") + "UIContext.");
        }
        Object o = this.uiContext.get(UIContext.KEY_OlapConnectionStorage);
        if (o == null) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustProvide") + "IOlapConnectionStorage");
        }
        if (!(o instanceof IOlapConnectionStorage)) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustImplement") + "IOlapConnectionStorage" + ReportResource.getString(ReportResource.class, (String)"Interface"));
        }
        this.setOlapConnectionStorage((IOlapConnectionStorage)o);
        o = context.get(UIContext.KEY_CubeModelSelectComponent);
        if (o == null) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustProvide") + "ICubeModelSelectComponent");
        }
        if (!(o instanceof ICubeModelSelectComponent)) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustImplement") + "ICubeModelSelectComponent" + ReportResource.getString(ReportResource.class, (String)"Interface"));
        }
        o = context.get(UIContext.KEY_URLResolver);
        if (o == null) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustProvide") + "IURLResolver");
        }
        if (!(o instanceof IURLResolver)) {
            throw new IllegalArgumentException(ReportResource.getString(ReportResource.class, (String)"MustImplement") + "IURLResolver" + ReportResource.getString(ReportResource.class, (String)"Interface"));
        }
        this.urlResolver = (IURLResolver)o;
    }

    private void setOlapConnectionStorage(IOlapConnectionStorage storage) throws OlapConnectionException {
        this.storage = storage;
        this.infoes = storage.getAllOlapConnectionInfos();
    }

    protected void todoInit() {
        this.setTitle("Olap" + ReportResource.getString(ReportResource.class, (String)"connectionbrowser"));
        this.setSize(480, 400);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table layout = thisCell.split(1, 2);
        layout.colStyle(0).setPriX(1);
        layout.colStyle(1).setMarginLeft(20);
        layout.colStyle(1).setPriX(0);
        parent.add((Component)this.getNodesPanel(), layout.cell(0));
        parent.add((Component)this.getButtonPanel(), layout.cell(1));
    }

    private KDPanel getNodesPanel() {
        KDPanel panel = new KDPanel();
        panel.setBorder(BorderFactory.createBevelBorder(1));
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)this.tree, (Object)"Center");
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)("OLAP" + ReportResource.getString(ReportResource.class, (String)"MDSet")));
        for (int i = 0; i < this.infoes.length; ++i) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)this.infoes[i].toString());
            node.setAllowsChildren(true);
            node.setUserObject((Object)this.infoes[i]);
            root.add((MutableTreeNode)node);
        }
        this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        ((DefaultTreeModel)this.tree.getModel()).setAsksAllowsChildren(true);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (treeNode.getUserObject() instanceof OlapConnectionInfo && treeNode.getChildCount() == 0) {
                    OlapConnectionInfoListUI.this.expandNode(treeNode);
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultKingdeeTreeNode treeNode;
                if (e.getClickCount() == 2 && ((treeNode = (DefaultKingdeeTreeNode)OlapConnectionInfoListUI.this.tree.getSelectionPath().getLastPathComponent()).getUserObject() instanceof CubeModel_Cube || treeNode.getUserObject() instanceof CubeDef)) {
                    OlapConnectionInfoListUI.this.confirm();
                }
            }
        });
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DefaultKingdeeTreeNode treeNode;
                if (e.getKeyCode() == 10 && ((treeNode = (DefaultKingdeeTreeNode)OlapConnectionInfoListUI.this.tree.getSelectionPath().getLastPathComponent()).getUserObject() instanceof CubeModel_Cube || treeNode.getUserObject() instanceof CubeDef)) {
                    OlapConnectionInfoListUI.this.confirm();
                }
            }
        });
        return panel;
    }

    private void expandNode(DefaultKingdeeTreeNode treeNode) {
        block6: {
            try {
                OlapConnectionInfo cnInfo = (OlapConnectionInfo)treeNode.getUserObject();
                String connectString = cnInfo.getConnectString();
                ConnectionInfoWrapper cnWrapper = new ConnectStringParser().parse(connectString);
                String url = cnWrapper.getUrl();
                if (cnWrapper.getConnectType() != 0) break block6;
                InputStream in = this.urlResolver.openInputStream(url);
                Document doc = null;
                try {
                    doc = new SAXBuilder().build(in);
                    CubeModel cm = CubeModelUtil.loadSchema(doc);
                    this.newNode(treeNode, cm);
                    treeNode.setUserObject((Object)new WrapperNodeInfo(cnInfo, cm));
                }
                catch (XMLException e) {
                    XMLException ex = e;
                    try {
                        SchemaDef def = SchemaParser.parse((Document)doc);
                        this.newNode(treeNode, def);
                        treeNode.setUserObject((Object)new WrapperNodeInfo(cnInfo, def));
                    }
                    catch (Exception ee) {
                        throw ex;
                    }
                }
            }
            catch (Exception e) {
                WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"ConnectionUnavailable") + "\n" + e.getMessage()));
            }
        }
    }

    void newNode(DefaultKingdeeTreeNode treeNode, CubeModel cm) throws OlapConnectionException {
        CubeModel_Cube[] cubes = cm.getCubes();
        if (cubes == null || cubes.length == 0) {
            throw new OlapConnectionException(ReportResource.getString(ReportResource.class, (String)"MDModelIllegal") + "Cube.");
        }
        for (int i = 0; i < cubes.length; ++i) {
            DefaultKingdeeTreeNode cnode = new DefaultKingdeeTreeNode((Object)cubes[i].getName());
            cnode.setUserObject((Object)cubes[i]);
            cnode.setAllowsChildren(false);
            this.tree.addNodeInto((MutableTreeNode)cnode, (MutableTreeNode)treeNode);
        }
    }

    void newNode(DefaultKingdeeTreeNode treeNode, SchemaDef schema) throws OlapConnectionException {
        CubeDef[] cubes = schema.cubes;
        if (cubes == null || cubes.length == 0) {
            throw new OlapConnectionException(ReportResource.getString(ReportResource.class, (String)"MDModelIllegal") + "Cube.");
        }
        for (int i = 0; i < cubes.length; ++i) {
            DefaultKingdeeTreeNode cnode = new DefaultKingdeeTreeNode((Object)cubes[i].name);
            cnode.setUserObject((Object)cubes[i]);
            cnode.setAllowsChildren(false);
            this.tree.addNodeInto((MutableTreeNode)cnode, (MutableTreeNode)treeNode);
        }
    }

    private KDPanel getButtonPanel() {
        KDPanel panel = new KDPanel();
        TableLayout layout = TableLayout.splitRow((int)5);
        panel.setLayout((LayoutManager)layout);
        layout.rowStyle(0).setHeight(20);
        panel.add((Component)this.btnNew, (Object)layout.cell(1));
        panel.add((Component)this.btnEdit, (Object)layout.cell(2));
        panel.add((Component)this.btnDelete, (Object)layout.cell(3));
        layout.rowStyle(4).setPriY(1);
        this.btnNew.setSize(40, 30);
        this.btnEdit.setSize(40, 30);
        this.btnDelete.setSize(40, 30);
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OlapConnectionInfoListUI.this.newConnection();
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OlapConnectionInfoListUI.this.editConnection();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OlapConnectionInfoListUI.this.deleteConnection();
            }
        });
        return panel;
    }

    void newConnection() {
        try {
            OlapConnectionInfo info;
            OlapConnectionInfoEditUI editUI = new OlapConnectionInfoEditUI((Dialog)((Object)this), this.uiContext);
            if (editUI.showDialog() && (info = editUI.getResult()).getType() == 0) {
                Object r = editUI.getTestedResult();
                if (r instanceof CubeModel) {
                    CubeModel cm = (CubeModel)r;
                    CubeModel_Cube[] cubes = cm.getCubes();
                    if (cubes == null || cubes.length == 0) {
                        throw new OlapConnectionException(ReportResource.getString(ReportResource.class, (String)"MDModelIllegal") + "Cube.");
                    }
                    this.storage.insert(info);
                    DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
                    DefaultKingdeeTreeNode cnNode = new DefaultKingdeeTreeNode((Object)info.toString());
                    cnNode.setUserObject((Object)new WrapperNodeInfo(info, cm));
                    this.tree.addNodeInto((MutableTreeNode)cnNode, (MutableTreeNode)root);
                    this.newNode(cnNode, cm);
                    this.tree.setSelectionPath(new TreePath(cnNode.getPath()));
                } else if (r instanceof SchemaDef) {
                    SchemaDef schema = (SchemaDef)r;
                    CubeDef[] cubes = schema.cubes;
                    if (cubes == null || cubes.length == 0) {
                        throw new OlapConnectionException(ReportResource.getString(ReportResource.class, (String)"MDModelIllegal") + "Cube.");
                    }
                    this.storage.insert(info);
                    DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
                    DefaultKingdeeTreeNode cnNode = new DefaultKingdeeTreeNode((Object)info.toString());
                    cnNode.setUserObject((Object)new WrapperNodeInfo(info, schema));
                    this.tree.addNodeInto((MutableTreeNode)cnNode, (MutableTreeNode)root);
                    this.newNode(cnNode, schema);
                    this.tree.setSelectionPath(new TreePath(cnNode.getPath()));
                }
            }
        }
        catch (Exception e) {
            WindowUtil.alert((Component)((Object)this), (String)e.getMessage());
        }
    }

    void editConnection() {
        try {
            OlapConnectionInfo cnInfo = this.getSelectedInfo();
            if (cnInfo == null) {
                return;
            }
            OlapConnectionInfoEditUI editUI = new OlapConnectionInfoEditUI((Dialog)((Object)this), this.uiContext);
            editUI.setOlapConnectionInfo(cnInfo);
            if (editUI.showDialog()) {
                this.storage.update(cnInfo);
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getSelectionPath().getPath()[1];
                treeNode.setText(cnInfo.toString());
                this.tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
                this.tree.expandAllNodes(true, (TreeNode)treeNode);
            }
        }
        catch (Exception e) {
            WindowUtil.alert((Component)((Object)this), (String)e.getMessage());
        }
    }

    void deleteConnection() {
        try {
            OlapConnectionInfo cnInfo = this.getSelectedInfo();
            if (cnInfo == null) {
                return;
            }
            this.storage.delete(cnInfo);
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getSelectionPath().getPath()[1];
            this.tree.removeNodeFromParent((MutableTreeNode)treeNode);
        }
        catch (Exception e) {
            WindowUtil.alert((Component)((Object)this), (String)e.getMessage());
        }
    }

    OlapConnectionInfo getSelectedInfo() {
        TreePath path = this.tree.getSelectionPath();
        if (path.getPathCount() < 2) {
            return null;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)path.getPath()[1];
        WrapperNodeInfo wnodeInfo = (WrapperNodeInfo)treeNode.getUserObject();
        return wnodeInfo.info;
    }

    protected boolean verify() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof CubeModel_Cube) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)treeNode.getParent();
            WrapperNodeInfo wnodeInfo = (WrapperNodeInfo)parent.getUserObject();
            this.cnInfo = wnodeInfo.info;
            this.dbSchema = wnodeInfo.dbSchema;
            this.cubeName = ((CubeModel_Cube)userObject).getName();
            return true;
        }
        if (userObject instanceof CubeDef) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)treeNode.getParent();
            WrapperNodeInfo wnodeInfo = (WrapperNodeInfo)parent.getUserObject();
            this.cnInfo = wnodeInfo.info;
            this.dbSchema = wnodeInfo.dbSchema;
            this.cubeName = ((CubeDef)userObject).name;
            return true;
        }
        WindowUtil.alert((Component)((Object)this), (String)(ReportResource.getString(ReportResource.class, (String)"plsSelectCube") + "Cube(" + ReportResource.getString(ReportResource.class, (String)"leafNode") + ")."));
        return false;
    }

    private void confirm() {
        super.onOk();
    }

    public OlapConnectionInfo getOlapConnectionInfo() {
        return this.cnInfo;
    }

    public Object getDBSchema() {
        return this.dbSchema;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    class WrapperNodeInfo {
        OlapConnectionInfo info;
        Object dbSchema;

        WrapperNodeInfo(OlapConnectionInfo info, Object dbSchema) {
            this.info = info;
            this.dbSchema = dbSchema;
        }
    }
}

