/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.base.FilterBase;
import com.kingdee.bos.ctrl.analysis.report.ui.DataFilterEditor;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;

public class DataFilterDialog
extends TypicalDialog {
    OlapModel olapModel = null;
    KDCheckBox cbUse = new KDCheckBox("\u542f\u7528\u6761\u4ef6\u8fc7\u6ee4");
    KDLabel label = new KDLabel("\u8bf7\u8f93\u5165\u6761\u4ef6\u8868\u8fbe\u5f0f");
    KDButton check = new KDButton("\u68c0\u67e5");
    KDPanel panel = new KDPanel();
    DataFilterEditor editor = new DataFilterEditor();

    public DataFilterDialog() {
    }

    public DataFilterDialog(Frame owner) {
        super(owner);
    }

    public DataFilterDialog(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setTitle("\u6761\u4ef6\u8fc7\u6ee4\u6570\u636e");
        this.setSize(640, 480);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table table = thisCell.splitRow(4);
        table.rowStyle(2).setPriY(1);
        parent.add((Component)this.cbUse, table.cell(0));
        parent.add((Component)this.label, table.cell(1));
        parent.add((Component)this.panel, table.cell(2));
        this.panel.setLayout((LayoutManager)new BorderLayout());
        this.panel.add((Component)new JScrollPane((Component)((Object)this.editor)), (Object)"Center");
        this.panel.add((Component)this.check, (Object)"East");
        this.check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFilterDialog.this.checkExpression(false);
            }
        });
    }

    public boolean checkExpression(boolean alert) {
        String exp = this.editor.getText();
        try {
            this.olapModel.createExp(exp);
        }
        catch (OlapException e) {
            WindowUtil.alert((Component)((Object)this), (String)(BIComponentResource.getString(BIComponentResource.class, (String)"IllegalExpression") + e.getMessage()));
            return false;
        }
        if (alert) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"Correct"));
        }
        return true;
    }

    public boolean verify() {
        return !this.cbUse.isSelected() || this.checkExpression(false);
    }

    public void setOlapModel(OlapModel olapModel) {
        this.olapModel = olapModel;
        this.initModel();
    }

    private void initModel() {
        FilterBase filter = (FilterBase)this.olapModel.getExtension("filter");
        if (filter.isFilterOnQuery()) {
            this.cbUse.setSelected(true);
            this.editor.setText(filter.getCondition(), false);
        } else {
            this.cbUse.setSelected(false);
        }
        try {
            Axis leftAxis = OlapModelUtil.getLeftAxis(this.olapModel);
            filter.setAxisToFilter(leftAxis.getOrdinal());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean useFilter() {
        return this.cbUse.isSelected();
    }

    public String getCondition() {
        return this.editor.getText();
    }
}

