/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.base.FilterBase;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Cell;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.report.ui.ColumnFilter;
import com.kingdee.bos.ctrl.analysis.report.ui.MemberColFilter;
import com.kingdee.bos.ctrl.analysis.report.ui.MemberColFilterHelper;
import com.kingdee.bos.ctrl.analysis.report.ui.ValueColFilter;
import com.kingdee.bos.ctrl.analysis.report.ui.ValueColFilterHelper;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DataSizerDialog
extends TypicalDialog
implements ModelChangeListener {
    private static final long serialVersionUID = 1L;
    DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"Member");
    TableLayout frameLayout = new TableLayout(3, 1);
    KDCheckBox cbUse = new KDCheckBox(ReportResource.getString(ReportResource.class, (String)"UseSizer"));
    KDPanel panelFrame = new KDPanel();
    KDLabel lblSelect = new KDLabel(ReportResource.getString(ReportResource.class, (String)"SelectSizerColumn"));
    KDComboBox cmbSelect = new KDComboBox();
    KDCheckBox cbShowAll = new KDCheckBox(ReportResource.getString(ReportResource.class, (String)"ShowAll"));
    KDWorkButton btnReloadColumn = new KDWorkButton(ReportResource.getString(ReportResource.class, (String)"ReloadSizerColumn"));
    KDLabel lblReloadColumn = new KDLabel(ReportResource.getString(ReportResource.class, (String)"NoteReload"));
    KDPanel panelMemberCol = new KDPanel();
    KDPanel panelValueCol = new KDPanel();
    KDWorkButton btnClear = new KDWorkButton(ReportResource.getString(ReportResource.class, (String)"Clear"));
    KDWorkButton btnAll = new KDWorkButton(ReportResource.getString(ReportResource.class, (String)"SelectAll"));
    KDTree treeMember = new KDTree((ITreeNode)this.root, true);
    KDRadioButton rbAND = new KDRadioButton("AND");
    KDRadioButton rbOR = new KDRadioButton("OR");
    KDWorkButton btnReloadData = new KDWorkButton(ReportResource.getString(ReportResource.class, (String)"ReloadData"));
    ButtonGroup group = new ButtonGroup();
    KDComboBox cmbValue1 = new KDComboBox();
    KDComboBox cmbValue2 = new KDComboBox();
    KDComboBox cmbCompare1 = new KDComboBox((Object[])new String[]{"", "=", "<>", ">", ">=", "<", "<="});
    KDComboBox cmbCompare2 = new KDComboBox((Object[])new String[]{"", "=", "<>", ">", ">=", "<", "<="});
    MemberColFilterHelper memberColFilterHelper = new MemberColFilterHelper();
    ValueColFilterHelper valueColFilterHelper = new ValueColFilterHelper();
    OlapModel olapModel = null;
    ColumnFilter[] savedColumns = null;
    ColumnFilter nowSelectColumn = null;
    KDPanel nowFilterColPanel = null;
    boolean disableColumnChangeEvent = false;
    boolean enableModelChange = true;
    private static int DLG_WIDTH = 640;
    private static int DLG_HEIGHT = 480;

    public DataSizerDialog() {
    }

    public DataSizerDialog(Frame owner) {
        super(owner);
    }

    public DataSizerDialog(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setSize(DLG_WIDTH, DLG_HEIGHT);
        this.setTitle(ReportResource.getString(ReportResource.class, (String)"SizerData"));
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this.initUI();
        this.layoutUI(parent, thisCell);
        this.addListener();
        this.loadColPanel();
    }

    public void setOlapModel(OlapModel olapModel) {
        this.olapModel = olapModel;
        this.refresh();
    }

    public void disableModelChange() {
        this.enableModelChange = false;
    }

    public void enableModelChange() {
        this.enableModelChange = true;
    }

    public String getCondition(boolean forVerify) {
        String condition = "";
        if (!forVerify && this.savedColumns == null) {
            return condition;
        }
        int nCount = this.cmbSelect.getItemCount();
        boolean firstItem = true;
        for (int i = 0; i < nCount; ++i) {
            ColumnFilter filter;
            ColumnFilter columnFilter = filter = forVerify ? (ColumnFilter)this.cmbSelect.getItemAt(i) : this.savedColumns[i];
            if (filter.isShowAll()) continue;
            String tempCondition = filter.getCondition();
            if (firstItem) {
                if (!tempCondition.equals("")) {
                    condition = condition + "(" + tempCondition + ")";
                }
                firstItem = false;
                continue;
            }
            if (tempCondition.equals("")) continue;
            condition = !condition.equals("") ? condition + " AND (" + tempCondition + ")" : "(" + tempCondition + ")";
        }
        return condition;
    }

    public boolean useFilter() {
        return this.cbUse.isSelected();
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        if (!this.enableModelChange) {
            return;
        }
        if (this.columnsChanged()) {
            this.btnReloadColumn.setEnabled(true);
            this.lblReloadColumn.setVisible(true);
            this.btnReloadData.setVisible(false);
        }
    }

    public void structureChanged(ModelChangeEvent e) {
    }

    protected void onOk() {
        this.saveColumn(this.nowSelectColumn);
        if (this.verify()) {
            this.save();
            this.isOk = true;
            this.dispose();
        }
    }

    protected boolean verify() {
        if (this.cbUse.isSelected()) {
            if (this.checkSelectionNull()) {
                return false;
            }
            if (!this.checkExpression(false)) {
                return false;
            }
        }
        return true;
    }

    private void initUI() {
        this.panelFrame.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.panelMemberCol.setBorder((Border)BorderFactory.createTitledBorder(ReportResource.getString(ReportResource.class, (String)"UDFMemberSizer")));
        this.panelValueCol.setBorder((Border)BorderFactory.createTitledBorder(ReportResource.getString(ReportResource.class, (String)"UDFValueSizer")));
        this.btnClear.setPreferredSize(new Dimension(80, 20));
        this.btnAll.setPreferredSize(new Dimension(80, 20));
        this.btnReloadColumn.setPreferredSize(new Dimension(120, 20));
        this.btnReloadColumn.setEnabled(false);
        this.btnReloadData.setPreferredSize(new Dimension(120, 20));
        this.btnReloadData.setVisible(true);
        this.lblReloadColumn.setForeground(new Color(255, 0, 0));
        this.lblReloadColumn.setVisible(false);
        this.treeMember.setRootVisible(false);
        this.treeMember.setShowsRootHandles(false);
        this.rbAND.setSelected(true);
        this.cmbValue1.setEditable(true);
        this.cmbValue2.setEditable(true);
    }

    private void createPanelFrame() {
        this.frameLayout.style().setMargin(20);
        this.frameLayout.style().setSize(-100, -100);
        this.frameLayout.rowStyle(0).setMarginBottom(10);
        this.frameLayout.rowStyle(1).setMarginBottom(10);
        this.frameLayout.rowStyle(2).setPriY(1);
        this.panelFrame.setLayout((LayoutManager)this.frameLayout);
        Table tblReloadColumn = this.frameLayout.cell(0).splitCol(2);
        tblReloadColumn.colStyle(0).setMarginRight(10);
        tblReloadColumn.colStyle(1).setPriX(1);
        this.panelFrame.add((Component)this.btnReloadColumn, (Object)tblReloadColumn.cell(0));
        this.panelFrame.add((Component)this.lblReloadColumn, (Object)tblReloadColumn.cell(1));
        Table tblSelect = this.frameLayout.cell(1).splitCol(3);
        tblSelect.colStyle(1).setPriX(1);
        this.panelFrame.add((Component)this.lblSelect, (Object)tblSelect.cell(0));
        this.panelFrame.add((Component)this.cmbSelect, (Object)tblSelect.cell(1));
        this.panelFrame.add((Component)this.cbShowAll, (Object)tblSelect.cell(2));
    }

    private void createPanelMemberCol() {
        TableLayout memberColLayout = new TableLayout(2, 1);
        memberColLayout.style().setMargin(20);
        memberColLayout.style().setSize(-100, -100);
        memberColLayout.rowStyle(0).setMarginTop(10);
        memberColLayout.rowStyle(0).setMarginBottom(10);
        memberColLayout.rowStyle(0).setPriY(1);
        this.panelMemberCol.setLayout((LayoutManager)memberColLayout);
        this.panelMemberCol.add((Component)new KDScrollPane((Component)this.treeMember), (Object)memberColLayout.cell(0));
        Table tblMemberColBtn = memberColLayout.cell(1).splitCol(3);
        tblMemberColBtn.colStyle(0).setPriX(1);
        tblMemberColBtn.colStyle(1).setMarginRight(20);
        this.panelMemberCol.add((Component)this.btnAll, (Object)tblMemberColBtn.cell(1));
        this.panelMemberCol.add((Component)this.btnClear, (Object)tblMemberColBtn.cell(2));
    }

    private void createPanelValueCol() {
        TableLayout valueColLayout = new TableLayout(5, 2);
        valueColLayout.style().setMargin(20);
        valueColLayout.style().setSize(-100, -100);
        valueColLayout.rowStyle(0).setMarginTop(10);
        valueColLayout.rowStyle(0).setMarginBottom(10);
        valueColLayout.rowStyle(1).setMarginBottom(10);
        valueColLayout.rowStyle(2).setMarginBottom(10);
        valueColLayout.rowStyle(0).lockHeight(40);
        valueColLayout.rowStyle(1).lockHeight(30);
        valueColLayout.rowStyle(2).lockHeight(30);
        valueColLayout.rowStyle(4).setPriY(1);
        valueColLayout.colStyle(0).setMarginRight(5);
        this.panelValueCol.setLayout((LayoutManager)valueColLayout);
        this.group.add((AbstractButton)this.rbAND);
        this.group.add((AbstractButton)this.rbOR);
        this.panelValueCol.add((Component)this.cmbCompare1, (Object)valueColLayout.cell(0, 0));
        this.panelValueCol.add((Component)this.cmbCompare2, (Object)valueColLayout.cell(2, 0));
        this.panelValueCol.add((Component)this.cmbValue1, (Object)valueColLayout.cell(0, 1));
        this.panelValueCol.add((Component)this.cmbValue2, (Object)valueColLayout.cell(2, 1));
        valueColLayout.cell(3, 1).style().setAlignmentX((short)2);
        this.panelValueCol.add((Component)this.btnReloadData, (Object)valueColLayout.cell(3, 1));
        Table tblLogic = valueColLayout.cell(1, 0).splitCol(2);
        this.panelValueCol.add((Component)this.rbAND, (Object)tblLogic.cell(0));
        this.panelValueCol.add((Component)this.rbOR, (Object)tblLogic.cell(1));
    }

    private void layoutUI(Container parent, Cell thisCell) {
        Table tblDialog = thisCell.splitRow(2);
        tblDialog.rowStyle(1).setPriY(1);
        parent.add((Component)this.cbUse, tblDialog.cell(0));
        parent.add((Component)this.panelFrame, tblDialog.cell(1));
        this.createPanelFrame();
        this.createPanelMemberCol();
        this.createPanelValueCol();
        this.panelFrame.add((Component)this.panelMemberCol, (Object)this.frameLayout.cell(2));
        this.nowFilterColPanel = this.panelMemberCol;
    }

    private void addListener() {
        if (this.olapModel != null) {
            this.olapModel.addModelChangeListener(this);
        }
        this.cmbSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DataSizerDialog.this.disableColumnChangeEvent) {
                    Object obj = DataSizerDialog.this.cmbSelect.getSelectedItem();
                    if (obj == DataSizerDialog.this.nowSelectColumn) {
                        return;
                    }
                    DataSizerDialog.this.saveColumn(DataSizerDialog.this.nowSelectColumn);
                    DataSizerDialog.this.loadColPanel();
                    DataSizerDialog.this.nowSelectColumn = (ColumnFilter)obj;
                }
            }
        });
        this.cbShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnFilter filter = (ColumnFilter)DataSizerDialog.this.cmbSelect.getSelectedItem();
                boolean isShowAll = DataSizerDialog.this.cbShowAll.isSelected();
                filter.setShowAll(isShowAll);
                DataSizerDialog.this.disablePanel(filter.getContainer(), isShowAll);
                DataSizerDialog.this.cmbSelect.repaint();
            }
        });
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSizerDialog.this.setTreeAllChecked(false);
            }
        });
        this.btnAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSizerDialog.this.setTreeAllChecked(true);
            }
        });
        this.btnReloadColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSizerDialog.this.savedColumns = null;
                DataSizerDialog.this.refresh();
                DataSizerDialog.this.btnReloadColumn.setEnabled(false);
                DataSizerDialog.this.lblReloadColumn.setVisible(false);
                DataSizerDialog.this.btnReloadData.setVisible(true);
            }
        });
        this.btnReloadData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSizerDialog.this.valueColFilterHelper.reloadValueColData(DataSizerDialog.this.olapModel, (ValueColFilter)DataSizerDialog.this.cmbSelect.getSelectedItem());
                DataSizerDialog.this.loadColPanel();
            }
        });
    }

    private void setTreeAllChecked(boolean checkAll) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.root.getChildAt(i);
            node.setChecked(checkAll);
        }
        this.treeMember.repaint();
    }

    private void disablePanel(KDPanel panel, boolean disableFlag) {
        Component[] coms = panel.getComponents();
        for (int i = 0; i < coms.length; ++i) {
            coms[i].setEnabled(!disableFlag);
            if (!(coms[i] instanceof KDScrollPane)) continue;
            ((KDScrollPane)coms[i]).getViewport().getComponents()[0].setEnabled(!disableFlag);
        }
    }

    private boolean checkExpression(boolean alert) {
        String exp = this.getCondition(true);
        if (exp.equals("")) {
            WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"NoFilter"));
            return false;
        }
        try {
            this.olapModel.createExp(exp);
        }
        catch (OlapException e) {
            WindowUtil.alert((Component)((Object)this), (String)(BIComponentResource.getString(BIComponentResource.class, (String)"IllegalExpression") + e.getMessage()));
            return false;
        }
        if (alert) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"Correct"));
        }
        return true;
    }

    private boolean columnsChanged() {
        boolean changed = false;
        ColumnFilter[] columnFilters = this.createColumns();
        if (columnFilters.length != this.cmbSelect.getItemCount()) {
            changed = true;
        } else {
            for (int i = 0; i < this.cmbSelect.getItemCount(); ++i) {
                ColumnFilter filterItem = (ColumnFilter)this.cmbSelect.getItemAt(i);
                if (filterItem.sameCol(columnFilters[i])) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }

    private boolean checkSelectionNull() {
        int nCount = this.cmbSelect.getItemCount();
        for (int i = 0; i < nCount; ++i) {
            ColumnFilter item = (ColumnFilter)this.cmbSelect.getItemAt(i);
            if (!item.checkSelectionNull()) continue;
            WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"NoMember"));
            this.cmbSelect.setSelectedItem((Object)item);
            return true;
        }
        return false;
    }

    private void saveColumn(Object column) {
        if (column == null) {
            return;
        }
        if (column instanceof MemberColFilter) {
            MemberColFilter filter = (MemberColFilter)column;
            filter.setShowAll(this.cbShowAll.isSelected());
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.root.getChildAt(i);
                filter.setSelected(i, node.isChecked());
            }
        } else if (column instanceof ValueColFilter) {
            ValueColFilter filter = (ValueColFilter)column;
            filter.setShowAll(this.cbShowAll.isSelected());
            filter.setCompare1(this.cmbCompare1.getSelectedItem());
            filter.setCompare2(this.cmbCompare2.getSelectedItem());
            filter.setValue1(this.cmbValue1.getSelectedItem());
            filter.setValue2(this.cmbValue2.getSelectedItem());
            filter.setLogicAnd(this.rbAND.isSelected());
        }
    }

    private void reloadPanelData(ColumnFilter filter) {
        if (filter instanceof MemberColFilter) {
            this.addMemberCol((MemberColFilter)filter);
        } else if (filter instanceof ValueColFilter) {
            this.addValueCol((ValueColFilter)filter);
        }
    }

    private void loadColPanel() {
        if (this.nowFilterColPanel == null) {
            return;
        }
        ColumnFilter filter = (ColumnFilter)this.cmbSelect.getSelectedItem();
        KDPanel oldPanel = this.nowFilterColPanel;
        KDPanel newPanel = filter.getContainer();
        this.reloadPanelData(filter);
        if (oldPanel != newPanel) {
            this.panelFrame.remove((Component)oldPanel);
            this.panelFrame.add((Component)newPanel, (Object)this.frameLayout.cell(2));
            this.nowFilterColPanel = newPanel;
            this.panelFrame.repaint();
            this.panelFrame.doLayout();
            newPanel.repaint();
            newPanel.doLayout();
        }
        Component[] coms = newPanel.getComponents();
        for (int i = 0; i < coms.length; ++i) {
            coms[i].doLayout();
        }
    }

    private void loadColumnList() {
        this.disableColumnChangeEvent = true;
        this.cmbSelect.removeAllItems();
        int selectedIndex = 0;
        if (this.savedColumns == null) {
            this.cmbSelect.addItems((Object[])this.createColumns());
        } else {
            Object[] newColumns = new ColumnFilter[this.savedColumns.length];
            for (int i = 0; i < this.savedColumns.length; ++i) {
                newColumns[i] = (ColumnFilter)this.savedColumns[i].clone();
                if (!this.savedColumns[i].sameCol(this.nowSelectColumn)) continue;
                selectedIndex = i;
            }
            this.cmbSelect.addItems(newColumns);
        }
        this.cmbSelect.setSelectedIndex(selectedIndex);
        this.nowSelectColumn = (ColumnFilter)this.cmbSelect.getSelectedItem();
        this.disableColumnChangeEvent = false;
    }

    private void addMemberCol(MemberColFilter memberColFilter) {
        if (memberColFilter == null || this.olapModel == null) {
            return;
        }
        this.cbShowAll.setSelected(memberColFilter.isShowAll());
        this.disablePanel(memberColFilter.getContainer(), this.cbShowAll.isSelected());
        this.treeMember.removeAllChildrenFromParent((MutableTreeNode)this.root);
        List memberList = memberColFilter.getMembers();
        boolean[] checked = memberColFilter.getSelected();
        int index = 0;
        for (Member member : memberList) {
            this.treeMember.addNodeInto((MutableTreeNode)new DefaultKingdeeTreeNode((Object)member, (Icon)NonIcon.getInstance(), checked[index], false), (MutableTreeNode)this.root);
            ++index;
        }
        this.treeMember.expandAllNodes(true, (TreeNode)this.root);
    }

    private void addValueCol(ValueColFilter valueColFilter) {
        if (valueColFilter == null || this.olapModel == null) {
            return;
        }
        this.cmbValue1.removeAllItems();
        this.cmbValue2.removeAllItems();
        this.cmbValue1.addItem((Object)"");
        this.cmbValue2.addItem((Object)"");
        List cellList = valueColFilter.getCellList();
        for (KDOLAP_Cell cell : cellList) {
            this.cmbValue1.addItem(cell.getValue());
            this.cmbValue2.addItem(cell.getValue());
        }
        this.cmbValue1.setSelectedItem((Object)valueColFilter.getValue1());
        this.cmbValue2.setSelectedItem((Object)valueColFilter.getValue2());
        this.cmbCompare1.setSelectedItem((Object)valueColFilter.getCompare1());
        this.cmbCompare2.setSelectedItem((Object)valueColFilter.getCompare2());
        if (valueColFilter.isLogicAnd()) {
            this.rbAND.setSelected(true);
        } else {
            this.rbOR.setSelected(true);
        }
        this.cbShowAll.setSelected(valueColFilter.isShowAll());
        this.disablePanel(valueColFilter.getContainer(), valueColFilter.isShowAll());
    }

    private void save() {
        int nCount = this.cmbSelect.getItemCount();
        if (this.savedColumns == null) {
            this.savedColumns = new ColumnFilter[nCount];
        }
        for (int i = 0; i < nCount; ++i) {
            Object item = this.cmbSelect.getItemAt(i);
            this.savedColumns[i] = (ColumnFilter)((ColumnFilter)item).clone();
        }
    }

    private void refresh() {
        FilterBase filter = (FilterBase)this.olapModel.getExtension("filter");
        if (filter.isFilterOnQuery()) {
            this.cbUse.setSelected(true);
        } else {
            this.cbUse.setSelected(false);
        }
        this.loadColumnList();
        this.loadColPanel();
        try {
            Axis leftAxis = OlapModelUtil.getLeftAxis(this.olapModel);
            filter.setAxisToFilter(leftAxis.getOrdinal());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ColumnFilter[] createColumns() {
        Iterator iter;
        List memberColFilterList = this.memberColFilterHelper.getMemberColFilterList(this.olapModel, this.panelMemberCol);
        List valueColFilterList = this.valueColFilterHelper.getValueColFilterList(this.olapModel, this.panelValueCol);
        ColumnFilter[] columnFilters = new ColumnFilter[memberColFilterList.size() + valueColFilterList.size()];
        int index = 0;
        if (memberColFilterList != null) {
            iter = memberColFilterList.iterator();
            while (iter.hasNext()) {
                columnFilters[index++] = (ColumnFilter)iter.next();
            }
        }
        if (valueColFilterList != null) {
            iter = valueColFilterList.iterator();
            while (iter.hasNext()) {
                columnFilters[index++] = (ColumnFilter)iter.next();
            }
        }
        return columnFilters;
    }
}

