/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.style.BinaryExpr;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.CompoundId;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Cstyle;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Expr;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.FunCall;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Literal;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Paren;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.MDXElement;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.report.ui.style.IPropertyChangeListener;
import com.kingdee.bos.ctrl.analysis.report.ui.style.LabelValueBean;
import com.kingdee.bos.ctrl.analysis.report.ui.style.SelectMemberDlg;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class DataStyleConditionPanel
extends KDPanel {
    private boolean loading = false;
    private KDTable tbl = null;
    private OlapModel model = null;
    private SelectMemberDlg selectDlg = null;
    private KDComboBox cbLParen = new KDComboBox();
    private KDComboBox cbDim = new KDComboBox();
    KDPromptBox pbValue = new KDPromptBox();
    private KDComboBox cbRParen = new KDComboBox();
    private KDComboBox cbLogic = new KDComboBox();
    private IPropertyChangeListener pl = null;
    private static final int COL_LPAREN = 0;
    private static final int COL_FUNC = 2;
    private static final int COL_DIM = 1;
    private static final int COL_CP = 3;
    private static final int COL_VALUE = 4;
    private static final int COL_RPAREN = 5;
    private static final int COL_LOGIC = 6;
    private int cRow = -1;

    DataStyleConditionPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new CardLayout());
        this.tbl = new KDTable(7, 1, 5);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tbl.setAfterAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                DataStyleConditionPanel.this.firePropertyChaged();
            }
        });
        this.tbl.getColumn(0).setWidth(60);
        this.tbl.getColumn(3).setWidth(60);
        this.tbl.getColumn(5).setWidth(60);
        this.tbl.getColumn(6).setWidth(60);
        this.add((Component)this.tbl, "");
        IRow row = this.tbl.getHeadRow(0);
        row.getCell(0).setValue((Object)"\u5de6\u62ec\u53f7");
        row.getCell(2).setValue((Object)"\u5c5e\u6027/\u51fd\u6570");
        row.getCell(1).setValue((Object)"\u9879\u76ee");
        row.getCell(3).setValue((Object)"\u6bd4\u8f83");
        row.getCell(4).setValue((Object)"\u6bd4\u8f83\u503c");
        row.getCell(5).setValue((Object)"\u53f3\u62ec\u53f7");
        row.getCell(6).setValue((Object)"\u903b\u8f91");
        this.cbDim.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DataStyleConditionPanel.this.tbl.getSelectManager().get() != null && !DataStyleConditionPanel.this.loading) {
                    SwingUtilities.invokeLater(new UpdateOnAttributeChangedThread(DataStyleConditionPanel.this.tbl.getSelectManager().get().getTop()));
                }
            }
        });
        CellItemListener cil = new CellItemListener();
        this.cbLParen.addItemListener((ItemListener)cil);
        this.cbRParen.addItemListener((ItemListener)cil);
        this.cbLogic.addItemListener((ItemListener)cil);
        this.cbLParen.addItemListener((ItemListener)cil);
        this.pbValue.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                DataStyleConditionPanel.this.firePropertyChaged();
            }
        });
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            KDComboBox cbFun = new KDComboBox();
            KDComboBox cbCP = new KDComboBox();
            row.getCell(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbLParen));
            row.getCell(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbFun));
            row.getCell(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbDim));
            row.getCell(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbCP));
            row.getCell(4).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.pbValue));
            row.getCell(5).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbRParen));
            row.getCell(6).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cbLogic));
            cbFun.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (DataStyleConditionPanel.this.tbl.getSelectManager().get() != null && !DataStyleConditionPanel.this.loading) {
                        SwingUtilities.invokeLater(new UpdateOnFuncChangedThread(DataStyleConditionPanel.this.tbl.getSelectManager().get().getTop()));
                    }
                }
            });
            cbCP.addItemListener((ItemListener)cil);
        }
        this.tbl.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                DataStyleConditionPanel.this.firePropertyChaged();
            }
        });
        this.pbValue.setEditable(false);
    }

    private void firePropertyChaged() {
        if (this.pl != null) {
            this.pl.propertyChanged();
        }
    }

    private void onCOL_FUNCChanged(int tableRowIndex) {
        LabelValueBean fun = (LabelValueBean)this.tbl.getCell(tableRowIndex, 2).getValue();
        LabelValueBean dim = (LabelValueBean)this.tbl.getCell(tableRowIndex, 1).getValue();
        KDComboBox cbCP = (KDComboBox)this.tbl.getCell(tableRowIndex, 3).getEditor().getComponent();
        if (fun != null) {
            String funName = (String)fun.getValue();
            if (funName.equals("currentmember") || funName.equals("parent")) {
                this.tbl.getCell(tableRowIndex, 4).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.pbValue));
                this.setComboBoxItems(cbCP, "=");
                this.pbValue.setEnabled(true);
                this.selectDlg.setDimension(this.model, (Dimension)dim.getValue());
            } else {
                this.tbl.getCell(tableRowIndex, 4).setEditor(null);
                this.setComboBoxItems(cbCP, "=,>,>=,<,<=,<>");
            }
        }
    }

    public void setPropertyChangeListener(IPropertyChangeListener pl) {
        this.pl = pl;
    }

    private void onCOL_DimChanged(int tableRowIndex, boolean changeFunc) {
        LabelValueBean dim = (LabelValueBean)this.tbl.getCell(tableRowIndex, 1).getValue();
        if (dim != null) {
            KDComboBox cbFunc = (KDComboBox)this.tbl.getCell(tableRowIndex, 2).getEditor().getComponent();
            KDComboBox cbCP = (KDComboBox)this.tbl.getCell(tableRowIndex, 3).getEditor().getComponent();
            Dimension selectDim = (Dimension)dim.getValue();
            if (selectDim.isMeasure()) {
                if (changeFunc) {
                    Member[] ms = this.model.getMeasures();
                    StringBuffer s = new StringBuffer();
                    s.append("\u5f53\u524d\u6210\u5458,currentmember,");
                    s.append("\u503c,value");
                    this.setComboBoxItemsWithName(cbFunc, s.toString());
                }
                this.setComboBoxItems(cbCP, "=,>,>=,<,<=,<>");
            } else {
                this.pbValue.setEnabled(true);
                this.selectDlg.setDimension(this.model, (Dimension)dim.getValue());
                if (changeFunc) {
                    this.setComboBoxItemsWithName(cbFunc, "\u5f53\u524d\u6210\u5458,currentmember,\u7236\u6210\u5458,parent,\u6210\u5458\u540d\u79f0,name,\u6210\u5458\u522b\u540d,caption");
                }
                this.setComboBoxItems(cbCP, "=");
                this.tbl.getCell(tableRowIndex, 4).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.pbValue));
            }
            if (changeFunc) {
                this.tbl.getCell(tableRowIndex, 2).setValue(cbFunc.getSelectedItem());
            }
            this.tbl.getCell(tableRowIndex, 3).setValue(cbCP.getSelectedItem());
        }
    }

    private boolean isLogicOP(String s) {
        if (s == null) {
            return false;
        }
        return "and".equals(s = s.toLowerCase(Locale.ENGLISH)) || "or".equals(s);
    }

    public void loadInitAttribute(OlapModel model, Dialog dlg) {
        this.model = model;
        this.setComboBoxItems(this.cbLParen, ",(,((,(((,((((,(((((");
        this.setComboBoxItems(this.cbRParen, ",),)),))),)))),)))))");
        this.setComboBoxItems(this.cbLogic, ",and,or");
        this.cbDim.removeAllItems();
        for (Dimension dim : model.getDimensions()) {
            this.cbDim.addItem((Object)new LabelValueBean(dim.getLabel(), dim));
        }
        this.selectDlg = new SelectMemberDlg(dlg);
        this.pbValue.setSelector((KDPromptSelector)this.selectDlg);
    }

    private void setComboBoxItemsWithName(KDComboBox cb, String values) {
        cb.removeAllItems();
        String[] ss = values.split(",");
        int n = ss.length;
        for (int i = 0; i < n; ++i) {
            cb.addItem((Object)new LabelValueBean(ss[i].trim(), ss[++i].trim()));
        }
        cb.updateUI();
    }

    private void setComboBoxItems(KDComboBox cb, String values) {
        cb.removeAllItems();
        String[] ss = values.split(",");
        int n = ss.length;
        for (int i = 0; i < n; ++i) {
            cb.addItem((Object)ss[i].trim());
        }
        cb.updateUI();
    }

    public void setConditionEntry(Cstyle.Entry item) {
        this.loading = true;
        this.cRow = 0;
        Cstyle.Condition c = item.getCondition();
        if (c != null) {
            if (c.getExpression() instanceof Paren) {
                this.extractParen((Paren)c.getExpression());
            } else {
                BinaryExpr be = (BinaryExpr)c.getExpression();
                this.addCondition(be);
            }
        }
        this.loading = false;
    }

    private void addCondition(BinaryExpr be) {
        this.setConditionOperationItem(be.getLeft());
        String op = be.getOperator().getName();
        if (this.isLogicOP(op)) {
            this.tbl.getCell(this.cRow, 6).setValue((Object)op);
            ++this.cRow;
        } else {
            this.tbl.getCell(this.cRow, 3).setValue((Object)op);
        }
        this.setConditionOperationItem(be.getRight());
    }

    private LabelValueBean getFunc(String name) {
        if ((name = name.toLowerCase(Locale.ENGLISH)).equals("currentmember")) {
            return new LabelValueBean("\u5f53\u524d\u6210\u5458", "currentmember");
        }
        if (name.equals("parent")) {
            return new LabelValueBean("\u7236\u6210\u5458", "parent");
        }
        if (name.equals("name")) {
            return new LabelValueBean("\u6210\u5458\u540d\u79f0", "name");
        }
        if (name.equals("caption")) {
            return new LabelValueBean("\u6210\u5458\u522b\u540d", "caption");
        }
        if (name.equals("value")) {
            return new LabelValueBean("\u503c", "value");
        }
        throw new RuntimeException("Unsupport function:" + name);
    }

    private void setConditionOperationItem(Expr item) {
        if (item instanceof BinaryExpr) {
            this.addCondition((BinaryExpr)item);
            return;
        }
        if (item instanceof CompoundId) {
            String uniqueName = ((CompoundId)item).toString();
            try {
                Member member = this.model.lookupMember(uniqueName);
                if (member != null) {
                    this.tbl.getCell(this.cRow, 4).setValue((Object)member);
                    this.onCOL_FUNCChanged(this.cRow);
                    return;
                }
            }
            catch (Throwable member) {
                // empty catch block
            }
        }
        if (item instanceof FunCall && ((FunCall)item).getName().equals("value") || item instanceof CompoundId && ((CompoundId)item).toStringArray()[0].toLowerCase(Locale.ENGLISH).equals("value")) {
            String[] nameParts = null;
            Object v = null;
            String label = null;
            boolean isAnyValue = item instanceof CompoundId;
            if (isAnyValue) {
                Dimension[] dims = this.model.getDimensions();
                int n = dims.length;
                for (int i = 0; i < n; ++i) {
                    if (!dims[i].isMeasure()) continue;
                    v = dims[i];
                    break;
                }
            } else {
                CompoundId ids = (CompoundId)((FunCall)item).getParams()[0];
                nameParts = ids.toStringArray();
                v = this.model.lookupDimension(nameParts[0]);
            }
            if (null != v) {
                label = v.getLabel();
            }
            ICell cell = this.tbl.getCell(this.cRow, 1);
            List list = this.removeCellKDComboBoxItemListener(cell);
            cell.setValue((Object)new LabelValueBean(label, v));
            this.addCellKDComboBoxItemListener(cell, list);
            this.onCOL_DimChanged(this.cRow, true);
            if (isAnyValue) {
                label = "\u503c";
                v = "value";
            } else {
                Member[] ms = this.model.getMeasures();
                MDXElement mm = null;
                for (int i = 0; i < ms.length; ++i) {
                    if (!ms[i].getName().equals(nameParts[1])) continue;
                    mm = ms[i];
                    break;
                }
                if (null != mm) {
                    label = mm.getCaption();
                    v = mm.getName();
                }
            }
            cell = this.tbl.getCell(this.cRow, 2);
            list = this.removeCellKDComboBoxItemListener(cell);
            cell.setValue((Object)new LabelValueBean(label, v));
            this.addCellKDComboBoxItemListener(cell, list);
        } else if (item instanceof FunCall) {
            FunCall fc = (FunCall)item;
            Expr p = fc.getParams()[0];
            Dimension v = this.model.lookupDimension(p.toString());
            String label = v.getLabel();
            ICell cell = this.tbl.getCell(this.cRow, 1);
            List list = this.removeCellKDComboBoxItemListener(cell);
            cell.setValue((Object)new LabelValueBean(label, v));
            this.addCellKDComboBoxItemListener(cell, list);
            this.onCOL_DimChanged(this.cRow, true);
            cell = this.tbl.getCell(this.cRow, 2);
            list = this.removeCellKDComboBoxItemListener(cell);
            cell.setValue((Object)this.getFunc(fc.getName()));
            this.addCellKDComboBoxItemListener(cell, list);
        } else if (item instanceof Literal) {
            this.tbl.getCell(this.cRow, 4).setValue(((Literal)item).getValueObject());
        } else if (item instanceof Paren) {
            this.extractParen((Paren)item);
        } else {
            this.tbl.getCell(this.cRow, 4).setValue((Object)item);
        }
        this.onCOL_FUNCChanged(this.cRow);
    }

    private List removeCellKDComboBoxItemListener(ICell cell) {
        KDComboBox cb = (KDComboBox)cell.getEditor().getComponent();
        ArrayList<ItemListener> list = new ArrayList<ItemListener>();
        list.addAll(Arrays.asList(cb.getItemListeners()));
        for (int i = list.size() - 1; i >= 0; --i) {
            cb.removeItemListener((ItemListener)list.get(i));
        }
        return list;
    }

    private void addCellKDComboBoxItemListener(ICell cell, List listenerList) {
        KDComboBox cb = (KDComboBox)cell.getEditor().getComponent();
        for (int i = listenerList.size() - 1; i >= 0; --i) {
            cb.addItemListener((ItemListener)listenerList.get(i));
        }
    }

    private BinaryExpr extractParen(Paren p) {
        int parenCount = 1;
        Expr e = p.getExpr();
        while (e instanceof Paren) {
            p = (Paren)e;
            e = p.getExpr();
            ++parenCount;
        }
        int lc = parenCount;
        int rc = parenCount;
        String oldL = (String)this.tbl.getCell(this.cRow, 0).getValue();
        if (oldL != null) {
            lc += oldL.length();
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < lc; ++i) {
            s.append("(");
        }
        this.tbl.getCell(this.cRow, 0).setValue((Object)s.toString());
        this.addCondition((BinaryExpr)e);
        String oldR = (String)this.tbl.getCell(this.cRow, 5).getValue();
        if (oldR != null) {
            rc += oldR.length();
        }
        s.setLength(0);
        for (int i = 0; i < rc; ++i) {
            s.append(")");
        }
        this.tbl.getCell(this.cRow, 5).setValue((Object)s.toString());
        return (BinaryExpr)e;
    }

    private Object getCellValue(int row, int col, Object nullWith) {
        Object v = this.tbl.getCell(row, col).getValue();
        return v == null ? nullWith : v;
    }

    public String getConditionScript() throws Exception {
        StringBuffer sb = new StringBuffer();
        boolean useFun = false;
        int measureCount = 0;
        Object lastLogic = null;
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object v = this.tbl.getCell(i, 1).getValue();
            if (v == null) continue;
            Dimension dim = (Dimension)((LabelValueBean)v).getValue();
            if (dim.isMeasure()) {
                ++measureCount;
            }
            sb.append(this.getCellValue(i, 0, ""));
            v = this.tbl.getCell(i, 2).getValue();
            String attr = (String)((LabelValueBean)v).getValue();
            if (dim.isMeasure()) {
                useFun = false;
                if ("currentmember".equals(attr)) {
                    sb.append("currentmember([Measures])");
                } else if ("value".equals(attr)) {
                    sb.append("value");
                } else {
                    sb.append("value([Measures].[").append(attr).append("])");
                }
            } else {
                sb.append(((LabelValueBean)v).getValue()).append("(").append(dim.getName()).append(")");
                if ("name".equals(attr) || "caption".equals(attr)) {
                    useFun = true;
                }
            }
            Object value = this.getCellValue(i, 4, "");
            if (value instanceof Member) {
                value = ((Member)value).getUniqueName();
            }
            sb.append(this.tbl.getCell(i, 3).getValue()).append(useFun ? "'" : "").append(value).append(useFun ? "'" : "");
            sb.append(this.getCellValue(i, 5, ""));
            String logic = (String)this.getCellValue(i, 6, "");
            if (logic == null || logic.length() == 0 && i < n - 1) {
                logic = "and";
            }
            sb.append(" ").append(logic).append(" ");
        }
        if (sb.length() > 0) {
            if (sb.toString().endsWith(" and ") || sb.toString().endsWith(" or ")) {
                sb.delete(sb.length() - 4, sb.length() - 1);
            }
            return "(" + sb.toString().trim() + ")";
        }
        return "";
    }

    public void clear() {
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            int k = this.tbl.getColumnCount();
            for (int j = 0; j < k; ++j) {
                this.tbl.getCell(i, j).setValue(null);
            }
        }
    }

    class UpdateOnFuncChangedThread
    extends Thread {
        int r;

        UpdateOnFuncChangedThread(int r) {
            this.r = r;
        }

        @Override
        public void run() {
            DataStyleConditionPanel.this.onCOL_FUNCChanged(this.r);
        }
    }

    class UpdateOnAttributeChangedThread
    extends Thread {
        int r;
        boolean changeFunc = true;

        UpdateOnAttributeChangedThread(int r) {
            this(r, true);
        }

        UpdateOnAttributeChangedThread(int r, boolean changeFunc) {
            this.r = r;
            this.changeFunc = changeFunc;
        }

        @Override
        public void run() {
            DataStyleConditionPanel.this.onCOL_DimChanged(this.r, this.changeFunc);
            DataStyleConditionPanel.this.onCOL_FUNCChanged(this.r);
        }
    }

    class CellItemListener
    implements ItemListener {
        CellItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DataStyleConditionPanel.this.firePropertyChaged();
        }
    }
}

