/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.util.bitemptable;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterManager;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterUtil;
import com.kingdee.bos.ctrl.analysis.util.bitemptable.BITTConstant;
import com.kingdee.bos.ctrl.analysis.util.bitemptable.TempTable;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.ITempTableManager;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class BITempTableManager
implements ITempTableManager {
    private static Logger logger = CommonLogger.getLogger(BITempTableManager.class);
    Context ctx;
    String dbcenterId;
    long cleanerInterval = 18000000L;
    private static List ttInfoList = new ArrayList();

    public BITempTableManager(Context ctx, String dbcenterId) {
        this.ctx = ctx;
        this.dbcenterId = dbcenterId;
        this.initDB();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new BITempTableCleaner(), 10000L + this.cleanerInterval, this.cleanerInterval);
    }

    /*
     * Loose catch block
     */
    private void initDB() {
        Connection con;
        block7: {
            con = null;
            try {
                int i;
                con = DBCenterManager.getConnection(this.ctx, this.dbcenterId);
                if (ttInfoList.size() == 0) {
                    ttInfoList = BITempTableManager.executeQuery(BITTConstant.QUERRY_BITT_REG_SQL, con);
                }
                if ((i = BITempTableManager.executeUpdate(BITTConstant.CREATE_BITT_REG_SQL, con)) <= 0) break block7;
                logger.debug((Object)"\u6267\u884c\u65b9\u6cd5initDB()\u521d\u59cb\u5316\u4e34\u65f6\u6ce8\u518c\u8868");
            }
            catch (SQLException e) {
                logger.debug((Object)("\u6267\u884c\u65b9\u6cd5initDB()\u51fa\u9519\uff1a" + e.getMessage()));
                DBCenterUtil.closeConnection(con);
            }
            catch (DBCenterException e2) {
                logger.debug((Object)("\u6267\u884c\u65b9\u6cd5initDB()\u51fa\u9519\uff1a" + e2.getMessage()));
                {
                    catch (Throwable throwable) {
                        DBCenterUtil.closeConnection(con);
                        throw throwable;
                    }
                }
                DBCenterUtil.closeConnection(con);
            }
        }
        DBCenterUtil.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getTemporaryTableName(String desc, String duration) {
        String tableName = "";
        Connection con = null;
        try {
            con = DBCenterManager.getConnection(this.ctx, this.dbcenterId);
            tableName = new UUTN().toString();
            String describe = desc;
            SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd hh:mm.ss");
            String createTime = dd.format(new Date());
            String dura = "5";
            String status = "1";
            Object[] params = new Object[]{tableName, describe, createTime, dura, status};
            BITempTableManager.executeUpdate(con, BITTConstant.INSERT_BITT_REG_SQL, params);
            TempTable ttInfo = new TempTable(tableName, describe, createTime, dura, status);
            ttInfoList.add(ttInfo);
            logger.info((Object)("\u6267\u884c\u65b9\u6cd5:getTemporaryTableName(),\u83b7\u53d6\u4e34\u65f6\u8868\u540d\u79f0:" + tableName));
        }
        catch (SQLException e) {
            e.printStackTrace();
            DBCenterUtil.closeConnection(con);
        }
        catch (DBCenterException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    DBCenterUtil.closeConnection(con);
                    throw throwable;
                }
            }
            DBCenterUtil.closeConnection(con);
        }
        DBCenterUtil.closeConnection(con);
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void releaseTemporaryTable(String tableName) throws SQLException, OLAPException {
        Connection con = null;
        try {
            con = DBCenterManager.getConnection(this.ctx, this.dbcenterId);
            String sql = " drop table " + tableName;
            try {
                BITempTableManager.executeUpdate(sql, con);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            sql = "delete from T_BI_TempTableReg where ftablename='" + tableName + "'";
            BITempTableManager.executeUpdate(sql, con);
            logger.info((Object)"\u6267\u884c\u65b9\u6cd5\uff1areleaseTemporaryTable(),\u91ca\u653e\u4e34\u65f6\u8868");
        }
        catch (SQLException e) {
            e.printStackTrace();
            DBCenterUtil.closeConnection(con);
        }
        catch (DBCenterException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    DBCenterUtil.closeConnection(con);
                    throw throwable;
                }
            }
            DBCenterUtil.closeConnection(con);
        }
        DBCenterUtil.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTempTable(Connection conn, String sql) throws SQLException, OLAPException {
        try {
            BITempTableManager.executeUpdate(sql, conn);
        }
        catch (Exception e) {
            logger.error((Object)("\u6267\u884c\u7ebf\u7a0bBITempTableCleaner\u51fa\u9519\uff1a" + e.getMessage()));
        }
        finally {
            DBCenterUtil.closeConnection(conn);
        }
    }

    public String getTemporaryTableName(Connection conn, String desc) throws SQLException, OLAPException {
        return this.getTemporaryTableName(desc, null);
    }

    public void releaseTemporaryTableName(Connection conn, String tableName) throws SQLException, OLAPException {
        this.releaseTemporaryTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Connection cn, String[] sqls) throws SQLException {
        Statement stmt = null;
        try {
            stmt = cn.createStatement();
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                stmt.addBatch(sqls[i]);
            }
            int[] nArray = stmt.executeBatch();
            return nArray;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Object[] params, Connection cn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i <= params.length - 1; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    public static int executeUpdate(String sql, Connection cn) throws SQLException {
        return BITempTableManager.executeUpdate(sql, null, cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List executeQuery(String sql, Connection cn) throws SQLException {
        ArrayList<TempTable> arrayList;
        ResultSet rs = null;
        Statement stmt = null;
        ArrayList<TempTable> lst = new ArrayList<TempTable>();
        try {
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String tableName = rs.getString("ftablename");
                String describe = rs.getString("fdesc");
                String createTime = rs.getString("fcreatetime");
                String dura = rs.getString("fduration");
                String status = rs.getString("fstatus");
                TempTable ttInfo = new TempTable(tableName, describe, createTime, dura, status);
                lst.add(ttInfo);
            }
            arrayList = lst;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection cn, String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            int n = stmt.executeUpdate();
            return n;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    class BITempTableCleaner
    extends TimerTask {
        BITempTableCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info((Object)"\u5f00\u59cb\u6267\u884c\u7ebf\u7a0b\uff1aBITempTableCleaner(),\u5220\u9664\u5df2\u8fc7\u671f\u4e34\u65f6\u8868");
            ArrayList<String> overTimeTTList = new ArrayList<String>();
            Connection con = null;
            try {
                int num = ttInfoList.size();
                for (int i = num - 1; i >= 0; --i) {
                    SimpleDateFormat dd;
                    String currentTime;
                    TempTable ttInfo = (TempTable)ttInfoList.get(i);
                    String createTime = ttInfo.getCreateTime();
                    if (!this.isOverTime(createTime, currentTime = (dd = new SimpleDateFormat("yyyy-MM-dd hh:mm.ss")).format(new Date()))) continue;
                    ttInfoList.remove(i);
                    overTimeTTList.add(ttInfo.getTableName());
                }
                num = overTimeTTList.size();
                if (num > 0) {
                    String sql;
                    String[] sqls = new String[num + 1];
                    String inWhere = "";
                    for (int i = 0; i < num; ++i) {
                        sqls[i] = " drop table " + overTimeTTList.get(i);
                        inWhere = inWhere + "','" + overTimeTTList.get(i);
                    }
                    inWhere = inWhere.substring(",'".length(), inWhere.length());
                    sqls[num] = sql = " delete from T_BI_TempTableReg where ftablename in(" + inWhere + "')";
                    con = DBCenterManager.getConnection(BITempTableManager.this.ctx, BITempTableManager.this.dbcenterId);
                    BITempTableManager.executeBatch(con, sqls);
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u6267\u884c\u7ebf\u7a0bBITempTableCleaner\u51fa\u9519\uff1a" + e.getMessage()));
            }
            finally {
                DBCenterUtil.closeConnection(con);
            }
            logger.info((Object)"\u7ebf\u7a0b\u6267\u884c\u7ed3\u675f\uff1aBITempTableCleaner!");
        }

        private boolean isOverTime(String createTime, String currentTime) {
            try {
                SimpleDateFormat fm = new SimpleDateFormat("yyyy-mm-dd hh:mm.ss");
                Date beginTime = fm.parse(createTime);
                Date endTime = fm.parse(currentTime);
                long between = endTime.getTime() - beginTime.getTime();
                long duration = Integer.parseInt("5") * 60 * 60 * 1000;
                if (between >= duration) {
                    return true;
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u6267\u884c\u7ebf\u7a0bBITempTableCleaner\u51fa\u9519\uff1a" + e.getMessage()));
            }
            return false;
        }
    }
}

